/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.workbench;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.bei.common.helper.OrgHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;

public class RecPayBaseList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(RecPayBaseList.class);
    private int ORG_SIZE = 20;

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String refEntityId = args.getRefEntityId();
        if ("bd_accountbanks".equals(refEntityId)) {
            ListShowParameter listParam = (ListShowParameter)this.getView().getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            QFilter filter = OrgHelper.getQFilterAuthorizedOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)listParam.getBillFormId(), (String)"47150e89000000ac", (String)"org");
            if (filter != null) {
                args.getQfilters().add(filter);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.addInnerAccountIsolateFilter(e);
        logger.info("RecPayBaseList: " + e.getQFilters().toString());
    }

    private Map<String, Map<String, Object>> loadBatchAppParameterByOrg(List<Long> selectCompanyIds) {
        AppParam param = new AppParam();
        param.setViewType("08");
        param.setAppId(AppMetadataCache.getAppInfo((String)"am").getId());
        return SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, selectCompanyIds);
    }

    private void addInnerAccountIsolateFilter(SetFilterEvent e) {
        long startTime = System.currentTimeMillis();
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        logger.info("mainOrgQFilter:{}", (Object)mainOrgQFilter);
        List orgIds = Objects.nonNull(mainOrgQFilter) ? (ArrayList)e.getMainOrgQFilter().getValue() : TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)((BillList)e.getSource()).getBillFormId(), (String)"47150e89000000ac");
        if (orgIds == null || orgIds.isEmpty()) {
            return;
        }
        Map<String, Map<String, Object>> stringMapMap = this.loadBatchAppParameterByOrg(orgIds);
        List queryOrg = stringMapMap.entrySet().stream().filter(entry -> {
            Map value = (Map)entry.getValue();
            if (value == null) {
                return false;
            }
            Boolean showInnerAccount = (Boolean)value.get("isshowinternalaccount");
            return showInnerAccount != null && showInnerAccount == false;
        }).map(s -> Long.parseLong((String)s.getKey())).collect(Collectors.toList());
        if (queryOrg.size() == 0) {
            return;
        }
        HashSet<Long> acctBankIdNotNeed = new HashSet<Long>(16);
        QFilter filter = new QFilter("finorgtype", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBankAcct", (String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("company", "in", queryOrg), filter}, null);){
            while (ds.hasNext()) {
                acctBankIdNotNeed.add(ds.next().getLong("id"));
            }
        }
        if (acctBankIdNotNeed.size() > 0) {
            e.getQFilters().add(new QFilter("accountbank", "not in", acctBankIdNotNeed));
        }
        long time = System.currentTimeMillis() - startTime;
        logger.info("RecPayBaseList-innerQuery-cost:" + time);
    }
}

