/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.workbench;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.bei.common.helper.LspWapper;
import kd.tmc.bei.common.helper.OrgHelper;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class WorkbenchCardBaseListPlugin
extends AbstractListPlugin
implements ClickListener {
    private static final Log LOGGER = LogFactory.getLog(WorkbenchCardBaseListPlugin.class);
    private static final String[] staticCardFields = new String[]{"accounted_panel", "noaccounted_panel", "all_panel", "rec_panel"};
    private static final String[] staticCardPrefix = new String[]{"tobeconfirm", "confirm", "all", "enroute"};
    private String businessBillName = "";
    private String enRouteBillName = "";
    private String BEI_INTELREC_LIST = "bei_intelrec_list";
    private String onRouteSelectedFields = "";
    private String selectedFields = "";

    public void initialize() {
        super.initialize();
        String listName = this.getModel().getDataEntityType().getName();
        if (this.BEI_INTELREC_LIST.equalsIgnoreCase(listName)) {
            this.businessBillName = "bei_intelrec";
            this.enRouteBillName = "cas_recbill";
            this.onRouteSelectedFields = "id,actrecamt as actamt,currency,currency.name,currency.sign";
            this.selectedFields = "receredtype,creditamount,currency,currency.name,currency.sign,case when receredtype = '0' then 1 else 0 end unacount ,case when receredtype = '3' then 1 else 0 end alacount,case when receredtype != '0' and receredtype != '3' then 1 else 0 end othercount";
        } else {
            this.businessBillName = "bei_intelpay";
            this.enRouteBillName = "cas_paybill";
            this.onRouteSelectedFields = "id,actpayamt as actamt,currency,currency.name,currency.sign";
            this.selectedFields = "receredtype,debitamount creditamount,currency,currency.name,currency.sign,case when receredtype = '0' then 1 else 0 end unacount ,case when receredtype = '3' then 1 else 0 end alacount,case when receredtype != '0' and receredtype != '3' then 1 else 0 end othercount";
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"rec_panel", "tobeconfirm_l_panel", "tobeconfirm_r_panel", "tobeconfirm_l", "tobeconfirm_r", "confirm_l_panel", "confirm_r_panel", "confirm_l", "confirm_r", "all_l_panel", "all_r_panel", "all_l", "all_r", "enroute_l_panel", "enroute_r_panel", "enroute_l", "enroute_r"});
    }

    private Map<String, String> getPrefixMap() {
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("tobeconfirm_l_panel", "tobeconfirm");
        map.put("tobeconfirm_r_panel", "tobeconfirm");
        map.put("tobeconfirm_l", "tobeconfirm");
        map.put("tobeconfirm_r", "tobeconfirm");
        map.put("confirm_l_panel", "confirm");
        map.put("confirm_r_panel", "confirm");
        map.put("confirm_l", "confirm");
        map.put("confirm_r", "confirm");
        map.put("all_l_panel", "all");
        map.put("all_r_panel", "all");
        map.put("all_l", "all");
        map.put("all_r", "all");
        map.put("enroute_r_panel", "enroute");
        map.put("enroute_l_panel", "enroute");
        map.put("enroute_r", "enroute");
        map.put("enroute_l", "enroute");
        return map;
    }

    private Set<String> getLeftBtnKeys() {
        HashSet<String> leftBtnKeys = new HashSet<String>(10);
        leftBtnKeys.add("tobeconfirm_l_panel");
        leftBtnKeys.add("tobeconfirm_l");
        leftBtnKeys.add("confirm_l_panel");
        leftBtnKeys.add("confirm_l");
        leftBtnKeys.add("all_l_panel");
        leftBtnKeys.add("all_l");
        leftBtnKeys.add("enroute_l_panel");
        leftBtnKeys.add("enroute_l");
        return leftBtnKeys;
    }

    private Set<String> getRightBtnKeys() {
        HashSet<String> rightBtnKeys = new HashSet<String>(10);
        rightBtnKeys.add("tobeconfirm_r_panel");
        rightBtnKeys.add("tobeconfirm_r");
        rightBtnKeys.add("confirm_r_panel");
        rightBtnKeys.add("confirm_r");
        rightBtnKeys.add("all_r_panel");
        rightBtnKeys.add("all_r");
        rightBtnKeys.add("enroute_r_panel");
        rightBtnKeys.add("enroute_r");
        return rightBtnKeys;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String operateKey = source.getKey();
        Set<String> leftBtnKeys = this.getLeftBtnKeys();
        Set<String> rightBtnKey = this.getRightBtnKeys();
        Map<String, String> prefixMap = this.getPrefixMap();
        if (operateKey.equals("rec_panel")) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
            qFilters.add(this.getIngRecFilter());
            ListShowParameter listShowParameter = new ListShowParameter();
            ArrayList<String> statuList = new ArrayList<String>(4);
            statuList.add(BillStatusEnum.SAVE.getValue());
            statuList.add(BillStatusEnum.SUBMIT.getValue());
            statuList.add(BillStatusEnum.AUDIT.getValue());
            statuList.add(BillStatusEnum.BEING.getValue());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            List<String> dataRange = Arrays.asList(dateFormat.format(this.getSelectedDate(0)), dateFormat.format(DateUtils.getNextDay((Date)this.getSelectedDate(1), (int)-1)));
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("isopenbyhyperlink", Boolean.TRUE);
            List<Object> selectedMyOrgIdList = this.getCachedIdList("selectedMyOrgIdList");
            if (selectedMyOrgIdList != null && !selectedMyOrgIdList.isEmpty()) {
                List selectedOrgIdList = selectedMyOrgIdList.stream().map(o -> o.toString()).collect(Collectors.toList());
                customParams.put("org.id", selectedOrgIdList);
            }
            customParams.put("bizdate", dataRange);
            customParams.put("billstatus", statuList);
            listShowParameter.setCustomParams(customParams);
            listShowParameter.setBillFormId(this.enRouteBillName);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            LspWapper lspWapper = new LspWapper(listShowParameter);
            lspWapper.coverFilters(qFilters);
            lspWapper.setStyleWithParentView(this.getView());
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if (leftBtnKeys.contains(operateKey)) {
            String prefix = prefixMap.get(operateKey);
            int curIndex = this.getModel().getEntryCurrentRowIndex(prefix + "entity");
            if (--curIndex == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{prefix + "_l"});
                this.getView().setEnable(Boolean.FALSE, new String[]{prefix + "_l"});
            }
            if (curIndex >= 0) {
                this.showDefaultInfo(prefix, curIndex);
                this.getModel().setEntryCurrentRowIndex(prefix + "entity", curIndex);
                this.getView().setVisible(Boolean.TRUE, new String[]{prefix + "_r"});
                this.getView().setEnable(Boolean.TRUE, new String[]{prefix + "_r"});
            }
        } else if (rightBtnKey.contains(operateKey)) {
            String prefix = prefixMap.get(operateKey);
            int curIndex = this.getModel().getEntryCurrentRowIndex(prefix + "entity");
            DynamicObjectCollection entity = this.getModel().getEntryEntity(prefix + "entity");
            if (++curIndex == entity.size() - 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{prefix + "_r"});
                this.getView().setEnable(Boolean.FALSE, new String[]{prefix + "_r"});
            }
            if (curIndex < entity.size()) {
                this.showDefaultInfo(prefix, curIndex);
                this.getModel().setEntryCurrentRowIndex(prefix + "entity", curIndex);
                this.getView().setVisible(Boolean.TRUE, new String[]{prefix + "_l"});
                this.getView().setEnable(Boolean.TRUE, new String[]{prefix + "_l"});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("progtext", (Object)ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"RecWorkbenchList_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("progtext1", (Object)ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"RecWorkbenchList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("progtext2", (Object)ResManager.loadKDString((String)"\u5168\u90e8", (String)"RecWorkbenchList_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        if ("bei_intelrec".equalsIgnoreCase(this.businessBillName)) {
            this.getModel().setValue("progtext3", (Object)ResManager.loadKDString((String)"\u5728\u9014\u6536\u6b3e\u5355", (String)"RecWorkbenchList_4", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("progtext3", (Object)ResManager.loadKDString((String)"\u5728\u9014\u4ed8\u6b3e\u5355", (String)"RecWorkbenchList_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter != null) {
            filters.add(mainOrgQFilter);
        }
        if (filters != null) {
            this.cacheIdList("selectedAcctIdList", null);
            this.cacheIdList("selectedMyOrgIdList", null);
            this.cacheIdList("selectedDateList", null);
            for (QFilter qFilter : filters) {
                List<Object> list;
                QFilter filter = qFilter.copy();
                String property = qFilter.getProperty();
                Set objectStream = qFilter.getNests(true).stream().map(o -> o.getFilter().getProperty()).collect(Collectors.toSet());
                if (this.isOrgFilterColumn(property) || objectStream.stream().anyMatch(o -> this.isOrgFilterColumn((String)o))) {
                    list = this.getOrgIds(filter);
                    this.cacheIdList("selectedMyOrgIdList", list);
                }
                if (this.isBankAccountFilterColumn(property) || objectStream.stream().anyMatch(o -> this.isBankAccountFilterColumn((String)o))) {
                    list = this.getAcctIds(filter);
                    this.cacheIdList("selectedAcctIdList", list);
                }
                if (!property.equals("bizdate")) continue;
                Date dateFilterBegin = null;
                Date dateFilterEnd = null;
                this.parseDateBeginAndEnd(dateFilterBegin, dateFilterEnd, filter);
            }
        }
        QFilter[] qFilterArr = filters == null ? null : filters.toArray(new QFilter[0]);
        this.refreshCard(qFilterArr);
        String tabKey = this.getPageCache().get("tabKey");
        QFilter receredQf = null;
        if (tabKey == null) {
            receredQf = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue());
        } else {
            switch (tabKey) {
                case "alrecord": {
                    receredQf = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
                    break;
                }
                case "norecord": {
                    receredQf = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue());
                    break;
                }
                case "noneedrecord": {
                    receredQf = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.NOCONFIRM.getValue());
                }
            }
        }
        if (filters != null && receredQf != null) {
            filters.add(receredQf);
        }
        e.setOrderBy("bizdate desc,company.id desc,id desc");
    }

    private boolean isOrgFilterColumn(String filterColumnName) {
        return filterColumnName.startsWith("org.") || filterColumnName.startsWith("company");
    }

    private <T> void cacheIdList(String key, List<T> selectedIdList) {
        if (selectedIdList != null) {
            this.getPageCache().put(key, SerializationUtils.toJsonString(selectedIdList));
        } else {
            this.getPageCache().put(key, null);
        }
    }

    private void refreshCard(QFilter[] qFilterArr) {
        Object accountedKey;
        Row row;
        IDataModel model = this.getModel();
        long accountNum = 0L;
        BigDecimal accountAmt = BigDecimal.ZERO;
        long noAccountNum = 0L;
        BigDecimal noAccountAmt = BigDecimal.ZERO;
        long allNum = 0L;
        long recCount = 0L;
        BigDecimal recAmt = BigDecimal.ZERO;
        Map<String, Long> confirmedInfoMap = new HashMap<String, Long>(2);
        Map<String, Long> toBeConfirmedInfoMap = new HashMap<String, Long>(2);
        Map<String, Long> allInfoMap = new HashMap<String, Long>(2);
        DataSet cardDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.businessBillName, (String)this.selectedFields, (QFilter[])qFilterArr, null);
        DataSet allDataSet = cardDataSet.copy().groupBy(new String[]{"currency", "currency.name", "currency.sign"}).sum("creditamount").sum("unacount").sum("alacount").sum("othercount").finish();
        DataSet otherDataSet = cardDataSet.groupBy(new String[]{"receredtype", "currency", "currency.name", "currency.sign"}).sum("creditamount").sum("unacount").sum("alacount").sum("othercount").finish();
        while (allDataSet.hasNext()) {
            row = allDataSet.next();
            long count = row.getLong("unacount") + row.getLong("alacount") + row.getLong("othercount");
            allNum += count;
            String key = row.getString("currency.name") + "@#&" + count + "@#&" + row.getString("currency.sign") + "@#&" + row.getString("creditamount");
            allInfoMap.put(key, count);
        }
        while (otherDataSet.hasNext()) {
            long value;
            row = otherDataSet.next();
            String receredType = row.getString("receredtype");
            if (ReceredtypeEnum.Pending.getValue().equals(receredType)) {
                String pendingKey = row.getString("currency.name") + "@#&" + row.getString("unacount") + "@#&" + row.getString("currency.sign") + "@#&" + row.getString("creditamount");
                value = row.getLong("unacount");
                toBeConfirmedInfoMap.put(pendingKey, value);
                noAccountAmt = noAccountAmt.add(row.getBigDecimal("creditamount"));
                noAccountNum += row.getLong("unacount").longValue();
                continue;
            }
            if (!ReceredtypeEnum.ACCOUNTED.getValue().equals(receredType)) continue;
            accountedKey = row.getString("currency.name") + "@#&" + row.getString("alacount") + "@#&" + row.getString("currency.sign") + "@#&" + row.getString("creditamount");
            value = row.getLong("alacount");
            confirmedInfoMap.put((String)accountedKey, value);
            accountAmt = accountAmt.add(row.getBigDecimal("creditamount"));
            accountNum += row.getLong("alacount").longValue();
        }
        this.clearLabelText("tobeconfirm");
        this.clearLabelText("confirm");
        this.clearLabelText("all");
        if (toBeConfirmedInfoMap != null && !toBeConfirmedInfoMap.isEmpty()) {
            toBeConfirmedInfoMap = this.mapReverseSorted(toBeConfirmedInfoMap);
            this.setLabelText(toBeConfirmedInfoMap, "tobeconfirm");
        }
        if (confirmedInfoMap != null && !confirmedInfoMap.isEmpty()) {
            confirmedInfoMap = this.mapReverseSorted(confirmedInfoMap);
            this.setLabelText(confirmedInfoMap, "confirm");
        }
        if (allInfoMap != null && !allInfoMap.isEmpty()) {
            allInfoMap = this.mapReverseSorted(allInfoMap);
            this.setLabelText(allInfoMap, "all");
        }
        QFilter ingRecFilter = this.getIngRecFilter();
        DataSet enRouteBills = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.enRouteBillName, (String)this.onRouteSelectedFields, (QFilter[])ingRecFilter.toArray(), null).groupBy(new String[]{"currency", "currency.name", "currency.sign"}).sum("actamt").count().finish();
        accountedKey = null;
        try {
            if (EmptyUtil.isNoEmpty((Object)enRouteBills)) {
                Map<String, Long> enRouteInfoMap = new HashMap<String, Long>(2);
                while (enRouteBills.hasNext()) {
                    Row row2 = enRouteBills.next();
                    long count = row2.getLong("count");
                    String key = row2.getString("currency.name") + "@#&" + count + "@#&" + row2.getString("currency.sign") + "@#&" + row2.getString("actamt");
                    enRouteInfoMap.put(key, count);
                    recCount += count;
                    recAmt = recAmt.add(row2.getBigDecimal("actamt"));
                }
                this.clearLabelText("enroute");
                if (enRouteInfoMap != null && !enRouteInfoMap.isEmpty()) {
                    enRouteInfoMap = this.mapReverseSorted(enRouteInfoMap);
                    this.setLabelText(enRouteInfoMap, "enroute");
                }
            }
        }
        catch (Throwable throwable) {
            accountedKey = throwable;
            throw throwable;
        }
        finally {
            if (enRouteBills != null) {
                if (accountedKey != null) {
                    try {
                        enRouteBills.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)accountedKey).addSuppressed(throwable);
                    }
                } else {
                    enRouteBills.close();
                }
            }
        }
        model.setValue("accounted_num", (Object)accountNum);
        model.setValue("noaccounted_num", (Object)noAccountNum);
        model.setValue("all_num", (Object)allNum);
        model.setValue("rec_count", (Object)recCount);
        String[] cardFields = staticCardFields;
        for (int i = 0; i < cardFields.length; ++i) {
            this.getView().updateView(cardFields[i]);
        }
        for (String prefix : staticCardPrefix) {
            this.showDefaultInfo(prefix, 0);
        }
    }

    private void showDefaultInfo(String prefix, int curIndex) {
        String entityName = prefix + "entity";
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityName);
        String ctrl_r = prefix + "_r";
        String ctrl_l = prefix + "_l";
        if (entryEntity != null && entryEntity.size() > 0) {
            String currency = (String)this.getModel().getValue(prefix + "currency", curIndex);
            String amount = (String)this.getModel().getValue(prefix + "amount", curIndex);
            String count = (String)this.getModel().getValue(prefix + "count", curIndex);
            String countStr = String.format(ResManager.loadKDString((String)"%s\u7b14", (String)"RecWorkCardDealList_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]), count);
            Label toBeConfirmShowCurrency = (Label)this.getView().getControl(prefix + "showcurrency");
            toBeConfirmShowCurrency.setText(currency);
            BigDecimal amt = new BigDecimal(amount);
            DecimalFormat df = new DecimalFormat("#,##0.00");
            Label toBeConfirmShowAmount = (Label)this.getView().getControl(prefix + "showamount");
            toBeConfirmShowAmount.setText(df.format(amt));
            Label toBeConfirmShowCount = (Label)this.getView().getControl(prefix + "showcount");
            toBeConfirmShowCount.setText(countStr);
            if (curIndex == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{ctrl_l});
                if (entryEntity.size() > 1) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{ctrl_r});
                    this.getView().setEnable(Boolean.TRUE, new String[]{ctrl_r});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{ctrl_r});
                    this.getView().setEnable(Boolean.FALSE, new String[]{ctrl_r});
                }
            }
        } else {
            Label toBeConfirmShowCurrency = (Label)this.getView().getControl(prefix + "showcurrency");
            toBeConfirmShowCurrency.setText("");
            Label toBeConfirmShowAmount = (Label)this.getView().getControl(prefix + "showamount");
            toBeConfirmShowAmount.setText("");
            Label toBeConfirmShowCount = (Label)this.getView().getControl(prefix + "showcount");
            toBeConfirmShowCount.setText("");
            this.getView().setVisible(Boolean.FALSE, new String[]{ctrl_r, ctrl_l});
            this.getView().setEnable(Boolean.FALSE, new String[]{ctrl_r, ctrl_l});
        }
    }

    private Map<String, Long> mapReverseSorted(Map<String, Long> infoMap) {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>(2);
        infoMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).forEachOrdered(e -> {
            Long cfr_ignored_0 = (Long)result.put((String)e.getKey(), (Long)e.getValue());
        });
        return result;
    }

    private void setLabelText(Map<String, Long> infoMap, String prefix) {
        String entityName = prefix + "entity";
        this.getModel().getEntryEntity(entityName).clear();
        for (Map.Entry<String, Long> entry : infoMap.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split("@#&");
            int newEntryRow = this.getModel().createNewEntryRow(entityName);
            this.getModel().setValue(prefix + "currency", (Object)split[0], newEntryRow);
            this.getModel().setValue(prefix + "count", (Object)split[1], newEntryRow);
            BigDecimal lblAmount = new BigDecimal(split[3]);
            lblAmount = lblAmount.setScale(2, RoundingMode.HALF_UP);
            this.getModel().setValue(prefix + "amount", (Object)lblAmount, newEntryRow);
        }
        this.getModel().setEntryCurrentRowIndex(entityName, 0);
        this.getView().updateView(entityName);
    }

    private void clearLabelText(String prefix) {
        String entityName = prefix + "entity";
        this.getModel().deleteEntryData(entityName);
        this.getView().updateView(entityName);
    }

    private QFilter getIngRecFilter() {
        QFilter ingFilter = new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue(), BillStatusEnum.BEING.getValue()});
        ingFilter.and(new QFilter("sourcebilltype", "in", (Object)new String[]{this.businessBillName, "cas_claimcenterbill", "bei_transdetail", "bei_transdetail_cas"}));
        ingFilter.and(new QFilter("bizdate", ">=", (Object)this.getSelectedDate(0))).and(new QFilter("bizdate", "<", (Object)this.getSelectedDate(1)));
        List<Object> selectedMyOrgIdList = this.getCachedIdList("selectedMyOrgIdList");
        if (selectedMyOrgIdList != null && !selectedMyOrgIdList.isEmpty()) {
            ingFilter.and(new QFilter("org.id", "in", selectedMyOrgIdList));
        } else if (!PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) {
            QFilter filter = OrgHelper.getQFilterAuthorizedOrgId((Long)RequestContext.get().getCurrUserId(), (String)"bei", (String)"bei_intelrec", (String)"47150e89000000ac", (String)"org.id");
            ingFilter.and(filter);
        }
        List<Object> selectedAcctIdList = this.getCachedIdList("selectedAcctIdList");
        if (selectedAcctIdList != null && !selectedAcctIdList.isEmpty()) {
            if ("cas_paybill".equalsIgnoreCase(this.enRouteBillName)) {
                ingFilter.and(new QFilter("payeracctbank", "in", selectedAcctIdList));
            } else {
                ingFilter.and(new QFilter("accountbank", "in", selectedAcctIdList));
            }
        }
        return ingFilter;
    }

    private List<Long> getOrgIds(QFilter filter) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        if (filter != null) {
            QFilter qFilter = this.processFilterProp(filter, null, this::isOrgFilterColumn);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrgId", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilter}, null);){
                while (ds.hasNext()) {
                    orgIds.add(ds.next().getLong("id"));
                }
            }
            List<Object> selectedIdList = this.getCachedIdList("selectedMyOrgIdList");
            if (selectedIdList != null) {
                selectedIdList = selectedIdList.stream().map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
                orgIds.retainAll(selectedIdList);
            }
        }
        return orgIds;
    }

    private Date getSelectedDate(int index) {
        List<Object> selectedDateList = this.getCachedIdList("selectedDateList");
        if (selectedDateList != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return sdf.parse(selectedDateList.get(index).toString());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private List<Object> getCachedIdList(String key) {
        String cache = this.getPageCache().get(key);
        if (cache != null) {
            return (List)SerializationUtils.fromJsonString((String)cache, List.class);
        }
        return null;
    }

    private boolean isBankAccountFilterColumn(String filterColumnName) {
        return (filterColumnName.startsWith("accountbank.") || filterColumnName.startsWith("bankaccount.")) && filterColumnName.split("\\.").length <= 2;
    }

    private List<Object> getAcctIds(QFilter filter) {
        ArrayList<Object> acctIds = new ArrayList<Object>(10);
        if (filter != null) {
            List<Object> selectedIdList;
            QFilter qFilter = this.processFilterProp(filter, null, this::isBankAccountFilterColumn);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (!coll.isEmpty()) {
                acctIds.addAll(OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
            if ((selectedIdList = this.getCachedIdList("selectedAcctIdList")) != null) {
                selectedIdList = selectedIdList.stream().map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
                acctIds.retainAll(selectedIdList);
            }
        }
        return acctIds;
    }

    private QFilter processFilterProp(QFilter filter, QFilter newFilter, CheckProperty checkProperty) {
        if (checkProperty.invoke(filter.getProperty())) {
            String[] str = filter.getProperty().split("\\.");
            String property = null;
            if (str.length == 2) {
                property = str[1];
            } else if (str.length == 1) {
                property = "id";
            }
            if (property != null) {
                if (newFilter == null) {
                    newFilter = new QFilter(property, filter.getCP(), filter.getValue());
                } else {
                    newFilter.and(new QFilter(property, filter.getCP(), filter.getValue()));
                }
            }
        }
        List list = filter.getNests(false);
        for (QFilter.QFilterNest qFilterNest : list) {
            newFilter = this.processFilterProp(qFilterNest.getFilter(), newFilter, checkProperty);
        }
        return newFilter;
    }

    private void parseDateBeginAndEnd(Date dateFilterBegin, Date dateFilterEnd, QFilter dateFilter) {
        if (dateFilter != null) {
            if (">=".equals(dateFilter.getCP())) {
                dateFilterBegin = (Date)dateFilter.getValue();
            } else {
                Object value = dateFilter.getValue();
                dateFilterEnd = null != value && "EMPTY".equalsIgnoreCase(value.toString()) ? null : (Date)dateFilter.getValue();
            }
            List dateFilterNest = dateFilter.getNests(false);
            Iterator it = dateFilterNest.iterator();
            while (it.hasNext()) {
                QFilter filterInner = ((QFilter.QFilterNest)it.next()).getFilter();
                Date dateFilter_0 = null;
                if (filterInner.getValue() instanceof Long) {
                    try {
                        dateFilter_0 = new Date((Long)filterInner.getValue());
                    }
                    catch (Exception e) {
                        LOGGER.info("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25:" + e.getMessage());
                    }
                } else if (filterInner.getValue() instanceof Date) {
                    dateFilter_0 = (Date)filterInner.getValue();
                }
                if (">=".equals(filterInner.getCP())) {
                    if (dateFilterBegin != null && !dateFilterBegin.before(dateFilter_0)) continue;
                    dateFilterBegin = dateFilter_0;
                    continue;
                }
                if (dateFilterEnd != null && (dateFilter_0 == null || !dateFilterEnd.after(dateFilter_0))) continue;
                dateFilterEnd = dateFilter_0;
            }
        }
        ArrayList<Date> list = new ArrayList<Date>(10);
        if (Objects.isNull(dateFilterBegin)) {
            dateFilterBegin = new Date(0L);
        }
        list.add(dateFilterBegin);
        if (Objects.isNull(dateFilterEnd)) {
            dateFilterEnd = DateUtils.stringToDate((String)"9999-12-31 23:23:59", (String)"yyyy-MM-dd HH:mm:ss");
        }
        list.add(dateFilterEnd);
        this.cacheIdList("selectedDateList", list);
    }

    public static interface CheckProperty {
        public boolean invoke(String var1);
    }
}

