/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.webapi.openapi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.result.OpenApiFile;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.helper.BeiHelper;
import kd.tmc.bei.common.helper.ReceiptPrintHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

@ApiController(value="bei", desc="\u7535\u5b50\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3")
@ApiMapping(value="/openapi/bei/elecreceipt")
public class ElecReceiptFileDownloadController
implements Serializable {
    private static final Log logger = LogFactory.getLog(ElecReceiptFileDownloadController.class);
    private static final long serialVersionUID = -2837783974139135829L;
    private static final String RECEIPTNO = "receiptno";

    @ApiGetMapping(value="/downloadFile")
    public CustomApiResult<Map<String, OpenApiFile>> downloadFile(@ApiParam(value="\u7535\u5b50\u56de\u5355\u53f7", required=true) @ApiParam(value="\u7535\u5b50\u56de\u5355\u53f7", required=true) List<String> receiptNoList) {
        CustomApiResult result = new CustomApiResult();
        if (receiptNoList == null || receiptNoList.isEmpty()) {
            result.setStatus(false);
            result.setErrorCode(ApiErrorCode.Data_Invalid.getStatusCode());
            result.setMessage(ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u9001\u7684\u56de\u5355\u6570\u636e\u3002", (String)"ElecReceiptFileImportController_0", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            return result;
        }
        logger.info("requestInfo: receiptNoList = " + receiptNoList);
        DynamicObjectCollection receipts = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id, receiptno, fileflag, uploadfilename", (QFilter[])new QFilter[]{new QFilter(RECEIPTNO, "in", receiptNoList)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)receipts)) {
            result.setStatus(false);
            result.setErrorCode(ApiErrorCode.Data_Invalid.getStatusCode());
            result.setMessage(ResManager.loadKDString((String)"\u6839\u636e\u8bf7\u6c42\u6570\u636e\u67e5\u8be2\u7535\u5b50\u56de\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u9001\u7684\u7535\u5b50\u56de\u5355\u53f7\u662f\u5426\u6b63\u786e\u3002", (String)"ElecReceiptFileDownloadController_0", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            return result;
        }
        logger.info("\u67e5\u8be2\u5230" + receipts.size() + "\u6761\u7535\u5b50\u56de\u5355 " + receipts.stream().map(r -> r.getString(RECEIPTNO)).collect(Collectors.toList()));
        HashMap<String, OpenApiFile> resultMap = new HashMap<String, OpenApiFile>(16);
        for (DynamicObject receipt : receipts) {
            String receiptNo = receipt.getString(RECEIPTNO);
            if (receipt.getBoolean("fileflag")) {
                try {
                    String realUploadUrl = ReceiptPrintHelper.getRealUploadUrl((DynamicObject)receipt);
                    byte[] stream = BeiHelper.getPdfPutStream((String)realUploadUrl);
                    if (stream.length <= 1) {
                        logger.warn(receiptNo + " \u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u6d41\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u56de\u5355\u6587\u4ef6\u8def\u5f84\u503c\u3002");
                        continue;
                    }
                    String[] split = realUploadUrl.split("\\.");
                    resultMap.put(receiptNo, new OpenApiFile(realUploadUrl, split[split.length - 1], true, stream));
                }
                catch (Exception e) {
                    logger.error("\u7535\u5b50\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38: " + e.getMessage());
                    result.setStatus(false);
                    result.setErrorCode(ApiErrorCode.ERROR.getStatusCode());
                    result.setMessage(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ElecReceiptFileDownloadController_1", (String)"tmc-bei-webapi", (Object[])new Object[0]));
                }
                continue;
            }
            logger.warn(receiptNo + "\u56de\u5355\u4e3a\u975e\u6587\u4ef6\u7c7b\u56de\u5355\u3002");
        }
        if (!resultMap.isEmpty()) {
            result.setStatus(true);
            result.setData(resultMap);
        } else {
            result.setStatus(false);
            result.setErrorCode(ApiErrorCode.Data_NotFound.getStatusCode());
            result.setMessage(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ElecReceiptFileDownloadController_2", (String)"tmc-bei-webapi", (Object[])new Object[0]));
        }
        logger.info("\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u6210\u529f" + resultMap.size() + "\u6761" + resultMap.keySet() + "\uff0c\u5931\u8d25" + (receiptNoList.size() - resultMap.size()) + "\u6761\u3002");
        result.setMessage(String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u6210\u529f%1$s\u6761%2$s\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"ElecReceiptFileDownloadController_3", (String)"tmc-bei-webapi", (Object[])new Object[0]), resultMap.size(), resultMap.keySet(), receiptNoList.size() - resultMap.size()));
        return result;
    }
}

