/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.webapi.openapi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.tmc.bei.common.bean.DealResultBean;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.bei.common.helper.OfdFileParseHelper;
import kd.tmc.bei.webapi.openapi.bean.ElecStatementFileInfo;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

@ApiController(value="bei", desc="\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u6d41\u5bfc\u5165\u63a5\u53e3")
@ApiMapping(value="/openapi/bei/elecstatement")
public class ElecStatementFileUploadController
implements Serializable {
    private static final Log logger = LogFactory.getLog(ElecStatementFileUploadController.class);

    @ApiPostMapping(value="/uploadFile")
    public CustomApiResult<String> uploadFile(@ApiParam(value="\u6587\u4ef6\u6d41") @ApiParam(value="\u6587\u4ef6\u6d41") List<ElecStatementFileInfo> datas) {
        CustomApiResult result = new CustomApiResult();
        if (datas == null) {
            result.setStatus(false);
            result.setErrorCode(ApiErrorCode.Data_Invalid.getStatusCode());
            result.setMessage(ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u9001\u7684\u5bf9\u8d26\u5355\u6570\u636e\u3002", (String)"ElecStatementSaveWebApiPlugin_0", (String)"tmc-bei-webapi", (Object[])new Object[0]));
        } else {
            ArrayList<DealResultBean> results = new ArrayList<DealResultBean>(10);
            for (ElecStatementFileInfo data : datas) {
                DealResultBean bean = new DealResultBean();
                ByteArrayInputStream ins = new ByteArrayInputStream(data.getFileData());
                String fileName = data.getFileName();
                bean.setIsCover(data.getIsCover());
                logger.info("\u8bc6\u522b\u524d\u6587\u4ef6\u540d\u79f0{}", (Object)fileName);
                String isContinue = OfdFileParseHelper.uploadAndGenResult((InputStream)ins, (String)fileName, results, (DealResultBean)bean);
                if ("continue".equals(isContinue)) continue;
                results.add(bean);
            }
            for (DealResultBean bean : results) {
                String fileName = bean.getFileName();
                logger.info("\u8bc6\u522b\u540e\u6587\u4ef6\u540d\u79f0{}", (Object)fileName);
                if ("F".equals(bean.getStatus())) {
                    result.setStatus(false);
                    result.setErrorCode(ApiErrorCode.Data_Invalid.getStatusCode());
                    result.setMessage(fileName + bean.getFailureReason());
                    continue;
                }
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("filename", fileName);
                operateOption.setVariableValue("fileurl", bean.getFileURL());
                operateOption.setVariableValue("json", bean.getJson());
                operateOption.setVariableValue("iscover", bean.getIsCover());
                operateOption.setVariableValue("datasource", DataSourceEnum.FILEIMPORT.getValue());
                OperationResult operate = TmcOperateServiceHelper.execOperate((String)"fileimport", (String)"bei_elecstatement", (DynamicObject[])new DynamicObject[]{TmcDataServiceHelper.newDynamicObject((String)"bei_elecstatement")}, (OperateOption)operateOption);
                if (operate.isSuccess()) continue;
                logger.info("file [{}] import fail {}", (Object)fileName, (Object)result.getMessage());
            }
        }
        return result;
    }
}

