/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.webapi.openapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.webapi.openapi.ApiUploadHelper;
import kd.tmc.bei.webapi.openapi.bean.ElecStatementInfo;
import kd.tmc.bei.webapi.openapi.bean.StatementDetail;
import kd.tmc.bei.webapi.openapi.bean.StatementFileStreamInfo;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class ElecStatementSaveWebApiPlugin
implements IBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(ElecStatementSaveWebApiPlugin.class);
    private static final String REGEX = "^\\d{4}-((0([1-9]))|(1(0|1|2)))$";

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        if (params == null) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u9001\u7684\u5bf9\u8d26\u5355\u6570\u636e\u3002", (String)"ElecStatementSaveWebApiPlugin_0", (String)"tmc-bei-webapi", (Object[])new Object[0]));
        } else {
            JSONObject paramObj = new JSONObject(params);
            JSONArray dataObjs = paramObj.getJSONArray("data");
            JSONArray fileStreamArray = paramObj.getJSONArray("datastream");
            List statementFileStreamInfos = JSON.parseArray((String)fileStreamArray.toJSONString(), StatementFileStreamInfo.class);
            List elecStatementInfoList = JSON.parseArray((String)dataObjs.toJSONString(), ElecStatementInfo.class);
            ArrayList<DynamicObject> resLists = new ArrayList<DynamicObject>(elecStatementInfoList.size());
            for (ElecStatementInfo elecStatementInfo : elecStatementInfoList) {
                DynamicObject elecStatement = BusinessDataServiceHelper.newDynamicObject((String)"bei_elecstatement");
                this.fillElecStatement(elecStatement, elecStatementInfo);
                resLists.add(elecStatement);
            }
            if (!resLists.isEmpty()) {
                Map<String, List<DynamicObject>> groupBy = resLists.stream().collect(Collectors.groupingBy(d -> d.getDynamicObject("accountbank").getString("bankaccountnumber") + "#" + d.getDynamicObject("currency").getString("number") + "#" + d.getString("period")));
                ArrayList finalDynamicObjects = new ArrayList();
                for (Map.Entry entry : groupBy.entrySet()) {
                    List elecStatements = (List)entry.getValue();
                    if (elecStatements.isEmpty()) continue;
                    Optional firstOptional = elecStatements.stream().min((v1, v2) -> v2.getDate("jointime").compareTo(v1.getDate("jointime")));
                    firstOptional.ifPresent(finalDynamicObjects::add);
                }
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
                for (DynamicObject dynamicObject : finalDynamicObjects) {
                    DynamicObject accountBank = dynamicObject.getDynamicObject("accountbank");
                    DynamicObject currency = dynamicObject.getDynamicObject("currency");
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String periodString = format.format(dynamicObject.getDate("period"));
                    Timestamp periodTimeStamp = Timestamp.valueOf(periodString);
                    QFilter qFilter = new QFilter("accountbank", "=", accountBank.getPkValue());
                    qFilter.and("currency", "=", currency.getPkValue());
                    qFilter.and("period", "=", (Object)periodTimeStamp);
                    DynamicObjectCollection elecStatements = QueryServiceHelper.query((String)"bei_elecstatement", (String)"id", (QFilter[])qFilter.toArray());
                    if (elecStatements.size() > 0) {
                        DynamicObject oldDynamicObject = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)elecStatements.get(0)).getLong("id"), (String)"bei_elecstatement");
                        Map headPropertyMap = EntityMetadataCache.getDataEntityType((String)"bei_elecstatement").getFields();
                        Set<String> headPropertySet = headPropertyMap.keySet();
                        Set<String> entryPropertySet = EntityMetadataCache.getDataEntityType((String)"bei_elecstatement").getAllFields().keySet();
                        entryPropertySet.removeAll(headPropertySet);
                        this.copyDyn(dynamicObject, oldDynamicObject, headPropertySet, entryPropertySet);
                        updateList.add(oldDynamicObject);
                        continue;
                    }
                    updateList.add(dynamicObject);
                }
                try {
                    if (!updateList.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
                        logger.info("\u7535\u5b50\u5bf9\u8d26\u5355\u7ed3\u6784\u5316\u6570\u636e\u4fdd\u5b58\u6210\u529f");
                        try {
                            this.uploadStatementPdfFile(statementFileStreamInfos);
                        }
                        catch (Exception exception) {
                            logger.info("\u7535\u5b50\u5bf9\u8d26\u5355PDF\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u51fa\u9519\uff1a{}", (Object)exception.getMessage());
                            result.setSuccess(false);
                            result.setMessage(exception.getMessage());
                            return result;
                        }
                    }
                    result.setSuccess(true);
                    result.setMessage(ResManager.loadKDString((String)"\u7535\u5b50\u5bf9\u8d26\u5355\u6570\u636e\u4e0a\u4f20\u4fdd\u5b58\u6210\u529f\u3002", (String)"ElecStatementSaveWebApiPlugin_1", (String)"tmc-bei-webapi", (Object[])new Object[0]));
                }
                catch (Exception exception) {
                    result.setSuccess(false);
                    result.setMessage(exception.getMessage());
                }
            }
        }
        return result;
    }

    private void uploadStatementPdfFile(List<StatementFileStreamInfo> statementFileStreamInfos) {
        ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>();
        for (StatementFileStreamInfo data : statementFileStreamInfos) {
            String accountBank = data.getAccountBank();
            if (StringUtils.isEmpty((CharSequence)accountBank)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElecStatementSaveWebApiPlugin_2", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("bankaccountnumber", "=", (Object)accountBank);
            DynamicObjectCollection acctBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,createorg.id,openorg.id,bank.id,acctname", (QFilter[])qFilter.toArray());
            if (acctBanks.size() == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u94f6\u884c\u8d26\u53f7\u201c%s\u201d\u3002", (String)"ElecStatementSaveWebApiPlugin_3", (String)"tmc-bei-webapi", (Object[])new Object[0]), accountBank));
            }
            long acctBankId = ((DynamicObject)acctBanks.get(0)).getLong("id");
            String currency = data.getCurrency();
            if (StringUtils.isEmpty((CharSequence)currency)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElecStatementSaveWebApiPlugin_4", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            }
            QFilter curQFilter = new QFilter("number", "=", (Object)currency);
            DynamicObjectCollection currencies = QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])curQFilter.toArray());
            if (currencies.size() == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5e01\u79cd\u3010%s\u3011\u3002", (String)"ElecStatementSaveWebApiPlugin_5", (String)"tmc-bei-webapi", (Object[])new Object[0]), currency));
            }
            long currencyId = ((DynamicObject)currencies.get(0)).getLong("id");
            if (StringUtils.isEmpty((CharSequence)data.getPeriod())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElecStatementSaveWebApiPlugin_12", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            }
            boolean matches = data.getPeriod().matches(REGEX);
            if (!matches) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a[yyyy-MM]\u3002", (String)"ElecStatementSaveWebApiPlugin_13", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String periodString = format.format(DateUtils.stringToDate((String)data.getPeriod(), (String)"yyyy-MM"));
            Timestamp periodTimeStamp = Timestamp.valueOf(periodString);
            QFilter dataFilter = new QFilter("accountbank", "=", (Object)acctBankId);
            dataFilter.and("currency", "=", (Object)currencyId);
            dataFilter.and("period", "=", (Object)periodTimeStamp);
            DynamicObject[] elecStatements = BusinessDataServiceHelper.load((String)"bei_elecstatement", (String)"id,isfile,iscompleted,urlentry,urlentry.e_fileservicepath,urlentry.e_filesuffix", (QFilter[])dataFilter.toArray());
            if (elecStatements.length <= 0) continue;
            String fileName = data.getFilename();
            byte[] fileStream = data.getFilestream();
            String uploadUrl = ApiUploadHelper.upload(fileName, fileStream, "statement");
            logger.info("\u6587\u4ef6uploadUrl\uff1a" + uploadUrl);
            DynamicObject elecStatement = elecStatements[0];
            elecStatement.set("isfile", (Object)"1");
            elecStatement.set("iscompleted", (Object)"1");
            this.addUrlEntryInfo(elecStatement, uploadUrl, fileName.substring(fileName.lastIndexOf(".")));
            saveDataList.add(elecStatement);
        }
        if (!saveDataList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveDataList.toArray(new DynamicObject[0]));
        }
    }

    private void fillElecStatement(DynamicObject elecStatement, ElecStatementInfo elecStatementInfo) {
        String accountBank = elecStatementInfo.getAccountBank();
        if (StringUtils.isEmpty((CharSequence)accountBank)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElecStatementSaveWebApiPlugin_2", (String)"tmc-bei-webapi", (Object[])new Object[0]));
        }
        DynamicObject[] acctBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,createorg,openorg,bank,", (QFilter[])new QFilter("bankaccountnumber", "=", (Object)accountBank).toArray());
        if (acctBanks.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u94f6\u884c\u8d26\u53f7\u201c%s\u201d\u3002", (String)"ElecStatementSaveWebApiPlugin_3", (String)"tmc-bei-webapi", (Object[])new Object[0]), accountBank));
        }
        elecStatement.set("accountbank", (Object)acctBanks[0]);
        elecStatement.set("company", acctBanks[0].get("createorg"));
        elecStatement.set("accountcompany", acctBanks[0].get("openorg"));
        elecStatement.set("bank", acctBanks[0].get("bank"));
        elecStatement.set("accountbankname", StringUtils.isNotEmpty((CharSequence)elecStatementInfo.getAccountBankName()) ? elecStatementInfo.getAccountBankName() : acctBanks[0].get("acctname"));
        elecStatement.set("identificationissuer", (Object)elecStatementInfo.getIdentificationIssuer());
        elecStatement.set("bankbranchnumber", (Object)elecStatementInfo.getBankBranchNumber());
        elecStatement.set("bankcustomercode", (Object)elecStatementInfo.getBankCustomerCode());
        String currency = elecStatementInfo.getCurrency();
        if (StringUtils.isEmpty((CharSequence)currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElecStatementSaveWebApiPlugin_4", (String)"tmc-bei-webapi", (Object[])new Object[0]));
        }
        DynamicObject[] currencies = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id", (QFilter[])new QFilter("number", "=", (Object)currency).toArray());
        if (currencies.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5e01\u79cd\u3010%s\u3011\u3002", (String)"ElecStatementSaveWebApiPlugin_5", (String)"tmc-bei-webapi", (Object[])new Object[0]), currency));
        }
        elecStatement.set("currency", (Object)currencies[0]);
        if (StringUtils.isEmpty((CharSequence)elecStatementInfo.getPeriod())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElecStatementSaveWebApiPlugin_12", (String)"tmc-bei-webapi", (Object[])new Object[0]));
        }
        boolean matches = elecStatementInfo.getPeriod().matches(REGEX);
        if (!matches) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a[yyyy-MM]\u3002", (String)"ElecStatementSaveWebApiPlugin_13", (String)"tmc-bei-webapi", (Object[])new Object[0]));
        }
        elecStatement.set("period", (Object)DateUtils.stringToDate((String)elecStatementInfo.getPeriod(), (String)"yyyy-MM"));
        elecStatement.set("printcount", (Object)elecStatementInfo.getPrintCount());
        elecStatement.set("printdate", (Object)elecStatementInfo.getPrintDate());
        elecStatement.set("endacctamount", (Object)elecStatementInfo.getEndAcctAmount());
        elecStatement.set("endretainamount", (Object)elecStatementInfo.getEndRetainAmount());
        elecStatement.set("endfreezeamount", (Object)elecStatementInfo.getEndFreezeAmount());
        elecStatement.set("endoverdraftamount", (Object)elecStatementInfo.getEndOverdraftAmount());
        elecStatement.set("endavailableamount", (Object)elecStatementInfo.getEndAvailableAmount());
        elecStatement.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        elecStatement.set("datasource", (Object)elecStatementInfo.getDataSource());
        elecStatement.set("jointime", (Object)new Date());
        elecStatement.set("joindate", (Object)new Date());
        String billNo = CodeRuleHelper.generateNumber((String)"bei_elecstatement", (DynamicObject)elecStatement, null, null);
        elecStatement.set("billno", (Object)billNo);
        String fileServicePath = elecStatementInfo.getFileServicePath();
        if (StringUtils.isNotEmpty((CharSequence)fileServicePath)) {
            elecStatement.set("isfile", (Object)"1");
            elecStatement.set("iscompleted", (Object)"1");
            this.addUrlEntryInfo(elecStatement, fileServicePath, fileServicePath.substring(fileServicePath.lastIndexOf(".")));
        }
        DynamicObjectCollection entry = elecStatement.getDynamicObjectCollection("entryentity");
        List<StatementDetail> statementDetails = elecStatementInfo.getStatementDetails();
        if (CollectionUtils.isEmpty(statementDetails)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElecStatementSaveWebApiPlugin_11", (String)"tmc-bei-webapi", (Object[])new Object[0]));
        }
        for (StatementDetail statementDetail : statementDetails) {
            DynamicObject row = entry.addNew();
            if (StringUtils.isNotEmpty((CharSequence)statementDetail.getBookJournal())) {
                row.set("e_bookjournal", (Object)statementDetail.getBookJournal());
            }
            row.set("e_bookdate", (Object)statementDetail.getBookDate());
            if (Objects.isNull(statementDetail.getBookDate())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElecStatementSaveWebApiPlugin_7", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            }
            if (!Objects.isNull(statementDetail.getBookTime())) {
                row.set("e_booktime", (Object)statementDetail.getBookTime());
            }
            row.set("e_debitamount", (Object)statementDetail.getDebitAmount());
            row.set("e_creditamount", (Object)statementDetail.getCreditAmount());
            row.set("e_balancedirection", (Object)statementDetail.getBalanceDirection());
            BigDecimal debitAmount = row.getBigDecimal("e_debitamount");
            BigDecimal creditAmount = row.getBigDecimal("e_creditamount");
            String direction = row.getString("e_balancedirection");
            if (StringUtils.isEmpty((CharSequence)statementDetail.getBalanceDirection())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u65b9\u5411\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElecStatementSaveWebApiPlugin_14", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            }
            if (Objects.equals(direction, "0") && debitAmount.compareTo(BigDecimal.ZERO) <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u65b9\u5411\u4e3a\u501f\u65b9\uff0c\u501f\u65b9\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ElecStatementSaveWebApiPlugin_9", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            }
            if (Objects.equals(direction, "1") && creditAmount.compareTo(BigDecimal.ZERO) <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u65b9\u5411\u4e3a\u8d37\u65b9\uff0c\u8d37\u65b9\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ElecStatementSaveWebApiPlugin_10", (String)"tmc-bei-webapi", (Object[])new Object[0]));
            }
            row.set("e_acctamount", (Object)statementDetail.getAcctAmount());
            row.set("e_oppositeacct", (Object)statementDetail.getOppositeAcct());
            row.set("e_oppositeacctname", (Object)statementDetail.getOppositeAcctName());
            row.set("e_oppositebank", (Object)statementDetail.getOppositeBank());
            row.set("e_remark", (Object)statementDetail.getRemark());
            row.set("e_elecreceiptno", (Object)statementDetail.getElecReceiptNo());
            row.set("e_bizproduct", (Object)statementDetail.getBizProduct());
            row.set("e_sourcedocument", (Object)statementDetail.getSourceDocument());
            row.set("e_sourcedocumentno", (Object)statementDetail.getSourceDocumentNo());
            row.set("e_transactioncode", (Object)statementDetail.getTransactionCode());
            row.set("e_bookkeeper", (Object)statementDetail.getBookkeeper());
            row.set("e_otherbookinfo", (Object)statementDetail.getOtherBookInfo());
        }
    }

    private void addUrlEntryInfo(DynamicObject elecStatement, String fileServicePath, String fileSuffix) {
        DynamicObjectCollection urlEntry = elecStatement.getDynamicObjectCollection("urlentry");
        DynamicObject urlAddNew = urlEntry.addNew();
        urlAddNew.set("e_fileservicepath", (Object)fileServicePath);
        urlAddNew.set("e_filesuffix", (Object)fileSuffix);
    }

    private void copyDyn(DynamicObject newExpDyn, DynamicObject oldExpDyn, Set<String> headFields, Set<String> entryFields) {
        List<String> unCopyFields = Arrays.asList("id", "billno", "joindate", "jointime");
        for (String field : headFields) {
            if (unCopyFields.contains(field)) continue;
            oldExpDyn.set(field, newExpDyn.get(field));
        }
        DynamicObjectCollection entryColl = newExpDyn.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection oldColl = oldExpDyn.getDynamicObjectCollection("entryentity");
        oldColl.clear();
        for (DynamicObject dynamicObject : entryColl) {
            DynamicObject rowDyn = oldColl.addNew();
            for (String entryField : entryFields) {
                rowDyn.set(entryField, dynamicObject.get(entryField));
            }
        }
    }
}

