/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.opplugin.balance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.BalanceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.opplugin.sysimport.AbstractTmcBatchImportPlugin;

public class BalanceBatchImportOp
extends AbstractTmcBatchImportPlugin {
    private static final String ID = "id";
    private static final String SYSTEM_TYPE = "tmc-bei-opplugin";

    public String getDefaultImportType() {
        return "overridenew";
    }

    protected void beforeImportOp(Map<String, Object> rowData, Map<String, Object> option) {
        this.checkAccountBank(rowData);
        Date bizDate = DateUtils.stringToDate((String)((String)rowData.get("bizdate")), (String)"yyyy-MM-dd");
        if (EmptyUtil.isEmpty((Object)bizDate)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceBatchImportOp_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else if (EmptyUtil.isEmpty((Object)rowData.get("amount")) && EmptyUtil.isEmpty((Object)rowData.get("valibalance"))) {
            this.addErrMessage(ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d\u548c\u53ef\u7528\u4f59\u989d\u5fc5\u987b\u586b\u5199\u5176\u4e00\u3002", (String)"BalanceBatchImportOp_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else if (bizDate.after(new Date())) {
            this.addErrMessage(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7cfb\u7edf\u5f53\u524d\u65e5\u671f\u3002", (String)"BalanceBatchImportOp_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    protected void afterImportOp(List<Map<String, Object>> data) {
        if (EmptyUtil.isEmpty(data)) {
            return;
        }
        List pkIds = data.stream().filter(elem -> (Boolean)elem.get("success")).map(elem -> (Long)elem.get(ID)).collect(Collectors.toList());
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"bei_bankbalance", (String)"id, billno, creator, accountbank, currency, bizdate, enddate, amount, datasource, valibalance, freezebalance, modifier, createtime, modifytime", (QFilter[])new QFilter[]{new QFilter(ID, "in", pkIds)});
        Map<String, List> groupedAndSorted = Arrays.stream(bills).collect(Collectors.groupingBy(balance -> balance.getDynamicObject("accountbank").getLong(ID) + "#" + balance.getDynamicObject("currency").getLong(ID), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.toList()))));
        ArrayList<DynamicObject> saveBalances = new ArrayList<DynamicObject>(10);
        ArrayList updateBalances = new ArrayList(10);
        for (List balannces : groupedAndSorted.values()) {
            List bizDates = balannces.stream().map(s -> s.getDate("bizdate")).collect(Collectors.toList());
            for (int i = 0; i < balannces.size(); ++i) {
                DynamicObject balannce = (DynamicObject)balannces.get(i);
                balannce.set("billno", (Object)"IMPORT-".concat(String.valueOf(System.currentTimeMillis())));
                balannce.set("datasource", (Object)"import");
                if (EmptyUtil.isEmpty((BigDecimal)balannce.getBigDecimal("amount"))) {
                    balannce.set("amount", (Object)balannce.getBigDecimal("valibalance"));
                } else if (EmptyUtil.isEmpty((BigDecimal)balannce.getBigDecimal("valibalance"))) {
                    balannce.set("valibalance", (Object)balannce.getBigDecimal("amount"));
                }
                if (balannce.getBigDecimal("freezebalance") == null) {
                    balannce.set("freezebalance", (Object)0);
                }
                balannce.set("creator", (Object)RequestContext.get().getCurrUserId());
                balannce.set("modifier", (Object)RequestContext.get().getCurrUserId());
                balannce.set("createtime", (Object)DateUtils.getCurrentTime());
                balannce.set("modifytime", (Object)DateUtils.getCurrentTime());
                long accountBankId = balannce.getDynamicObject("accountbank").getLong(ID);
                long currencyId = balannce.getDynamicObject("currency").getLong(ID);
                Date endDate = BalanceHelper.dealEndDate((int)i, bizDates, (Date)balannce.getDate("bizdate"), (Object)accountBankId, (Object)currencyId, updateBalances);
                balannce.set("enddate", (Object)endDate);
                saveBalances.add(balannce);
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveBalances.toArray(new DynamicObject[0]));
        if (updateBalances.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateBalances.toArray(new DynamicObject[0]));
        }
    }

    private void checkAccountBank(Map<String, Object> rowData) {
        JSONObject account = (JSONObject)rowData.get("accountbank");
        if (EmptyUtil.isEmpty((Object)account)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceBatchImportOp_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        String accountNum = account.getString("bankaccountnumber");
        DynamicObject accountDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id, company, currency, issetbankinterface, finorgtype, isvirtual", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)accountNum)});
        if (EmptyUtil.isEmpty((DynamicObject)accountDO)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u4e0d\u5b58\u5728\u3002", (String)"BalanceBatchImportOp_4", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
            return;
        }
        if (accountDO.getBoolean("isvirtual")) {
            this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s \u662f\u865a\u62df\u8d26\u6237\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\u4f59\u989d\u3002", (String)"BalanceBatchImportOp_13", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
            return;
        }
        DynamicObject company = accountDO.getDynamicObject("company");
        Long orgId = company.getLong(ID);
        int hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)AppMetadataCache.getAppInfo((String)"bei").getId(), (String)"bei_bankbalance", (String)"4730fc9f000003ae");
        if (hasPermission == 0) {
            this.addErrMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8d26\u6237\u4f59\u989d\u7684\u5bfc\u5165\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5bfc\u5165\u4f59\u989d\u3002", (String)"BalanceBatchImportOp_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else if (FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(accountDO.getString("finorgtype"))) {
            this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\uff1a%s\u662f\u5185\u90e8\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5bfc\u5165\u4f59\u989d\u3002", (String)"BalanceBatchImportOp_10", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
        }
        if (accountDO.getBoolean("issetbankinterface")) {
            QFilter queryFilter = new QFilter(ID, "=", (Object)accountDO.getLong(ID)).and("entry.e_enable", "=", (Object)"1").and("entry.e_bankfunction", "=", (Object)BankFuncEnum.QUERY.getValue());
            DynamicObjectCollection banks = QueryServiceHelper.query((String)"am_accountbank", (String)"id,bankaccountnumber,entry", (QFilter[])new QFilter[]{queryFilter});
            if (banks != null && !banks.isEmpty()) {
                this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u5df2\u5f00\u542f\u94f6\u4f01\u63a5\u53e3\uff0c\u4e0d\u80fd\u624b\u5de5\u5bfc\u5165\u4f59\u989d\u3002", (String)"BalanceBatchImportOp_9", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
            } else {
                queryFilter = new QFilter(ID, "=", (Object)accountDO.getLong(ID)).and("entry.e_enable", "=", (Object)"1");
                banks = QueryServiceHelper.query((String)"am_accountbank", (String)"id,bankaccountnumber,entry", (QFilter[])new QFilter[]{queryFilter});
                if (banks == null || banks.isEmpty()) {
                    this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u5df2\u5f00\u542f\u94f6\u4f01\u63a5\u53e3\uff0c\u4e0d\u80fd\u624b\u5de5\u5bfc\u5165\u4f59\u989d\u3002", (String)"BalanceBatchImportOp_9", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
                }
            }
        }
        JSONObject currency = (JSONObject)rowData.get("currency");
        String currencyNum = "";
        if (EmptyUtil.isEmpty((Object)currency)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceBatchImportOp_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else {
            currencyNum = currency.getString("number");
        }
        Set currencyList = accountDO.getDynamicObjectCollection("currency").stream().map(cur -> cur.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toSet());
        if (!currencyList.contains(currencyNum)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u8d26\u6237\u3010%s\u3011\u4e0d\u5305\u542b\u8be5\u5e01\u79cd\u3002", (String)"BalanceBatchImportOp_12", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
        }
        rowData.put("company", JSON.parseObject((String)SerializationUtils.toJsonString((Object)company)));
    }
}

