/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.opplugin.elec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.BeiParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.opplugin.sysimport.AbstractTmcBatchImportPlugin;

public class ReceiptImportOp
extends AbstractTmcBatchImportPlugin {
    private static final String ID = "id";
    private static final String SYSTEM_TYPE = "tmc-bei-opplugin";

    protected void beforeImportOp(Map<String, Object> rowData, Map<String, Object> option) {
        this.checkAccountBank(rowData);
        Date bizDate = DateUtils.stringToDate((String)((String)rowData.get("bizdate")), (String)"yyyy-MM-dd");
        if (EmptyUtil.isEmpty((Object)bizDate)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceBatchImportOp_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else if (bizDate.after(new Date())) {
            this.addErrMessage(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7cfb\u7edf\u5f53\u524d\u65e5\u671f\u3002", (String)"ReceiptImportOp_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    protected void afterImportOp(List<Map<String, Object>> datas) {
    }

    protected void beforeSave(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.beforeSave(rowdatas, logger);
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            data.put("datasource", (Object)DataSourceEnum.IMPORT.getValue());
        }
    }

    private void checkAccountBank(Map<String, Object> rowData) {
        JSONObject account = (JSONObject)rowData.get("accountbank");
        if (EmptyUtil.isEmpty((Object)account)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceBatchImportOp_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        String accountNum = account.getString("bankaccountnumber");
        DynamicObject accountDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id, company, currency, issetbankinterface, finorgtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)accountNum)});
        if (EmptyUtil.isEmpty((DynamicObject)accountDO)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u4e0d\u5b58\u5728\u3002", (String)"BalanceBatchImportOp_4", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
            return;
        }
        DynamicObject company = accountDO.getDynamicObject("company");
        Long orgId = company.getLong(ID);
        int hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)AppMetadataCache.getAppInfo((String)"bei").getId(), (String)"bei_elecreceipt", (String)"4730fc9f000003ae");
        if (hasPermission == 0) {
            this.addErrMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7535\u5b50\u56de\u5355\u5bfc\u5165\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5bfc\u5165\u4f59\u989d\u3002", (String)"ReceiptImportOp_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else if (FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(accountDO.getString("finorgtype"))) {
            this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\uff1a%s\u662f\u5185\u90e8\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5bfc\u5165\u4f59\u989d\u3002", (String)"BalanceBatchImportOp_10", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
        }
        if (accountDO.getBoolean("issetbankinterface")) {
            boolean isPredictOpenDate = BeiParameterHelper.getAppBoolParameter((long)Long.parseLong(company.getPkValue().toString()), (String)"bei008");
            if (isPredictOpenDate) {
                QFilter queryFilter = new QFilter(ID, "=", (Object)accountDO.getLong(ID)).and("entry.e_enable", "=", (Object)"1").and("entry.e_bankfunction", "=", (Object)BankFuncEnum.QUERY.getValue());
                DynamicObjectCollection banks = QueryServiceHelper.query((String)"am_accountbank", (String)"id,bankaccountnumber,entry,entry.e_predictopendate", (QFilter[])new QFilter[]{queryFilter});
                if (!EmptyUtil.isEmpty((DynamicObjectCollection)banks)) {
                    if (((DynamicObject)banks.get(0)).getDate("entry.e_predictopendate") != null) {
                        Date predictOpendate = DateUtils.getDataFormat((Date)((DynamicObject)banks.get(0)).getDate("entry.e_predictopendate"), (boolean)true);
                        Date bizDate = DateUtils.stringToDate((String)((String)rowData.get("bizdate")), (String)"yyyy-MM-dd");
                        if (bizDate.compareTo(predictOpendate) >= 0) {
                            this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c%s\u201d\u5df2\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\u4e14\u4ea4\u6613\u65e5\u671f\u5927\u4e8e\u7b49\u4e8e\u8be5\u8d26\u6237\u94f6\u4f01\u63a5\u53e3\u67e5\u8be2\u529f\u80fd\u7684\u9884\u8ba1\u5f00\u901a\u65f6\u95f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ReceiptImportOp_3", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
                        }
                    } else {
                        this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u5df2\u5f00\u542f\u94f6\u4f01\u63a5\u53e3\uff0c\u4e0d\u80fd\u624b\u5de5\u5bfc\u5165\u3002", (String)"ReceiptImportOp_4", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
                    }
                } else {
                    queryFilter = new QFilter(ID, "=", (Object)accountDO.getLong(ID)).and("entry.e_enable", "=", (Object)"1").and("entry.e_bankfunction", "!=", (Object)BankFuncEnum.QUERY.getValue());
                    banks = QueryServiceHelper.query((String)"am_accountbank", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{queryFilter});
                    if (banks == null || banks.isEmpty()) {
                        this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u5df2\u5f00\u542f\u94f6\u4f01\u63a5\u53e3\uff0c\u4e0d\u80fd\u624b\u5de5\u5bfc\u5165\u3002", (String)"ReceiptImportOp_4", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
                    }
                }
            } else {
                this.addErrMessage(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u5df2\u5f00\u542f\u94f6\u4f01\u63a5\u53e3\uff0c\u4e0d\u80fd\u624b\u5de5\u5bfc\u5165\u3002", (String)"ReceiptImportOp_4", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
            }
        }
        JSONObject currency = (JSONObject)rowData.get("currency");
        String currencyNum = "";
        if (EmptyUtil.isEmpty((Object)currency)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceBatchImportOp_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else {
            currencyNum = currency.getString("number");
        }
        Set currencyList = accountDO.getDynamicObjectCollection("currency").stream().map(cur -> cur.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toSet());
        if (!currencyList.contains(currencyNum)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u8d26\u6237\u3010%s\u3011\u4e0d\u5305\u542b\u8be5\u5e01\u79cd\u3002", (String)"BalanceBatchImportOp_12", (String)SYSTEM_TYPE, (Object[])new Object[]{accountNum}));
        }
        rowData.put("company", JSON.parseObject((String)SerializationUtils.toJsonString((Object)company)));
    }
}

