/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.opplugin.missing;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.bei.business.helper.BalanceCheckErrorHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class MissingRecordCheckErrorOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MissingRecordCheckErrorOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        Map variables = this.getOption().getVariables();
        String cycle = (String)variables.get("schedule_cycle");
        Date bizDate = this.getBizeDate(cycle);
        String bankNumber = (String)variables.get("bankaccountnumber");
        logger.info("begin process cycle {} bankNumber {}", (Object)cycle, (Object)bankNumber);
        DynamicObjectCollection accountbanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{this.getAccountFilter(variables)});
        if (CollectionUtils.isNotEmpty((Collection)accountbanks)) {
            List acctIds = accountbanks.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
            BalanceCheckErrorHelper.processBankCheck(acctIds, (Date)bizDate, (String)bankNumber);
        }
    }

    private Date getBizeDate(String cycle) {
        Date startdate = DateUtils.getCurrentDate();
        int cyc = StringUtils.isNotEmpty((CharSequence)cycle) ? Integer.parseInt(cycle) : 1;
        startdate = DateUtils.getLastDay((Date)startdate, (int)cyc);
        return startdate;
    }

    private QFilter getAccountFilter(Map<String, String> variables) {
        QFilter filter = new QFilter("acctstatus", "=", (Object)"normal");
        String bankNumber = variables.get("bankaccountnumber");
        String issetbankinterface = variables.get("issetbankinterface");
        if (StringUtils.isNotBlank((CharSequence)bankNumber)) {
            String[] number = bankNumber.split(",");
            filter.and("bankaccountnumber", "in", (Object)number);
        }
        if (StringUtils.isNotBlank((CharSequence)issetbankinterface)) {
            filter.and("issetbankinterface", "=", (Object)issetbankinterface);
        }
        return filter;
    }
}

