/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.opplugin.workbench;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.business.helper.CasFlowConfirmLogHelper;
import kd.tmc.bei.business.service.factory.AutoMatchServiceFactory;
import kd.tmc.bei.business.validate.workbench.PassiveCancelEnterValidator;
import kd.tmc.bei.common.enums.FlowOperateTypeEnum;
import kd.tmc.bei.common.param.AutoMatchInfoParam;

public class PassiveCancelEnterOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PassiveCancelEnterOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("claimnoticebillno");
        fieldKeys.add("receredtype");
        fieldKeys.add("smartmatch");
        fieldKeys.add("billno");
        fieldKeys.add("recedbillnumber");
        fieldKeys.add("claimnoticebillno");
        fieldKeys.add("accountbank");
        fieldKeys.add("currency");
        fieldKeys.add("bankcheckflag");
        fieldKeys.add("bizdate");
        fieldKeys.add("rulename");
        fieldKeys.add("ishandlink");
        fieldKeys.add("recedbilltype");
        fieldKeys.add("receredway");
        fieldKeys.add("isreced");
        fieldKeys.add("oppunit");
        fieldKeys.add("accountbank");
        fieldKeys.add("company");
        fieldKeys.add("datasource");
        fieldKeys.add("recedbillentryid");
        fieldKeys.add("debitamount");
        fieldKeys.add("creditamount");
        fieldKeys.addAll(AutoMatchHelper.getMatchFieldKeys());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        PassiveCancelEnterValidator validator = new PassiveCancelEnterValidator();
        validator.setEntityKey("bei_intelpay");
        e.addValidator((AbstractValidator)validator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        logger.info("beginOperationTransaction is start");
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List selectedPks = Arrays.stream(dataEntities).map(o -> o.getPkValue()).collect(Collectors.toList());
        logger.info("beginOperationTransaction selectedPks is:" + SerializationUtils.toJsonString(selectedPks));
        this.updataRecedBillEntry(dataEntities);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Map bizDateMap = AutoMatchServiceHelper.getBizDate((DynamicObject[])dataEntities);
        ArrayList tAutoMatchInfoList = new ArrayList(0);
        Arrays.stream(dataEntities).forEach(transDetail -> {
            transDetail.getDynamicObjectCollection("recedbillentry").forEach(item -> {
                Date traceDate = null;
                if (bizDateMap.containsKey(item.getString("e_recedbilltype"))) {
                    traceDate = (Date)((Map)bizDateMap.get(item.getString("e_recedbilltype"))).get(item.getLong("e_recedbillid"));
                }
                tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelpay", transDetail.getString("billno"), Long.valueOf(transDetail.getLong("id")), item.getString("e_recedbilltype"), item.getString("e_recedbillnumber"), Long.valueOf(item.getLong("e_recedbillid")), Long.valueOf(item.getLong("e_recedbillentryid")), Long.valueOf(transDetail.getLong("currency.id")), item.getString("e_amttype"), item.getBigDecimal("e_amount"), transDetail.getString("bankcheckflag"), traceDate));
            });
            if (transDetail.getDynamicObjectCollection("recedbillentry").isEmpty()) {
                tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelpay", transDetail.getString("billno"), Long.valueOf(transDetail.getLong("id")), null, null, Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(transDetail.getLong("currency.id")), null, transDetail.getBigDecimal("debitamount"), transDetail.getString("bankcheckflag"), null));
            }
        });
        AutoMatchServiceFactory.getAutoMatchService().execute(tAutoMatchInfoList, null, null, false, null);
        CasFlowConfirmLogHelper.saveCancelLog(Arrays.stream(dataEntities).map(m -> m.getLong("id")).collect(Collectors.toList()), (String)FlowOperateTypeEnum.CANCELGEN.getValue());
    }

    private void updataRecedBillEntry(DynamicObject[] dataEntities) {
        Map recedbilltypeMap = Arrays.stream(dataEntities).filter(transDetail -> transDetail.getDynamicObjectCollection("recedbillentry").size() < 1).filter(o -> o.getString("recedbilltype") != null && o.getString("recedbilltype").trim().length() > 0 && o.getString("recedbillnumber") != null && o.getString("recedbillnumber").trim().length() > 0).collect(Collectors.groupingBy(k -> k.getString("recedbilltype"), Collectors.mapping(o -> o.getString("recedbillnumber"), Collectors.toSet())));
        HashMap<String, Map<String, Long>> tRecedBillsMap = new HashMap<String, Map<String, Long>>(recedbilltypeMap.size());
        for (Map.Entry tRecedBillsEntry : recedbilltypeMap.entrySet()) {
            try {
                QFilter qFilter = new QFilter("billno", "in", tRecedBillsEntry.getValue());
                DynamicObjectCollection billnos = QueryServiceHelper.query((String)tRecedBillsEntry.getKey(), (String)"id,billno", (QFilter[])qFilter.toArray());
                tRecedBillsMap.put(tRecedBillsEntry.getKey(), billnos.stream().collect(Collectors.toMap(k -> k.getString("billno"), v -> v.getLong("id"))));
            }
            catch (Exception ex) {
                logger.info("\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff1a\u5143\u6570\u636e\uff08" + tRecedBillsEntry.getKey() + "\uff09\u9519\u8bef\u4fe1\u606f\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            }
        }
        if (tRecedBillsMap.size() > 0) {
            String thisOpnumber = DB.genGlobalLongId() + "";
            Arrays.stream(dataEntities).filter(transDetail -> transDetail.getDynamicObjectCollection("recedbillentry").size() < 1).forEach(transDetail -> {
                String recedbilltype = transDetail.getString("recedbilltype");
                String recedbillnumber = transDetail.getString("recedbillnumber");
                if (tRecedBillsMap.containsKey(recedbilltype) && ((Map)tRecedBillsMap.get(recedbilltype)).containsKey(recedbillnumber)) {
                    AutoMatchHelper.setRecedBillEntry((DynamicObject)transDetail, (String)transDetail.getString("recedbilltype"), (String)transDetail.getString("recedbillnumber"), (Long)((Long)((Map)tRecedBillsMap.get(recedbilltype)).get(recedbillnumber)), (Long)transDetail.getLong("recedbillentryid"), null, (BigDecimal)transDetail.getBigDecimal("debitamount"), (String)thisOpnumber, (String)"pay");
                }
            });
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
    }
}

