/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.opplugin.workbench;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.helper.CasFlowConfirmLogHelper;
import kd.tmc.bei.common.enums.FlowOperateTypeEnum;
import kd.tmc.bei.common.enums.ReceredTypeEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;

public class RecPayCancelMarkConfirmedOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("receredtype");
        fieldKeys.add("receredway");
        fieldKeys.add("accountbank");
        fieldKeys.add("currency");
        fieldKeys.add("company");
        fieldKeys.add("bizdate");
        fieldKeys.add("billno");
        fieldKeys.add("creditamount");
        fieldKeys.add("debitamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject transDetail = dataEntity.getDataEntity();
                    String receredType = transDetail.getString("receredtype");
                    String receredWay = transDetail.getString("receredway");
                    if (ReceredTypeEnum.NONEEDCONFIRM.getValue().equals(receredType) || ReceredWayEnum.CONFIRM.getValue().equals(receredWay)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u786e\u8ba4\u65b9\u5f0f\u4e3a\u624b\u5de5\u6807\u8bb0\u5df2\u786e\u8ba4\u6216\u786e\u8ba4\u72b6\u6001\u4e3a\u65e0\u9700\u786e\u8ba4\u7684\uff0c\u624d\u5141\u8bb8\u89e6\u53d1\u8be5\u64cd\u4f5c\u3002", (String)"RecPayCancelMarkConfirmedOp_0", (String)"tmc-bei-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject transDatail : dataEntities = e.getDataEntities()) {
            String receredType = transDatail.getString("receredtype");
            String receredWay = transDatail.getString("receredway");
            if (ReceredTypeEnum.RECERED.getValue().equals(receredType) && ReceredWayEnum.CONFIRM.getValue().equals(receredWay)) {
                transDatail.set("receredtype", (Object)ReceredTypeEnum.UNRECERED.getValue());
                transDatail.set("receredway", null);
            }
            if (!ReceredTypeEnum.NONEEDCONFIRM.getValue().equals(receredType)) continue;
            transDatail.set("receredtype", (Object)ReceredTypeEnum.UNRECERED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        CasFlowConfirmLogHelper.saveCancelLog(Arrays.stream(dataEntities).map(m -> m.getLong("id")).collect(Collectors.toList()), (String)FlowOperateTypeEnum.CANCELMARK.getValue());
    }
}

