/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.opplugin.workbench;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.helper.CasFlowConfirmLogHelper;
import kd.tmc.bei.common.enums.FlowOperateTypeEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RecPayMarkNoNeedConfirmOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("claimnoticebillno");
        fieldKeys.add("receredtype");
        fieldKeys.add("accountbank");
        fieldKeys.add("currency");
        fieldKeys.add("company");
        fieldKeys.add("bizdate");
        fieldKeys.add("billno");
        fieldKeys.add("creditamount");
        fieldKeys.add("debitamount");
        fieldKeys.add("kdretflag");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject transDetail = dataEntity.getDataEntity();
                    String claimNoticeBillNo = transDetail.getString("claimnoticebillno");
                    String receredType = transDetail.getString("receredtype");
                    if (!ReceredtypeEnum.Pending.getValue().equals(receredType) || EmptyUtil.isNoEmpty((String)claimNoticeBillNo)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u786e\u8ba4\u72b6\u6001\u4e3a\u5f85\u786e\u8ba4\u4e14\u8ba4\u9886\u901a\u77e5\u5355\u4e3a\u7a7a\u7684\uff0c\u624d\u5141\u8bb8\u89e6\u53d1\u8be5\u64cd\u4f5c\u3002", (String)"RecPayMarkNoNeedConfirmOp_0", (String)"tmc-bei-opplugin", (Object[])new Object[0]));
                    }
                    if (!EmptyUtil.isNoEmpty((String)transDetail.getString("kdretflag"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%1$s\uff09\u64cd\u4f5c\u5931\u8d25\u3002\u8be5\u4ea4\u6613\u660e\u7ec6\u6709\u201cKD\u6807\u8bc6\u201d\u4fe1\u606f\uff0c\u4e3a\u94f6\u4f01\u4ed8\u6b3e\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u5e94\u7531\u7cfb\u7edf\u8fdb\u884c\u81ea\u52a8\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6309\u89c4\u5219\u751f\u5355\u3001\u624b\u5de5\u751f\u5355\u3001\u76f4\u63a5\u6807\u8bb0\u5df2\u786e\u8ba4\u3001\u6807\u8bb0\u4e3a\u65e0\u9700\u786e\u8ba4\u3001\u901a\u77e5\u8ba4\u9886\u7b49\u64cd\u4f5c\u3002", (String)"RecWorkbenchList_46", (String)"tmc-bei-formplugin", (Object[])new Object[]{transDetail.getString("billno")}));
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Arrays.stream(dataEntities).forEach(t -> t.set("receredtype", (Object)ReceredtypeEnum.NOCONFIRM.getValue()));
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        CasFlowConfirmLogHelper.saveMarkLog(Arrays.stream(dataEntities).collect(Collectors.toList()), (String)FlowOperateTypeEnum.MARKNOCONFIRM.getValue());
    }
}

