/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.convert;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.bei.common.helper.DetailInfoExtFieldsHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.graalvm.collections.Pair;

public class BankCheckFlagConverter
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map detailInfoFieldsMap = DetailInfoExtFieldsHelper.getDetailInfoFields((String)targetEntityNumber);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            StringBuilder str = new StringBuilder();
            DynamicObject targetBill = billDataEntity.getDataEntity();
            for (DynamicObject object : srcData) {
                Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue((Object)object);
                DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)this.getSrcMainType());
                if (sourceBill == null) continue;
                Object bankCheckFlag = sourceBill.get("bankcheckflag");
                this.setBankCheckFlagEntity(sourceBill, targetBill, detailInfoFieldsMap);
                if (!EmptyUtil.isNoEmpty((Object)bankCheckFlag)) continue;
                str.append(bankCheckFlag).append(',');
            }
            String strFlag = str.toString();
            if (EmptyUtil.isNoEmpty((String)strFlag) && strFlag.length() >= 1) {
                strFlag = strFlag.substring(0, strFlag.length() - 1);
            }
            targetBill.set("bankcheckflag_tag", (Object)strFlag);
            targetBill.set("bankcheckflag", (Object)strFlag);
        }
    }

    private void setBankCheckFlagEntity(DynamicObject sourceBill, DynamicObject targetBill, Map<String, Pair<String, DataType>> detailInfoFieldsMap) {
        if (targetBill.containsProperty("bankcheckentity")) {
            List eBankCheckEntity;
            DynamicObjectCollection bankCheckEntity = targetBill.getDynamicObjectCollection("bankcheckentity");
            Object bankCheckFlag = sourceBill.get("bankcheckflag");
            if (bankCheckFlag == null) {
                return;
            }
            String flag = bankCheckFlag.toString();
            if (EmptyUtil.isEmpty((String)flag)) {
                return;
            }
            if (bankCheckEntity.stream().noneMatch(o -> flag.equalsIgnoreCase(o.getString("ebankcheckflag")))) {
                DynamicObject entry = bankCheckEntity.addNew();
                entry.set("ebankcheckflag", (Object)flag);
                DetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)sourceBill, (DynamicObject)entry, detailInfoFieldsMap);
            } else if (bankCheckEntity.stream().anyMatch(o -> Objects.equals(o.getString("ebankcheckflag"), flag)) && !(eBankCheckEntity = bankCheckEntity.stream().filter(o -> flag.equals(o.getString("ebankcheckflag"))).collect(Collectors.toList())).isEmpty()) {
                for (DynamicObject dynamicObject : eBankCheckEntity) {
                    DetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)sourceBill, (DynamicObject)dynamicObject, detailInfoFieldsMap);
                }
            }
        }
    }
}

