/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.sdk.tmc.bei.extpoint.transdetail.IDeleteTransDetail;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.helper.TransDetailHelper;
import kd.tmc.bei.business.opservice.param.DetailQueryParam;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.fbp.common.compare.concurrent.MultiThreadOperationExecutor;
import kd.tmc.fbp.common.constant.InvocationTaskVO;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.DetailQueryInfo;
import kd.tmc.fbp.webapi.ebentity.biz.detail.Detail;

public class EBDetailQueryService {
    private static final Log logger = LogFactory.getLog(EBDetailQueryService.class);
    List<TransDetailResult> results;
    private DetailQueryParam detailQueryParam;

    public EBDetailQueryService(DetailQueryParam detailQueryParam) {
        this.detailQueryParam = detailQueryParam;
        this.results = Collections.synchronizedList(new ArrayList());
    }

    public EBDetailQueryService() {
    }

    public List<TransDetailResult> downTransDetails() {
        List<Long> bankAcctIds = this.detailQueryParam.getIdList();
        DynamicObject[] bankAccts = BusinessDataServiceHelper.load((Object[])bankAcctIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
        List bankAcctList = Arrays.stream(bankAccts).collect(Collectors.toList());
        new MultiThreadOperationExecutor().doBatchOperation(bankAcctList, 8, dataList -> {
            for (DynamicObject accountBank : dataList) {
                logger.info("\u5f53\u524d\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\u7ebf\u7a0b\uff1a{}\uff0c\u94f6\u884c\u8d26\u53f7\uff1a{}", (Object)Thread.currentThread().getName(), accountBank.get("number"));
                DynamicObjectCollection currencies = new DynamicObjectCollection();
                if (this.detailQueryParam.getCurr() != null) {
                    currencies.add((Object)this.detailQueryParam.getCurr());
                } else {
                    for (DynamicObject currency : accountBank.getDynamicObjectCollection("currency")) {
                        currencies.add((Object)currency.getDynamicObject("fbasedataid"));
                    }
                }
                this.downDetails(accountBank, currencies);
            }
            return bankAcctList;
        });
        return this.results;
    }

    private void downDetails(DynamicObject accountBank, DynamicObjectCollection currencies) {
        ArrayList<InvocationTaskVO> taskVoList = new ArrayList<InvocationTaskVO>(0);
        block0: for (DynamicObject currency : currencies) {
            ArrayList<String> detailIds = new ArrayList<String>();
            ArrayList<String> uniqueSeqIds = new ArrayList<String>();
            DetailQueryInfo detailQueryInfo = new DetailQueryInfo();
            detailQueryInfo.setIdList(this.detailQueryParam.getIdList());
            detailQueryInfo.setBeginDate(this.detailQueryParam.getBeginDate());
            detailQueryInfo.setEndDate(this.detailQueryParam.getEndDate());
            detailQueryInfo.setAsyncTask(this.detailQueryParam.isAsyncTask());
            detailQueryInfo.setDownloadFromBank(this.detailQueryParam.isDownloadFromBank());
            detailQueryInfo.setSchedule(this.detailQueryParam.isSchedule());
            int progress = 0;
            int totalCount = 0;
            while (detailQueryInfo.isSuccess() && !detailQueryInfo.isLastPage()) {
                detailQueryInfo.setBankAcct(accountBank);
                detailQueryInfo.setCurr(currency);
                detailQueryInfo.setOrgId(Long.valueOf(TmcAccountHelper.getCreateOrgByBankAcct((DynamicObject)accountBank)));
                TransDetailResult transDetailResult = EBServiceFacadeFactory.getBankService().downTransDetails(detailQueryInfo, new DynamicObject[0]);
                if (detailQueryInfo.isDownloadFromBank() && transDetailResult != null && transDetailResult.isTimeOut()) {
                    detailQueryInfo.setDownloadFromBank(false);
                    detailQueryInfo.setPageNum(detailQueryInfo.getPageNum() - 1);
                    transDetailResult = EBServiceFacadeFactory.getBankService().downTransDetails(detailQueryInfo, new DynamicObject[0]);
                    detailQueryInfo.setDownloadFromBank(true);
                }
                if (!Objects.nonNull(transDetailResult)) continue;
                totalCount = transDetailResult.getTotalCount();
                progress = transDetailResult.getProgress();
                this.results.add(transDetailResult);
                if (progress == 0) {
                    logger.info("\u5f53\u524d\u5e01\u79cd {} \u672a\u5728\u4e0b\u8f7d\uff0c\u76f4\u63a5continue\u8fdb\u5165\u4e0b\u6b21\u5e01\u79cd\u5faa\u73af\u3002", currency == null ? null : currency.get("number"));
                    continue block0;
                }
                if (CollectionUtils.isEmpty(transDetailResult.getDetailIds())) continue;
                detailIds.addAll(transDetailResult.getDetailIds());
                for (Detail detail : transDetailResult.getDetails()) {
                    if (!EmptyUtil.isNoEmpty((String)detail.getUniqueSeq())) continue;
                    uniqueSeqIds.add(detail.getUniqueSeq());
                }
            }
            logger.info("\u5faa\u73af\u7ed3\u675f\uff1adetailQueryInfo.isSuccess() = {}, detailQueryInfo.isLastPage() = {}", (Object)detailQueryInfo.isSuccess(), (Object)detailQueryInfo.isLastPage());
            if (!CollectionUtils.isEmpty(detailIds)) {
                HashSet<String> checkRepeat = new HashSet<String>(detailIds.size());
                checkRepeat.addAll(detailIds);
                if (totalCount != checkRepeat.size()) {
                    logger.info(" transDetail[detailIds] from ebg is repeated ");
                    throw new KDBizException("transDetail[detailIds] from ebg is repeated");
                }
                this.deleteNoExistDetail(accountBank, currency, detailIds, uniqueSeqIds);
            } else {
                logger.info("detailIds is empty");
            }
            if (false != progress) continue;
            if (!detailQueryInfo.isAsyncTask()) {
                logger.info("\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u53c2\u6570\u8fdb\u884c\u4e86\u91cd\u8bd5,\u8c03\u7528fbp:asyncInvocationTaskService");
                InvocationTaskVO taskVo = new InvocationTaskVO();
                taskVo.setAppId("bei");
                taskVo.setCloudId("tmc");
                taskVo.setServiceName("TransDetailAsyncService");
                taskVo.setMethodName("asyncExecute");
                taskVo.setMaxRetryCount(10);
                ArrayList<String> params = new ArrayList<String>(0);
                String accountBanksJson = JSON.toJSONString((Object)detailQueryInfo.getBankAcct().getPkValue());
                params.add(accountBanksJson);
                String currJson = JSON.toJSONString((Object)detailQueryInfo.getCurr().getPkValue());
                params.add(currJson);
                String startDateJson = JSON.toJSONString((Object)detailQueryInfo.getBeginDate());
                params.add(startDateJson);
                String endDateJson = JSON.toJSONString((Object)detailQueryInfo.getEndDate());
                params.add(endDateJson);
                taskVo.setParams(params);
                taskVoList.add(taskVo);
                continue;
            }
            TransDetailResult result = new TransDetailResult();
            result.setBillId((Long)accountBank.getPkValue());
            result.setErrMsg(ResManager.loadKDString((String)"\u5f02\u6b65\u8c03\u7528\u5931\u8d25\uff0c\u94f6\u4f01\u4e91\u8fd4\u56de\u7684progress\u6807\u8bc6\u4e3a0\u3002", (String)"TransDetailDownService_2", (String)"tmc-bei-business", (Object[])new Object[0]));
            this.results.add(result);
        }
        if (taskVoList.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"asyncInvocationTaskService", (String)"submit", (Object[])taskVoList.toArray());
        }
    }

    public void deleteNoExistDetail(DynamicObject bankAcct, DynamicObject currency, List<String> detailIds, List<String> uniqueSeqIds) {
        String selectProp;
        DynamicObject[] details;
        PluginProxy pluginProxy;
        List extFilters;
        QFilter filter = new QFilter("accountbank.id", "=", (Object)bankAcct.getLong("id")).and(new QFilter("currency.id", "=", (Object)currency.getLong("id"))).and(new QFilter("bizdate", ">=", (Object)this.detailQueryParam.getBeginDate())).and(new QFilter("bizdate", "<=", (Object)this.detailQueryParam.getEndDate())).and(new QFilter("detailid", "not in", detailIds)).and(new QFilter("datasource", "=", (Object)"frombank"));
        if (uniqueSeqIds.size() > 0) {
            logger.info("deleteNoExistDetail uniqueSeqIds size is not null");
            filter = filter.and(new QFilter("uniqueseq", "not in", uniqueSeqIds));
        }
        if ((extFilters = (pluginProxy = PluginProxy.create(IDeleteTransDetail.class, (String)"kd.sdk.tmc.bei.extpoint.transdetail.IDeleteTransDetail")).callReplace(p -> p.getQfilterCanDelete())) != null && extFilters.size() > 0) {
            for (QFilter extFilter : extFilters) {
                if (!EmptyUtil.isNoEmpty((Object)extFilter)) continue;
                filter = filter.and(extFilter);
            }
        }
        if ((details = TmcDataServiceHelper.load((String)"bei_transdetail_cas", (String)(selectProp = "id,errortype,errormsg,ismatchereceipt,isdowntobankstate,isdownbankjournal,receredtype,claimnoticebillno,istransdown,istransup,isbankwithholding,isreced"), (QFilter[])filter.toArray())).length > 0) {
            List<DynamicObject> toUpdateList = Arrays.stream(details).filter(t -> !TransDetailHelper.noneBusiness(t)).map(t -> {
                t.set("errortype", (Object)"D");
                t.set("errormsg", (Object)ResManager.loadKDString((String)"\u6700\u8fd1\u4e00\u6b21\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\uff0c\u94f6\u884c\u8fd4\u56de\u7ed3\u679c\u4e0d\u5305\u542b\u8be5\u7b14\u660e\u7ec6\uff0c\u8be5\u7b14\u4ea4\u6613\u660e\u7ec6\u5df2\u5173\u8054\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EBDetailQueryService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
                return t;
            }).collect(Collectors.toList());
            List toDelete = Arrays.stream(details).filter(t -> TransDetailHelper.noneBusiness(t)).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(toDelete)) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas");
                DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])toDelete.toArray());
            }
            if (!CollectionUtils.isEmpty(toUpdateList)) {
                TmcDataServiceHelper.save((DynamicObject[])toUpdateList.toArray(new DynamicObject[0]));
            }
        } else {
            logger.info("deleteNoExistDetail is empty");
        }
    }
}

