/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.bei.business.ebservice.service.acct.BankAcctSyncService;
import kd.tmc.bei.business.ebservice.service.acct.GetLoginListService;
import kd.tmc.bei.business.ebservice.service.detail.BatchBalanceService;
import kd.tmc.bei.business.ebservice.service.detail.DetailQueryService;
import kd.tmc.bei.business.ebservice.service.detail.ELecStatementService;
import kd.tmc.bei.business.ebservice.service.detail.ElecBalanceMatchService;
import kd.tmc.bei.business.ebservice.service.detail.ElecBalanceQueryService;
import kd.tmc.bei.business.ebservice.service.detail.ElecReceiptService;
import kd.tmc.bei.business.ebservice.service.elecacc.ElecBalanceAccCommitBeService;
import kd.tmc.bei.business.ebservice.service.elecacc.ElecBalanceAccFeedBackService;
import kd.tmc.bei.business.ebservice.service.elecacc.ElecBalanceAccQueryService;
import kd.tmc.bei.business.ebservice.service.elecacc.ElecBalanceAccSyncService;
import kd.tmc.bei.business.ebservice.service.pay.BankAgentPayService;
import kd.tmc.bei.business.ebservice.service.pay.BankPayService;
import kd.tmc.bei.business.ebservice.service.pay.BankTransDownPayService;
import kd.tmc.bei.business.ebservice.service.pay.BankTransUpPayService;
import kd.tmc.bei.business.ebservice.service.query.BankAgentQueryService;
import kd.tmc.bei.business.ebservice.service.query.BankLinkPayQueryService;
import kd.tmc.bei.business.ebservice.service.query.BankPayQueryService;
import kd.tmc.bei.business.ebservice.service.query.BankTransDownQueryService;
import kd.tmc.bei.business.ebservice.service.query.BankTransUpQueryService;
import kd.tmc.bei.business.ebservice.service.update.BankAgentUpdateService;
import kd.tmc.bei.business.ebservice.service.update.BankPayUpdateService;
import kd.tmc.bei.business.ebservice.service.update.BankTransDownUpdateService;
import kd.tmc.bei.business.ebservice.service.update.BankTransUpUpdateService;
import kd.tmc.bei.business.opservice.param.BalanceReconciliationParam;
import kd.tmc.bei.business.opservice.param.ElecBalanceAccQueryParam;
import kd.tmc.bei.business.opservice.param.ElecBalanceQueryParam;
import kd.tmc.bei.business.opservice.param.ElecStatementPram;
import kd.tmc.bei.business.opservice.param.QueryBalanceReconciliationParam;
import kd.tmc.bei.business.opservice.param.UpdateBalanceReconciliationParam;
import kd.tmc.bei.business.opservice.queryinfo.BalanceQueryInfo;
import kd.tmc.bei.business.opservice.queryinfo.ReceiptQueryInfo;
import kd.tmc.bei.business.opservice.result.BalanceResult;
import kd.tmc.bei.business.opservice.result.ELecStatementResult;
import kd.tmc.bei.business.opservice.result.ElecBalanceResult;
import kd.tmc.bei.business.opservice.result.ElecReceiptResult;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.fbp.service.ebservice.bean.DetailQueryInfo;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBGetLoginListResult;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.service.IEBService;

public class EBServiceFactory {
    public static IEBService<List<SyncStatusInfo>> getPayService(List<DynamicObject> dataList, boolean isBankPay) {
        String entityName;
        switch (entityName = dataList.get(0).getDynamicObjectType().getName()) {
            case "bei_bankagentpay": {
                return new BankAgentPayService(dataList, isBankPay);
            }
            case "bei_bankpaybill": {
                return new BankPayService(dataList, isBankPay);
            }
            case "bei_banktransdownbill": {
                return new BankTransDownPayService(dataList, isBankPay);
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b%s\u3002", (String)"EBServiceFactory_0", (String)"tmc-bei-business", (Object[])new Object[0]), entityName));
    }

    public static IEBService<List<SyncStatusInfo>> getPayService(DynamicObject data, DynamicObject entry, boolean isBankPay) {
        return new BankTransUpPayService(data, entry, isBankPay);
    }

    public static IEBService<EBResult> getQueryPayService(List<DynamicObject> dataList, boolean isForceQuery) {
        String entityName;
        switch (entityName = dataList.get(0).getDynamicObjectType().getName()) {
            case "bei_bankagentpay": {
                return new BankAgentQueryService(dataList, isForceQuery);
            }
            case "bei_bankpaybill": {
                if (dataList.get(0).getBoolean("islinkpay")) {
                    return new BankLinkPayQueryService(dataList, isForceQuery);
                }
                return new BankPayQueryService(dataList, isForceQuery);
            }
            case "bei_banktransdownbill": {
                return new BankTransDownQueryService(dataList, isForceQuery);
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b%s\u3002", (String)"EBServiceFactory_0", (String)"tmc-bei-business", (Object[])new Object[0]), entityName));
    }

    public static IEBService<EBResult> getQueryPayService(DynamicObject data, DynamicObject entry, boolean isForceQuery) {
        return new BankTransUpQueryService(data, entry, isForceQuery);
    }

    public static IEBService<EBResult> getUpdateService(DynamicObject data, Map<Long, String> updateStatusMap) {
        String entityName;
        switch (entityName = data.getDynamicObjectType().getName()) {
            case "bei_bankagentpay": {
                return new BankAgentUpdateService(data, updateStatusMap);
            }
            case "bei_bankpaybill": {
                return new BankPayUpdateService(data, updateStatusMap);
            }
            case "bei_banktransdownbill": {
                return new BankTransDownUpdateService(data, updateStatusMap);
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b%s\u3002", (String)"EBServiceFactory_0", (String)"tmc-bei-business", (Object[])new Object[0]), entityName));
    }

    public static IEBService<EBResult> getUpdateService(DynamicObject data, DynamicObject entry, Map<Long, String> updateStatusMap) {
        return new BankTransUpUpdateService(data, entry, updateStatusMap);
    }

    public static IEBService<TransDetailResult> getDetailQueryService(DetailQueryInfo queryInfo) {
        return new DetailQueryService(queryInfo);
    }

    public static IEBService<BalanceResult> getBatchBalanceService(BalanceQueryInfo queryInfo) {
        return new BatchBalanceService(queryInfo);
    }

    public static IEBService<ElecReceiptResult> getElecReceiptService(ReceiptQueryInfo queryInfo) {
        return new ElecReceiptService(queryInfo);
    }

    public static IEBService<EBGetLoginListResult> getLoginListService(DynamicObject bankAcct) {
        return new GetLoginListService(bankAcct);
    }

    public static IEBService<EBResult> syncBankAcct(DynamicObject bankAcct, boolean isDelete) {
        return new BankAcctSyncService(bankAcct, isDelete);
    }

    public static IEBService<EBResult> syncBankAccts(List<DynamicObject> bankAccts, boolean isDelete) {
        return new BankAcctSyncService(bankAccts, isDelete);
    }

    public static IEBService<ElecBalanceResult> getElecBalanceQueryService(ElecBalanceQueryParam queryInfo) {
        return new ElecBalanceQueryService(queryInfo);
    }

    public static IEBService<ElecBalanceResult> getMatchElecBalanceService(DynamicObject elecBalanceBill, Boolean isMatch) {
        return new ElecBalanceMatchService(elecBalanceBill, isMatch);
    }

    public static IEBService<ELecStatementResult> getElecStatementService(ElecStatementPram queryInfo) {
        return new ELecStatementService(queryInfo);
    }

    public static IEBService<ElecBalanceResult> getElecBalanceAccQueryService(ElecBalanceAccQueryParam queryParam) {
        return new ElecBalanceAccQueryService(queryParam);
    }

    public static IEBService<ElecBalanceResult> getElecBalanceAccCommitBeService(BalanceReconciliationParam commitBeParam) {
        return new ElecBalanceAccCommitBeService(commitBeParam);
    }

    public static IEBService<ElecBalanceResult> getElecBalanceAccFeedBackService(UpdateBalanceReconciliationParam feedBackParam) {
        return new ElecBalanceAccFeedBackService(feedBackParam);
    }

    public static IEBService<ElecBalanceResult> getElecBalanceAccSyncService(QueryBalanceReconciliationParam queryParam) {
        return new ElecBalanceAccSyncService(queryParam);
    }
}

