/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.ebservice.EBServiceFactory;
import kd.tmc.bei.business.ebservice.api.IEBServiceFacade;
import kd.tmc.bei.business.ebservice.service.EBServiceExecutorFactory;
import kd.tmc.bei.business.ebservice.service.others.BankPayBillSyncService;
import kd.tmc.bei.business.opservice.detail.SyncMatchBillTask;
import kd.tmc.bei.business.opservice.param.BalanceReconciliationParam;
import kd.tmc.bei.business.opservice.param.ElecBalanceAccQueryParam;
import kd.tmc.bei.business.opservice.param.ElecBalanceQueryParam;
import kd.tmc.bei.business.opservice.param.ElecStatementPram;
import kd.tmc.bei.business.opservice.param.QueryBalanceReconciliationParam;
import kd.tmc.bei.business.opservice.param.ReceiptQueryParam;
import kd.tmc.bei.business.opservice.param.UpdateBalanceReconciliationParam;
import kd.tmc.bei.business.opservice.queryinfo.BalanceQueryInfo;
import kd.tmc.bei.business.opservice.queryinfo.ReceiptQueryInfo;
import kd.tmc.bei.business.opservice.result.BalanceResult;
import kd.tmc.bei.business.opservice.result.ELecStatementResult;
import kd.tmc.bei.business.opservice.result.ElecBalanceResult;
import kd.tmc.bei.business.opservice.result.ElecReceiptResult;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.bei.common.enums.EBOperateTypeEnum;
import kd.tmc.bei.common.enums.QueryRequestStatusEnum;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.DetailQueryInfo;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBGetLoginListResult;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BEBizException;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.service.IEBServiceExecutor;
import kd.tmc.fbp.service.ebservice.service.executor.EBServiceBatchExecutor;

public class EBServiceFacadeImpl
implements IEBServiceFacade {
    private static final Log logger = LogFactory.getLog(EBServiceFacadeImpl.class);

    @Override
    public List<SyncStatusInfo> pay(List<DynamicObject> bankBillList, boolean isBankPay) {
        try (TXHandle ignore = TX.notSupported();){
            String entityName = bankBillList.get(0).getDataEntityType().getName();
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bei_banktransupbill")) {
                ArrayList resultList = new ArrayList(10);
                for (DynamicObject bankBill : bankBillList) {
                    DynamicObjectCollection entrys = bankBill.getDynamicObjectCollection("entrys");
                    for (DynamicObject entry : entrys) {
                        IEBService<List<SyncStatusInfo>> service = EBServiceFactory.getPayService(bankBill, entry, isBankPay);
                        IEBServiceExecutor ebServiceExecutor = EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.PAY);
                        resultList.addAll((Collection)ebServiceExecutor.execute(service));
                    }
                }
                ArrayList arrayList = resultList;
                return arrayList;
            }
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bei_bankpaybill") && !this.useSinglePay()) {
                EBServiceBatchExecutor<List<SyncStatusInfo>> batchPayExecutor = EBServiceExecutorFactory.createBatchPayExecutor(bankBillList, isBankPay);
                List resultList = batchPayExecutor.execute();
                List<SyncStatusInfo> bankBill = resultList.stream().flatMap(Collection::stream).collect(Collectors.toList());
                return bankBill;
            }
            ArrayList resultList = new ArrayList(bankBillList.size());
            for (DynamicObject bankBill : bankBillList) {
                IEBServiceExecutor ebServiceExecutor = EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.PAY);
                IEBService<List<SyncStatusInfo>> ebService = EBServiceFactory.getPayService(Collections.singletonList(bankBill), isBankPay);
                List currResult = (List)ebServiceExecutor.execute(ebService);
                resultList.addAll(currResult);
            }
            ArrayList arrayList = resultList;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EBResult> queryPay(List<DynamicObject> bankBillList, boolean isForceQuery) {
        try (TXHandle ignore = TX.notSupported();){
            ArrayList<EBResult> resultList = new ArrayList<EBResult>(bankBillList.size());
            String entityName = bankBillList.get(0).getDataEntityType().getName();
            if (entityName.equals("bei_banktransupbill")) {
                for (DynamicObject bankBill : bankBillList) {
                    DynamicObjectCollection entrys = bankBill.getDynamicObjectCollection("entrys");
                    for (DynamicObject entry : entrys) {
                        String entryStatus = entry.getString("status");
                        if (StringUtils.isNotEmpty((CharSequence)entryStatus) && BeBillStatusEnum.TS.getValue().equals(entryStatus)) continue;
                        EBResult result = new EBResult();
                        try {
                            IEBServiceExecutor ebServiceExecutor = EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.SYNC_STATUS);
                            IEBService<EBResult> service = EBServiceFactory.getQueryPayService(bankBill, entry, isForceQuery);
                            result = (EBResult)ebServiceExecutor.execute(service);
                        }
                        catch (Exception e2) {
                            logger.error(entityName + "\u540c\u6b65\u72b6\u6001\u5f02\u5e38,\u5206\u5f55id\uff1a" + entry.getLong("id") + e2.getMessage());
                            if (!EmptyUtil.isEmpty((String)result.getErrMsg())) continue;
                            result.setStatusCode(EBResultStatusCode.ERROR);
                            result.setErrMsg(e2.getMessage());
                        }
                        finally {
                            result.setBankBillId(Long.valueOf(bankBill.getLong("id")));
                            result.setPayBillId(Long.valueOf(bankBill.getLong("sourcebillid")));
                            result.setBankBillEntryId(Long.valueOf(entry.getLong("id")));
                            resultList.add(result);
                        }
                    }
                    BigDecimal actPayAmount = BigDecimal.ZERO;
                    int actPayCount = 0;
                    for (DynamicObject row : entrys) {
                        if (!BeBillStatusEnum.TS.getValue().equals(row.get("status"))) continue;
                        BigDecimal amount = row.getBigDecimal("transamt");
                        actPayAmount = actPayAmount.add(amount);
                        ++actPayCount;
                    }
                    bankBill.set("actamount", (Object)actPayAmount);
                    bankBill.set("actcount", (Object)actPayCount);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bankBill});
                }
            } else {
                String payStatusProp;
                String[] serialNumArr = (String[])bankBillList.stream().map(o -> o.getString("serialnumber")).toArray(String[]::new);
                Set bankBillIdSet = bankBillList.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                QFilter serializeFilter = new QFilter("serialnumber", "in", (Object)serialNumArr);
                if ("bei_bankpaybill".equals(entityName)) {
                    payStatusProp = "bankpaystate";
                } else if ("bei_bankagentpay".equals(entityName)) {
                    payStatusProp = "paystate";
                } else if ("bei_banktransdownbill".equals(entityName)) {
                    payStatusProp = "paystate";
                } else {
                    throw new IllegalArgumentException();
                }
                DynamicObjectCollection bankBillIdArr = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{serializeFilter});
                DynamicObject[] dbBankBillList = TmcDataServiceHelper.load((Object[])bankBillIdArr.stream().map(e -> e.get("id")).toArray(), (DynamicObjectType)bankBillList.get(0).getDynamicObjectType());
                Map<String, List<DynamicObject>> dbBankBillGrpMap = Arrays.stream(dbBankBillList).filter(o -> {
                    boolean isSelf = bankBillIdSet.contains(o.getLong("id"));
                    String payState = o.getString(payStatusProp);
                    boolean isNotTfAndTs = !BeBillStatusEnum.TF.getValue().equals(payState) && !BeBillStatusEnum.TS.getValue().equals(payState);
                    return isSelf || isNotTfAndTs;
                }).collect(Collectors.groupingBy(o -> o.getString("serialnumber")));
                Map<String, List<DynamicObject>> batchSeqIdGroup = bankBillList.stream().collect(Collectors.groupingBy(o -> o.getString("serialnumber")));
                for (Map.Entry<String, List<DynamicObject>> grpEntry : batchSeqIdGroup.entrySet()) {
                    EBResult result;
                    List<DynamicObject> batchBankBillList = dbBankBillGrpMap.get(grpEntry.getKey());
                    if (batchBankBillList == null || batchBankBillList.size() == 0) continue;
                    List<DynamicObject> grpList = grpEntry.getValue();
                    EBResult grpResult = new EBResult();
                    String errorMsg = "";
                    boolean isError = false;
                    try {
                        IEBServiceExecutor ebServiceExecutor = EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.SYNC_STATUS);
                        IEBService<EBResult> service = EBServiceFactory.getQueryPayService(batchBankBillList, isForceQuery);
                        grpResult = (EBResult)ebServiceExecutor.execute(service);
                    }
                    catch (Exception e3) {
                        try {
                            logger.error(entityName + "\u540c\u6b65\u72b6\u6001\u5f02\u5e38,\u6279\u6b21\u53f7\uff1a" + grpEntry.getKey() + e3.getMessage());
                            if (EmptyUtil.isEmpty((String)grpResult.getErrMsg())) {
                                errorMsg = e3.getMessage();
                                isError = true;
                            } else {
                                errorMsg = grpResult.getErrMsg();
                            }
                        }
                        catch (Throwable throwable) {
                            for (DynamicObject bankBill : grpList) {
                                EBResult result2 = new EBResult();
                                result2.setStatusCode(isError && grpResult.getStatusCode() == null ? EBResultStatusCode.ERROR : grpResult.getStatusCode());
                                result2.setErrCode(grpResult.getErrCode());
                                result2.setErrMsg(isError ? errorMsg : grpResult.getErrMsg());
                                result2.setBankBillId(Long.valueOf(bankBill.getLong("id")));
                                result2.setPayBillId(Long.valueOf(bankBill.getLong("sourcebillid")));
                                resultList.add(result2);
                            }
                            throw throwable;
                        }
                        for (DynamicObject bankBill : grpList) {
                            result = new EBResult();
                            result.setStatusCode(isError && grpResult.getStatusCode() == null ? EBResultStatusCode.ERROR : grpResult.getStatusCode());
                            result.setErrCode(grpResult.getErrCode());
                            result.setErrMsg(isError ? errorMsg : grpResult.getErrMsg());
                            result.setBankBillId(Long.valueOf(bankBill.getLong("id")));
                            result.setPayBillId(Long.valueOf(bankBill.getLong("sourcebillid")));
                            resultList.add(result);
                        }
                        continue;
                    }
                    for (DynamicObject bankBill : grpList) {
                        result = new EBResult();
                        result.setStatusCode(isError && grpResult.getStatusCode() == null ? EBResultStatusCode.ERROR : grpResult.getStatusCode());
                        result.setErrCode(grpResult.getErrCode());
                        result.setErrMsg(isError ? errorMsg : grpResult.getErrMsg());
                        result.setBankBillId(Long.valueOf(bankBill.getLong("id")));
                        result.setPayBillId(Long.valueOf(bankBill.getLong("sourcebillid")));
                        resultList.add(result);
                    }
                }
            }
            ArrayList<EBResult> arrayList = resultList;
            return arrayList;
        }
    }

    @Override
    public List<EBResult> updateStatus(DynamicObject[] bankBills, List<Long> directUpdateIdList, Map<Long, Map<Long, String>> statusMap) {
        try (TXHandle ignore = TX.notSupported();){
            ArrayList<EBResult> resultList = new ArrayList<EBResult>(bankBills.length);
            String entityName = bankBills[0].getDataEntityType().getName();
            for (DynamicObject bankBill : bankBills) {
                EBResult result;
                try {
                    IEBService<EBResult> service;
                    IEBServiceExecutor ebServiceExecutor;
                    Map<Long, String> updateStatusMap = statusMap.get(bankBill.getLong("id"));
                    if ("bei_banktransupbill".equals(entityName)) {
                        DynamicObjectCollection entrys = bankBill.getDynamicObjectCollection("entrys");
                        for (DynamicObject entry : entrys) {
                            IEBServiceExecutor iEBServiceExecutor = ebServiceExecutor = directUpdateIdList.contains(bankBill.getLong("id")) ? EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.UPDATE_STATUS_DIRECT) : EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.UPDATE_STATUS);
                            if (!updateStatusMap.containsKey(entry.getLong("id"))) continue;
                            service = EBServiceFactory.getUpdateService(bankBill, entry, updateStatusMap);
                            EBResult result2 = (EBResult)ebServiceExecutor.execute(service);
                            result2.setBankBillId(Long.valueOf(bankBill.getLong("id")));
                            result2.setPayBillId(Long.valueOf(bankBill.getLong("sourcebillid")));
                            resultList.add(result2);
                        }
                        continue;
                    }
                    ebServiceExecutor = directUpdateIdList.contains(bankBill.getLong("id")) ? EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.UPDATE_STATUS_DIRECT) : EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.UPDATE_STATUS);
                    service = EBServiceFactory.getUpdateService(bankBill, updateStatusMap);
                    result = (EBResult)ebServiceExecutor.execute(service);
                    result.setBankBillId(Long.valueOf(bankBill.getLong("id")));
                    result.setPayBillId(Long.valueOf(bankBill.getLong("sourcebillid")));
                    resultList.add(result);
                }
                catch (Exception e) {
                    result = new EBResult(EBResultStatusCode.ERROR, e.getMessage());
                    result.setBankBillId(Long.valueOf(bankBill.getLong("id")));
                    resultList.add(result);
                }
            }
            ArrayList<EBResult> arrayList = resultList;
            return arrayList;
        }
    }

    @Override
    public List<SyncStatusInfo> sync(String entityName, List<Long> payBillIdList) {
        ArrayList<SyncStatusInfo> resultList = new ArrayList<SyncStatusInfo>(payBillIdList.size());
        try {
            List<SyncStatusInfo> syncResultList = BankPayBillSyncService.getInstance().sync(entityName, payBillIdList);
            resultList.addAll(syncResultList);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            SyncStatusInfo result = new SyncStatusInfo();
            result.setStatusCode(EBResultStatusCode.ERROR);
            result.setErrMsg(e.getMessage());
            resultList.add(result);
            logger.error("\u540c\u6b65\u5931\u8d25:" + result.getErrMsg());
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransDetailResult downTransDetails(DetailQueryInfo detailQueryInfo, DynamicObject ... queryRequestRecord) {
        DynamicObject bankAcct = detailQueryInfo.getBankAcct();
        long id = bankAcct.getLong("id");
        String curFlag = detailQueryInfo.getCurr() == null ? "0" : detailQueryInfo.getCurr().getPkValue().toString();
        boolean lock = MutexServiceHelper.requestWithLostTime((String)String.valueOf(id), (String)"bd_accountbanks", (String)("op_detail" + curFlag));
        logger.info("\u4ea4\u6613\u660e\u7ec6\u83b7\u53d6\u9501\u7ed3\u679c{}", (Object)lock);
        if (lock) {
            TransDetailResult result;
            logger.info("{}\u83b7\u53d6\u5230\u9501\u5f00\u59cb\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6", (Object)id);
            if (EmptyUtil.isNoEmpty((Object[])queryRequestRecord)) {
                queryRequestRecord[0].set("status", (Object)QueryRequestStatusEnum.QUERYING.getValue());
                queryRequestRecord[0].set("publishtime", (Object)new Date());
            }
            try {
                logger.info("\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u53c2\u6570bizInfo:" + detailQueryInfo);
                IEBService<TransDetailResult> service = EBServiceFactory.getDetailQueryService(detailQueryInfo);
                result = (TransDetailResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.QUERY_DETAIL).execute(service);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result = new TransDetailResult();
                result.setErrMsg("\n" + ResManager.loadKDString((String)"\u8d26\u53f7", (String)"TransDetailDownService_0", (String)"tmc-bei-business", (Object[])new Object[0]) + bankAcct.get("number") + ResManager.loadKDString((String)" \u5e01\u79cd", (String)"TransDetailDownService_1", (String)"tmc-bei-business", (Object[])new Object[0]) + detailQueryInfo.getCurr().getString("number") + ' ' + ExceptionUtils.getExceptionStackTraceMessage((Exception)e) + ' ');
                result.setBillId(id);
                detailQueryInfo.setSuccess(false);
            }
            finally {
                logger.info("{}\u91ca\u653e\u9501\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\u5b8c\u6210", (Object)id);
                MutexServiceHelper.release((String)String.valueOf(id), (String)"bd_accountbanks", (String)("op_detail" + curFlag));
            }
            logger.info("\u91ca\u653e\u9501\u540e\u6267\u884c\u5339\u914d\u4e1a\u52a1\u903b\u8f91");
            Map<String, Object> matchMap = result.getMatchMap();
            logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0c\u83b7\u5f97\u7684\u5339\u914d\u96c6\u5408\uff1a{}", matchMap);
            ArrayList<Map<String, Object>> tdaParams = new ArrayList<Map<String, Object>>(16);
            ArrayList<String> billNoList = new ArrayList<String>(16);
            if (Objects.nonNull(matchMap)) {
                if (matchMap.containsKey("updatedetailSet") && matchMap.containsKey("updateOperateOption")) {
                    Set updatedetailSet = (Set)matchMap.get("updatedetailSet");
                    OperateOption updateOperateOption = (OperateOption)matchMap.get("updateOperateOption");
                    logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0c\u83b7\u5f97\u7684updatedetailSet\uff1a{}", (Object)updatedetailSet);
                    logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0c\u83b7\u5f97\u7684updateOperateOption\uff1a{}", (Object)updateOperateOption);
                    ThreadPools.executeOnceIncludeRequestContext((String)"matchbill_update", (Runnable)new SyncMatchBillTask("matchbill", "bei_transdetail_cas", updatedetailSet.toArray(new DynamicObject[0]), updateOperateOption, "updatedetailSet"));
                    tdaParams.addAll(this.getTdaTransDetailSummaryParams(updatedetailSet));
                    billNoList.addAll(this.getTdaBigAmountSummaryParams(updatedetailSet));
                }
                if (matchMap.containsKey("newDetailSet") && matchMap.containsKey("newOperateOption")) {
                    Set newDetailSet = (Set)matchMap.get("newDetailSet");
                    OperateOption newOperateOption = (OperateOption)matchMap.get("newOperateOption");
                    logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0c\u83b7\u5f97\u7684newDetailSet\uff1a{}", (Object)newDetailSet);
                    logger.info("\u62bd\u79bb\u5339\u914d\u64cd\u4f5c\u540e\uff0c\u83b7\u5f97\u7684newOperateOption\uff1a{}", (Object)newOperateOption);
                    ThreadPools.executeOnceIncludeRequestContext((String)"matchbill_new", (Runnable)new SyncMatchBillTask("matchbill", "bei_transdetail_cas", newDetailSet.toArray(new DynamicObject[0]), newOperateOption, "newDetailSet"));
                    tdaParams.addAll(this.getTdaTransDetailSummaryParams(newDetailSet));
                    billNoList.addAll(this.getTdaBigAmountSummaryParams(newDetailSet));
                }
                this.invokeTdaSummaryService(tdaParams, billNoList);
            }
            return result;
        }
        TransDetailResult result = new TransDetailResult();
        result.setErrMsg(new BeiBizResource().getTransDetail_Lock());
        result.setBillId((Long)bankAcct.getPkValue());
        return result;
    }

    private void setIsDownloadFromBank(DetailQueryInfo detailQueryInfo) {
        boolean isSchedule = detailQueryInfo.isSchedule();
        boolean downloadFromBank = detailQueryInfo.isDownloadFromBank();
        if (isSchedule && !downloadFromBank) {
            Date endDate = detailQueryInfo.getEndDate();
            Date currentDate = DateUtils.getCurrentDate();
            if (currentDate.after(endDate)) {
                Long bankAcctId = detailQueryInfo.getBankAcct().getLong("id");
                Long currencyId = detailQueryInfo.getCurr().getLong("id");
                DeleteServiceHelper.delete((String)"fcs_bankquerydetail", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"0"), new QFilter("account", "=", (Object)bankAcctId), new QFilter("currency", "=", (Object)currencyId), new QFilter("lastruntime", "<", (Object)DateUtils.getCurrentDate())});
                DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"fcs_bankquerydetail", (String)"account,currency,lastruntime,runtimes", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"0"), new QFilter("account", "=", (Object)bankAcctId), new QFilter("currency", "=", (Object)currencyId)});
                if (EmptyUtil.isEmpty((DynamicObject)record)) {
                    logger.info("\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e00\u6b21\u67e5\u8be2\u8bbe\u7f6e\u5f3a\u5236\u4ece\u94f6\u884c\u83b7\u53d6");
                    detailQueryInfo.setDownloadFromBank(true);
                    record = TmcDataServiceHelper.newDynamicObject((String)"fcs_bankquerydetail");
                    record.set("account", (Object)bankAcctId);
                    record.set("currency", (Object)currencyId);
                    record.set("lastruntime", (Object)new Date());
                    record.set("type", (Object)"0");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                }
            }
        }
    }

    private void invokeTdaSummaryService(List<Map<String, Object>> tdaParams, List<String> billNoList) {
        try {
            logger.info("\u901a\u8fc7\u94f6\u4f01\u63a5\u53e3\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\u65f6\u8c03\u7528tda\u5fae\u670d\u52a1\u63a5\u53e3\u53c2\u6570\uff0ctdaParams " + JSONArray.toJSONString(tdaParams));
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tda", (String)"transDetailSummaryService", (String)"batchSummary", (Object[])new Object[]{tdaParams});
            logger.info("\u901a\u8fc7\u94f6\u4f01\u63a5\u53e3\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\u65f6\u8c03\u7528tda\u5fae\u670d\u52a1\u63a5\u53e3\u53c2\u6570\uff0cbillNoList " + JSONArray.toJSONString(billNoList));
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tda", (String)"bigAmountSummaryService", (String)"batchBigAmount", (Object[])new Object[]{billNoList});
        }
        catch (Exception ex) {
            logger.error("\u901a\u8fc7\u94f6\u4f01\u63a5\u53e3\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\u65f6\u8c03\u7528tda\u5fae\u670d\u52a1\u62a5\u9519\uff1a", (Throwable)ex);
        }
    }

    private List<String> getTdaBigAmountSummaryParams(Set<DynamicObject> detailSet) {
        return detailSet.stream().map(t -> t.getString("billno")).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getTdaTransDetailSummaryParams(Set<DynamicObject> detailSet) {
        ArrayList<Map<String, Object>> updateParams = new ArrayList<Map<String, Object>>(detailSet.size());
        try {
            for (DynamicObject transDetail : detailSet) {
                HashMap<String, Object> tdaParam = new HashMap<String, Object>(4);
                Object company = transDetail.get("company");
                if (company instanceof DynamicObject) {
                    tdaParam.put("orgId", ((DynamicObject)company).getLong("id"));
                } else {
                    tdaParam.put("orgId", transDetail.getLong("company"));
                }
                tdaParam.put("bizDate", DateUtils.formatString((Date)transDetail.getDate("bizdate"), (String)"yyyy-MM-dd"));
                updateParams.add(tdaParam);
            }
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7\u94f6\u4f01\u63a5\u53e3\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\u65f6\u83b7\u53d6\u53c2\u6570\u62a5\u9519\uff1a", (Throwable)e);
        }
        return updateParams;
    }

    @Override
    public BalanceResult queryBatchBalance(final BalanceQueryInfo balanceQueryInfo, DynamicObject ... queryRequestRecord) {
        DynamicObject accountBank = balanceQueryInfo.getBankAcct();
        String curFlag = balanceQueryInfo.getCurrency() == null ? "0" : balanceQueryInfo.getCurrency().getPkValue().toString();
        Date beginDate = balanceQueryInfo.getBalanceQueryParam().getBeginDate();
        Date curDate = new Date();
        int dateFlag = beginDate.compareTo(DateUtils.getDataFormat((Date)curDate, (boolean)true));
        return this.getLock(queryRequestRecord, "bd_accountbanks", accountBank.getLong("id"), "op_batchbalance" + curFlag + dateFlag, new GetLockCallback<BalanceResult>(){

            @Override
            public BalanceResult success(Long id) {
                try {
                    IEBService<BalanceResult> service = EBServiceFactory.getBatchBalanceService(balanceQueryInfo);
                    BalanceResult result = (BalanceResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.QUERY_BALANCE).execute(service);
                    return result;
                }
                catch (Exception e) {
                    throw new BEBizException(new BeErrorCode().ONLINEQUERY_ERROR(), (Object[])new String[]{e.getMessage()});
                }
            }

            @Override
            public BalanceResult fail(Long id) {
                BalanceResult result = new BalanceResult();
                result.setErrMsg(new BeiBizResource().getBatchBalance_Lock());
                result.setBillId(id);
                return result;
            }
        });
    }

    @Override
    public ElecReceiptResult downReceipt(ReceiptQueryParam receiptQueryParam) {
        ReceiptQueryInfo queryInfo = new ReceiptQueryInfo(receiptQueryParam);
        queryInfo.setBankAcct(receiptQueryParam.getAccountBank());
        queryInfo.setCurrency(receiptQueryParam.getCurrency());
        queryInfo.setOrgId(TmcAccountHelper.getCreateOrgByBankAcct((DynamicObject)receiptQueryParam.getAccountBank()));
        queryInfo.setEntityName("bei_elecreceipt");
        IEBService<ElecReceiptResult> service = EBServiceFactory.getElecReceiptService(queryInfo);
        return (ElecReceiptResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.QUERY_ELE_RECEIPT).execute(service);
    }

    @Override
    public EBGetLoginListResult getBankLoginList(DynamicObject bankAcct) {
        IEBService<EBGetLoginListResult> service = EBServiceFactory.getLoginListService(bankAcct);
        return (EBGetLoginListResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.GET_LOGIN_LIST).execute(service);
    }

    @Override
    public EBResult syncBankAcct(DynamicObject bankAcct, boolean isDelete) {
        IEBService<EBResult> service = EBServiceFactory.syncBankAcct(bankAcct, isDelete);
        return (EBResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.SYNC_ACCT).execute(service);
    }

    @Override
    public EBResult syncBankAccts(List<DynamicObject> bankAccts, boolean isDelete) {
        IEBService<EBResult> service = EBServiceFactory.syncBankAccts(bankAccts, isDelete);
        return (EBResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.SYNC_ACCT).execute(service);
    }

    @Override
    public ElecBalanceResult queryElecBalance(ElecBalanceQueryParam queryParam) {
        IEBService<ElecBalanceResult> service = EBServiceFactory.getElecBalanceQueryService(queryParam);
        return (ElecBalanceResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.QUERY_ELECBALANCE).execute(service);
    }

    @Override
    public ElecBalanceResult queryElecBalanceAcc(ElecBalanceAccQueryParam queryParam) {
        IEBService<ElecBalanceResult> service = EBServiceFactory.getElecBalanceAccQueryService(queryParam);
        return (ElecBalanceResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.QUERY_ELECBALANCE_ACC).execute(service);
    }

    @Override
    public ElecBalanceResult commitBeElecBalanceAcc(BalanceReconciliationParam commitBeParam) {
        IEBService<ElecBalanceResult> service = EBServiceFactory.getElecBalanceAccCommitBeService(commitBeParam);
        return (ElecBalanceResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.QUERY_ELECBALANCE_ACC_COMMITBE).execute(service);
    }

    @Override
    public ElecBalanceResult feedBackElecBalanceAcc(UpdateBalanceReconciliationParam feedBackParam) {
        IEBService<ElecBalanceResult> service = EBServiceFactory.getElecBalanceAccFeedBackService(feedBackParam);
        return (ElecBalanceResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.QUERY_ELECBALANCE_ACC_FEEDBACK).execute(service);
    }

    @Override
    public ElecBalanceResult syncElecBalanceAcc(QueryBalanceReconciliationParam queryParam) {
        IEBService<ElecBalanceResult> service = EBServiceFactory.getElecBalanceAccSyncService(queryParam);
        return (ElecBalanceResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.QUERY_ELECBALANCE_ACC_SYNC).execute(service);
    }

    @Override
    public ElecBalanceResult matchElecBalance(DynamicObject elecBalanceBill, Boolean isMatch) {
        IEBService<ElecBalanceResult> service = EBServiceFactory.getMatchElecBalanceService(elecBalanceBill, isMatch);
        return (ElecBalanceResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.MATCH_ELECBALANCE).execute(service);
    }

    @Override
    public ELecStatementResult downElecStatement(ElecStatementPram info) {
        IEBService<ELecStatementResult> service = EBServiceFactory.getElecStatementService(info);
        return (ELecStatementResult)EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.QUERY_OFDSTATEMENT).execute(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> List<R> getBatchLock(String entityName, List<Long> idList, String lockKey, GetBatchLockCallback<R> callback) {
        ArrayList<R> resultList = new ArrayList<R>(idList.size());
        ArrayList<String> requestIds = new ArrayList<String>(10);
        ArrayList<Long> requestFailIds = new ArrayList<Long>(10);
        List idStrList = idList.stream().map(String::valueOf).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequest(idStrList, (String)entityName, (String)lockKey);
        try {
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(Long.valueOf(key));
            }
            if (requestFailIds.size() > 0) {
                logger.info("\u83b7\u53d6\u4e92\u65a5\u9501\u5931\u8d25, entityName:{}, idList:{}, lockKey:{}", new Object[]{entityName, JSON.toJSONString(requestFailIds), lockKey});
                List<R> failResultList = callback.fail(requestFailIds);
                resultList.addAll(failResultList);
            }
            if (requestIds.size() > 0) {
                logger.info("\u83b7\u53d6\u4e92\u65a5\u9501\u6210\u529f, entityName:{}, idList:{}, lockKey:{}", new Object[]{entityName, JSON.toJSONString(requestIds), lockKey});
                List<Long> successIdList = requestIds.stream().map(Long::valueOf).collect(Collectors.toList());
                List<R> successResultList = callback.success(successIdList);
                resultList.addAll(successResultList);
            }
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)entityName, (String)lockKey);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R getLock(DynamicObject[] queryRequestRecord, String entityName, Long id, String lockKey, GetLockCallback<R> callback) {
        boolean isLock = MutexServiceHelper.requestWithLostTime((String)String.valueOf(id), (String)entityName, (String)lockKey);
        try {
            if (isLock) {
                logger.info("\u83b7\u53d6\u4e92\u65a5\u9501\u6210\u529f, entityName:{}, idList:{}, lockKey:{}", new Object[]{entityName, id, lockKey});
                if (EmptyUtil.isNoEmpty((Object[])queryRequestRecord)) {
                    queryRequestRecord[0].set("status", (Object)QueryRequestStatusEnum.QUERYING.getValue());
                    queryRequestRecord[0].set("publishtime", (Object)new Date());
                }
                R r = callback.success(id);
                return r;
            }
            logger.info("\u83b7\u53d6\u4e92\u65a5\u9501\u5931\u8d25, entityName:{}, idList:{}, lockKey:{}", new Object[]{entityName, id, lockKey});
            R r = callback.fail(id);
            return r;
        }
        finally {
            if (isLock) {
                MutexServiceHelper.release((String)String.valueOf(id), (String)entityName, (String)lockKey);
            }
        }
    }

    private boolean useSinglePay() {
        QFilter payWriteNumber = new QFilter("number", "=", (Object)"bei.bankpaybill.singlepay");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObject conFig = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_extend_config", (String)"configvalue", (QFilter[])new QFilter[]{payWriteNumber, enable});
        return conFig != null && "true".equals(conFig.getString("configvalue"));
    }

    static interface GetBatchLockCallback<R> {
        public List<R> success(List<Long> var1);

        public List<R> fail(List<Long> var1);
    }

    static interface GetLockCallback<R> {
        public R success(Long var1);

        public R fail(Long var1);
    }
}

