/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.request;

import java.text.SimpleDateFormat;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.bei.business.opservice.param.ElecBalanceAccQueryParam;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.webapi.ebentity.EBHeader;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.biz.elecbalanceacc.BalanceStatementRequest;
import kd.tmc.fbp.webapi.ebentity.biz.elecbalanceacc.BalanceStatementRequestBody;

public class BalanceStatementAccRequestBuilder
implements IEBRequestBuilder {
    private final ElecBalanceAccQueryParam queryInfo;

    public BalanceStatementAccRequestBuilder(ElecBalanceAccQueryParam queryInfo) {
        this.queryInfo = queryInfo;
    }

    public EBRequest buildRequest() {
        BalanceStatementRequest request = new BalanceStatementRequest();
        EBHeader header = new EBHeader();
        header.setClientName(ResManager.loadKDString((String)"\u91d1\u8776\u4e0b\u4e00\u4ee3\u4e91ERP", (String)"AbstractBankServiceStragety_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        header.setClientVersion("V1.0");
        String identificationCode = TmcBusinessBaseHelper.toBase64String((byte[])(RequestContext.get().getTenantId() + RequestContext.get().getAccountId()).getBytes());
        header.setIdentificationCode(identificationCode);
        header.setRequestTime(System.currentTimeMillis());
        header.setBizType("balanceStatement");
        header.setSubBizType("balanceStatement");
        header.setAccNo(this.queryInfo.getAccNumberList().get(0));
        request.setHeader(header);
        BalanceStatementRequestBody body = new BalanceStatementRequestBody();
        body.setAccNos(this.queryInfo.getAccNumberList());
        body.setCurrency(this.queryInfo.getCurrency().getString("number"));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
        body.setStartMonth(dateFormat.format(this.queryInfo.getStartMonth()));
        body.setEndMonth(dateFormat.format(this.queryInfo.getEndMonth()));
        body.setQueryFromBank(this.queryInfo.isQueryFromBank());
        request.setBody(body);
        return request;
    }
}

