/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.webapi.ebentity.EBHeader;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.biz.syncaccount.Account;
import kd.tmc.fbp.webapi.ebentity.biz.syncaccount.SyncAccountBody;
import kd.tmc.fbp.webapi.ebentity.biz.syncaccount.SyncAccountRequest;

public class BankAcctSyncRequestBuilder
implements IEBRequestBuilder {
    private static Log logger = LogFactory.getLog(BankAcctSyncRequestBuilder.class);
    private DynamicObject bankAcct;
    private List<DynamicObject> bankAccts = new ArrayList<DynamicObject>();
    private boolean isDelete;

    public BankAcctSyncRequestBuilder(DynamicObject bankAcct, boolean isDelete) {
        this.bankAcct = bankAcct;
        this.isDelete = isDelete;
        this.bankAccts.add(bankAcct);
    }

    public BankAcctSyncRequestBuilder(List<DynamicObject> bankAccts, boolean isDelete) {
        this.bankAccts = bankAccts;
        this.isDelete = isDelete;
    }

    public EBRequest buildRequest() {
        SyncAccountRequest request = new SyncAccountRequest();
        request.setHeader(this.buildHeader());
        request.setBody(this.buildBody());
        return request;
    }

    private EBHeader buildHeader() {
        EBHeader header = new EBHeader();
        header.setClientName(ResManager.loadKDString((String)"\u91d1\u8776\u4e0b\u4e00\u4ee3\u4e91ERP", (String)"AbstractBankServiceStragety_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        header.setClientVersion("V1.0");
        header.setCurrency("CNY");
        String identificationCode = TmcBusinessBaseHelper.toBase64String((byte[])(RequestContext.get().getTenantId() + RequestContext.get().getAccountId()).getBytes());
        header.setIdentificationCode(identificationCode);
        header.setRequestTime(System.currentTimeMillis());
        header.setBizType("syncAccount");
        header.setSubBizType("default");
        header.setOperationName("syncAccount");
        return header;
    }

    private SyncAccountBody buildBody() {
        SyncAccountBody body = new SyncAccountBody();
        if (this.isDelete) {
            body.setOperationCode(2);
        } else {
            body.setOperationCode(1);
        }
        ArrayList<Account> accounts = new ArrayList<Account>();
        accounts.addAll(this.buildAccount(this.bankAccts, this.isDelete));
        body.setTotalCount(accounts.size());
        body.setAccounts(accounts);
        return body;
    }

    private List<Account> buildAccount(List<DynamicObject> infos, boolean isDelete) {
        ArrayList<Account> lsAcct = new ArrayList<Account>(infos.size());
        for (DynamicObject info : infos) {
            Account acct = new Account();
            acct.setAccNo(info.getString("bankaccountnumber"));
            acct.setAccName(info.getString("acctname"));
            acct.setCurrency(info.getDynamicObject("defaultcurrency").getString("number"));
            DynamicObject bank = TmcDataServiceHelper.loadSingle((Object)info.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo");
            acct.setSwiftCode(bank.getString("swift_code"));
            String bankFunc = info.getString("bebankfunc");
            if (StringUtils.isNotEmpty((CharSequence)bankFunc) && bankFunc.contains(BankFuncEnum.RECEIPT.getValue())) {
                acct.setHasReceipt(Boolean.TRUE);
            } else {
                acct.setHasReceipt(Boolean.FALSE);
            }
            try {
                if (!isDelete) {
                    acct.setBankName(info.getDynamicObject("bank").getString("name"));
                    DynamicObject country = bank.getDynamicObject("country");
                    if (country != null) {
                        if (StringUtils.isNotEmpty((CharSequence)(country = BusinessDataServiceHelper.loadSingle((Object)country.getLong("id"), (String)"bd_country", (String)"id,number,threecountrycode")).getString("threecountrycode"))) {
                            acct.setCountry(country.getString("threecountrycode"));
                        } else {
                            acct.setCountry(country.getString("number"));
                        }
                    } else {
                        acct.setCountry("CHN");
                    }
                    DynamicObject province = bank.getDynamicObject("province");
                    String provincestr = "";
                    if (province != null) {
                        provincestr = province.getString("name");
                        if (!provincestr.endsWith(ResManager.loadKDString((String)"\u7701", (String)"AcctSyncServiceStragety_0", (String)"tmc-bei-business", (Object[])new Object[0])) && !provincestr.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"AcctSyncServiceStragety_1", (String)"tmc-bei-business", (Object[])new Object[0]))) {
                            provincestr = provincestr.equals(ResManager.loadKDString((String)"\u5317\u4eac", (String)"AcctSyncServiceStragety_2", (String)"tmc-bei-business", (Object[])new Object[0])) || provincestr.equals(ResManager.loadKDString((String)"\u4e0a\u6d77", (String)"AcctSyncServiceStragety_3", (String)"tmc-bei-business", (Object[])new Object[0])) || provincestr.equals(ResManager.loadKDString((String)"\u5929\u6d25", (String)"AcctSyncServiceStragety_4", (String)"tmc-bei-business", (Object[])new Object[0])) || provincestr.equals(ResManager.loadKDString((String)"\u91cd\u5e86", (String)"AcctSyncServiceStragety_5", (String)"tmc-bei-business", (Object[])new Object[0])) ? provincestr + ResManager.loadKDString((String)"\u5e02", (String)"AcctSyncServiceStragety_1", (String)"tmc-bei-business", (Object[])new Object[0]) : provincestr + ResManager.loadKDString((String)"\u7701", (String)"AcctSyncServiceStragety_0", (String)"tmc-bei-business", (Object[])new Object[0]);
                        }
                        acct.setProvince(provincestr);
                    }
                    DynamicObject city = bank.getDynamicObject("city");
                    String citystr = "";
                    if (city != null) {
                        citystr = city.getString("name");
                        if (!citystr.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"AcctSyncServiceStragety_1", (String)"tmc-bei-business", (Object[])new Object[0]))) {
                            acct.setCity(citystr + ResManager.loadKDString((String)"\u5e02", (String)"AcctSyncServiceStragety_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                        } else {
                            acct.setCity(citystr);
                        }
                    }
                    acct.setCnaps(bank.getString("union_number"));
                    acct.setBankAddress(provincestr + citystr);
                    acct.setHasEcny(Boolean.valueOf(info.getBoolean("iselecpayment")));
                    acct.setAccEcnyLevel(info.getString("elecpaymentlevel"));
                    acct.setAccEcnyType(info.getString("elecpaymenttype"));
                    acct.setBranchNo(this.getInstitUtionCodeByBankId(bank.getLong("id")));
                    acct.setBranchName(this.getInstitutionNameByBankId(bank.getLong("id")));
                }
            }
            catch (Exception e) {
                logger.error("BankAcctSyncRequestBuilder buildAccount exception:" + e);
                throw e;
            }
            acct.setAccType(info.getString("additionalproperty"));
            String beBankFunc = info.getString("bebankfunc");
            boolean isContainsEcd = Arrays.stream(beBankFunc.split(",")).collect(Collectors.toSet()).contains("ecd");
            acct.setHasNote(Boolean.valueOf(isContainsEcd));
            if (isDelete) {
                DynamicObject bdBankAcct = TmcDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)"bd_accountbanks", (String)"id, bankinterface");
                acct.setBankLoginId(bdBankAcct.getString("bankinterface"));
            } else {
                acct.setBankLoginId(info.getString("bankinterface"));
            }
            lsAcct.add(acct);
        }
        return lsAcct;
    }

    private String getInstitUtionCodeByBankId(Long bankId) {
        QFilter filter;
        DynamicObjectCollection query;
        if (EmptyUtil.isNoEmpty((Long)bankId) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(query = QueryServiceHelper.query((String)"bd_finorginfo", (String)"bank_cate.institutioncode", (QFilter[])(filter = new QFilter("id", "=", (Object)bankId)).toArray())))) {
            return ((DynamicObject)query.get(0)).getString("bank_cate.institutioncode");
        }
        return null;
    }

    private String getInstitutionNameByBankId(Long bankId) {
        QFilter filter;
        DynamicObjectCollection query;
        if (EmptyUtil.isNoEmpty((Long)bankId) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(query = QueryServiceHelper.query((String)"bd_finorginfo", (String)"bank_cate.institutionname", (QFilter[])(filter = new QFilter("id", "=", (Object)bankId)).toArray())))) {
            return ((DynamicObject)query.get(0)).getString("bank_cate.institutionname");
        }
        return null;
    }
}

