/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.request;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.bei.business.opservice.queryinfo.BalanceQueryInfo;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.webapi.ebentity.EBHeader;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.biz.balance.BatchBalanceRequest;
import kd.tmc.fbp.webapi.ebentity.biz.balance.BatchBalanceRequestBody;

public class DownBalanceBuilder
implements IEBRequestBuilder {
    private String currency;
    private List<String> bankAccts;
    private List<String> swiftCode;
    private String bankVersion;
    private Date startDate;
    private Date endDate;

    public DownBalanceBuilder(BalanceQueryInfo queryInfo) {
        this.currency = queryInfo.getCurrency().getString("number");
        this.bankAccts = queryInfo.getBankAccts();
        this.bankVersion = queryInfo.getBankVersion();
        this.startDate = queryInfo.getBalanceQueryParam().getBeginDate();
        this.endDate = queryInfo.getBalanceQueryParam().getEndDate();
        this.swiftCode = queryInfo.getSwiftCode();
    }

    public EBRequest buildRequest() {
        EBHeader header = this.buildHeader();
        BatchBalanceRequest request = new BatchBalanceRequest();
        request.setHeader(header);
        BatchBalanceRequestBody body = new BatchBalanceRequestBody();
        body.setAccNos(this.bankAccts);
        String bDateStr = DateUtils.formatString((Date)this.startDate, (String)"yyyyMMdd");
        String eDateStr = DateUtils.formatString((Date)this.endDate, (String)"yyyyMMdd");
        body.setStartDate(bDateStr);
        body.setEndDate(eDateStr);
        body.setExtData("");
        body.setSwiftCode(this.swiftCode);
        request.setBody(body);
        return request;
    }

    protected EBHeader buildHeader() {
        EBHeader header = new EBHeader();
        header.setClientName(ResManager.loadKDString((String)"\u91d1\u8776\u4e0b\u4e00\u4ee3\u4e91ERP", (String)"AbstractBankServiceStragety_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        header.setClientVersion("V1.0");
        String identificationCode = TmcBusinessBaseHelper.toBase64String((byte[])(RequestContext.get().getTenantId() + RequestContext.get().getAccountId()).getBytes());
        header.setIdentificationCode(identificationCode);
        header.setRequestTime(System.currentTimeMillis());
        header.setBizType("batchBalance");
        header.setSubBizType("batch_balance");
        header.setOperationName("batchBalance");
        header.setAccNo(this.bankAccts.get(0));
        header.setCurrency(this.currency);
        header.setBankVersion(this.bankVersion);
        return header;
    }
}

