/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.request;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.service.ebservice.bean.DetailQueryInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.webapi.ebentity.EBHeader;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.biz.detail.DetailRequest;
import kd.tmc.fbp.webapi.ebentity.biz.detail.DetailRequestBody;

public class DownTransDetailBuilder
implements IEBRequestBuilder {
    private DetailQueryInfo detailQueryInfo;

    public DownTransDetailBuilder(DetailQueryInfo detailQueryInfo) {
        this.detailQueryInfo = detailQueryInfo;
    }

    public EBRequest buildRequest() {
        EBHeader header = this.buildHeader();
        DetailRequest request = new DetailRequest();
        request.setHeader(header);
        DetailRequestBody body = new DetailRequestBody();
        String serialNo = Long.valueOf(DBServiceHelper.genGlobalLongId()).toString();
        body.setSerialNo(serialNo);
        body.setStartDate(DateUtils.formatString((Date)this.detailQueryInfo.getBeginDate(), (String)"yyyyMMdd"));
        body.setEndDate(DateUtils.formatString((Date)this.detailQueryInfo.getEndDate(), (String)"yyyyMMdd"));
        body.setPageSize(this.detailQueryInfo.getPageSize());
        body.setPageNum(this.detailQueryInfo.getPageNum());
        this.detailQueryInfo.setPageNum(this.detailQueryInfo.getPageNum() + 1);
        body.setDownloadFromBank(this.detailQueryInfo.isDownloadFromBank());
        DynamicObject bank = this.detailQueryInfo.getBankAcct().getDynamicObject("bank");
        String swCode = "";
        if (bank != null) {
            swCode = bank.getString("swift_code");
        }
        body.setSwiftCode(swCode);
        request.setBody(body);
        return request;
    }

    protected EBHeader buildHeader() {
        EBHeader header = new EBHeader();
        header.setClientName(ResManager.loadKDString((String)"\u91d1\u8776\u4e0b\u4e00\u4ee3\u4e91ERP", (String)"AbstractBankServiceStragety_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        header.setClientVersion("V1.0");
        header.setCurrency("CNY");
        String identificationCode = TmcBusinessBaseHelper.toBase64String((byte[])(RequestContext.get().getTenantId() + RequestContext.get().getAccountId()).getBytes());
        header.setIdentificationCode(identificationCode);
        header.setRequestTime(System.currentTimeMillis());
        header.setBizType("detail");
        header.setSubBizType("normal_detail");
        header.setOperationName("detail");
        header.setAccNo(this.detailQueryInfo.getBankAcct().getString("bankaccountnumber"));
        header.setCurrency(this.detailQueryInfo.getCurr().getString("number"));
        return header;
    }
}

