/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.request;

import java.math.BigDecimal;
import java.util.List;
import kd.tmc.bei.business.ebservice.request.AbstractRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.fbp.webapi.ebentity.EBHeader;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayBody;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayRequest;

public class PayRequestBuilder
extends AbstractRequestBuilder {
    private String subBizType;
    boolean batchRollBack;

    public PayRequestBuilder(String subBizType, IEBRequestDataSource dataSource, boolean batchRollBack) {
        super(dataSource);
        this.subBizType = subBizType;
        this.batchRollBack = batchRollBack;
    }

    public EBRequest buildRequest() {
        PayRequest request = new PayRequest();
        request.setHeader(this.buildHeader());
        request.setBody(this.buildBody());
        return request;
    }

    @Override
    protected EBHeader buildHeader() {
        EBHeader header = super.buildHeader();
        header.setBizType(this.getBizType());
        header.setSubBizType(this.subBizType);
        header.setOperationName(this.getOperationName());
        return header;
    }

    protected PayBody buildBody() {
        PayBody body = new PayBody();
        List<PayDetail> detailList = this.getDataSource().getPayDetail();
        body.setBatchSeqID(this.getDataSource().getBatchSeqId());
        body.setBatchBizNo(this.getDataSource().getBatchBizNo());
        body.setTotalCount(detailList.size());
        body.setExtData("{\"idempotency\":\"true\"}");
        BigDecimal totalAmount = detailList.stream().map(PayDetail::getAmount).map(BigDecimal::new).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        body.setTotalAmount(this.transAmount(totalAmount));
        body.setBatchRollBack(this.batchRollBack);
        body.setDetails(detailList);
        return body;
    }

    protected String getBizType() {
        return "pay";
    }

    protected String getOperationName() {
        return "pay";
    }
}

