/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.request.datasource.banktrans;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.bei.business.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.bei.common.constants.BizConstant;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusDetail;

public class BankTransDownRequestDataSource
implements IEBRequestDataSource {
    private List<DynamicObject> bankTransDownBillList;
    private String batchSeqId;

    public BankTransDownRequestDataSource(DynamicObject bankTransDownBill) {
        this.batchSeqId = bankTransDownBill.getString("serialnumber");
        this.bankTransDownBillList = Collections.singletonList(bankTransDownBill);
    }

    public BankTransDownRequestDataSource(String batchSeqId, List<DynamicObject> bankTransDownBillList) {
        this.batchSeqId = batchSeqId;
        this.bankTransDownBillList = bankTransDownBillList;
    }

    @Override
    public List<PayDetail> getPayDetail() {
        ArrayList<PayDetail> details = new ArrayList<PayDetail>(10);
        for (DynamicObject bankTransDownBill : this.bankTransDownBillList) {
            DynamicObject payBillAuditor;
            boolean isIndividual = bankTransDownBill.getBoolean("ispersonpay");
            DynamicObjectCollection entry = bankTransDownBill.getDynamicObjectCollection("entrys");
            Date nowDate = new Date();
            String trans = new BizConstant().getTrans();
            String transdown = new BizConstant().getTransdown();
            Long[] bankIds = (Long[])entry.stream().map(e -> e.getDynamicObject("subacct")).filter(Objects::nonNull).map(subAcct -> subAcct.getDynamicObject("bank")).filter(Objects::nonNull).map(bank -> bank.getLong("id")).toArray(Long[]::new);
            DynamicObject[] banks = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"union_number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)bankIds)});
            HashMap<Long, String> bankMap = new HashMap<Long, String>(8);
            for (DynamicObject bank2 : banks) {
                bankMap.put(bank2.getLong("id"), bank2.getString("union_number"));
            }
            HashMap<String, String> extDatas = new HashMap<String, String>(16);
            DynamicObject payBillCreator = bankTransDownBill.getDynamicObject("paybillcreator");
            if (EmptyUtil.isNoEmpty((DynamicObject)payBillCreator)) {
                extDatas.put("paybillcreator", payBillCreator.getString("username"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(payBillAuditor = bankTransDownBill.getDynamicObject("paybillauditor")))) {
                extDatas.put("paybillauditor", payBillAuditor.getString("username"));
            }
            for (DynamicObject entryInfo : entry) {
                DynamicObject bank3;
                PayDetail detail = new PayDetail();
                detail.setBatchSeqID(this.batchSeqId);
                detail.setDetailSeqID(entryInfo.getPkValue().toString());
                detail.setDetailBizNo(entryInfo.getString("sourceentryid"));
                extDatas.put("idempotency", "true");
                String recName = entryInfo.getString("sonacctname");
                if (EmptyUtil.isEmpty((String)recName)) {
                    recName = entryInfo.getString("sonacctorg");
                }
                detail.setIncomeAccName(recName);
                detail.setIncomeAccNo(entryInfo.getString("sonacctnumber"));
                detail.setIncomeBankName(entryInfo.getString("sonacctbankname"));
                DynamicObject subAcct2 = entryInfo.getDynamicObject("subacct");
                if (Objects.nonNull(subAcct2) && Objects.nonNull(bank3 = subAcct2.getDynamicObject("bank"))) {
                    detail.setIncomeCnapsCode((String)bankMap.get(bank3.getLong("id")));
                }
                detail.setIncomeBankAddress(entryInfo.getString("sonacctcity"));
                detail.setIncomeCountry("CHN");
                detail.setIncomeProvince(entryInfo.getString("sonacctprovince"));
                detail.setIncomeCity(entryInfo.getString("sonacctcity"));
                BigDecimal amount = entryInfo.getBigDecimal("transamt").setScale(2, 4);
                detail.setAmount(String.valueOf(amount));
                Date expectDealTime = bankTransDownBill.getDate("expectdealtime") == null ? nowDate : bankTransDownBill.getDate("expectdealtime");
                detail.setBookingTime(String.valueOf(expectDealTime.getTime()));
                String entryRemark = entryInfo.getString("remark");
                if (EmptyUtil.isEmpty((String)entryRemark)) {
                    entryRemark = trans;
                }
                detail.setExplanation(entryRemark);
                detail.setUrgent(false);
                detail.setForce(false);
                detail.setUseCode("-1");
                detail.setUseCN(transdown);
                detail.setVerifyField("");
                if (isIndividual) {
                    detail.setIncomeType("individual");
                } else {
                    detail.setIncomeType("company");
                }
                detail.setExtData(JSON.toJSONString(extDatas));
                details.add(detail);
            }
        }
        return details;
    }

    @Override
    public PayStatusBody getUpdateBody(Map<Long, String> updateStatusMap) {
        if (this.bankTransDownBillList.size() != 1) {
            throw new IllegalArgumentException("Bank bill size can not > 1");
        }
        DynamicObject bankTransDownBill = this.bankTransDownBillList.get(0);
        ArrayList<PayStatusDetail> details = new ArrayList<PayStatusDetail>(updateStatusMap.size());
        for (DynamicObject entry : bankTransDownBill.getDynamicObjectCollection("entrys")) {
            Long key = entry.getLong("id");
            if (!updateStatusMap.containsKey(key)) continue;
            String entry_Status = updateStatusMap.get(key);
            if (BeBillStatusEnum.NC.getValue().equals(entry_Status)) continue;
            PayStatusDetail detail = new PayStatusDetail();
            detail.setDetailSeqID(key.toString());
            detail.setBatchSeqID(bankTransDownBill.getString("serialnumber"));
            detail.setModifyStatus(entry_Status.equals(BeBillStatusEnum.TS.getValue()) ? 12 : 13);
            detail.setUpdateStatus(BankReturnStatusEnum.BANK_SUCCESS.getValue());
            detail.setUpdateReason(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u7ecf\u6838\u5b9e\uff0c\u624b\u5de5\u4fee\u6539\u72b6\u6001\u3002", (String)"BankRequestBodyHelper_2", (String)"tmc-bei-business", (Object[])new Object[0]));
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
            detail.setOperator(user.getLocaleString("name").getLocaleValue());
            details.add(detail);
        }
        PayStatusBody body = new PayStatusBody();
        if (details.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u6570\u636e\u672a\u53d8\u5316\uff0c\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BankRequestBodyHelper_3", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        body.setTotalCount(details.size());
        body.setDetails(details);
        return body;
    }

    @Override
    public String getAcctNo() {
        return this.bankTransDownBillList.get(0).getDynamicObject("accountbank").getString("bankaccountnumber");
    }

    @Override
    public String getCurrency() {
        return this.bankTransDownBillList.get(0).getDynamicObject("currency").getString("number");
    }

    @Override
    public String getBatchSeqId() {
        return this.batchSeqId;
    }

    @Override
    public String getBatchBizNo() {
        return this.batchSeqId;
    }
}

