/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.ebservice.BankBillMergeHandler;
import kd.tmc.bei.business.ebservice.EBServiceFactory;
import kd.tmc.bei.business.ebservice.service.executor.UpdateStateServiceExecutor;
import kd.tmc.bei.common.enums.EBOperateTypeEnum;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.service.IEBServiceExecutor;
import kd.tmc.fbp.service.ebservice.service.executor.EBExecutorBatchWrap;
import kd.tmc.fbp.service.ebservice.service.executor.EBServiceBatchExecutor;
import kd.tmc.fbp.service.ebservice.service.executor.EBServiceExecutor;

public class EBServiceExecutorFactory {
    private static Log logger = LogFactory.getLog(EBServiceExecutorFactory.class);

    public static IEBServiceExecutor getEBServiceExecutor(EBOperateTypeEnum opType) {
        if (EBServiceExecutorFactory.isTestEvn()) {
            String mockClzName = "kd.tmc.bei.unittest.mock.EBServiceMockExecutor";
            try {
                return (IEBServiceExecutor)Class.forName(mockClzName).newInstance();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDBizException("Mock Executor not found: " + mockClzName);
            }
        }
        if (opType == EBOperateTypeEnum.UPDATE_STATUS_DIRECT) {
            return new UpdateStateServiceExecutor();
        }
        return new EBServiceExecutor();
    }

    public static EBServiceBatchExecutor<List<SyncStatusInfo>> createBatchPayExecutor(List<DynamicObject> bankBillList, boolean isBankPay) {
        List<List<DynamicObject>> groupList = BankBillMergeHandler.merge(bankBillList);
        EBServiceBatchExecutor batchExecutor = new EBServiceBatchExecutor();
        for (List<DynamicObject> mergeList : groupList) {
            IEBServiceExecutor executor = EBServiceExecutorFactory.getEBServiceExecutor(EBOperateTypeEnum.PAY);
            IEBService<List<SyncStatusInfo>> service = EBServiceFactory.getPayService(mergeList, isBankPay);
            EBExecutorBatchWrap wrap = new EBExecutorBatchWrap(executor, service);
            batchExecutor.addBatchTask(wrap);
        }
        return batchExecutor;
    }

    private static boolean isTestEvn() {
        boolean existInterfaceInfo = DB.exitsTable((DBRoute)DBRouteConst.TMC, (String)"t_bei_interfaceinfomock");
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        boolean isLocalEvn = "tenant_devfi_dev".equals(tenantId) && "1150100171577623552".equals(accountId);
        boolean isPatchSmokeEvn = "tenant_patchfi_smoke".equals(tenantId) && "201912162149311205".equals(accountId);
        boolean isBaselineSmokeEvn = "baseline_smoke".equals(tenantId) && ("1562834230588".equals(accountId) || "1113059203489991680".equals(accountId));
        return existInterfaceInfo && (isLocalEvn || isPatchSmokeEvn || isBaselineSmokeEvn);
    }
}

