/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.tmc.bei.extpoint.balance.IFillBankBalance;
import kd.tmc.bei.business.ebservice.request.DownBalanceBuilder;
import kd.tmc.bei.business.opservice.queryinfo.BalanceQueryInfo;
import kd.tmc.bei.business.opservice.result.BalanceResult;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.BalanceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.log.bean.BankLogDetail;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.balance.Balance;

public class BatchBalanceService
implements IEBService<BalanceResult> {
    private static final Log logger = LogFactory.getLog(BatchBalanceService.class);
    private final Map<String, Long> accountMap = new HashMap<String, Long>();
    private final BalanceResult balanceResult = new BalanceResult();
    private final BalanceQueryInfo queryInfo;

    public BatchBalanceService(BalanceQueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.balanceResult.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.balanceResult.setErrCode(new ErrorCode("batchBalance", errMsg));
        this.balanceResult.setErrMsg(errMsg);
    }

    public void handleResultBody(String resultBody) {
        JSONObject response = JSON.parseObject((String)resultBody);
        JSONArray balancesJSONArray = (JSONArray)response.get((Object)"balances");
        List balances = balancesJSONArray.toJavaList(Balance.class);
        HashMap<String, Object> balanceMap = new HashMap<String, Object>();
        HashMap balMap = new HashMap(balances.size());
        ArrayList balanceList = new ArrayList(balances.size());
        ArrayList updateBalanceList = new ArrayList(balances.size());
        HashMap bankAccountCache = new HashMap();
        try (TXHandle tx = TX.requiresNew();){
            try {
                Map<String, List> groupedAndSorted = balances.stream().collect(Collectors.groupingBy(balance -> balance.getAccNo() + "#" + balance.getCurrency(), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(Balance::getBalanceDateTime)).collect(Collectors.toList()))));
                groupedAndSorted.forEach((key, value) -> {
                    List bizDates = value.stream().map(s -> DateUtils.stringToDate((String)s.getBalanceDateTime(), (String)"yyyy-MM-dd")).collect(Collectors.toList());
                    for (int i = 0; i < value.size(); ++i) {
                        Balance balance = (Balance)value.get(i);
                        String acctNo = balance.getAccNo();
                        DynamicObject bankAcct = bankAccountCache.computeIfAbsent(acctNo, this::getBankAcctByNo);
                        if (bankAcct == null) {
                            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u94f6\u884c\u8d26\u53f7\uff1a%s\uff0c\u5728\u201c\u8d44\u91d1\u4e91>\u8d26\u6237\u7ba1\u7406\u201d\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"BalanceQueryServiceStragety_0", (String)"tmc-bei-business", (Object[])new Object[0]), acctNo)});
                        }
                        if (StringUtils.isNotEmpty((String)balance.getError())) {
                            balanceMap.put(acctNo, balance.getError());
                            continue;
                        }
                        this.accountMap.put(acctNo, bankAcct.getDynamicObject("company").getLong("id"));
                        String currentBalance = balance.getCurrentBalance();
                        String availableBalance = balance.getAvailableBalance();
                        String lastDayAvailableBalance = balance.getLastDayAvailableBalance();
                        String freezeBalance = balance.getFreezeBalance();
                        String balanceString = SerializationUtils.toJsonString((Object)balance);
                        String balanceDate = balance.getBalanceDateTime();
                        Date bizdate = DateUtils.stringToDate((String)balanceDate, (String)"yyyy-MM-dd");
                        Date lastEndDate = BalanceHelper.dealEndDate((int)i, bizDates, (Date)bizdate, (Object)bankAcct.getLong("id"), (Object)this.queryInfo.getCurrency().getPkValue(), (List)updateBalanceList);
                        logger.info("\u4f59\u989d\u6279\u91cf\u67e5\u8be2\u54cd\u5e94\uff1a\u8d26\u6237(" + acctNo + ");\u5f53\u524d\u4f59\u989d(" + currentBalance + ");\u53ef\u7528\u4f59\u989d(" + availableBalance + ");\u4e0a\u65e5\u4f59\u989d(" + lastDayAvailableBalance + ")");
                        QFilter[] filter = new QFilter[]{new QFilter("accountbank", "=", (Object)bankAcct.getLong("id")), new QFilter("currency", "=", this.queryInfo.getCurrency().getPkValue()), new QFilter("bizdate", "=", (Object)bizdate)};
                        DynamicObject bankBalance = TmcDataServiceHelper.loadSingle((String)"bei_bankbalance", (String)"id", (QFilter[])filter);
                        if (bankBalance != null) {
                            bankBalance = TmcDataServiceHelper.loadSingle((Object)bankBalance.getPkValue(), (String)"bei_bankbalance");
                        }
                        logger.info("BalanceQueryServiceStragety afterQuery bankBalance :" + bankBalance);
                        if (bankBalance == null) {
                            bankBalance = TmcDataServiceHelper.newDynamicObject((String)"bei_bankbalance");
                            bankBalance.set("currency", this.queryInfo.getCurrency().getPkValue());
                            bankBalance.set("accountbank", (Object)bankAcct);
                            bankBalance.set("bank", (Object)bankAcct.getDynamicObject("bank"));
                            bankBalance.set("company", (Object)bankAcct.getDynamicObject("company"));
                            bankBalance.set("id", (Object)DBServiceHelper.genGlobalLongId());
                        }
                        bankBalance.set("datasource", (Object)DataSourceEnum.FROMBANK.getValue());
                        logger.info("\u6570\u636e\u6765\u6e90==============" + DataSourceEnum.FROMBANK.getValue());
                        if (StringUtils.isNotEmpty((String)currentBalance)) {
                            bankBalance.set("amount", (Object)new BigDecimal(currentBalance));
                        }
                        if (StringUtils.isNotEmpty((String)availableBalance)) {
                            bankBalance.set("valibalance", (Object)new BigDecimal(availableBalance));
                        }
                        if (StringUtils.isNotEmpty((String)lastDayAvailableBalance)) {
                            bankBalance.set("lstbalance", (Object)new BigDecimal(lastDayAvailableBalance));
                        }
                        if (StringUtils.isNotEmpty((String)freezeBalance)) {
                            bankBalance.set("freezebalance", (Object)new BigDecimal(freezeBalance));
                        }
                        this.dealExtData(bankBalance, balanceString);
                        bankBalance.set("bizdate", (Object)bizdate);
                        bankBalance.set("enddate", (Object)lastEndDate);
                        bankBalance.set("modifytime", (Object)DateUtils.getCurrentTime());
                        bankBalance.set("exchangerate", (Object)Constants.ZERO);
                        bankBalance.set("logo", bankAcct.get("bank.logo"));
                        bankBalance.set("extraaccno", (Object)balance.getExtraAccNo());
                        balanceList.add(bankBalance);
                        balanceMap.put(acctNo, bankBalance);
                        balMap.put(bankBalance.getLong("id"), balance);
                    }
                });
                if (balanceList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])balanceList.toArray(new DynamicObject[0]));
                }
                if (updateBalanceList.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])updateBalanceList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        this.balanceResult.setBalanceMap(balanceMap);
    }

    private void dealExtData(DynamicObject bankBalance, String balanceString) {
        PluginProxy pluginProxy = PluginProxy.create(IFillBankBalance.class, (String)"kd.sdk.tmc.bei.extpoint.balance.IFillBankBalance");
        pluginProxy.callReplace(p -> {
            p.fillExtBankBalance(bankBalance, balanceString);
            return new Object();
        });
    }

    private DynamicObject getBankAcctByNo(String acctNo) {
        QFilter filter = new QFilter("bankaccountnumber", "=", (Object)acctNo);
        return TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,company,bank,bank.logo,createorg", (QFilter[])new QFilter[]{filter});
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new DownBalanceBuilder(this.queryInfo);
    }

    public String getEntityName() {
        return "bei_bankbalance";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo bankLogInfo = new BankLogInfo();
        bankLogInfo.setEntityName(this.getEntityName());
        String billNo = StringUtils.isNotEmpty((String)this.queryInfo.getBillNo()) ? this.queryInfo.getBillNo() : (this.queryInfo.getBankAcct() != null ? this.queryInfo.getBankAcct().getString("number") : JSON.toJSONString(this.queryInfo.getBankAccts()));
        Long orgId = this.accountMap.get(billNo);
        if (EmptyUtil.isEmpty((Long)orgId)) {
            DynamicObject bankAcct = this.getBankAcctByNo(billNo);
            orgId = EmptyUtil.isNoEmpty((DynamicObject)bankAcct) ? bankAcct.getDynamicObject("company").getLong("id") : RequestContext.get().getOrgId();
        }
        bankLogInfo.setOrgid(orgId);
        bankLogInfo.setBillNo(billNo);
        List<String> bankAccts = this.queryInfo.getBankAccts();
        logger.info("setLogDetailList is start orgId is that:" + orgId + ",billNo is:" + billNo);
        logger.info("bankAccts is start :" + SerializationUtils.toJsonString(bankAccts));
        ArrayList<BankLogDetail> detailList = new ArrayList<BankLogDetail>(bankAccts.size());
        for (String banlAcc : bankAccts) {
            BankLogDetail bankDetail = new BankLogDetail();
            bankDetail.setBillType("bei_bankbalance");
            bankDetail.setBillOrgId(orgId);
            bankDetail.setBillNumber(banlAcc);
            detailList.add(bankDetail);
        }
        bankLogInfo.setLogDetailList(detailList);
        bankLogInfo.setRequestId(Long.valueOf(EmptyUtil.isNoEmpty((Long)this.queryInfo.getRequestId()) ? this.queryInfo.getRequestId() : 0L));
        return bankLogInfo;
    }

    public BalanceResult getEBResult() {
        return this.balanceResult;
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.queryInfo.getBankAcct());
    }
}

