/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.request.QueryElecBalanceRequestBuilder;
import kd.tmc.bei.business.opservice.param.ElecBalanceQueryParam;
import kd.tmc.bei.business.opservice.result.ElecBalanceResult;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.elecbalance.BalanceReconciliationDetail;
import kd.tmc.fbp.webapi.ebentity.biz.elecbalance.QueryBalanceReconciliationResponseBody;

public class ElecBalanceQueryService
implements IEBService<ElecBalanceResult> {
    private static final Log logger = LogFactory.getLog(ElecBalanceQueryService.class);
    private final ElecBalanceResult result = new ElecBalanceResult();
    private final ElecBalanceQueryParam queryParam;

    public ElecBalanceQueryService(ElecBalanceQueryParam queryParam) {
        this.queryParam = queryParam;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.result.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.result.setErrMsg(errMsg);
    }

    public void handleResultBody(String resultBody) {
        if (StringUtils.isEmpty((String)resultBody)) {
            throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
        }
        QueryBalanceReconciliationResponseBody body = (QueryBalanceReconciliationResponseBody)JSON.parseObject((String)resultBody, (TypeReference)new TypeReference<QueryBalanceReconciliationResponseBody>(){}, (Feature[])new Feature[0]);
        List details = body.getReceiptInfos();
        if (EmptyUtil.isNoEmpty((Object)details) && details.size() > 0) {
            Set<String> existFinishKeySet = this.queryParam.getExistFinishKey();
            HashMap<String, List<String[]>> savePathMap = new HashMap<String, List<String[]>>(5);
            HashMap<String, List<String[]>> updatePathMap = new HashMap<String, List<String[]>>(5);
            HashMap<String, DynamicObject> updateMap = new HashMap<String, DynamicObject>(details.size());
            HashMap<String, DynamicObject> saveMap = new HashMap<String, DynamicObject>(details.size());
            for (BalanceReconciliationDetail detail : details) {
                List<String[]> urlEntryList;
                String fileSuffix;
                String filePath;
                DynamicObject urlAddNew;
                DynamicObjectCollection urlEntry;
                String[] fileInfo;
                QFilter filter4;
                String protocolNo = detail.getReconciliationProtocolNo();
                String reconciliationNo = detail.getReconciliationNo();
                String yyyyMM = detail.getReconciliationYearMonth();
                String existFinishKey = protocolNo + reconciliationNo + yyyyMM;
                if (CollectionUtils.isNotEmpty(existFinishKeySet) && existFinishKeySet.contains(existFinishKey)) continue;
                QFilter filter1 = new QFilter("protocol", "=", (Object)protocolNo);
                QFilter filter2 = new QFilter("stateno", "=", (Object)reconciliationNo);
                Date period = DateUtils.stringToDate((String)yyyyMM, (String)"yyyyMM");
                QFilter filter3 = new QFilter("period", "=", (Object)period);
                DynamicObject[] updateObj = BusinessDataServiceHelper.load((String)"bei_elecbalancestate", (String)"id,modifytime,modifier,banktype,company,accountcompany,urlentry,urlentry.e_fileservicepath,urlentry.e_filesuffix", (QFilter[])new QFilter[]{filter1, filter2, filter3, filter4 = new QFilter("billtype", "=", (Object)"bei_elecbalancestate")});
                if (updateObj.length > 0 || saveMap.containsKey(existFinishKey)) {
                    DynamicObject existObj;
                    if (updateObj.length > 0) {
                        existObj = updateObj[0];
                        existObj.set("modifytime", (Object)DateUtils.getCurrentTime());
                        existObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    } else {
                        existObj = (DynamicObject)saveMap.get(existFinishKey);
                    }
                    this.setOrgProtocol(existObj, protocolNo);
                    if (body.getFileFlag() == 1) {
                        fileInfo = new String[2];
                        urlEntry = existObj.getDynamicObjectCollection("urlentry");
                        urlEntry.clear();
                        urlAddNew = urlEntry.addNew();
                        filePath = detail.getFilePath();
                        urlAddNew.set("e_fileservicepath", (Object)detail.getUploadFileName());
                        fileInfo[0] = detail.getUploadFileName();
                        if (filePath.contains(".")) {
                            fileSuffix = filePath.substring(filePath.lastIndexOf("."));
                            urlAddNew.set("e_filesuffix", (Object)fileSuffix);
                            fileInfo[1] = fileSuffix;
                        }
                        if (updateObj.length > 0) {
                            if (updatePathMap.containsKey(existFinishKey)) {
                                urlEntryList = (ArrayList)updatePathMap.get(existFinishKey);
                                urlEntryList.add(fileInfo);
                            } else {
                                urlEntryList = new ArrayList(5);
                                urlEntryList.add(fileInfo);
                                updatePathMap.put(existFinishKey, urlEntryList);
                            }
                        } else if (savePathMap.containsKey(existFinishKey)) {
                            urlEntryList = (List)savePathMap.get(existFinishKey);
                            urlEntryList.add(fileInfo);
                        }
                    }
                    if (updateObj.length > 0) {
                        updateMap.put(existFinishKey, existObj);
                        continue;
                    }
                    saveMap.put(existFinishKey, existObj);
                    continue;
                }
                DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"bei_elecbalancestate");
                bill.set("billtype", (Object)"bei_elecbalancestate");
                this.setOrgProtocol(bill, protocolNo);
                bill.set("period", (Object)period);
                bill.set("protocol", (Object)protocolNo);
                bill.set("stateno", (Object)reconciliationNo);
                bill.set("isfile", (Object)body.getFileFlag());
                if (body.getFileFlag() == 1) {
                    fileInfo = new String[2];
                    urlEntry = bill.getDynamicObjectCollection("urlentry");
                    urlAddNew = urlEntry.addNew();
                    filePath = detail.getFilePath();
                    fileInfo[0] = detail.getUploadFileName();
                    urlAddNew.set("e_fileservicepath", (Object)detail.getUploadFileName());
                    if (filePath.contains(".")) {
                        fileSuffix = filePath.substring(filePath.lastIndexOf("."));
                        urlAddNew.set("e_filesuffix", (Object)fileSuffix);
                        fileInfo[1] = fileSuffix;
                    }
                    urlEntryList = new ArrayList(5);
                    urlEntryList.add(fileInfo);
                    savePathMap.put(existFinishKey, urlEntryList);
                }
                bill.set("datasource", (Object)DataSourceEnum.FROMBANK.getValue());
                bill.set("creator", (Object)RequestContext.get().getCurrUserId());
                Timestamp curTime = DateUtils.getCurrentTime();
                bill.set("createtime", (Object)curTime);
                bill.set("jointime", (Object)curTime);
                bill.set("joindate", (Object)curTime);
                String billNo = CodeRuleHelper.generateNumber((String)"bei_elecbalancestate", (DynamicObject)bill, null, null);
                bill.set("billno", (Object)billNo);
                saveMap.put(existFinishKey, bill);
            }
            if (saveMap.size() > 0) {
                logger.info(" elecBalanceQuery[addNewData]:" + saveMap.size());
                this.saveElecBalanceState(savePathMap, saveMap);
            }
            if (updateMap.size() > 0) {
                logger.info(" elecBalanceQuery[updateData]:" + updateMap.size());
                this.saveElecBalanceState(updatePathMap, updateMap);
            }
            this.result.setCount(saveMap.size() + updateMap.size());
        } else {
            logger.info(" detail is null [ElecBalanceQuery] ");
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new QueryElecBalanceRequestBuilder(this.queryParam);
    }

    public String getEntityName() {
        return "bei_elecbalancestate";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo bankLogInfo = new BankLogInfo();
        bankLogInfo.setEntityName("bei_elecbalancestate");
        Long orgId = this.queryParam.getOrg() != null && this.queryParam.getOrg().getLong("id") != 0L ? this.queryParam.getOrg().getLong("id") : RequestContext.get().getOrgId();
        bankLogInfo.setOrgid(orgId);
        return bankLogInfo;
    }

    public ElecBalanceResult getEBResult() {
        return this.result;
    }

    public String getServiceUrl() {
        return "/kapi/app/receipt/receiptQuery";
    }

    public Long getBankCateId() {
        return null;
    }

    private void setOrgProtocol(DynamicObject bill, String protocolNo) {
        DynamicObject orgProtocol = QueryServiceHelper.queryOne((String)"bei_orgprotocol", (String)"banktype.id,org.id,accountorg.id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)protocolNo), new QFilter("enable", "=", (Object)"1")});
        if (EmptyUtil.isNoEmpty((DynamicObject)orgProtocol)) {
            bill.set("banktype", (Object)orgProtocol.getLong("banktype.id"));
            bill.set("company", (Object)orgProtocol.getLong("org.id"));
            bill.set("accountcompany", (Object)orgProtocol.getLong("accountorg.id"));
        }
    }

    private void saveElecBalanceState(Map<String, List<String[]>> savePathMap, Map<String, DynamicObject> saveMap) {
        savePathMap.forEach((existKey, pathList) -> {
            if (pathList.size() > 1) {
                DynamicObjectCollection urlEntry = ((DynamicObject)saveMap.get(existKey)).getDynamicObjectCollection("urlentry");
                urlEntry.clear();
                for (String[] fileInfo : pathList) {
                    DynamicObject urlAddNew = urlEntry.addNew();
                    urlAddNew.set("e_fileservicepath", (Object)fileInfo[0]);
                    if (!StringUtils.isNotEmpty((String)fileInfo[1])) continue;
                    urlAddNew.set("e_filesuffix", (Object)fileInfo[1]);
                }
            }
        });
        SaveServiceHelper.save((DynamicObject[])saveMap.values().toArray(new DynamicObject[0]));
    }
}

