/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.ebservice.request.DownElecReceiptRequestBuilder;
import kd.tmc.bei.business.opservice.queryinfo.ReceiptQueryInfo;
import kd.tmc.bei.business.opservice.result.ElecReceiptResult;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.bei.common.helper.CodeRuleHelper;
import kd.tmc.bei.common.helper.ReceiptPrintHelper;
import kd.tmc.fbp.common.bean.Receipt;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.OFDReceiptUtils;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.queryreceipt.QueryReceiptResponseBody;
import kd.tmc.fbp.webapi.ebentity.biz.queryreceipt.ReceiptDetail;
import org.apache.commons.lang3.StringUtils;

public class ElecReceiptService
implements IEBService<ElecReceiptResult> {
    private static final Log logger = LogFactory.getLog(ElecReceiptService.class);
    private final ElecReceiptResult result = new ElecReceiptResult();
    private ReceiptQueryInfo queryInfo;

    public ElecReceiptService(ReceiptQueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.result.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.result.setErrMsg(errMsg);
    }

    public void handleResultBody(String resultBody) {
        ArrayList<DynamicObject> receiptList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> receiptUpdate = new ArrayList<DynamicObject>();
        QueryReceiptResponseBody body = (QueryReceiptResponseBody)JSON.parseObject((String)resultBody, (TypeReference)new TypeReference<QueryReceiptResponseBody>(){}, (Feature[])new Feature[0]);
        if (kd.bos.util.StringUtils.isEmpty((String)resultBody)) {
            throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
        }
        List details = body.getDetails();
        logger.info(" junxi.error\u6253\u4e2a\u65e5\u5fd7\u770b\u4e00\u4e0b\u800c\u5df2 details :{}", (Object)details.size());
        if (details.size() > 0) {
            for (ReceiptDetail detail : details) {
                QFilter[] filter = new QFilter[]{new QFilter("receiptno", "=", (Object)detail.getReceiptNo())};
                DynamicObject[] updateObj = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,modifytime,uploadfilename", (QFilter[])filter);
                String uploadFileName = detail.getUploadFileName();
                if (updateObj.length > 0) {
                    if (StringUtils.equals((CharSequence)updateObj[0].getString("uploadfilename"), (CharSequence)uploadFileName)) continue;
                    updateObj[0].set("modifytime", (Object)DateUtils.getCurrentTime());
                    updateObj[0].set("uploadfilename", (Object)uploadFileName);
                    receiptUpdate.add(updateObj[0]);
                    continue;
                }
                DynamicObject receipt = BusinessDataServiceHelper.newDynamicObject((String)"bei_elecreceipt");
                logger.info("UploadFileName:  " + uploadFileName);
                QFilter qFilter = null;
                Boolean isRec = Boolean.FALSE;
                if (kd.bos.util.StringUtils.isNotEmpty((String)detail.getCreditAmount()) && !"0".equals(detail.getCreditAmount())) {
                    qFilter = new QFilter("bankaccountnumber", "=", (Object)detail.getOppAccNo());
                    isRec = Boolean.TRUE;
                } else {
                    qFilter = new QFilter("bankaccountnumber", "=", (Object)detail.getAccNo());
                }
                DynamicObject bankAcct = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,company,createorg,bank", (QFilter[])new QFilter[]{qFilter});
                if (bankAcct != null) {
                    receipt.set("company", (Object)TmcAccountHelper.getCreateOrgByBankAcct((DynamicObject)bankAcct));
                    receipt.set("accountbank", (Object)bankAcct.getLong("id"));
                    receipt.set("bank", (Object)bankAcct.getDynamicObject("bank").getLong("id"));
                }
                receipt.set("currency", this.queryInfo.getCurrency().getPkValue());
                receipt.set("fileflag", (Object)body.getFileFlag());
                receipt.set("completeflag", (Object)body.getCompleteFlag());
                receipt.set("host", (Object)body.getHost());
                receipt.set("tcpurl", (Object)body.getTcpUrl());
                receipt.set("fileserverurl", (Object)body.getFileServerUrl());
                receipt.set("username", (Object)body.getUserName());
                receipt.set("password", (Object)body.getPassword());
                receipt.set("proxy", (Object)body.getProxy());
                receipt.set("port", (Object)body.getPort());
                receipt.set("filepath", (Object)detail.getFilePath());
                receipt.set("uploadfilename", (Object)uploadFileName);
                receipt.set("validcode", (Object)detail.getValidateCode());
                if (body.getFileFlag() == 1) {
                    try {
                        String desPlace;
                        OutputStream out;
                        File ofdFile;
                        String realUploadUrl = ReceiptPrintHelper.getRealUploadUrl((DynamicObject)receipt);
                        String[] split = realUploadUrl.split("/");
                        String fileName = split[split.length - 1];
                        if (fileName.endsWith(".ofd") && (ofdFile = TmcAttachmentHelper.getFile((OutputStream)(out = TmcAttachmentHelper.downloadFile((String)(desPlace = "./".concat(fileName)), (String)realUploadUrl)), (String)realUploadUrl, (String)desPlace)) != null) {
                            OFDReceiptUtils OFDReceiptUtils2 = new OFDReceiptUtils();
                            String canonicalPath = ofdFile.getCanonicalPath();
                            Receipt receiptContext = OFDReceiptUtils2.parseOFDStructuredData(canonicalPath);
                            if (EmptyUtil.isEmpty((String)receiptContext.getValidcode())) {
                                logger.info("\u672a\u6210\u529f\u89e3\u6790\uff1a\u65e0\u7535\u5b50\u56de\u5355\u8bb0\u5f55");
                            } else {
                                receipt.set("validcode", (Object)receiptContext.getValidcode());
                            }
                            if (!ofdFile.delete()) {
                                logger.info("\u6587\u4ef6\u5220\u9664\u5931\u8d25");
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                receipt.set("recno", (Object)detail.getOppAccNo());
                receipt.set("recname", (Object)detail.getOppAccName());
                receipt.set("recbankname", (Object)detail.getOppBankName());
                receipt.set("accno", (Object)detail.getAccNo());
                receipt.set("accname", (Object)detail.getAccName());
                receipt.set("bankname", (Object)detail.getBankName());
                receipt.set("oppbanknumber", (Object)(isRec != false ? detail.getAccNo() : detail.getOppAccNo()));
                receipt.set("oppbankname", (Object)(isRec != false ? detail.getAccName() : detail.getOppAccName()));
                receipt.set("oppbank", (Object)(isRec != false ? detail.getBankName() : detail.getOppBankName()));
                receipt.set("debitamount", (Object)detail.getDebitAmount());
                receipt.set("creditamount", (Object)detail.getCreditAmount());
                receipt.set("oppunit", (Object)(isRec != false ? detail.getAccName() : detail.getOppAccName()));
                receipt.set("biztype", (Object)detail.getBusType());
                receipt.set("description", (Object)detail.getExplanation());
                if (detail.getTransDate() != null) {
                    receipt.set("bizdate", (Object)DateFormatUtil.FormatDate((String)detail.getTransDate()));
                } else {
                    receipt.set("bizdate", (Object)DateUtils.getCurrentDate());
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)detail.getDetailDateTime())) {
                    receipt.set("detaildatetime", (Object)DateFormatUtil.FormatDate((String)detail.getDetailDateTime()));
                } else {
                    receipt.set("detaildatetime", (Object)DateUtils.getCurrentTime());
                }
                BigDecimal debitAmount = kd.bos.util.StringUtils.isEmpty((String)detail.getDebitAmount()) ? BigDecimal.ZERO : new BigDecimal(detail.getDebitAmount());
                BigDecimal creditAmount = kd.bos.util.StringUtils.isEmpty((String)detail.getCreditAmount()) ? BigDecimal.ZERO : new BigDecimal(detail.getCreditAmount());
                receipt.set("amount", (Object)debitAmount.add(creditAmount));
                receipt.set("receiptno", (Object)detail.getReceiptNo());
                receipt.set("use", (Object)detail.getUseCn());
                receipt.set("detailid", (Object)detail.getTranSerialNo());
                receipt.set("remarks", (Object)detail.getRemark());
                receipt.set("transnetcode", (Object)detail.getTransNetCode());
                receipt.set("transtellno", (Object)detail.getTransTellno());
                receipt.set("datasource", (Object)DataSourceEnum.FROMBANK.getValue());
                receipt.set("modifytime", (Object)DateUtils.getCurrentTime());
                receipt.set("billstatus", (Object)"C");
                String billno = CodeRuleHelper.generateNumber((String)"bei_elecreceipt", (DynamicObject)receipt, null, null);
                logger.info("junxi billno:" + billno);
                receipt.set("billno", (Object)billno);
                receiptList.add(receipt);
            }
            if (receiptList.size() > 0) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)receiptList.get(0)).getDataEntityType(), (Object[])receiptList.toArray());
            }
            if (receiptUpdate.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])receiptUpdate.toArray(new DynamicObject[receiptUpdate.size()]));
            }
        } else {
            logger.info(" details is null " + details);
        }
        this.result.setCount(receiptList.size());
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new DownElecReceiptRequestBuilder(this.queryInfo);
    }

    public String getEntityName() {
        return "bei_elecreceipt";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo bankLogInfo = new BankLogInfo();
        bankLogInfo.setEntityName("bei_transdetail_cas");
        String billNo = kd.bos.util.StringUtils.isNotEmpty((String)this.queryInfo.getBillNo()) ? this.queryInfo.getBillNo() : this.queryInfo.getBankAcct().getString("bankaccountnumber");
        Long orgId = this.queryInfo.getOrgId() != null && this.queryInfo.getOrgId().compareTo(0L) != 0 ? this.queryInfo.getOrgId().longValue() : RequestContext.get().getOrgId();
        bankLogInfo.setOrgid(orgId);
        bankLogInfo.setBillNo(billNo);
        return bankLogInfo;
    }

    public ElecReceiptResult getEBResult() {
        return this.result;
    }

    public String getServiceUrl() {
        return "/kapi/app/receipt/receiptQuery";
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.queryInfo.getBankAcct());
    }
}

