/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.executor;

import com.alibaba.fastjson.JSON;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.service.ebservice.log.BankLogService;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.service.IEBServiceExecutor;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusRequest;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class UpdateStateServiceExecutor
implements IEBServiceExecutor {
    private static final Log logger = LogFactory.getLog(UpdateStateServiceExecutor.class);
    private BankLogService logService;

    public <R> R execute(IEBService<R> service) {
        PayStatusRequest request;
        try {
            boolean isValid = service.validate();
            if (!isValid) {
                return (R)service.getEBResult();
            }
            service.beforeRequest();
        }
        catch (Exception e) {
            try {
                service.rollback(ExceptionUtils.getExceptionStackTraceMessage((Exception)e), e);
            }
            catch (Exception e1) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e1));
            }
            return (R)service.getEBResult();
        }
        this.logService = new BankLogService(service.getBankLogInfo());
        try {
            request = (PayStatusRequest)service.getRequestBuilder().buildRequest();
            this.logService.setRequest((EBRequest)request);
            this.logService.save();
        }
        catch (Exception e) {
            try {
                service.rollback(ExceptionUtils.getExceptionStackTraceMessage((Exception)e), e);
            }
            catch (Exception e1) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e1));
            }
            return (R)service.getEBResult();
        }
        PayStatusBody body = request.getBody();
        for (PayStatusDetail detail : body.getDetails()) {
            if (detail.getModifyStatus() == 12) {
                detail.setEbStatus(EbStatus.BANK_SUCCESS.getName());
            } else if (detail.getModifyStatus() == 13) {
                detail.setEbStatus(EbStatus.BANK_FAIL.getName());
            }
            detail.setEbStatusMsg(detail.getUpdateReason());
        }
        String resultBody = JSON.toJSONString((Object)body);
        try {
            service.handleResultBody(resultBody);
        }
        catch (Exception e) {
            this.logService.setBizException(e);
            try {
                service.handleEBException(resultBody, ExceptionUtils.getExceptionStackTraceMessage((Exception)e), e);
            }
            catch (Exception e1) {
                this.logService.setBizException(e1);
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e1));
            }
        }
        this.logService.update();
        return (R)service.getEBResult();
    }
}

