/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.pay;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.builder.PayTraceLogBankBillBuilder;
import kd.tmc.fbp.common.log.enums.PayLogLevelEnum;
import kd.tmc.fbp.common.log.enums.PayTraceLogStepEmum;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.exception.EBSQLException;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayBody;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public abstract class AbstractPayService
implements IEBService<List<SyncStatusInfo>> {
    private static Log logger = LogFactory.getLog(AbstractPayService.class);
    private List<SyncStatusInfo> payResultList;
    private static PayLogger traceLogger = PayLogger.create(AbstractPayService.class);
    protected boolean isBankPay;

    public AbstractPayService(boolean isBankPay) {
        this.isBankPay = isBankPay;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(this.getBankBillList(), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), "beforeCommitBe", null, null).build());
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.beforeDoRequest();
            }
            catch (Exception e) {
                tx.markRollback();
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(this.getBankBillList(), PayLogLevelEnum.ERROR.getValue(), PayTraceLogStepEmum.PAY.getValue(), "beforeCommitBeError", null, e).build());
                throw e;
            }
        }
    }

    public void handleResultBody(String resultBody) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(this.getBankBillList(), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), "handleResponse", null, null).build());
        PayBody payBody = (PayBody)JSON.parseObject((String)resultBody, PayBody.class);
        List details = payBody.getDetails();
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.payResultList = this.handleSuccessResult(details);
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(this.getBankBillList(), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), "handleResponseResult", null, null).build());
            }
            catch (Exception e) {
                tx.markRollback();
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(this.getBankBillList(), PayLogLevelEnum.ERROR.getValue(), PayTraceLogStepEmum.PAY.getValue(), "handleResponseResultError", null, e).build());
                throw e;
            }
        }
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(this.getBankBillList(), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), "handleEBException", null, e).build());
        this.payResultList = new ArrayList<SyncStatusInfo>(this.getBankBillList().size());
        for (DynamicObject bankBill : this.getBankBillList()) {
            SyncStatusInfo payResult = new SyncStatusInfo();
            payResult.setStatusCode(EBResultStatusCode.ERROR);
            payResult.setErrMsg(errMsg);
            payResult.setBankBillId(Long.valueOf(bankBill.getLong("id")));
            payResult.setPayBillId(Long.valueOf(bankBill.getLong("sourcebillid")));
            if (e instanceof EBBizNCException) {
                payResult.setErrCode(((EBBizNCException)e).getErrorCode());
            }
            this.payResultList.add(payResult);
        }
        if (e instanceof EBSQLException) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.handleEBException(errMsg);
            }
            catch (Exception ee) {
                tx.markRollback();
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(this.getBankBillList(), PayLogLevelEnum.ERROR.getValue(), PayTraceLogStepEmum.PAY.getValue(), "handleEBExceptionError", null, ee).build());
                throw ee;
            }
        }
    }

    public void rollback(String errMsg, Exception e) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(this.getBankBillList(), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), "rollback", errMsg, e).build());
        this.payResultList = new ArrayList<SyncStatusInfo>(this.getBankBillList().size());
        for (DynamicObject bankBill : this.getBankBillList()) {
            SyncStatusInfo payResult = new SyncStatusInfo();
            payResult.setStatusCode(EBResultStatusCode.ROLLBACK);
            payResult.setErrMsg(errMsg);
            payResult.setBankBillId(Long.valueOf(bankBill.getLong("id")));
            payResult.setPayBillId(Long.valueOf(bankBill.getLong("sourcebillid")));
            this.payResultList.add(payResult);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (this.isBankPay) {
                    this.handleBankPayRollback(errMsg);
                } else {
                    this.handleBizPayRollback(errMsg);
                }
            }
            catch (Exception ee) {
                tx.markRollback();
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(this.getBankBillList(), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), "rollbackError", errMsg, ee).build());
                throw ee;
            }
        }
    }

    public List<SyncStatusInfo> getEBResult() {
        return this.payResultList;
    }

    protected abstract void beforeDoRequest();

    protected abstract List<SyncStatusInfo> handleSuccessResult(List<PayDetail> var1);

    protected abstract void handleEBException(String var1);

    protected abstract void handleBankPayRollback(String var1);

    protected abstract void handleBizPayRollback(String var1);

    protected abstract List<DynamicObject> getBankBillList();
}

