/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.pay;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.ebservice.log.BankLogInfoFactory;
import kd.tmc.bei.business.ebservice.request.LinkPayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.OverseaPayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.PayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.bankpay.BankPayRequestDataSource;
import kd.tmc.bei.business.ebservice.service.pay.AbstractPayService;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.PayBusinessTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBSQLException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class BankPayService
extends AbstractPayService {
    private String batchSeqId = DBServiceHelper.genStringId();
    private List<DynamicObject> bankBillList;

    public BankPayService(List<DynamicObject> bankBillList, boolean isBankPay) {
        super(isBankPay);
        this.bankBillList = bankBillList;
    }

    @Override
    protected void beforeDoRequest() {
        List idList = this.bankBillList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        String sql = "update t_bei_bankpayingbill set fbankpaystate = ? where fid in (" + TmcBusinessBaseHelper.idListToString(idList) + ") and fbankpaystate = ? and fbillstatus = ?";
        int[] result = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, Collections.singletonList(new Object[]{BeBillStatusEnum.OS.getValue(), BeBillStatusEnum.OP.getValue(), BillStatusEnum.AUDIT.getValue()}));
        if (result.length < 1 || result[0] != this.bankBillList.size()) {
            throw new EBSQLException(new EBBizErrorCode().UPDATE_SQL_EXCEPTION());
        }
        for (DynamicObject bankPayBill : this.bankBillList) {
            bankPayBill.set("bankpaystate", (Object)BeBillStatusEnum.OS.getValue());
            bankPayBill.set("submittime", (Object)new Date());
            bankPayBill.set("submituser", (Object)RequestContext.get().getUserId());
            bankPayBill.set("batchseqid", (Object)this.batchSeqId);
            bankPayBill.set("serialnumber", (Object)this.batchSeqId);
            bankPayBill.set("returntime", (Object)new Date());
            bankPayBill.set("payer", (Object)RequestContext.get().getUserId());
            bankPayBill.set("paytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])this.bankBillList.toArray(new DynamicObject[0]));
    }

    public IEBRequestBuilder getRequestBuilder() {
        BankPayRequestDataSource bankPayRequestDataSource = new BankPayRequestDataSource(this.batchSeqId, this.bankBillList);
        if (this.bankBillList.get(0).getBoolean("istranspay")) {
            return new OverseaPayRequestBuilder(bankPayRequestDataSource, false);
        }
        if (this.bankBillList.get(0).getBoolean("islinkpay")) {
            return new LinkPayRequestBuilder(bankPayRequestDataSource, false);
        }
        String businessType = this.bankBillList.get(0).getString("businesstype");
        String subBizType = PayBusinessTypeEnum.getSubBizType((String)businessType);
        if (subBizType == null) {
            subBizType = "pay";
        }
        return new PayRequestBuilder(subBizType, bankPayRequestDataSource, false);
    }

    @Override
    protected List<SyncStatusInfo> handleSuccessResult(List<PayDetail> details) {
        ArrayList<SyncStatusInfo> resultList = new ArrayList<SyncStatusInfo>(this.bankBillList.size());
        Map idToBankBillMap = this.bankBillList.stream().collect(Collectors.toMap(o -> o.getString("id"), Function.identity()));
        ArrayList<DynamicObject> rollBankBackList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> rollBizBackList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < details.size(); ++i) {
            SyncStatusInfo syncInfo;
            PayDetail detail = details.get(i);
            DynamicObject bankPayBill = (DynamicObject)idToBankBillMap.get(detail.getDetailSeqID());
            if (bankPayBill == null) continue;
            String ebStatus = detail.getEbStatus();
            if ("EB_ROLL_BACK".equals(ebStatus)) {
                syncInfo = new SyncStatusInfo();
                if (this.isBankPay) {
                    this.rollBackBankBill(bankPayBill);
                    bankPayBill.set("bankreturnmsg", (Object)detail.getEbStatusMsg());
                    rollBankBackList.add(bankPayBill);
                    syncInfo.setStatusCode(EBResultStatusCode.ERROR);
                } else {
                    syncInfo.setStatusCode(EBResultStatusCode.ROLLBACK);
                    rollBizBackList.add(bankPayBill);
                }
                syncInfo.setBankPay(this.isBankPay);
                syncInfo.setBankBillId((Long)bankPayBill.getPkValue());
                syncInfo.setErrMsg(detail.getEbStatusMsg());
                resultList.add(syncInfo);
                continue;
            }
            syncInfo = new SyncStatusInfo();
            syncInfo.setBankPay(this.isBankPay);
            ArrayList<SyncStatusDetail> detailList = new ArrayList<SyncStatusDetail>(details.size());
            syncInfo.setDetailList(detailList);
            syncInfo.setBatchSeqId(detail.getBatchSeqID());
            syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
            syncInfo.setErrMsg(null);
            syncInfo.setBankBillId((Long)bankPayBill.getPkValue());
            syncInfo.setPayBillId(Long.valueOf(bankPayBill.getLong("sourcebillid")));
            syncInfo.setBankPayStatus(bankPayBill.getString("bankpaystate"));
            syncInfo.setEntityType("cas_paybill");
            SyncStatusDetail syncDetail = new SyncStatusDetail();
            detailList.add(syncDetail);
            syncDetail.setEbSeqId(detail.getEbSeqId());
            syncDetail.setEbStatusMsg(detail.getEbStatusMsg());
            syncDetail.setBankMsg(detail.getBankMsg());
            syncDetail.setBankBatchSeqId(detail.getBankBatchSeqId());
            syncDetail.setBankDetailSeqId(detail.getBankDetailSeqId());
            syncDetail.setResponseSerialNo(detail.getResponseSerialNo());
            BeBillStatusEnum entryStatus = BeServiceHelper.transferState((String)ebStatus);
            bankPayBill.set("bankpaystate", (Object)entryStatus.getValue());
            bankPayBill.set("bankreturnmsg", (Object)detail.getEbStatusMsg());
            bankPayBill.set("statementrefno", (Object)detail.getBankDetailSeqId());
            boolean isRefund = ResManager.loadKDString((String)"\u9000\u7968", (String)"BankBillPayQueryStragety_0", (String)"tmc-bei-business", (Object[])new Object[0]).equals(detail.getBankMsg());
            bankPayBill.set("isrefund", (Object)isRefund);
            resultList.add(syncInfo);
        }
        if (EmptyUtil.isNoEmpty(rollBankBackList)) {
            TmcDataServiceHelper.save((DynamicObject[])rollBankBackList.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty(rollBizBackList)) {
            this.deleteBankBill(rollBizBackList);
        }
        return resultList;
    }

    @Override
    protected void handleEBException(String errMsg) {
        for (DynamicObject bankBill : this.bankBillList) {
            bankBill.set("bankpaystate", (Object)BeBillStatusEnum.OS.getValue());
            bankBill.set("bankreturnmsg", (Object)errMsg);
        }
        TmcDataServiceHelper.save((DynamicObject[])this.bankBillList.toArray(new DynamicObject[0]));
    }

    @Override
    protected void handleBankPayRollback(String errMsg) {
        for (DynamicObject bankPayBill : this.bankBillList) {
            this.rollBackBankBill(bankPayBill);
            String preError = String.format(ResManager.loadKDString((String)"\u5904\u7406\u524d\u5931\u8d25%s", (String)"EBBizErrorCode_5", (String)"tmc-fbp-mservice", (Object[])new Object[0]), ":");
            if (!errMsg.contains(preError)) continue;
            try {
                String jsonStr = errMsg.split(preError)[1];
                Map map = (Map)JSON.parseObject((String)jsonStr, Map.class);
                for (Map.Entry message : map.entrySet()) {
                    if (!String.valueOf(bankPayBill.getPkValue()).equals(message.getKey())) continue;
                    bankPayBill.set("bankreturnmsg", (Object)errMsg);
                }
            }
            catch (Exception e) {
                bankPayBill.set("bankreturnmsg", (Object)errMsg);
            }
        }
        SaveServiceHelper.save((DynamicObject[])this.bankBillList.toArray(new DynamicObject[0]));
    }

    private void rollBackBankBill(DynamicObject bankPayBill) {
        bankPayBill.set("bankpaystate", (Object)BeBillStatusEnum.OP.getValue());
        bankPayBill.set("submittime", null);
        bankPayBill.set("submituser", null);
        bankPayBill.set("batchseqid", null);
        bankPayBill.set("serialnumber", null);
        bankPayBill.set("returntime", null);
        bankPayBill.set("payer", null);
        bankPayBill.set("paytime", null);
    }

    @Override
    protected void handleBizPayRollback(String errMsg) {
        Object[] sourceBillIdArr = this.bankBillList.stream().map(o -> o.getLong("lastsourcebillid")).filter(o -> o != 0L).toArray();
        if (sourceBillIdArr.length > 0) {
            DynamicObject[] sourceBillArr;
            for (DynamicObject sourceBill : sourceBillArr = TmcDataServiceHelper.load((Object[])sourceBillIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntityName()))) {
                sourceBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                sourceBill.set("payunique", (Object)-1L);
            }
            SaveServiceHelper.save((DynamicObject[])sourceBillArr);
        }
        Object[] idArr = this.bankBillList.stream().map(DataEntityBase::getPkValue).toArray();
        QFilter idFilter = new QFilter("id", "in", (Object)idArr);
        QFilter payStateFilter = new QFilter("bankpaystate", "=", (Object)BeBillStatusEnum.OS.getValue());
        int lines = DeleteServiceHelper.delete((String)this.getEntityName(), (QFilter[])new QFilter[]{idFilter, payStateFilter});
        if (lines != this.bankBillList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u94f6\u884c\u4ed8\u6b3e\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u518d\u64cd\u4f5c\u3002", (String)"GenerateBankPayBillService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
    }

    private void deleteBankBill(List<DynamicObject> rollBizBackList) {
        if (EmptyUtil.isNoEmpty(rollBizBackList)) {
            Object[] idArr = rollBizBackList.stream().map(DataEntityBase::getPkValue).toArray();
            QFilter idFilter = new QFilter("id", "in", (Object)idArr);
            DeleteServiceHelper.delete((String)this.getEntityName(), (QFilter[])new QFilter[]{idFilter});
        }
    }

    @Override
    protected List<DynamicObject> getBankBillList() {
        return this.bankBillList;
    }

    public String getEntityName() {
        return "bei_bankpaybill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoFactory.generateBankLogInfo(this.bankBillList);
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.bankBillList.get(0).getDynamicObject("accountbank"));
    }
}

