/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.pay;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.ebservice.log.BankLogInfoFactory;
import kd.tmc.bei.business.ebservice.request.PayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.banktrans.BankTransUpRequestDataSource;
import kd.tmc.bei.business.ebservice.service.pay.AbstractPayService;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.log.bean.BankLogDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBSQLException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class BankTransUpPayService
extends AbstractPayService {
    private DynamicObject bankTransUpBill;
    private DynamicObject entry;

    public BankTransUpPayService(DynamicObject bankTransUpBill, DynamicObject entry, boolean isBankPay) {
        super(isBankPay);
        this.bankTransUpBill = bankTransUpBill;
        this.entry = entry;
    }

    @Override
    protected void beforeDoRequest() {
        boolean updateStatusSuccess = DB.execute((DBRoute)DBRouteConst.TMC, (String)"update t_bei_banktransup_entry set FStatus = ? where fentryid = ? and FStatus = ?", (Object[])new Object[]{BeBillStatusEnum.OS.getValue(), this.entry.getPkValue(), BeBillStatusEnum.OP.getValue()});
        if (!updateStatusSuccess) {
            throw new EBSQLException(new EBBizErrorCode().UPDATE_SQL_EXCEPTION());
        }
        DynamicObjectCollection entries = this.bankTransUpBill.getDynamicObjectCollection("entrys");
        for (DynamicObject entryEntity : entries) {
            if (!entryEntity.getString("id").equals(this.entry.getString("id"))) continue;
            this.entry.set("status", (Object)BeBillStatusEnum.OS.getValue());
            this.entry.set("serialnumber", (Object)BeServiceHelper.generateSerialNumber());
        }
        this.bankTransUpBill.set("submittime", (Object)new Date());
        this.bankTransUpBill.set("paystate", (Object)BeBillStatusEnum.OS.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bankTransUpBill});
    }

    @Override
    protected List<SyncStatusInfo> handleSuccessResult(List<PayDetail> details) {
        if (details.size() != 1 || !details.get(0).getDetailSeqID().equals(this.entry.getPkValue().toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u5931\u8d25, \u672a\u63a5\u6536\u5230\u6709\u6548\u7684\u94f6\u4f01\u4e91\u8fd4\u56de\u4fe1\u606f\u3002", (String)"BankTransUpPayService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        PayDetail firstDetail = details.get(0);
        SyncStatusInfo syncInfo = new SyncStatusInfo();
        ArrayList<SyncStatusDetail> detailList = new ArrayList<SyncStatusDetail>(details.size());
        syncInfo.setDetailList(detailList);
        syncInfo.setBatchSeqId(firstDetail.getBatchSeqID());
        syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
        syncInfo.setErrMsg(null);
        syncInfo.setBankBillId((Long)this.bankTransUpBill.getPkValue());
        syncInfo.setPayBillId(Long.valueOf(this.bankTransUpBill.getLong("sourcebillid")));
        syncInfo.setEntityType("fca_transupbill");
        syncInfo.setBankPayStatus(this.bankTransUpBill.getString("paystate"));
        SyncStatusDetail syncDetail = new SyncStatusDetail();
        detailList.add(syncDetail);
        syncDetail.setEbSeqId(firstDetail.getEbSeqId());
        syncDetail.setEbStatusMsg(firstDetail.getEbStatusMsg());
        syncDetail.setBankMsg(firstDetail.getBankMsg());
        syncDetail.setBankBatchSeqId(firstDetail.getBankBatchSeqId());
        syncDetail.setBankDetailSeqId(firstDetail.getBankDetailSeqId());
        syncDetail.setResponseSerialNo(firstDetail.getResponseSerialNo());
        syncDetail.setPayBillEntryId(Long.valueOf(this.entry.getLong("sourceentryid")));
        return Collections.singletonList(syncInfo);
    }

    @Override
    protected void handleEBException(String errMsg) {
        for (DynamicObject entryObj : this.bankTransUpBill.getDynamicObjectCollection("entrys")) {
            if (!this.entry.getPkValue().equals(entryObj.getPkValue())) continue;
            this.entry.set("status", (Object)BeBillStatusEnum.OS.getValue());
            String preError = String.format(ResManager.loadKDString((String)"\u5904\u7406\u524d\u5931\u8d25%s", (String)"EBBizErrorCode_5", (String)"tmc-fbp-mservice", (Object[])new Object[0]), ":");
            if (!errMsg.contains(preError)) continue;
            try {
                String jsonStr = errMsg.split(preError)[1];
                Map map = (Map)JSON.parseObject((String)jsonStr, Map.class);
                for (Map.Entry message : map.entrySet()) {
                    if (!String.valueOf(this.entry.getPkValue()).equals(message.getKey())) continue;
                    this.entry.set("bankreturnmsg", (Object)errMsg);
                }
            }
            catch (Exception e) {
                this.entry.set("bankreturnmsg", (Object)errMsg);
            }
        }
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bankTransUpBill});
    }

    @Override
    protected void handleBankPayRollback(String errMsg) {
        this.rollback(errMsg);
    }

    @Override
    protected void handleBizPayRollback(String errMsg) {
        this.rollback(errMsg);
    }

    private void rollback(String errMsg) {
        DynamicObjectCollection entrys = this.bankTransUpBill.getDynamicObjectCollection("entrys");
        for (DynamicObject entryObj : entrys) {
            if (!this.entry.getPkValue().equals(entryObj.getPkValue())) continue;
            this.entry.set("status", (Object)BeBillStatusEnum.NC.getValue());
            this.entry.set("bankreturnmsg", (Object)errMsg);
        }
        this.bankTransUpBill.set("paystate", (Object)BeBillStatusEnum.NC.getValue());
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bankTransUpBill});
        Iterator iterator = this.getEBResult().iterator();
        while (iterator.hasNext()) {
            SyncStatusInfo result = (SyncStatusInfo)iterator.next();
            result.setStatusCode(EBResultStatusCode.ERROR);
        }
    }

    @Override
    protected List<DynamicObject> getBankBillList() {
        return Collections.singletonList(this.bankTransUpBill);
    }

    public String getEntityName() {
        return "bei_banktransupbill";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo bankLogInfo = BankLogInfoFactory.generateBankTransLog(Collections.singletonList(this.bankTransUpBill));
        BigDecimal amt = this.entry.getBigDecimal("transamt");
        bankLogInfo.setPayTotalAmt(amt);
        for (BankLogDetail detail : bankLogInfo.getLogDetailList()) {
            detail.setPayAmt(amt);
        }
        return bankLogInfo;
    }

    public IEBRequestBuilder getRequestBuilder() {
        BankTransUpRequestDataSource bankTransUpPayRequestDataSource = new BankTransUpRequestDataSource(this.bankTransUpBill, this.entry);
        return new PayRequestBuilder("pay_for_capital_allocation", bankTransUpPayRequestDataSource, true);
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.entry.getDynamicObject("subacct"));
    }
}

