/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.log.BankLogInfoFactory;
import kd.tmc.bei.business.ebservice.request.QueryOverseaPayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.QueryPayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.bankagent.BankAgentRequestDataSource;
import kd.tmc.bei.business.ebservice.service.query.AbstractQueryService;
import kd.tmc.bei.common.enums.BeiMsgTemplateEnum;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.NoticeMsgHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayBody;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class BankAgentQueryService
extends AbstractQueryService {
    private static Log logger = LogFactory.getLog(BankAgentQueryService.class);
    private String batchSeqId;

    public BankAgentQueryService(List<DynamicObject> bankPayBillList, boolean isForceQuery) {
        super(bankPayBillList, isForceQuery);
        this.batchSeqId = bankPayBillList.get(0).getString("serialnumber");
    }

    @Override
    protected List<SyncStatusInfo> handlePayDetails(List<PayDetail> details) {
        ArrayList<SyncStatusInfo> resultList = new ArrayList<SyncStatusInfo>(this.bankPayBillList.size());
        Map detailSeqIdToDetailMap = details.stream().collect(Collectors.toMap(PayDetail::getDetailSeqID, Function.identity(), (a, b) -> a));
        HashSet<DynamicObject> sendMsgBills = new HashSet<DynamicObject>(10);
        block0: for (DynamicObject bankPayBill : this.bankPayBillList) {
            DynamicObjectCollection entryList = bankPayBill.getDynamicObjectCollection("entrys");
            SyncStatusInfo syncInfo = new SyncStatusInfo();
            ArrayList<SyncStatusDetail> syncStatusList = new ArrayList<SyncStatusDetail>(details.size());
            String batchSeqId = null;
            for (DynamicObject entry : entryList) {
                String kdFlagId;
                String ebStatusMsg;
                String entryIdStr = entry.getPkValue().toString();
                BeBillStatusEnum[] detail = (BeBillStatusEnum[])detailSeqIdToDetailMap.get(entryIdStr);
                if (detail == null) continue;
                if (batchSeqId == null) {
                    batchSeqId = detail.getBatchSeqID();
                }
                if (!Objects.equals(batchSeqId, detail.getBatchSeqID())) continue block0;
                SyncStatusDetail syncDetail = new SyncStatusDetail();
                StringBuilder msgSb = new StringBuilder();
                if (StringUtils.isNotEmpty((String)detail.getBankMsg())) {
                    msgSb.append(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%s\u3002", (String)"BankAgentQueryService_0", (String)"tmc-bei-business", (Object[])new Object[0]), detail.getBankMsg()));
                }
                if (StringUtils.isNotEmpty((String)detail.getEbStatusMsg())) {
                    msgSb.append(detail.getEbStatusMsg());
                }
                if (StringUtils.isNotEmpty((String)(ebStatusMsg = msgSb.toString()))) {
                    ebStatusMsg = ebStatusMsg.substring(0, Math.min(255, ebStatusMsg.length()));
                }
                if ((kdFlagId = detail.getKdFlagID()) == null) {
                    logger.info("kdFlagId is null");
                    kdFlagId = detail.getBankDetailSeqId();
                }
                syncDetail.setEbSeqId(detail.getEbSeqId());
                syncDetail.setEbStatusMsg(ebStatusMsg);
                syncDetail.setBankMsg(detail.getBankMsg());
                syncDetail.setBankBatchSeqId(detail.getBankBatchSeqId());
                syncDetail.setBankDetailSeqId(kdFlagId);
                syncDetail.setResponseSerialNo(detail.getResponseSerialNo());
                syncDetail.setExchangeRate(detail.getExchangeRate());
                syncDetail.setActualAmount(detail.getActualAmount());
                BeBillStatusEnum entryStatus = BeServiceHelper.transferState((String)detail.getEbStatus());
                entry.set("status", (Object)entryStatus.getValue());
                entry.set("bankreturnmsg", (Object)ebStatusMsg);
                entry.set("bankcheckflag", (Object)kdFlagId);
                boolean isRefund = this.detailIsRefund((PayDetail)detail);
                entry.set("isrefund", (Object)isRefund);
                syncDetail.setRenote(isRefund);
                syncDetail.setBankEntryPayStatus(entryStatus.getValue());
                syncDetail.setPayBillEntryId(Long.valueOf(entry.getLong("sourceentryid")));
                syncStatusList.add(syncDetail);
                if (!isRefund) continue;
                sendMsgBills.add(bankPayBill);
            }
            if (batchSeqId == null) continue;
            syncInfo.setBatchSeqId(details.get(0).getBatchSeqID());
            syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
            syncInfo.setErrMsg(null);
            syncInfo.setBankBillId((Long)bankPayBill.getPkValue());
            syncInfo.setPayBillId(Long.valueOf(bankPayBill.getLong("sourcebillid")));
            syncInfo.setDetailList(syncStatusList);
            syncInfo.setEntityType("cas_agentpaybill");
            resultList.add(syncInfo);
            String payStatus = this.getPayStatus(entryList);
            bankPayBill.set("paystate", (Object)payStatus);
            syncInfo.setBankPayStatus(payStatus);
            BeBillStatusEnum[] billStatusEnums = BeBillStatusEnum.values();
            HashMap<BeBillStatusEnum, Integer> entryStatusMap = new HashMap<BeBillStatusEnum, Integer>(billStatusEnums.length);
            for (BeBillStatusEnum eachStatus : billStatusEnums) {
                entryStatusMap.put(eachStatus, 0);
            }
            BigDecimal actPayAmount = BigDecimal.ZERO;
            int actPayCount = 0;
            DynamicObjectCollection entry = bankPayBill.getDynamicObjectCollection("entrys");
            for (DynamicObject row : entry) {
                if (BeBillStatusEnum.TS.getValue().equals(row.get("status"))) {
                    BigDecimal amount = row.getBigDecimal("recamount");
                    actPayAmount = actPayAmount.add(amount);
                    ++actPayCount;
                }
                BeBillStatusEnum rowStatus = BeBillStatusEnum.valueOf((String)row.getString("status"));
                entryStatusMap.put(rowStatus, (Integer)entryStatusMap.get(rowStatus) + 1);
            }
            bankPayBill.set("actamount", (Object)actPayAmount);
            bankPayBill.set("actcount", (Object)actPayCount);
        }
        BeiMsgTemplateEnum msgTemplateEnum = BeiMsgTemplateEnum.BANK_AGENT_PAYBILL_REFUND;
        NoticeMsgHelper.batchAsyncSendNoticeMsg(sendMsgBills, (String)msgTemplateEnum.getTemplateNumber(), (String)msgTemplateEnum.getMsgTag());
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncRemoteStatus(List<SyncStatusInfo> syncInfoList) {
        if (this.isForceQuery) {
            for (SyncStatusInfo syncInfo : syncInfoList) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"casEbService", (String)"syncBankBillStatus", (Object[])new Object[]{"cas_agentpaybill", SerializationUtils.toJsonString((Object)syncInfo)});
            }
            return;
        }
        MessagePublisher pub = MQFactory.get().createSimplePublisher("tmc", "kd.tmc.bei.payquery");
        for (SyncStatusInfo syncInfo : syncInfoList) {
            try {
                HashMap<String, String> msgParamMap = new HashMap<String, String>();
                msgParamMap.put("entityName", this.getEntityName());
                msgParamMap.put("syncInfo", (String)syncInfo);
                pub.publish(msgParamMap);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            finally {
                pub.close();
            }
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        boolean isOverseaPay = ((DynamicObject)this.bankPayBillList.get(0)).getBoolean("istranspay");
        if (isOverseaPay) {
            return new QueryOverseaPayRequestBuilder(new BankAgentRequestDataSource(this.batchSeqId, this.bankPayBillList));
        }
        return new QueryPayRequestBuilder(new BankAgentRequestDataSource(this.batchSeqId, this.bankPayBillList), this.isForceQuery);
    }

    public String getEntityName() {
        return "bei_bankagentpay";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoFactory.generateBankLogInfo(this.bankPayBillList);
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)((DynamicObject)this.bankPayBillList.get(0)).getDynamicObject("accountbank"));
    }

    @Override
    protected void handleRollback(String errMsg, Exception e) {
        for (DynamicObject bankPayBill : this.bankPayBillList) {
            for (DynamicObject entry : bankPayBill.getDynamicObjectCollection("entrys")) {
                entry.set("bankreturnmsg", (Object)e.getMessage());
            }
        }
        SaveServiceHelper.save((DynamicObject[])this.bankPayBillList.toArray(new DynamicObject[0]));
    }

    @Override
    protected void handleException(PayBody result, Exception e) {
        for (DynamicObject bankPayBill : this.bankPayBillList) {
            String code;
            boolean isUnknownBatch = false;
            if (e instanceof EBBizNCException && "tmc.bei.UNKNOWN_BATCH".equals(code = ((EBBizNCException)e).getErrorCode().getCode())) {
                bankPayBill.set("paystate", (Object)BeBillStatusEnum.NC.getValue());
                isUnknownBatch = true;
            }
            for (DynamicObject entry : bankPayBill.getDynamicObjectCollection("entrys")) {
                entry.set("bankreturnmsg", (Object)e.getMessage());
                if (!isUnknownBatch) continue;
                entry.set("status", (Object)BeBillStatusEnum.NC.getValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])this.bankPayBillList.toArray(new DynamicObject[0]));
    }
}

