/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.update;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayBody;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public abstract class AbstractUpdateService
implements IEBService<EBResult> {
    private EBResult ebResult;
    protected boolean isForceQuery;
    protected List<DynamicObject> bankPayBillList;

    public AbstractUpdateService(List<DynamicObject> bankPayBillList, boolean isForceQuery) {
        this.bankPayBillList = bankPayBillList;
        this.isForceQuery = isForceQuery;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void handleResultBody(String resultBody) {
        List<SyncStatusInfo> syncInfoList;
        PayBody result = (PayBody)JSON.parseObject((String)resultBody, PayBody.class);
        List details = result.getDetails();
        if (details == null || details.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u72b6\u6001\u65f6\uff0c\u94f6\u4f01\u8fd4\u56de\u7684\u4ed8\u6b3e\u660e\u7ec6\u4e3a\u7a7a\u3002\u8be6\u60c5\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u3002", (String)"BankAgentPayQueryStragety_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                syncInfoList = this.handlePayDetails(details);
                SaveServiceHelper.save((DynamicObject[])this.bankPayBillList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        this.syncRemoteStatus(syncInfoList);
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
        this.ebResult.setErrMsg(null);
    }

    public void rollback(String errMsg, Exception e) {
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.ebResult.setErrMsg(errMsg);
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.handleRollback(errMsg, e);
            }
            catch (Exception ee) {
                tx.markRollback();
                throw ee;
            }
        }
    }

    public void handleEBException(String body, String errMsg, Exception e) {
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ERROR);
        this.ebResult.setErrMsg(errMsg);
        if (e instanceof EBBizNCException) {
            this.ebResult.setErrCode(((EBBizNCException)e).getErrorCode());
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                PayBody result = (PayBody)JSON.parseObject((String)body, PayBody.class);
                this.handleException(result, e);
            }
            catch (Exception ee) {
                tx.markRollback();
                throw ee;
            }
        }
    }

    protected void updateBankLogWhenSync(DynamicObject bankBill, String bankStatusField) {
        ThreadPools.executeOnceIncludeRequestContext((String)"syncBankLogStatus", () -> {
            String sSQL = bankBill.getBoolean("istranspay") ? "update t_bei_banklogentry set fbankpaystate = ? where fbillid = ? and fbanklogtype = 'overseaPay'" : "update t_bei_banklogentry set fbankpaystate = ? where fbillid = ? and fbanklogtype = 'pay'";
            String bankPayStatus = bankBill.getString(bankStatusField);
            if (BeBillStatusEnum.NC.getValue().equals(bankPayStatus)) {
                sSQL = sSQL + " and (fbankpaystate <> 'TF' or fbankpaystate <> 'TS')";
            }
            Long id = (Long)bankBill.getPkValue();
            DB.execute((DBRoute)DBRouteConst.TMC, (String)sSQL, (Object[])new Object[]{bankPayStatus, id});
        });
    }

    protected String getPayStatus(DynamicObjectCollection entries) {
        boolean isPartSuccess;
        boolean hasNCRecord = false;
        boolean hasBPRecord = false;
        boolean hasOsRecord = false;
        for (DynamicObject entry : entries) {
            Object status = entry.get("status");
            if (BeBillStatusEnum.NC.getValue().equals(status)) {
                hasNCRecord = true;
                continue;
            }
            if (BeBillStatusEnum.BP.getValue().equals(status)) {
                hasBPRecord = true;
                continue;
            }
            if (!BeBillStatusEnum.OS.getValue().equals(status)) continue;
            hasOsRecord = true;
        }
        boolean isAllSuccess = entries.stream().map(o -> o.get("status")).allMatch(o -> BeBillStatusEnum.TS.getValue().equals(o));
        boolean isAllFailed = entries.stream().map(o -> o.get("status")).allMatch(o -> BeBillStatusEnum.TF.getValue().equals(o));
        boolean bl = isPartSuccess = !isAllSuccess && !isAllFailed && entries.stream().map(o -> o.get("status")).allMatch(o -> BeBillStatusEnum.TF.getValue().equals(o) || BeBillStatusEnum.TS.getValue().equals(o));
        String status = hasOsRecord ? BeBillStatusEnum.OS.getValue() : (hasBPRecord ? BeBillStatusEnum.BP.getValue() : (hasNCRecord ? BeBillStatusEnum.NC.getValue() : (isPartSuccess ? BeBillStatusEnum.PS.getValue() : (isAllFailed ? BeBillStatusEnum.TF.getValue() : (isAllSuccess ? BeBillStatusEnum.TS.getValue() : BeBillStatusEnum.OS.getValue())))));
        return status;
    }

    protected abstract List<SyncStatusInfo> handlePayDetails(List<PayDetail> var1);

    protected abstract void syncRemoteStatus(List<SyncStatusInfo> var1);

    protected void handleException(PayBody result, Exception e) {
    }

    protected void handleRollback(String errMsg, Exception e) {
    }

    public EBResult getEBResult() {
        return this.ebResult;
    }

    public void setEbResult(EBResult ebResult) {
        this.ebResult = ebResult;
    }

    protected void setUpdateStatusBillStatus(Long sourceId, boolean isSuccess, String ebStatusMsg) {
        if (isSuccess) {
            String SQL = "update t_bei_updatepaystat_entry set fopstatus = 'success' where fsourceentryid = ?";
            DB.execute((DBRoute)DBRouteConst.TMC, (String)SQL, (Object[])new Object[]{sourceId.toString()});
        } else {
            String SQL = "update t_bei_updatepaystat_entry set fopstatus = 'failed' , ferrmsg = ? where fsourceentryid = ?";
            DB.execute((DBRoute)DBRouteConst.TMC, (String)SQL, (Object[])new Object[]{ebStatusMsg, sourceId.toString()});
        }
    }
}

