/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.log.BankLogInfoFactory;
import kd.tmc.bei.business.ebservice.request.UpdateRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.banktrans.BankTransUpRequestDataSource;
import kd.tmc.bei.business.ebservice.service.update.AbstractUpdateService;
import kd.tmc.bei.common.helper.BankCateHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayBody;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class BankTransUpUpdateService
extends AbstractUpdateService {
    private DynamicObject bankTransUpBill;
    private DynamicObject entry;
    private Map<Long, String> updateStatusMap;

    public BankTransUpUpdateService(DynamicObject bankTransUpBill, DynamicObject entry, Map<Long, String> updateStatusMap) {
        super(Collections.singletonList(bankTransUpBill), false);
        this.bankTransUpBill = bankTransUpBill;
        this.entry = entry;
        this.updateStatusMap = updateStatusMap;
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new UpdateRequestBuilder(new BankTransUpRequestDataSource(this.bankTransUpBill, this.entry), this.updateStatusMap);
    }

    @Override
    protected List<SyncStatusInfo> handlePayDetails(List<PayDetail> details) {
        String ebStatusMsg;
        SyncStatusInfo syncInfo = new SyncStatusInfo();
        ArrayList<SyncStatusDetail> detailList = new ArrayList<SyncStatusDetail>(details.size());
        syncInfo.setDetailList(detailList);
        syncInfo.setEntityType("fca_transupbill");
        if (details.size() != 1 || !details.get(0).getDetailSeqID().equals(this.entry.getPkValue().toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25, \u672a\u63a5\u6536\u5230\u6709\u6548\u7684\u94f6\u4f01\u4e91\u8fd4\u56de\u4fe1\u606f\u3002", (String)"BankTransUpQueryService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        PayDetail firstDetail = details.get(0);
        SyncStatusDetail syncDetail = new SyncStatusDetail();
        detailList.add(syncDetail);
        syncDetail.setPayBillEntryId(Long.valueOf(this.entry.getLong("sourceentryid")));
        String entryStatus = BeServiceHelper.transferState((String)firstDetail.getEbStatus()).getValue();
        this.entry.set("status", (Object)entryStatus);
        StringBuilder msgSb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)firstDetail.getBankMsg())) {
            msgSb.append(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%s\u3002", (String)"BankAgentQueryService_0", (String)"tmc-bei-business", (Object[])new Object[0]), firstDetail.getBankMsg()));
        }
        if (StringUtils.isNotEmpty((String)firstDetail.getEbStatusMsg())) {
            msgSb.append(firstDetail.getEbStatusMsg());
        }
        if (StringUtils.isNotEmpty((String)(ebStatusMsg = msgSb.toString()))) {
            ebStatusMsg = ebStatusMsg.substring(0, Math.min(255, ebStatusMsg.length()));
        }
        this.entry.set("bankreturnmsg", (Object)ebStatusMsg);
        DynamicObjectCollection entrys = this.bankTransUpBill.getDynamicObjectCollection("entrys");
        String payStatus = this.getPayStatus(entrys);
        this.bankTransUpBill.set("paystate", (Object)payStatus);
        BeBillStatusEnum[] billStatusEnums = BeBillStatusEnum.values();
        HashMap<BeBillStatusEnum, Integer> entryStatusMap = new HashMap<BeBillStatusEnum, Integer>(billStatusEnums.length);
        for (BeBillStatusEnum eachStatus : billStatusEnums) {
            entryStatusMap.put(eachStatus, 0);
        }
        for (DynamicObject row : entrys) {
            if (!this.entry.getString("id").equals(row.getString("id"))) continue;
            BeBillStatusEnum rowStatus = BeBillStatusEnum.valueOf((String)row.getString("status"));
            entryStatusMap.put(rowStatus, (Integer)entryStatusMap.get(rowStatus) + 1);
        }
        syncInfo.setBatchSeqId(details.get(0).getBatchSeqID());
        syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
        syncInfo.setErrMsg(null);
        syncInfo.setBankBillId(Long.valueOf(this.bankTransUpBill.getLong("id")));
        syncInfo.setPayBillId(Long.valueOf(this.bankTransUpBill.getLong("sourcebillid")));
        syncInfo.setBankPayStatus(payStatus);
        syncDetail.setEbStatusMsg(ebStatusMsg);
        syncDetail.setBankDetailSeqId(this.entry.getString("bankcheckflag"));
        syncDetail.setBankEntryPayStatus(entryStatus);
        boolean isSuccess = BankReturnStatusEnum.BANK_SUCCESS.getValue().equals(firstDetail.getUpdateStatus());
        this.entry.set("isupdatestate", (Object)isSuccess);
        this.setUpdateStatusBillStatus((Long)this.entry.getPkValue(), isSuccess, ebStatusMsg);
        this.bankTransUpBill.set("isupdatingstatus", (Object)0);
        return Collections.singletonList(syncInfo);
    }

    public String getEntityName() {
        return "bei_banktransupbill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoFactory.generateBankLogInfo(Collections.singletonList(this.bankTransUpBill));
    }

    @Override
    protected void syncRemoteStatus(List<SyncStatusInfo> syncInfoList) {
        for (SyncStatusInfo syncInfo : syncInfoList) {
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fca", (String)"PayRpcApiService", (String)"syncBankBillStatus", (Object[])new Object[]{"fca_transupbill", SerializationUtils.toJsonString((Object)syncInfo)});
        }
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.entry.getDynamicObject("subacct"));
    }

    @Override
    protected void handleRollback(String errMsg, Exception e) {
        DynamicObjectCollection entrys = this.bankTransUpBill.getDynamicObjectCollection("entrys");
        for (DynamicObject entryObj : entrys) {
            if (!this.entry.getPkValue().equals(entryObj.getPkValue())) continue;
            this.entry.set("bankreturnmsg", (Object)e.getMessage());
        }
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bankTransUpBill});
    }

    @Override
    protected void handleException(PayBody result, Exception e) {
        Object code;
        DynamicObjectCollection entrys = this.bankTransUpBill.getDynamicObjectCollection("entrys");
        boolean isUnknownBatch = false;
        if (e instanceof EBBizNCException && "tmc.bei.UNKNOWN_BATCH".equals(code = ((EBBizNCException)e).getErrorCode().getCode())) {
            isUnknownBatch = true;
        }
        for (DynamicObject entryObj : entrys) {
            if (!this.entry.getPkValue().equals(entryObj.getPkValue())) continue;
            if (isUnknownBatch) {
                this.entry.set("status", (Object)BeBillStatusEnum.NC.getValue());
            }
            this.entry.set("bankreturnmsg", (Object)e.getMessage());
        }
        String payStatus = this.getPayStatus(entrys);
        this.bankTransUpBill.set("paystate", (Object)payStatus);
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bankTransUpBill});
    }
}

