/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.compare.SmartRecCompareStrategy;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.BuildFilterInfo;
import kd.tmc.bei.business.helper.CompanyMatchData;
import kd.tmc.bei.business.helper.TransDetailHelper;
import kd.tmc.bei.common.helper.AmountHelper;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fbp.common.compare.CompareEngine;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.data.CompareRuleGroup;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.compare.strategy.ICompareStrategy;
import kd.tmc.fbp.common.dao.CalMatchData;
import kd.tmc.fbp.common.dao.SmartMatch;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import kd.tmc.fbp.common.enums.MatchPlanEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AutoMatchCalMultiHelper {
    private static final Log logger = LogFactory.getLog(AutoMatchCalMultiHelper.class);
    private static final String[] staticMatchField = new String[]{"id", "bizcondition", "range_bizcondition_real", "range_bizcondition_real_TAG", "bizdateprop", "entrybizdateprop", "enabledate", "entryentity.id", "entryentity.seq", "entryentity.e_rulesname", "entryentity.e_matchplan_real_TAG", "entryentity.detailcondition_real_TAG", "org_entry.u_org", "entryentity.bizcondition_real_TAG", "entryentity.e_multiplematch", "entryentity.e_isenable", "entryentity.e_matchbyentry", "entryentity.e_matchrel"};

    public static List<Pair<Object, List<CompareResult>>> autoMatchCal(Set<Object> companyPKs, Map<Object, List<Object>> tdIdMap, MatchBizTypeEnum biztype, String direction) {
        List<CompanyMatchData> companyMatchDataList = AutoMatchCalMultiHelper.getMatchDataList(companyPKs, tdIdMap, biztype, direction);
        logger.info("wtpc-companyMatchDataList-size:{}", (Object)companyMatchDataList.size());
        ArrayList<Pair<Object, List<CompareResult>>> resultList = new ArrayList<Pair<Object, List<CompareResult>>>(companyMatchDataList.size());
        logger.info("wtpc-dataList-size:{}", (Object)companyMatchDataList.size());
        Set<String> detailDateFields = AutoMatchCalMultiHelper.getFieldsByType("bei_transdetail_cas", "date");
        for (CompanyMatchData matchData : companyMatchDataList) {
            List<DynamicObject> bizBillDCs = matchData.getBizBillDCs();
            logger.info("wtpc-\u53c2\u4e0e\u5339\u914d\u4e1a\u52a1\u5355\u636eid:{}", (Object)bizBillDCs.size());
            Pair<Object, List<CompareResult>> result = AutoMatchCalMultiHelper.calForThread(matchData, detailDateFields);
            if (result == null) continue;
            resultList.add(result);
        }
        return resultList;
    }

    public static List<Pair<Object, List<CompareResult>>> autoMatchCal(Set<Object> companyPKs, Map<Object, List<Object>> tdIdMap, MatchBizTypeEnum biztype) {
        return AutoMatchCalMultiHelper.autoMatchCal(companyPKs, tdIdMap, biztype, null);
    }

    private static List<CompanyMatchData> getMatchDataList(Set<Object> companyIds, Map<Object, List<Object>> tdIdMap, MatchBizTypeEnum bizType, String direction) {
        String bizName = AutoMatchCalMultiHelper.getBizName(bizType);
        DynamicObjectCollection smartMatchDOCs = AutoMatchCalMultiHelper.getSmartMatchDOC(bizType, direction);
        Date enableDate = null;
        Set<Object> detailFields = Sets.newHashSetWithExpectedSize((int)10);
        Set<Object> bizFields = Sets.newHashSetWithExpectedSize((int)10);
        ArrayList<CompanyMatchData> companyMatchDataList = new ArrayList<CompanyMatchData>(10);
        Map<Long, List<DynamicObject>> smartMatchDOCMap = smartMatchDOCs.stream().collect(Collectors.groupingBy(smartMatchDOC -> smartMatchDOC.getLong("org_entry.u_org")));
        boolean matchByEntryHasAny = false;
        HashSet detailIds = new HashSet();
        HashSet<Long> bizBillIds = new HashSet<Long>();
        int index = 0;
        for (Object companyId : companyIds) {
            CompanyMatchData matchData = new CompanyMatchData();
            DynamicObjectCollection finalSmartMatchDOCs = new DynamicObjectCollection();
            if (smartMatchDOCMap.containsKey(companyId)) {
                finalSmartMatchDOCs.addAll((Collection)smartMatchDOCMap.get(companyId));
            } else if (smartMatchDOCMap.containsKey(0L)) {
                finalSmartMatchDOCs.addAll((Collection)smartMatchDOCMap.get(0L));
            }
            AutoMatchCalMultiHelper.addMatchPlanDefCondition(finalSmartMatchDOCs, bizType, direction);
            matchData.setBizName(bizName);
            matchData.setCompanyId(companyId);
            matchData.setSmartmatchDCs(finalSmartMatchDOCs);
            companyMatchDataList.add(matchData);
            boolean detailNotExistExpression = Boolean.TRUE;
            boolean bizNotExistExpression = Boolean.TRUE;
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas");
            MainEntityType dataType_biz = EntityMetadataCache.getDataEntityType((String)bizName);
            for (DynamicObject smartmatchDC : finalSmartMatchDOCs) {
                Date enableDateDc = smartmatchDC.getDate("enabledate");
                if (index == 0 || enableDate != null && enableDateDc != null && enableDate.after(enableDateDc)) {
                    enableDate = enableDateDc;
                }
                ++index;
                String rangeBizCondition = smartmatchDC.getString("range_bizcondition_real_TAG");
                String bizDateProp = smartmatchDC.getString("bizdateprop");
                String entryBizDateProp = smartmatchDC.getString("entrybizdateprop");
                String matchplan = smartmatchDC.getString("entryentity.e_matchplan_real_TAG");
                String detailCondition = smartmatchDC.getString("entryentity.detailcondition_real_TAG");
                String bizCondition = smartmatchDC.getString("entryentity.bizcondition_real_TAG");
                boolean matchByEntry = smartmatchDC.getBoolean("entryentity.e_matchbyentry");
                matchByEntryHasAny = matchByEntryHasAny || matchByEntry;
                AutoMatchCalMultiHelper.buildNeedFields((Set<String>)bizFields, rangeBizCondition);
                bizFields.add(bizDateProp);
                if (EmptyUtil.isNoEmpty((String)entryBizDateProp)) {
                    bizFields.add(entryBizDateProp);
                }
                HashSet<QFilter> commBizQFs = new HashSet<QFilter>(10);
                BuildFilterInfo rangeBizResult = AutoMatchCalMultiHelper.buildQFilters(rangeBizCondition, dataType_biz);
                Set<QFilter> rangeBizQF = rangeBizResult.getFilterList();
                if (rangeBizQF.size() > 0) {
                    commBizQFs.addAll(rangeBizQF);
                }
                HashSet<QFilter> companyDetailQFs = new HashSet<QFilter>(10);
                HashSet<QFilter> companyBizQFs = new HashSet<QFilter>(10);
                if (!EmptyUtil.isEmpty((String)matchplan)) {
                    Object result;
                    JSONArray matchplanArr = (JSONArray)JSONObject.parse((String)matchplan);
                    List smartMatches = matchplanArr.toJavaList(SmartMatch.class);
                    detailFields = AutoMatchCalMultiHelper.buildNeedFields((Set<String>)detailFields, detailCondition);
                    bizFields = AutoMatchCalMultiHelper.buildNeedFields((Set<String>)bizFields, bizCondition);
                    if (detailNotExistExpression) {
                        result = AutoMatchCalMultiHelper.buildQFilters(detailCondition, dataType);
                        detailNotExistExpression = ((BuildFilterInfo)result).getNotExistExpression();
                        if (detailNotExistExpression) {
                            Set<QFilter> detailQF = ((BuildFilterInfo)result).getFilterList();
                            if (detailQF.size() > 0) {
                                companyDetailQFs.addAll(detailQF);
                            }
                        } else {
                            companyDetailQFs.clear();
                        }
                    }
                    if (bizNotExistExpression) {
                        result = AutoMatchCalMultiHelper.buildQFilters(bizCondition, dataType_biz);
                        bizNotExistExpression = ((BuildFilterInfo)result).getNotExistExpression();
                        if (bizNotExistExpression) {
                            Set<QFilter> bizQF = ((BuildFilterInfo)result).getFilterList();
                            if (bizQF.size() > 0) {
                                companyBizQFs.addAll(bizQF);
                            }
                        } else {
                            companyBizQFs.clear();
                        }
                    }
                    for (SmartMatch sm : smartMatches) {
                        detailFields.add(sm.getTransdetailfields());
                        bizFields.add(sm.getBizfields());
                    }
                }
                QFilter qFilter = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue());
                QFilter detailQFilter = AutoMatchCalMultiHelper.getFilterFromList(companyDetailQFs);
                qFilter.and(detailQFilter);
                if (enableDate != null) {
                    qFilter.and(new QFilter("bizdate", ">=", (Object)enableDate));
                }
                DynamicObjectCollection transDetailColl = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,accountbank,oppbanknumber,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", tdIdMap.get(companyId)), qFilter});
                Set matchEntryDetails = transDetailColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                detailIds.addAll(matchEntryDetails);
                Set<Object> accountIdSet = transDetailColl.stream().filter(o -> o.get("accountbank") != null).map(o -> o.get("accountbank")).collect(Collectors.toSet());
                Set<String> oppBankNumberSet = transDetailColl.stream().filter(o -> o.getString("oppbanknumber") != null).map(o -> o.getString("oppbanknumber")).collect(Collectors.toSet());
                Set<Object> currencySet = transDetailColl.stream().filter(o -> o.get("currency") != null).map(o -> o.get("currency")).collect(Collectors.toSet());
                Set<Long> matchEntryBizBillIds = AutoMatchCalMultiHelper.getTargetBizBillIds(enableDate, bizType, companyBizQFs, commBizQFs, accountIdSet, oppBankNumberSet, currencySet, direction);
                bizBillIds.addAll(matchEntryBizBillIds);
            }
            detailFields.add("id");
            detailFields.add("company");
            detailFields.add("bizdate");
            detailFields.add("createtime");
            detailFields.add("accountbank");
            detailFields.add("oppunit");
            detailFields.add("oppbanknumber");
            detailFields.add("currency");
            bizFields.add("id");
            bizFields.add("createtime");
            if (MatchBizTypeEnum.AGENTPAY == bizType && matchByEntryHasAny) {
                bizFields.add("entry.id");
                if (bizFields.contains("entry.e_encryptamount") || bizFields.contains("entry.e_amount")) {
                    bizFields.add("entry.e_encryptamount");
                    bizFields.add("entry.e_amount");
                }
                bizFields.add("entry.e_bankcheckflag");
            }
            if (MatchBizTypeEnum.TRANSUP == bizType || MatchBizTypeEnum.TRANSDOWN == bizType) {
                bizFields.add("entrys.id");
                bizFields.add("entrys.subacct_company");
                bizFields.add("company");
                bizFields.add("transbilldate");
                bizFields.add("entrys.bankcheckflag");
                bizFields.add("ismatchbyhead");
            } else {
                bizFields.add("bizdate");
                if (MatchBizTypeEnum.TRANSHANDLE == bizType) {
                    bizFields.add("scorg");
                    bizFields.add("beibankcheckflag");
                } else {
                    bizFields.add("org");
                    if (bizType != MatchBizTypeEnum.EXCHANGE) {
                        bizFields.add(bizType.getBankCheckFlagProp());
                    } else {
                        bizFields.add("rec".equals(direction) ? "buybankcheckflag" : "sellingbankcheckflag");
                    }
                }
            }
            if (Objects.isNull(matchData.getDetailFields())) {
                matchData.setDetailFields((Set<String>)detailFields);
            }
            if (!Objects.isNull(matchData.getBizFields())) continue;
            matchData.setBizFields((Set<String>)bizFields);
        }
        Object transDetails = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)String.join((CharSequence)",", (Iterable<? extends CharSequence>)detailFields), (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
        transDetails = AutoMatchCalMultiHelper.filterSynonymData((List<DynamicObject>)transDetails, bizType, direction);
        Map<String, DynamicProperty> transFilterProperties = null;
        if (!transDetails.isEmpty()) {
            transFilterProperties = AutoMatchCalMultiHelper.getFilterProperties((DynamicObject)transDetails.get(0), "bei_transdetail_cas");
        }
        Map<Object, List<DynamicObject>> tdMap = transDetails.stream().collect(Collectors.groupingBy(v -> v.get("company")));
        HashMap<Object, List<Object>> tUseCompanys = new HashMap<Object, List<Object>>(companyMatchDataList.size());
        for (CompanyMatchData matchData : companyMatchDataList) {
            if (tdMap.containsKey(matchData.getCompanyId()) && tdMap.get(matchData.getCompanyId()) != null) {
                matchData.setTransdetails(tdMap.get(matchData.getCompanyId()));
            } else {
                matchData.setTransdetails(new ArrayList<DynamicObject>(0));
            }
            matchData.setTransFilterProperties(transFilterProperties);
            Set<Object> accountIdSet = matchData.getTransdetails().stream().filter(o -> o.get("accountbank") != null).map(o -> o.get("accountbank")).collect(Collectors.toSet());
            List<Object> tUseCompanyIds = AutoMatchCalMultiHelper.getUseCompanyIds(accountIdSet);
            tUseCompanyIds.remove(matchData.getCompanyId());
            tUseCompanys.put(matchData.getCompanyId(), tUseCompanyIds);
        }
        HashSet finalBizFields = bizFields;
        DynamicObjectCollection bizBillDCs = AutoMatchCalMultiHelper.getTargetBizBills(bizType, finalBizFields, matchByEntryHasAny, bizBillIds);
        Map<Object, List<DynamicObject>> bizMap = MatchBizTypeEnum.TRANSUP == bizType || MatchBizTypeEnum.TRANSDOWN == bizType ? bizBillDCs.stream().collect(Collectors.groupingBy(v -> v.get("company"))) : (MatchBizTypeEnum.TRANSHANDLE == bizType ? bizBillDCs.stream().collect(Collectors.groupingBy(v -> v.get("scorg"))) : bizBillDCs.stream().collect(Collectors.groupingBy(v -> v.get("org"))));
        logger.info("wtpc-\u6240\u6709\u4e1a\u52a1\u5355\u636e\u7684\u7ec4\u7ec7{}", (Object)JSON.toJSONString(bizMap.keySet()));
        Map<String, DynamicProperty> bizFilterProperties = null;
        if (!bizBillDCs.isEmpty()) {
            bizFilterProperties = AutoMatchCalMultiHelper.getFilterProperties((DynamicObject)bizBillDCs.get(0), bizName);
        }
        ArrayList<DynamicObject> tBizBillDCs = null;
        for (CompanyMatchData matchData : companyMatchDataList) {
            tBizBillDCs = new ArrayList<DynamicObject>(0);
            if (bizMap.containsKey(matchData.getCompanyId())) {
                tBizBillDCs.addAll((Collection)bizMap.get(matchData.getCompanyId()));
            }
            for (Object tUseCompany : (List)tUseCompanys.get(matchData.getCompanyId())) {
                if (!bizMap.containsKey(tUseCompany)) continue;
                tBizBillDCs.addAll((Collection<DynamicObject>)bizMap.get(tUseCompany));
            }
            matchData.setBizBillDCs(tBizBillDCs);
            matchData.setBizFilterProperties(bizFilterProperties);
        }
        logger.info("wtpc-\u53c2\u4e0e\u5339\u914d\u4e1a\u52a1\u5355\u636e\u5171{}\uff0c\u4ea4\u6613\u660e\u7ec6\u5171{}", (Object)bizBillDCs.size(), (Object)transDetails.size());
        return companyMatchDataList;
    }

    private static void addMatchPlanDefCondition(DynamicObjectCollection smartMatchDOCs, MatchBizTypeEnum bizType, String direction) {
        if (StringUtils.isBlank((CharSequence)direction)) {
            return;
        }
        for (DynamicObject matchRule : smartMatchDOCs) {
            String matchPlanStr = (String)matchRule.get("entryentity.e_matchplan_real_TAG");
            JSONArray matchPlanArr = (JSONArray)JSONObject.parse((String)matchPlanStr);
            Set transDetailFields = matchPlanArr.stream().map(j -> ((JSONObject)j).getString("transdetailfields")).collect(Collectors.toSet());
            boolean containsAcctNumber = transDetailFields.contains("accountbank.bankaccountnumber");
            boolean containsCurrency = transDetailFields.contains("currency.number");
            if (containsAcctNumber && containsCurrency) {
                return;
            }
            String acctBankField = "";
            String currencyField = "currency.number";
            if ("rec".equals(direction)) {
                if (MatchBizTypeEnum.REC == bizType || MatchBizTypeEnum.TRANSUP == bizType) {
                    acctBankField = "accountbank.bankaccountnumber";
                } else if (MatchBizTypeEnum.EXCHANGE == bizType) {
                    acctBankField = "buyingaccount.bankaccountnumber";
                    currencyField = "buyingcurrency.number";
                } else if (MatchBizTypeEnum.PAY == bizType) {
                    continue;
                }
            } else if (MatchBizTypeEnum.PAY == bizType || MatchBizTypeEnum.AGENTPAY == bizType) {
                acctBankField = "payeracctbank.bankaccountnumber";
                currencyField = "dpcurrency.number";
            } else if (MatchBizTypeEnum.TRANSDOWN == bizType) {
                acctBankField = "accountbank.bankaccountnumber";
            } else if (MatchBizTypeEnum.TRANSHANDLE == bizType) {
                acctBankField = "agentpayeraccount.bankaccountnumber";
            } else if (MatchBizTypeEnum.EXCHANGE == bizType) {
                acctBankField = "sellingaccount.bankaccountnumber";
                currencyField = "sellingcurrency.number";
            } else if (MatchBizTypeEnum.REC == bizType) continue;
            if (!containsAcctNumber) {
                SmartMatch acctBank = AutoMatchCalMultiHelper.getSmartMatch("accountbank.bankaccountnumber", "equals", acctBankField);
                JSONObject acctBankJsonObj = (JSONObject)JSONObject.toJSON((Object)acctBank);
                matchPlanArr.add((Object)acctBankJsonObj);
            }
            if (!containsCurrency) {
                SmartMatch currency = AutoMatchCalMultiHelper.getSmartMatch("currency.number", "equals", currencyField);
                JSONObject currencyJsonObj = (JSONObject)JSONObject.toJSON((Object)currency);
                matchPlanArr.add((Object)currencyJsonObj);
            }
            matchRule.set("entryentity.e_matchplan_real_TAG", (Object)JSON.toJSONString((Object)matchPlanArr));
        }
    }

    private static SmartMatch getSmartMatch(String transDetailField, String relation, String bizField) {
        SmartMatch smartMatch = new SmartMatch();
        smartMatch.setTransdetailfields(transDetailField);
        smartMatch.setRelation(relation);
        smartMatch.setBizfields(bizField);
        smartMatch.setIsnullmatch("false");
        smartMatch.setIsallnullmatch("false");
        smartMatch.setNum(null);
        return smartMatch;
    }

    private static List<DynamicObject> filterSynonymData(List<DynamicObject> transDetails, MatchBizTypeEnum bizType, String direction) {
        if ("rec".equals(direction) && bizType == MatchBizTypeEnum.PAY || "pay".equals(direction) && bizType == MatchBizTypeEnum.REC) {
            return transDetails.stream().filter(o -> TransDetailHelper.updateSynonym(o, o.getLong("accountbank"), o.getLong("company"))).collect(Collectors.toList());
        }
        return transDetails;
    }

    private static QFilter getFilterFromList(Set<QFilter> qFs) {
        QFilter qFilter = null;
        if (qFs != null && qFs.size() > 0) {
            for (QFilter qf : qFs) {
                if (qFilter == null) {
                    qFilter = qf;
                    continue;
                }
                qFilter.or(qf);
            }
        }
        return qFilter;
    }

    private static String getBizName(MatchBizTypeEnum bizType) {
        String bizName = "";
        if (MatchBizTypeEnum.PAY == bizType) {
            bizName = "cas_paybill";
        } else if (MatchBizTypeEnum.REC == bizType) {
            bizName = "cas_recbill";
        } else if (MatchBizTypeEnum.AGENTPAY == bizType) {
            bizName = "cas_agentpaybill";
        } else if (MatchBizTypeEnum.TRANSUP == bizType) {
            bizName = "fca_transupbill";
        } else if (MatchBizTypeEnum.TRANSDOWN == bizType) {
            bizName = "fca_transdownbill";
        } else if (MatchBizTypeEnum.TRANSHANDLE == bizType) {
            bizName = "ifm_transhandlebill";
        } else if (MatchBizTypeEnum.EXCHANGE == bizType) {
            bizName = "cas_exchangebill";
        }
        return bizName;
    }

    private static List<Object> getUseCompanyIds(Set<Object> accountIdSet) {
        if (accountIdSet == null || accountIdSet.size() < 1) {
            return new ArrayList<Object>(0);
        }
        String sql = "select distinct a.fuseorgid from t_bd_accountbanks_U a where a.fdataid in (%s)";
        List idList = accountIdSet.stream().distinct().map(o -> o.toString()).collect(Collectors.toList());
        List integers = null;
        HashSet useorgIdsList = new HashSet(10);
        int tMaxSize = 900;
        while (idList.iterator().hasNext()) {
            integers = idList.size() > 900 ? idList.subList(0, 900) : idList;
            DB.query((DBRoute)DBRoute.basedata, (String)String.format("select distinct a.fuseorgid from t_bd_accountbanks_U a where a.fdataid in (%s)", String.join((CharSequence)",", integers)), rs -> {
                while (rs.next()) {
                    useorgIdsList.add(rs.getLong("fuseorgid"));
                }
                return null;
            });
            integers.clear();
        }
        return new ArrayList<Object>(useorgIdsList);
    }

    private static Pair<Object, List<CompareResult>> calForThread(CompanyMatchData matchData, Set<String> detailDateFields) {
        logger.info("------\u5f02\u6b65\u8c03\u7528\u8ba1\u7b97\u5f00\u59cb,: " + Thread.currentThread().getName() + ": " + Thread.currentThread().getId());
        CalMatchData md = AutoMatchCalMultiHelper.transCalMatchDate(matchData, detailDateFields);
        if (md == null) {
            return null;
        }
        List tarDataList = md.getTarDataList();
        List tarIdList = tarDataList.stream().map(i -> i.get("id")).collect(Collectors.toList());
        logger.info("wtpc-\u6700\u7ec8\u4f20\u8f93\u5230\u5339\u914d\u5f15\u64ce\u7684\u4e1a\u52a1\u5355\u636e id:" + JSON.toJSONString(tarIdList));
        CompareEngine engine = new CompareEngine(md.getSrcDataList(), md.getTarDataList());
        logger.info("\u81ea\u52a8\u5339\u914d==========\u6e90\u6570\u636e\u6570\u91cf:" + md.getSrcDataList().size() + "; \u76ee\u6807\u6570\u636e\u6570\u91cf:" + md.getTarDataList().size());
        SmartRecCompareStrategy strategy = new SmartRecCompareStrategy(md.getCompareRuleGroupList());
        List resultList = engine.compare((ICompareStrategy)strategy);
        logger.info("------\u5f02\u6b65\u8c03\u7528\u8ba1\u7b97\u5b8c\u6210,: " + Thread.currentThread().getName() + ": " + Thread.currentThread().getId() + "------");
        return Pair.of((Object)md.getRuleId(), (Object)resultList);
    }

    /*
     * WARNING - void declaration
     */
    private static CalMatchData transCalMatchDate(CompanyMatchData matchData, Set<String> detailDateFields) {
        String bizName = matchData.getBizName();
        List<DynamicObject> transDetails = matchData.getTransdetails();
        if (CollectionUtils.isEmpty(transDetails)) {
            return null;
        }
        Set<String> detailFields = matchData.getDetailFields();
        Set<String> bizFields = matchData.getBizFields();
        Set<String> bizDateFields = AutoMatchCalMultiHelper.getFieldsByType(bizName, "date");
        ArrayList<CompareRuleGroup> compareRuleGroupList = new ArrayList<CompareRuleGroup>(10);
        DynamicObjectCollection smartmatchDCs = matchData.getSmartmatchDCs();
        if (smartmatchDCs == null || smartmatchDCs.isEmpty()) {
            return null;
        }
        ArrayList srcDataList = new ArrayList(transDetails.size());
        for (DynamicObject orgTransdetail : transDetails) {
            HashMap<String, Object> srcDataMap = new HashMap<String, Object>();
            for (String detailField : detailFields) {
                if (detailDateFields.contains(detailField)) {
                    void var16_16;
                    Date date = orgTransdetail.getDate(detailField);
                    String string = "";
                    if (!EmptyUtil.isEmpty((Object)date)) {
                        String string2 = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
                    }
                    if ("bizdate".equals(detailField)) {
                        if (!EmptyUtil.isEmpty((Object)date)) {
                            date = DateUtils.getDataFormat((Date)date, (boolean)true);
                        }
                        srcDataMap.put("__bizdate", date);
                    } else if ("createtime".equals(detailField)) {
                        srcDataMap.put("__createtime", date);
                    }
                    srcDataMap.put(detailField, var16_16);
                    continue;
                }
                Iterator<String> detail = orgTransdetail.get(detailField);
                if (detail instanceof BigDecimal) {
                    detail = new BigDecimal(((BigDecimal)((Object)detail)).stripTrailingZeros().toPlainString());
                }
                srcDataMap.put(detailField, detail);
            }
            srcDataList.add(srcDataMap);
        }
        logger.info("=========\u7b26\u5408\u81ea\u52a8\u5339\u914d\u89c4\u5219\u6761\u6570smartmatchDCs:" + smartmatchDCs.size());
        List<DynamicObject> bizBillDCs = matchData.getBizBillDCs();
        if (bizBillDCs == null || bizBillDCs.isEmpty()) {
            return null;
        }
        logger.info("wtpc-transCalMatchDate:" + bizBillDCs.size());
        ArrayList<Object> tarDataList = new ArrayList<Object>(bizBillDCs.size());
        for (DynamicObject bizBillDy : bizBillDCs) {
            HashMap recBillMap = Maps.newHashMapWithExpectedSize((int)bizFields.size());
            for (String string : bizFields) {
                if (bizDateFields.contains(string)) {
                    Date date = bizBillDy.getDate(string);
                    String dateStr = "";
                    if (!EmptyUtil.isEmpty((Object)date)) {
                        dateStr = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
                    }
                    if ("bizdate".equals(string) || "transbilldate".equals(string)) {
                        if (!EmptyUtil.isEmpty((Object)date)) {
                            date = DateUtils.getDataFormat((Date)date, (boolean)true);
                        }
                        recBillMap.put("__bizdate", date);
                    } else if ("createtime".equals(string)) {
                        recBillMap.put("__createtime", date);
                    }
                    recBillMap.put(string, dateStr);
                    continue;
                }
                Object biz = bizBillDy.get(string);
                if (biz instanceof BigDecimal) {
                    biz = new BigDecimal(((BigDecimal)biz).stripTrailingZeros().toPlainString());
                }
                recBillMap.put(string, biz);
            }
            Object id = recBillMap.get("id");
            for (String entryKey : Arrays.asList("entry.id", "entrys.id")) {
                if (!recBillMap.containsKey(entryKey)) continue;
                tarDataList.add(new HashMap(recBillMap));
                recBillMap.put("id", recBillMap.get(entryKey));
                recBillMap.put("entry.id", id);
            }
            tarDataList.add(recBillMap);
        }
        Set<String> detailAmountFields = AutoMatchCalMultiHelper.getFieldsByType("bei_transdetail_cas", "amount");
        Set<String> bizAmountFields = AutoMatchCalMultiHelper.getFieldsByType(bizName, "amount");
        for (DynamicObject smartmatchDC : smartmatchDCs) {
            String string = smartmatchDC.getString("entryentity.e_matchplan_real_TAG");
            Long entryRuleId = smartmatchDC.getLong("entryentity.id");
            String detailCondition = smartmatchDC.getString("entryentity.detailcondition_real_TAG");
            String bizCondition = smartmatchDC.getString("entryentity.bizcondition_real_TAG");
            Boolean isMultMatch = smartmatchDC.getBoolean("entryentity.e_multiplematch");
            boolean matchByEntry = smartmatchDC.getBoolean("entryentity.e_matchbyentry");
            String matchRel = smartmatchDC.getString("entryentity.e_matchrel");
            JSONArray matchplanArr = (JSONArray)JSONObject.parse((String)string);
            List smartMatches = matchplanArr.toJavaList(SmartMatch.class);
            ArrayList<CompareRule> rules = new ArrayList<CompareRule>(smartMatches.size());
            HashSet<Object> srcIdSet = new HashSet<Object>(10);
            Map<String, DynamicProperty> transFilterProperties = matchData.getTransFilterProperties();
            if (transFilterProperties != null) {
                AutoMatchCalMultiHelper.matchRule(transFilterProperties, "bei_transdetail_cas", matchData.getTransdetails(), detailCondition, srcIdSet, false);
            }
            HashSet<Object> tarIdSet = new HashSet<Object>(10);
            Map<String, DynamicProperty> bizFilterProperties = matchData.getBizFilterProperties();
            if (bizFilterProperties != null) {
                AutoMatchCalMultiHelper.matchRule(bizFilterProperties, bizName, bizBillDCs, bizCondition, tarIdSet, matchByEntry);
            }
            for (SmartMatch sm : smartMatches) {
                rules.add(AutoMatchCalMultiHelper.transRule(sm, detailAmountFields, bizAmountFields));
            }
            CompareRuleGroup compareRuleGroup = new CompareRuleGroup();
            compareRuleGroup.setCompareRuleList(rules);
            compareRuleGroup.setEnableMultiRes(isMultMatch.booleanValue());
            compareRuleGroup.setMatchRel(matchRel);
            compareRuleGroup.setSrcIdSet(srcIdSet);
            compareRuleGroup.setTarIdSet(tarIdSet);
            compareRuleGroup.setRuleId((Object)entryRuleId);
            compareRuleGroupList.add(compareRuleGroup);
        }
        CalMatchData md = new CalMatchData();
        md.setRuleId((Object)((DynamicObject)smartmatchDCs.get(0)).getLong("id"));
        md.setCompareRuleGroupList(compareRuleGroupList);
        md.setSrcDataList(srcDataList);
        md.setTarDataList(tarDataList);
        return md;
    }

    private static Set<Long> getTargetBizBillIds(Date enableDate, MatchBizTypeEnum biztype, Set<QFilter> bizQFs, Set<QFilter> commBizQFs, Set<Object> accountIdSet, Set<String> oppBankBumberSet, Set<Object> currencyIdSet, String direction) {
        String bizEntityName = AutoMatchCalMultiHelper.getBizName(biztype);
        QFilter bziFileter = AutoMatchCalMultiHelper.getFilterFromList(bizQFs);
        QFilter comm_qfilter = AutoMatchCalMultiHelper.getFilterFromList(commBizQFs);
        QFilter billFilter = AutoMatchHelper.getBillFilter(biztype, true, accountIdSet, oppBankBumberSet, currencyIdSet, enableDate, direction);
        DynamicObjectCollection billCol = QueryServiceHelper.query((String)bizEntityName, (String)"id", (QFilter[])new QFilter[]{billFilter, bziFileter, comm_qfilter});
        return billCol.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    private static DynamicObjectCollection getTargetBizBills(MatchBizTypeEnum biztype, Set<String> finalBizFields, boolean matchByEntry, Set<Long> bizBillIds) {
        String bizEntityName = AutoMatchCalMultiHelper.getBizName(biztype);
        long time = System.currentTimeMillis();
        DynamicObjectCollection billCol = QueryServiceHelper.query((String)bizEntityName, (String)String.join((CharSequence)",", finalBizFields), (QFilter[])new QFilter[]{new QFilter("id", "in", bizBillIds)});
        logger.info("\u6839\u636e\u57fa\u7840\u8fc7\u6ee4\u6761\u4ef6\u83b7\u53d6\u5230\u7684\u4e1a\u52a1\u5355\u636e\u6570\u91cf\uff1a{}", (Object)billCol.size());
        long costMs = System.currentTimeMillis() - time;
        logger.info("getBizListCostMS: {}", (Object)costMs);
        String tEncryptAmountKey = "entry.e_encryptamount";
        if (MatchBizTypeEnum.AGENTPAY == biztype && matchByEntry && finalBizFields.contains("entry.e_encryptamount")) {
            billCol.stream().filter(bill -> EmptyUtil.isNoEmpty((String)bill.getString("entry.e_encryptamount"))).forEach(bill -> bill.set("entry.e_amount", (Object)AmountHelper.decodeAmount((String)bill.getString("entry.e_encryptamount"))));
        }
        return billCol;
    }

    private static void matchRule(Map<String, DynamicProperty> filterProperties, String entityName, List<DynamicObject> dataCols, String conditionStr, Set<Object> idSet, boolean matchByEntry) {
        if (EmptyUtil.isNoEmpty((String)conditionStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
            for (DynamicObject dataCol : dataCols) {
                if (!((Boolean)basebillFilterHandle.GetVchFldValue(filterProperties, dataCol, null)).booleanValue()) continue;
                if (matchByEntry && "cas_agentpaybill".equals(entityName)) {
                    idSet.add(dataCol.get("entry.id"));
                    continue;
                }
                if (matchByEntry && ("fca_transupbill".equals(entityName) || "fca_transdownbill".equals(entityName))) {
                    idSet.add(dataCol.get("entrys.id"));
                    continue;
                }
                idSet.add(dataCol.get("id"));
            }
        } else {
            for (DynamicObject dataCol : dataCols) {
                if (matchByEntry && "cas_agentpaybill".equals(entityName)) {
                    idSet.add(dataCol.get("entry.id"));
                    continue;
                }
                if (matchByEntry && ("fca_transupbill".equals(entityName) || "fca_transdownbill".equals(entityName))) {
                    idSet.add(dataCol.get("entrys.id"));
                    continue;
                }
                idSet.add(dataCol.get("id"));
            }
        }
    }

    private static Map<String, DynamicProperty> getFilterProperties(DynamicObject info, String entityName) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(16);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        DynamicObjectType dType = info.getDynamicObjectType();
        for (String prop : selProps) {
            if (dType.getProperty(prop) == null) continue;
            fldProperties.put(prop, dType.getProperty(prop));
        }
        return fldProperties;
    }

    private static Set<String> buildNeedFields(Set<String> needDateFields, String conditionStr) {
        if (!EmptyUtil.isEmpty((String)conditionStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionStr, CRCondition.class);
            List filterRow = filterObj.getFilterCondition().getFilterRow();
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                String fieldName = simpleFilterRow.getFieldName();
                needDateFields.add(fieldName);
            }
        }
        return needDateFields;
    }

    private static BuildFilterInfo buildQFilters(String conditionStr, MainEntityType dataType) {
        BuildFilterInfo result = new BuildFilterInfo();
        HashSet<QFilter> filterList = new HashSet<QFilter>();
        if (!EmptyUtil.isEmpty((String)conditionStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionStr, CRCondition.class);
            if (filterObj.getExpression().isEmpty()) {
                FilterBuilder fb = new FilterBuilder(dataType, filterObj.getFilterCondition(), true);
                fb.buildFilter(true);
                QFilter archiveFilter = fb.getQFilter();
                filterList.add(archiveFilter);
                result.setFilterList(filterList);
                result.setNotExistExpression(Boolean.TRUE);
            } else {
                filterList.clear();
                result.setFilterList(filterList);
                result.setNotExistExpression(Boolean.FALSE);
            }
        } else {
            filterList.clear();
            result.setFilterList(filterList);
            result.setNotExistExpression(Boolean.FALSE);
        }
        return result;
    }

    public static DynamicObjectCollection getSmartMatchDOC(MatchBizTypeEnum biztype, String direction) {
        QFilter rulCommonFilter = AutoMatchCalMultiHelper.getRulCommonFilter(biztype.getValue(), direction);
        return QueryServiceHelper.query((String)"cas_smartmatch", (String)String.join((CharSequence)",", staticMatchField), (QFilter[])new QFilter[]{rulCommonFilter}, (String)"entryentity.seq asc");
    }

    public static boolean isExistSmartRule(Set<Object> companyPKs, MatchBizTypeEnum biztype, String direction) {
        QFilter commonFilter = new QFilter("biztype", "=", (Object)biztype.getValue()).and(new QFilter("enable", "=", (Object)"1"));
        if (EmptyUtil.isNoEmpty((String)direction)) {
            commonFilter.and(new QFilter("direction", "=", (Object)direction));
        }
        QFilter orgFilter = new QFilter("org_entry.u_org", "in", companyPKs).or(QFilter.isNull((String)"org_entry.u_org"));
        return TmcDataServiceHelper.exists((String)"cas_smartmatch", (QFilter[])new QFilter[]{commonFilter, orgFilter});
    }

    public static boolean isExistSmartRule(Set<Object> companyPKs, MatchBizTypeEnum biztype) {
        return AutoMatchCalMultiHelper.isExistSmartRule(companyPKs, biztype, null);
    }

    private static QFilter getRulCommonFilter(String type, String direction) {
        QFilter filter = new QFilter("biztype", "=", (Object)type).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("entryentity.e_isenable", "=", (Object)"1"));
        if (EmptyUtil.isNoEmpty((String)direction)) {
            filter.and(new QFilter("direction", "=", (Object)direction));
        }
        logger.info("\u81ea\u52a8\u5339\u914d\u89c4\u5219\u7684\u8fc7\u6ee4\u6761\u4ef6" + filter.toString());
        return filter;
    }

    private static Set<String> getFieldsByType(String entryName, String type) {
        HashSet<String> dateFields = new HashSet<String>();
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        for (FilterField transField : transFields) {
            IDataEntityProperty fieldProp = transField.getFieldProp();
            if ("date".equals(type)) {
                if (!(fieldProp instanceof DateProp) && !(fieldProp instanceof TimeProp) && !(fieldProp instanceof DateTimeProp) && !(fieldProp instanceof ModifyDateProp) && !(fieldProp instanceof CreateDateProp)) continue;
                dateFields.add(transField.getFullFieldName());
                continue;
            }
            if (!"amount".equals(type) || !(fieldProp instanceof AmountProp)) continue;
            dateFields.add(transField.getFullFieldName());
        }
        return dateFields;
    }

    private static CompareRule transRule(SmartMatch sm, Set<String> detailAmountFields, Set<String> bizAmountFields) {
        CompareRule r = new CompareRule();
        r.setSymbol(AutoMatchCalMultiHelper.transSymbol(sm.getRelation()));
        if (CompareRule.Symbol.STR_MATCH.equals((Object)r.getSymbol())) {
            if (MatchPlanEnum.LIKE.getValue().equals(sm.getRelation())) {
                r.setExtraVal((Object)1);
            } else if (MatchPlanEnum.LIKERIGHT.getValue().equals(sm.getRelation())) {
                r.setExtraVal((Object)-1);
            } else {
                r.setExtraVal((Object)0);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)sm.getNum())) {
            try {
                r.setExtraVal((Object)Integer.valueOf(sm.getNum()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (detailAmountFields.contains(sm.getTransdetailfields()) && bizAmountFields.contains(sm.getBizfields())) {
            r.setAmountMatch(true);
        }
        r.setPropNameSrc(sm.getTransdetailfields());
        r.setPropNameTgt(sm.getBizfields());
        if (StringUtils.isNotBlank((CharSequence)sm.getIsnullmatch())) {
            r.setNullMatch(Boolean.parseBoolean(sm.getIsnullmatch()));
        }
        if (StringUtils.isNotBlank((CharSequence)sm.getIsallnullmatch())) {
            r.setAllNullMatch((sm.getIsallnullmatch().equals("true") ? Boolean.TRUE : Boolean.FALSE).booleanValue());
        } else if (sm.getIsnullmatch().equals("true")) {
            r.setAllNullMatch(true);
        }
        return r;
    }

    private static CompareRule.Symbol transSymbol(String relation) {
        if (MatchPlanEnum.DIFF.getValue().equals(relation)) {
            return CompareRule.Symbol.DATE_DIFF;
        }
        if (MatchPlanEnum.LIKE.getValue().equals(relation) || MatchPlanEnum.LIKERIGHT.getValue().equals(relation) || MatchPlanEnum.LIKEBOTH.getValue().equals(relation)) {
            return CompareRule.Symbol.STR_MATCH;
        }
        return CompareRule.Symbol.EQUALS;
    }

    public static BigDecimal decodeAmountOld(String encryptAmount) {
        if (encryptAmount == null || encryptAmount.trim().isEmpty()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(new String(Base64.getDecoder().decode(encryptAmount)));
    }
}

