/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.helper.AutoMatchCalMultiHelper;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class AutoMatchScheDuleHelper {
    private static final Log logger = LogFactory.getLog(AutoMatchScheDuleHelper.class);

    public static boolean autoMatch(List<DynamicObject> dataList, MatchBizTypeEnum biztype) {
        if (dataList == null || dataList.size() <= 0) {
            return false;
        }
        HashSet<Object> companyPKs = new HashSet<Object>(dataList.size());
        HashMap<Object, List<Object>> tdIdMap = new HashMap<Object, List<Object>>(dataList.size());
        for (DynamicObject row : dataList) {
            Object companyId = row.getDynamicObject("company").getPkValue();
            companyPKs.add(companyId);
            ArrayList<Object> tdIdList = (ArrayList<Object>)tdIdMap.get(companyId);
            if (tdIdList == null) {
                tdIdList = new ArrayList<Object>();
            }
            tdIdList.add(row.getPkValue());
            tdIdMap.put(companyId, tdIdList);
        }
        List<Pair<Object, List<CompareResult>>> results = AutoMatchCalMultiHelper.autoMatchCal(companyPKs, tdIdMap, biztype);
        if (results != null && results.size() > 0) {
            for (Pair<Object, List<CompareResult>> result : results) {
                List rs = (List)result.getRight();
                if (rs == null || rs.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static HashSet<Object> autoMatch(List<DynamicObject> dataList, MatchBizTypeEnum biztype, boolean isNewMethod) {
        return AutoMatchScheDuleHelper.autoMatch(dataList, biztype, isNewMethod, null);
    }

    public static HashSet<Object> autoMatch(List<DynamicObject> dataList, MatchBizTypeEnum biztype, boolean isNewMethod, String direction) {
        HashSet<Object> succIdSet = new HashSet<Object>();
        if (dataList == null || dataList.size() <= 0) {
            return succIdSet;
        }
        HashSet<Object> companyPKs = new HashSet<Object>(dataList.size());
        HashMap<Object, List<Object>> tdIdMap = new HashMap<Object, List<Object>>(dataList.size());
        for (DynamicObject row : dataList) {
            Object companyId = row.getDynamicObject("company").getPkValue();
            companyPKs.add(companyId);
            ArrayList<Object> tdIdList = (ArrayList<Object>)tdIdMap.get(companyId);
            if (tdIdList == null) {
                tdIdList = new ArrayList<Object>();
            }
            tdIdList.add(row.getPkValue());
            tdIdMap.put(companyId, tdIdList);
        }
        List<Pair<Object, List<CompareResult>>> results = AutoMatchCalMultiHelper.autoMatchCal(companyPKs, tdIdMap, biztype, direction);
        if (results != null && results.size() > 0) {
            for (Pair<Object, List<CompareResult>> result : results) {
                List rs = (List)result.getRight();
                if (rs == null || rs.size() <= 0) continue;
                for (CompareResult compareResult : rs) {
                    succIdSet.addAll(compareResult.getSrcIdSet());
                }
            }
        }
        logger.info("succIdSet size:" + succIdSet.size());
        return succIdSet;
    }
}

