/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.SmartRecPayHelper;
import kd.tmc.bei.common.enums.AutoMatchFlagEnum;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.common.param.AutoMatchInfoParam;

public class AutoMatchServiceHelper {
    private static final Log logger = LogFactory.getLog(AutoMatchServiceHelper.class);
    private static final String AUTOMATCHINFOKEY = "AutoMatchInfoList";
    private static final Set<String> RecedBillType = Sets.newHashSet((Object[])new String[]{"cas_paybill_synonym", "cas_paybill_cash", "cas_paybill_spanmainpart", "cas_paybill_dcep"});
    public static final String RECEREDWAY = "receredway";
    public static final String RULENAME = "rulename";
    public static final String DOEXECUTE = "DoExecute";
    public static final String AUTORECPAYBIZBILLID = "autoRecPayBizBillId";
    private static final String PRE_MATCH_AMT = "preMatchAmount";
    private static final String MATCH_FLAG = "matchFlag";
    private static final String IS_PRE_FLAG = "isPreFlag";
    public static final String IS_DELETE_WORK = "isDeleteWork";
    public static final List<String> mTmcDb = Arrays.asList("fca_transupbill", "fca_transdownbill", "ifm_transhandlebill");
    private static final Map<String, String> TRACETYPEMAP = new HashMap<String, String>(3){
        private static final long serialVersionUID = 1L;
        {
            this.put("buy", "buybankcheckflag");
            this.put("sell", "sellingbankcheckflag");
        }
    };

    public static CommonParam getCommonParam(Object param) {
        if (param instanceof CommonParam) {
            return (CommonParam)param;
        }
        return new CommonParam();
    }

    public static List<AutoMatchInfoParam> getAutoMatchInfoList(CommonParam comParam) {
        String tAutoMatchInfoListStr = comParam.getString((Object)AUTOMATCHINFOKEY);
        ArrayList<AutoMatchInfoParam> tAutoMatchInfoParamList = new ArrayList();
        try {
            tAutoMatchInfoParamList = SerializationUtils.fromJsonStringToList((String)tAutoMatchInfoListStr, AutoMatchInfoParam.class);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6AutoMatchInfoParam\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return tAutoMatchInfoParamList;
    }

    public static boolean executeBatchSql(String entityName, String tUpdateSql, List<Object[]> paramList) {
        if (paramList == null || paramList.isEmpty()) {
            return false;
        }
        ArrayList<Integer> updateInfos = new ArrayList<Integer>(paramList.size());
        for (Object[] param : paramList) {
            logger.info("executeBatchSql:entityName:{},tUpdateSql:{},paramList:{}", new Object[]{entityName, tUpdateSql, param});
            int updateInfo = DB.update((DBRoute)DBRoute.of((String)EntityMetadataCache.getDataEntityType((String)entityName).getDBRouteKey()), (String)tUpdateSql, (Object[])param);
            logger.info("executeBatchSql:updateInfos:{}", (Object)updateInfo);
            updateInfos.add(updateInfo);
        }
        Iterator<Object> iterator = updateInfos.iterator();
        while (iterator.hasNext()) {
            int updateInfo = (Integer)iterator.next();
            if (updateInfo > 0) continue;
            return false;
        }
        return true;
    }

    public static Map<String, Map<String, String>> getFieldMap(String headProp, String preMatchAmountProp, String isPreFlagProp, String matchFlagProp) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(3);
        if (preMatchAmountProp != null && preMatchAmountProp.trim().length() > 0) {
            fieldMap.put(PRE_MATCH_AMT, preMatchAmountProp);
        }
        if (isPreFlagProp != null && isPreFlagProp.trim().length() > 0) {
            fieldMap.put(IS_PRE_FLAG, isPreFlagProp);
        }
        if (matchFlagProp != null && matchFlagProp.trim().length() > 0) {
            fieldMap.put(MATCH_FLAG, matchFlagProp);
        }
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(1);
        resultMap.put(headProp != null ? headProp.trim() : "", fieldMap);
        return resultMap;
    }

    public static Map<String, List<Long>> getAutoRecPayMap(Set<Object> autoRecPayBizBillIdSet, Map<String, Map<Long, DynamicObject>> tRecedBillsMap, Boolean isAutoRecPay) {
        HashMap<String, List<Long>> tAutoRecPayMap = new HashMap<String, List<Long>>(2);
        if (autoRecPayBizBillIdSet != null) {
            tRecedBillsMap.entrySet().forEach(tRecedBillsEntry -> {
                List billstatus = isAutoRecPay != false ? ((Map)tRecedBillsEntry.getValue()).entrySet().stream().filter(o -> autoRecPayBizBillIdSet.contains(o.getKey()) && BillStatusEnum.AUDIT.getValue().equals(((DynamicObject)o.getValue()).getString("billstatus")) && AutoMatchFlagEnum.ALL.getValue().equals(((DynamicObject)o.getValue()).getString("matchflag"))).map(o -> (Long)o.getKey()).collect(Collectors.toList()) : ((Map)tRecedBillsEntry.getValue()).entrySet().stream().filter(o -> autoRecPayBizBillIdSet.contains(o.getKey()) && BillStatusEnum.PAY.getValue().equals(((DynamicObject)o.getValue()).getString("billstatus"))).map(o -> (Long)o.getKey()).collect(Collectors.toList());
                if (billstatus.size() > 0) {
                    tAutoRecPayMap.put((String)tRecedBillsEntry.getKey(), billstatus);
                }
            });
        }
        return tAutoRecPayMap;
    }

    public static String getRecedBillType(String key) {
        if (RecedBillType.contains(key)) {
            return "cas_paybill";
        }
        return key;
    }

    public static String getBunessType(String tSourceEntity, String receredWay) {
        if (ReceredWayEnum.REVERSEMATCH.getValue().equals(receredWay)) {
            return "bei_intelpay".equals(tSourceEntity) ? "rec" : ("bei_intelrec".equals(tSourceEntity) ? "pay" : null);
        }
        return "bei_intelpay".equals(tSourceEntity) ? "pay" : ("bei_intelrec".equals(tSourceEntity) ? "rec" : null);
    }

    public static String getbankcheckBill(String bankcheckBill, String bankcheckflag, int maxLength) {
        bankcheckBill = StringUtils.trimToNull((String)bankcheckBill);
        bankcheckflag = StringUtils.trimToNull((String)bankcheckflag);
        String result = null;
        if (bankcheckBill != null && bankcheckflag != null) {
            if (bankcheckBill.equals(bankcheckflag)) {
                result = bankcheckBill;
            } else {
                HashSet<String> flagList = new HashSet<String>(10);
                flagList.addAll(Arrays.asList(bankcheckBill.split(",")));
                flagList.addAll(Arrays.asList(bankcheckflag.split(",")));
                if (flagList.size() > 0) {
                    result = flagList.stream().collect(Collectors.joining(","));
                }
            }
        } else {
            result = bankcheckflag != null ? bankcheckflag : bankcheckBill;
        }
        if (result != null && maxLength > 0 && result.length() > maxLength) {
            result = result.substring(0, maxLength);
        }
        return result;
    }

    public static String dealBankcheckflag(String bussFlag, String detailFlag) {
        if (bussFlag != null && detailFlag != null) {
            if (bussFlag.equals(detailFlag)) {
                return null;
            }
            ArrayList<String> flagList = new ArrayList<String>(10);
            flagList.addAll(Arrays.asList(bussFlag.split(",")));
            flagList.removeAll(Arrays.asList(detailFlag.split(",")));
            return flagList.stream().distinct().reduce((s1, s2) -> String.join((CharSequence)",", s1, s2)).orElse(null);
        }
        return bussFlag;
    }

    public static void updataExchangeBill(DynamicObject busnessBill, String tracetype, String bankcheckflag, Date traceDate) {
        Date exchangedate;
        if (TRACETYPEMAP.containsKey(tracetype)) {
            String sellingbankcheckflag = TRACETYPEMAP.get(tracetype);
            String bankcheckBill = busnessBill.getString(sellingbankcheckflag);
            busnessBill.set(sellingbankcheckflag, (Object)AutoMatchServiceHelper.getbankcheckBill(bankcheckBill, bankcheckflag, 1024));
        }
        busnessBill.set("acttradedate", (Object)((exchangedate = busnessBill.getDate("acttradedate")) != null && exchangedate.compareTo(traceDate) > 0 ? exchangedate : traceDate));
    }

    public static void cancelExchangeBill(DynamicObject busnessBill, String tracetype, String bankcheckflag, Date traceDate) {
        if (TRACETYPEMAP.containsKey(tracetype)) {
            String sellingbankcheckflag = TRACETYPEMAP.get(tracetype);
            String bankcheckBill = busnessBill.getString(sellingbankcheckflag);
            busnessBill.set(sellingbankcheckflag, (Object)AutoMatchServiceHelper.getbankcheckBill(AutoMatchServiceHelper.dealBankcheckflag(bankcheckBill, bankcheckflag), "", 1024));
        }
        busnessBill.set("acttradedate", (Object)traceDate);
    }

    public static Map<String, Map<Long, Date>> getBizDate(DynamicObject[] detailDoArr) {
        Map recedbillMap = Arrays.stream(detailDoArr).map(o -> o.getDynamicObjectCollection("recedbillentry")).flatMap(o -> o.stream()).collect(Collectors.groupingBy(k -> k.getString("e_recedbilltype"), Collectors.mapping(v -> v.getLong("e_recedbillid"), Collectors.toSet())));
        Set detailIds = Arrays.stream(detailDoArr).map(o -> o.getLong("id")).collect(Collectors.toSet());
        HashMap srcBills = new HashMap(recedbillMap.size());
        recedbillMap.entrySet().forEach(entry -> {
            Map result = BFTrackerServiceHelper.findSourceBills((String)AutoMatchServiceHelper.getRecedBillType((String)entry.getKey()), (Long[])((Set)entry.getValue()).toArray(new Long[0]));
            SmartRecPayHelper.mergerMap(srcBills, result);
        });
        HashMap<String, Map<Long, Date>> recedbillidMap = new HashMap<String, Map<Long, Date>>();
        Set srcBillIds = srcBills.entrySet().stream().filter(o -> Arrays.asList("bei_transdetail_cas", "bei_intelpay", "bei_intelrec").contains(o.getKey())).map(o -> (HashSet)o.getValue()).flatMap(o -> o.stream()).collect(Collectors.toSet());
        srcBillIds.removeAll(detailIds);
        if (srcBillIds.size() > 0) {
            String collect = AutoMatchHelper.getMatchFieldKeys().stream().collect(Collectors.joining(","));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)("id,bizdate," + collect), (QFilter[])new QFilter("id", "in", srcBillIds).toArray());
            if (query.size() > 0) {
                recedbillidMap.putAll(query.stream().collect(Collectors.groupingBy(k -> k.getString("recedbillentry.e_recedbilltype"), Collectors.groupingBy(k -> k.getLong("recedbillentry.e_recedbillid"), Collectors.mapping(o -> o.getDate("bizdate"), Collectors.reducing(null, (a, b) -> a.compareTo((Date)b) > 0 ? a : b))))));
            }
        }
        return recedbillidMap;
    }
}

