/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.security.SecureRandom;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.bei.common.constants.CasBFRow;
import kd.tmc.bei.common.constants.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CasBotpHelper {
    private static final Log logger = LogFactory.getLog(CasBotpHelper.class);

    public static void checkpush(String sourceEntity, String[] TargetEntitys) {
        if (sourceEntity == null) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u6e90\u5355\u672a\u6307\u5b9a\u3002", (String)"CasBotpHelper_3", (String)"tmc-bei-business", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        if (TargetEntitys.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u76ee\u6807\u5355\u672a\u6307\u5b9a\u3002", (String)"CasBotpHelper_5", (String)"tmc-bei-business", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        for (int i = 0; i < TargetEntitys.length; ++i) {
            CasBotpHelper.checkPushValidity(sourceEntity, TargetEntitys[i]);
        }
    }

    private static void checkPushValidity(String sourceEntity, String targetEntity) {
        QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)sourceEntity), new QFilter("targetentitynumber", "=", (Object)targetEntity), new QFilter("enabled", "=", (Object)"1")};
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id", (QFilter[])filter);
        if (rules.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"CasBotpHelper_2", (String)"tmc-bei-business", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntity);
        List items = linkSet.getItems();
        if (items == null || items.isEmpty()) {
            throw new KDException(new ErrorCode("CASBOTPERROR", ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u76ee\u6807\u5355\u636e\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\u3002", (String)"CasBotpHelper_0", (String)"tmc-bei-business", (Object[])new Object[0])), new Object[0]);
        }
        CodeRuleServiceHelper helper = new CodeRuleServiceHelper();
        List codeRuleList = helper.getAllCodeRuleByEntity(targetEntity);
        if (codeRuleList == null || codeRuleList.size() == 0) {
            ErrorCode ec = new ErrorCode("number", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u7f3a\u5c11\u7f16\u7801\u89c4\u5219\uff0c\u65e0\u6cd5\u751f\u6210\u3002", (String)"CasBotpHelper_4", (String)"tmc-bei-business", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
    }

    @Deprecated
    public static DynamicObject[] push(String sourceEntity, String TargetEntity, DynamicObject info) {
        return CasBotpHelper.push(info, TargetEntity);
    }

    public static DynamicObject[] push(DynamicObject info, String TargetEntity) {
        String sourceEntity = info.getDataEntityType().getName();
        String ruleId = CasBotpHelper.getDefaultBotpRule(sourceEntity, TargetEntity);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(info.getPkValue());
        selectedRows.add(row);
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(TargetEntity);
        args.setRuleId(ruleId);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)TargetEntity);
        List dynamicresults = result.loadTargetDataObjects(refDataProvider, mainType);
        DynamicObject[] dataEntities = new DynamicObject[dynamicresults.size()];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        if (codeRuleService == null) {
            codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
        }
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < dynamicresults.size(); ++i) {
            dataEntities[i] = (DynamicObject)dynamicresults.get(i);
            String number = codeRuleService.getNumber(TargetEntity, (DynamicObject)dynamicresults.get(i), ((DynamicObject)dynamicresults.get(i)).getString("org.id"));
            if (kd.bos.util.StringUtils.isEmpty((String)number)) {
                ErrorCode ec = new ErrorCode("billNo", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u7f3a\u5c11\u7f16\u7801\u89c4\u5219\uff0c\u65e0\u6cd5\u751f\u6210\u3002", (String)"CasBotpHelper_4", (String)"tmc-bei-business", (Object[])new Object[0]));
                throw new KDBizException(ec, new Object[0]);
            }
            dataEntities[i].set("billno", (Object)number);
        }
        return dataEntities;
    }

    private static String getDefaultBotpRule(String sourceEntity, String targetEntity) {
        QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)sourceEntity), new QFilter("targetentitynumber", "=", (Object)targetEntity), new QFilter("enabled", "=", (Object)"1")};
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id", (QFilter[])filter);
        if (rules.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"CasBotpHelper_2", (String)"tmc-bei-business", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return rules[0].getString("id");
    }

    public static void showParamter(String entitynumber, Long primaryKeyValue, String opeat, IFormView iFormView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_lookuptracker");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashSet<Long> subEntryIds = new HashSet<Long>();
        subEntryIds.add(primaryKeyValue);
        String linkNodesJson = null;
        List nodes = null;
        nodes = opeat.equals("lookdown") ? BFTrackerServiceHelper.loadLinkDownNodes((String)entitynumber, (String)"", (Long[])subEntryIds.toArray(new Long[subEntryIds.size()])) : BFTrackerServiceHelper.loadLinkUpNodes((String)entitynumber, (String)"", (Long[])subEntryIds.toArray(new Long[subEntryIds.size()]));
        if (nodes.isEmpty()) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"CasBotpHelper_1", (String)"tmc-bei-business", (Object[])new Object[0]));
            return;
        }
        linkNodesJson = SerializationUtils.serializeToBase64((Object)nodes);
        showParameter.getCustomParams().put("linknodes", linkNodesJson);
        showParameter.getCustomParams().put("lookuptype", opeat);
        iFormView.showForm(showParameter);
    }

    public static boolean isPushedBy(DynamicObject bill, String possibleSource) {
        String entity = bill.getDataEntityType().getName();
        Long pk = (Long)bill.getPkValue();
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)entity, (Long[])new Long[]{pk});
        HashSet sourcePks = (HashSet)sourceBills.get(possibleSource);
        return sourcePks != null && !sourcePks.isEmpty();
    }

    private static List<CasBFRow> getLinkedBill(Long id, boolean isLinkUp) {
        String sql = null;
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        if (isLinkUp) {
            sql = "select FID,FSTABLEID,FSBILLID,FTTABLEID,FTBILLID from T_BOTP_BillTracker  WHERE FTBILLID= ?";
            params.add(new SqlParameter(":FTBILLID", -5, (Object)id));
        } else {
            sql = "select FID,FSTABLEID,FSBILLID,FTTABLEID,FTBILLID from T_BOTP_BillTracker  WHERE FSBILLID= ?";
            params.add(new SqlParameter(":FSBILLID", -5, (Object)id));
        }
        ResultSetHandler<List<CasBFRow>> action = new ResultSetHandler<List<CasBFRow>>(){

            public List<CasBFRow> handle(ResultSet rs) throws Exception {
                ArrayList<CasBFRow> rowIds = new ArrayList<CasBFRow>(10);
                while (rs.next()) {
                    Long id = rs.getLong("FID");
                    Long sTableId = rs.getLong("FSTABLEID");
                    Long sBillId = rs.getLong("FSBILLID");
                    Long tTableId = rs.getLong("FTTABLEID");
                    Long tBillId = rs.getLong("FTBILLID");
                    CasBFRow rowId = new CasBFRow(id, sBillId, sTableId, tTableId, tBillId);
                    rowIds.add(rowId);
                }
                return rowIds;
            }
        };
        List rowIds = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        return rowIds;
    }

    public static List<String> getIdByLink(String souTable, String entTable, final Boolean isSource) {
        Long souTableId = CasBotpHelper.getTableIdByEntityKey(souTable);
        Long entTableId = CasBotpHelper.getTableIdByEntityKey(entTable);
        String sql = "SELECT FSBILLID,FTBILLID FROM T_BOTP_BILLTRACKER WHERE FSTABLEID= ? AND FTTABLEID= ?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FSTABLEID", -5, (Object)souTableId));
        params.add(new SqlParameter(":FTTABLEID", -5, (Object)entTableId));
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    String column = isSource != false ? "FSBILLID" : "FTBILLID";
                    list.add(rs.getString(column));
                }
                return list;
            }
        };
        List listIds = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        return listIds;
    }

    @Deprecated
    public static List<Map<String, Object>> gettargetBill(Long id) {
        List<CasBFRow> list = CasBotpHelper.getLinkedBill(id, false);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(list.size());
        HashMap<String, Object> temp = null;
        for (int i = 0; i < list.size(); ++i) {
            temp = new HashMap<String, Object>();
            temp.put("id", list.get(i).getTbillId());
            temp.put("entity", CasBotpHelper.getEntiKeyByTableId(list.get(i).gettTableId()));
            temp.put("sourceEntity", CasBotpHelper.getEntiKeyByTableId(list.get(i).getsTableId()));
            temp.put("sourceBillId", list.get(i).getsBillid());
            result.add(temp);
        }
        return result;
    }

    public static Long getTableIdByEntityKey(final String entityName) {
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FEntityKey = ? ");
        parameters[0] = new SqlParameter(":FEntityKey", 12, (Object)entityName);
        ResultSetHandler<TableDefine> action = new ResultSetHandler<TableDefine>(){

            public TableDefine handle(ResultSet rs) throws Exception {
                TableDefine tableDefine = null;
                if (rs.next()) {
                    tableDefine = new TableDefine();
                    tableDefine.setEntityNumber(rs.getString("FId"));
                    tableDefine.setEntityKey(entityName);
                    tableDefine.setTableId(Long.valueOf(rs.getLong("FTableId")));
                }
                return tableDefine;
            }
        };
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return tableDefine.getTableId();
    }

    public static String getEntiKeyByTableId(final Long tableId) {
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FTableId = ? ");
        parameters[0] = new SqlParameter(":FTableId", -5, (Object)tableId);
        ResultSetHandler<TableDefine> action = new ResultSetHandler<TableDefine>(){

            public TableDefine handle(ResultSet rs) throws Exception {
                TableDefine tableDefine = null;
                if (rs.next()) {
                    tableDefine = new TableDefine();
                    tableDefine.setEntityNumber(rs.getString("FId"));
                    tableDefine.setEntityKey(rs.getString("FEntityKey"));
                    tableDefine.setTableId(tableId);
                }
                return tableDefine;
            }
        };
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return tableDefine.getEntityNumber();
    }

    public static void deleteRation(Object Pk, String ... entityKeys) {
        int i;
        ArrayList<Map<String, Object>> relations = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> target = CasBotpHelper.gettargetBill((Long)Pk);
        relations.addAll(target);
        List<CasBFRow> list = CasBotpHelper.getLinkedBill((Long)Pk, true);
        ArrayList source = new ArrayList(list.size());
        for (i = 0; i < list.size(); ++i) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("id", list.get(i).getTbillId());
            temp.put("entity", CasBotpHelper.getEntiKeyByTableId(list.get(i).gettTableId()));
            temp.put("sourceEntity", CasBotpHelper.getEntiKeyByTableId(list.get(i).getsTableId()));
            temp.put("sourceBillId", list.get(i).getsBillid());
            source.add(temp);
        }
        relations.addAll(source);
        if (entityKeys.length == 0) {
            for (int j = 0; j < relations.size(); ++j) {
                CasBotpHelper.deleteRation_NewMethod((Map)relations.get(j));
            }
        } else {
            for (i = 0; i < entityKeys.length; ++i) {
                for (int j = 0; j < relations.size(); ++j) {
                    String entityKey = (String)((Map)relations.get(j)).get("entity");
                    String sourceEntityKey = (String)((Map)relations.get(j)).get("sourceEntity");
                    if (!entityKey.equals(entityKeys[i]) && !sourceEntityKey.equals(entityKeys[i])) continue;
                    CasBotpHelper.deleteRation_NewMethod((Map)relations.get(j));
                }
            }
        }
    }

    private static void deleteRation_NewMethod(Map<String, Object> map) {
        String entityKey = (String)map.get("entity");
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items == null || items.size() <= 0) {
            throw new KDException(new ErrorCode("CASBOTPERROR", entityKey + ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u76ee\u6807\u5355\u636e\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\u3002", (String)"CasBotpHelper_0", (String)"tmc-bei-business", (Object[])new Object[0])), new Object[0]);
        }
        lk = ((LinkSetItemElement)items.get(0)).getTableName();
        CasBotpHelper.deleteCasRation(map, tc, lk);
        try (TXHandle h = TX.requiresNew();){
            CasBotpHelper.deleteRation(map);
        }
    }

    private static void deleteCasRation(Map<String, Object> map, String tc, String lk) {
        Long FSBillId = (Long)map.get("sourceBillId");
        Long FTBILLID = (Long)map.get("id");
        String sBuilder_tc = "";
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>();
        sBuilder_tc = "delete from  " + tc + " where FSBillId= ? and FTId= ?";
        params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_tc.add(new SqlParameter(":FTId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)DBRouteConst.cas, (String)sBuilder_tc, (Object[])params_tc.toArray(new SqlParameter[params_tc.size()]));
        String sBuilder_lk = "";
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>();
        sBuilder_lk = "delete from  " + lk + " where FSBillId= ? and FId= ?";
        params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_lk.add(new SqlParameter(":FId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)DBRouteConst.cas, (String)sBuilder_lk, (Object[])params_lk.toArray(new SqlParameter[params_lk.size()]));
    }

    private static void deleteRation(Map<String, Object> map) {
        Long FSBillId = (Long)map.get("sourceBillId");
        Long FTBILLID = (Long)map.get("id");
        String sBuilder = "";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder = "delete from T_BOTP_BillTracker where FSBillId= ? and FTBillId= ?";
        params.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params.add(new SqlParameter(":FTBillId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])params.toArray(new SqlParameter[params.size()]));
    }

    public static void deleteRation(DBRoute dbRoute, Object pk, String ... entityKeys) {
        CasBotpHelper.deleteRation(dbRoute, pk, null, entityKeys);
    }

    public static void deleteRation(DBRoute dbRoute, Object pk, Boolean isLinkUp, String ... entityKeys) {
        List<CasBFRow> list;
        if (isLinkUp != null) {
            list = CasBotpHelper.getLinkedBill((Long)pk, isLinkUp);
        } else {
            list = CasBotpHelper.getLinkedBill((Long)pk, true);
            list.addAll(CasBotpHelper.getLinkedBill((Long)pk, false));
        }
        ArrayList source = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> temp = new HashMap<String, Object>(4);
            temp.put("id", list.get(i).getTbillId());
            temp.put("entity", CasBotpHelper.getEntiKeyByTableId(list.get(i).gettTableId()));
            temp.put("sourceEntity", CasBotpHelper.getEntiKeyByTableId(list.get(i).getsTableId()));
            temp.put("sourceBillId", list.get(i).getsBillid());
            source.add(temp);
        }
        ArrayList relations = new ArrayList(source);
        if (entityKeys.length == 0) {
            for (int j = 0; j < relations.size(); ++j) {
                CasBotpHelper.deleteRation_NewMethod(dbRoute, (Map)relations.get(j));
            }
        } else {
            for (int i = 0; i < entityKeys.length; ++i) {
                for (int j = 0; j < relations.size(); ++j) {
                    String entityKey = (String)((Map)relations.get(j)).get("entity");
                    String sourceEntityKey = (String)((Map)relations.get(j)).get("sourceEntity");
                    if (isLinkUp == null) {
                        if (!entityKey.equals(entityKeys[i]) && !sourceEntityKey.equals(entityKeys[i])) continue;
                        CasBotpHelper.deleteRation_NewMethod(dbRoute, (Map)relations.get(j));
                        continue;
                    }
                    if (isLinkUp.booleanValue() && sourceEntityKey.equals(entityKeys[i])) {
                        CasBotpHelper.deleteRation_NewMethod(dbRoute, (Map)relations.get(j));
                        continue;
                    }
                    if (isLinkUp.booleanValue() || !entityKey.equals(entityKeys[i])) continue;
                    CasBotpHelper.deleteRation_NewMethod(dbRoute, (Map)relations.get(j));
                }
            }
        }
    }

    private static void deleteRation_NewMethod(DBRoute dbRoute, Map<String, Object> map) {
        String entityKey = (String)map.get("entity");
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items == null || items.size() <= 0) {
            throw new KDException(new ErrorCode("CASBOTPERROR", entityKey + ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u76ee\u6807\u5355\u636e\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\u3002", (String)"CasBotpHelper_0", (String)"tmc-bei-business", (Object[])new Object[0])), new Object[0]);
        }
        lk = ((LinkSetItemElement)items.get(0)).getTableName();
        CasBotpHelper.deleteDBRation(dbRoute, map, tc, lk);
        try (TXHandle h = TX.requiresNew();){
            CasBotpHelper.deleteRation(map);
        }
    }

    private static void deleteDBRation(DBRoute dbRoute, Map<String, Object> map, String tc, String lk) {
        Long FSBillId = (Long)map.get("sourceBillId");
        Long FTBILLID = (Long)map.get("id");
        String sBuilder_tc = "";
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>();
        sBuilder_tc = "delete from  " + tc + " where FSBillId= ? and FTId= ?";
        params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_tc.add(new SqlParameter(":FTId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)dbRoute, (String)sBuilder_tc, (Object[])params_tc.toArray(new SqlParameter[params_tc.size()]));
        String sBuilder_lk = "";
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>();
        sBuilder_lk = "delete from  " + lk + " where FSBillId= ? and FId= ?";
        params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_lk.add(new SqlParameter(":FId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)dbRoute, (String)sBuilder_lk, (Object[])params_lk.toArray(new SqlParameter[params_lk.size()]));
    }

    public static void saveRelation(DynamicObject[] targetBills) {
        for (DynamicObject targetBill : targetBills) {
            CasBotpHelper.saveRelation(targetBill);
        }
    }

    public static void saveRelation(DynamicObject targetBill) {
        String sourceKey = targetBill.getString("sourcebilltype");
        Long sourcePk = targetBill.getLong("sourcebillid");
        String targetKey = targetBill.getDataEntityType().getName();
        Long targetPk = (Long)targetBill.getPkValue();
        CasBotpHelper.saveRelation(sourceKey, sourcePk, targetKey, targetPk);
    }

    public static void saveRelation(DynamicObject sourceBill, DynamicObject targetBill) {
        String sourceKey = sourceBill.getDataEntityType().getName();
        Long sourcePk = (Long)sourceBill.getPkValue();
        String targetKey = targetBill.getDataEntityType().getName();
        Long targetPk = (Long)targetBill.getPkValue();
        CasBotpHelper.saveRelation(sourceKey, sourcePk, targetKey, targetPk);
    }

    public static void saveRelation(Collection<DynamicObject> sourceBills, DynamicObject targetBill) {
        ArrayList<Long> sourcePks = new ArrayList<Long>(sourceBills.size());
        String sourceKey = null;
        for (DynamicObject sourceBill : sourceBills) {
            sourcePks.add((Long)sourceBill.getPkValue());
            sourceKey = sourceBill.getDataEntityType().getName();
        }
        String targetKey = targetBill.getDataEntityType().getName();
        CasBotpHelper.saveRelation(sourceKey, sourcePks, targetKey, (Long)targetBill.getPkValue());
    }

    public static void saveRelation(String sourceEntityKey, Collection<Long> sourcePks, String targetEntityKey, Long targetPk) {
        Long sourceTableId = CasBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = CasBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<CasBFRow> rows = new ArrayList<CasBFRow>(sourcePks.size());
        for (Long sourcePk : sourcePks) {
            long pk = DBServiceHelper.genGlobalLongId();
            CasBFRow row = new CasBFRow(Long.valueOf(pk), sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        CasBotpHelper.saveRelation(rows, targetEntityKey);
    }

    public static void saveRelation(String sourceEntityKey, Long sourcePk, String targetEntityKey, Collection<Long> targetPks) {
        Long sourceTableId = CasBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = CasBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<CasBFRow> rows = new ArrayList<CasBFRow>(targetPks.size());
        for (Long targetPk : targetPks) {
            long pk = DBServiceHelper.genGlobalLongId();
            CasBFRow row = new CasBFRow(Long.valueOf(pk), sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        CasBotpHelper.saveRelation(rows, targetEntityKey);
    }

    public static void saveRelation(List<CasBFRow> rows, String targetEntityKey) {
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items == null || items.size() <= 0) {
            throw new KDException(new ErrorCode("CAS_BOTP_ERROR", targetEntityKey + ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u76ee\u6807\u5355\u636e\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\u3002", (String)"CasBotpHelper_0", (String)"tmc-bei-business", (Object[])new Object[0])), new Object[0]);
        }
        lk = ((LinkSetItemElement)items.get(0)).getTableName();
        CasBotpHelper.saveBizRelation(rows, tc, lk);
        try (TXHandle h = TX.requiresNew();){
            CasBotpHelper.saveSysRelation(rows);
        }
    }

    public static void saveRelation(String sourceEntityKey, Long sourcePk, String targetEntityKey, Long targetPk) {
        CasBotpHelper.saveRelation(sourceEntityKey, sourcePk, targetEntityKey, Collections.singletonList(targetPk));
    }

    public static void batchSaveRelation(String sourceEntityKey, String targetEntityKey, List<Pair<Long, Long>> srcTarIds) {
        Long sourceTableId = CasBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = CasBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<CasBFRow> rows = new ArrayList<CasBFRow>(srcTarIds.size());
        for (Pair<Long, Long> srcTarId : srcTarIds) {
            long pk = DBServiceHelper.genGlobalLongId();
            CasBFRow row = new CasBFRow(Long.valueOf(pk), (Long)srcTarId.getKey(), sourceTableId, targetTableId, (Long)srcTarId.getValue());
            rows.add(row);
        }
        CasBotpHelper.saveRelation(rows, targetEntityKey);
    }

    public static void batchSaveRelation(DBRoute targetDBRoute, String sourceEntityKey, String targetEntityKey, List<Pair<Long, Long>> srcTarIds) {
        Long sourceTableId = CasBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = CasBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<CasBFRow> rows = new ArrayList<CasBFRow>(srcTarIds.size());
        for (Pair<Long, Long> srcTarId : srcTarIds) {
            long pk = DBServiceHelper.genGlobalLongId();
            CasBFRow row = new CasBFRow(Long.valueOf(pk), (Long)srcTarId.getKey(), sourceTableId, targetTableId, (Long)srcTarId.getValue());
            rows.add(row);
        }
        CasBotpHelper.saveRelation(targetDBRoute, rows, targetEntityKey);
    }

    public static void saveRelation(DBRoute targetDBRoute, List<CasBFRow> rows, String targetEntityKey) {
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)linkEntry.getParentEntityKey(), (CharSequence)targetEntityKey)) continue;
            lk = linkEntry.getTableName();
            break;
        }
        if (lk == null) {
            throw new KDException(new ErrorCode("CAS_BOTP_ERROR", String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\uff01", (String)"CasBotpHelper_6", (String)"fi-cas-common", (Object[])new Object[0]), targetEntityKey)), new Object[0]);
        }
        CasBotpHelper.saveBizRelation(targetDBRoute, rows, tc, lk);
        try (TXHandle h = TX.requiresNew();){
            CasBotpHelper.saveSysRelation(rows);
        }
    }

    private static void saveBizRelation(DBRoute dbRoute, List<CasBFRow> rows, String tc, String lk) {
        ArrayList<SqlParameter[]> tcBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> lkBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> deleteBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>(10);
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>(10);
        ArrayList<SqlParameter> delParams_lk = new ArrayList<SqlParameter>(10);
        for (CasBFRow row : rows) {
            params_tc.clear();
            params_lk.clear();
            delParams_lk.clear();
            Long id_tc = DBServiceHelper.genGlobalLongId();
            Long FTBillId = row.getTbillId();
            Long FTTableId = row.gettTableId();
            Long FTId = row.getTbillId();
            Long FSBillId = row.getsBillid();
            Long FSTableId = row.getsTableId();
            Long FSId = row.getsBillid();
            params_tc.add(new SqlParameter(":FID", -5, (Object)id_tc));
            params_tc.add(new SqlParameter(":FTBillId", -5, (Object)FTBillId));
            params_tc.add(new SqlParameter(":FTTableId", -5, (Object)FTTableId));
            params_tc.add(new SqlParameter(":FTId", -5, (Object)FTId));
            params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_tc.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_tc.add(new SqlParameter(":FSId", -5, (Object)FSId));
            tcBatchParameters.add(params_tc.toArray(new SqlParameter[params_tc.size()]));
            Long id_lk = DBServiceHelper.genGlobalLongId();
            params_lk.add(new SqlParameter(":FId", -5, (Object)FTId));
            params_lk.add(new SqlParameter(":FPKId", -5, (Object)id_lk));
            params_lk.add(new SqlParameter(":FSeq", 4, (Object)1));
            params_lk.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_lk.add(new SqlParameter(":FSId", -5, (Object)FSBillId));
            lkBatchParameters.add(params_lk.toArray(new SqlParameter[params_lk.size()]));
            delParams_lk.add(new SqlParameter(":FId", -5, (Object)FTId));
            delParams_lk.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            delParams_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            delParams_lk.add(new SqlParameter(":FSId", -5, (Object)FSBillId));
            deleteBatchParameters.add(delParams_lk.toArray(new SqlParameter[delParams_lk.size()]));
        }
        String sBuilder_tc = "INSERT INTO " + tc + " (FID, FTBillId, FTTableId,FTId,FSBillId,FSTableId,FSId) VALUES (?, ?,?,?, ?,?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)sBuilder_tc, tcBatchParameters);
        String delete_lk = "delete from  " + lk + " where  FId= ? and FSTableId=? and FSBillId=? and FSId=?";
        DB.executeBatch((DBRoute)dbRoute, (String)delete_lk, deleteBatchParameters);
        String sBuilder_lk = "INSERT INTO " + lk + " (FId, FPKId, FSeq,FSTableId,FSBillId,FSId) VALUES (?, ?,?,?, ?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)sBuilder_lk, lkBatchParameters);
    }

    private static void saveSysRelation(List<CasBFRow> rows) {
        ArrayList<SqlParameter[]> batchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        for (CasBFRow row : rows) {
            params.clear();
            params.add(new SqlParameter(":FID", -5, (Object)row.getId()));
            params.add(new SqlParameter(":FSTABLEID", -5, (Object)row.getsTableId()));
            params.add(new SqlParameter(":FSBILLID", -5, (Object)row.getsBillid()));
            params.add(new SqlParameter(":FTTABLEID", -5, (Object)row.gettTableId()));
            params.add(new SqlParameter(":FTBILLID", -5, (Object)row.getTbillId()));
            params.add(new SqlParameter(":FCREATETIME", 91, (Object)new Date()));
            batchParameters.add(params.toArray(new SqlParameter[params.size()]));
        }
        String sBuilder = "INSERT INTO T_BOTP_BillTracker (FID, FSTABLEID, FSBILLID, FTTABLEID, FTBILLID, FCREATETIME) VALUES (?, ?, ?, ?, ?, ?)";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sBuilder, batchParameters);
    }

    private static void saveBizRelation(List<CasBFRow> rows, String tc, String lk) {
        ArrayList<SqlParameter[]> tcBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> lkBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> deleteBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>(10);
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>(10);
        ArrayList<SqlParameter> delParams_lk = new ArrayList<SqlParameter>(10);
        for (CasBFRow row : rows) {
            params_tc.clear();
            params_lk.clear();
            delParams_lk.clear();
            Long id_tc = DBServiceHelper.genGlobalLongId();
            Long FTBillId = row.getTbillId();
            Long FTTableId = row.gettTableId();
            Long FTId = row.getTbillId();
            Long FSBillId = row.getsBillid();
            Long FSTableId = row.getsTableId();
            Long FSId = row.getsBillid();
            params_tc.add(new SqlParameter(":FID", -5, (Object)id_tc));
            params_tc.add(new SqlParameter(":FTBillId", -5, (Object)FTBillId));
            params_tc.add(new SqlParameter(":FTTableId", -5, (Object)FTTableId));
            params_tc.add(new SqlParameter(":FTId", -5, (Object)FTId));
            params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_tc.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_tc.add(new SqlParameter(":FSId", -5, (Object)FSId));
            tcBatchParameters.add(params_tc.toArray(new SqlParameter[params_tc.size()]));
            Long id_lk = DBServiceHelper.genGlobalLongId();
            params_lk.add(new SqlParameter(":FId", -5, (Object)FTId));
            params_lk.add(new SqlParameter(":FPKId", -5, (Object)id_lk));
            params_lk.add(new SqlParameter(":FSeq", 4, (Object)1));
            params_lk.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_lk.add(new SqlParameter(":FSId", -5, (Object)FSBillId));
            lkBatchParameters.add(params_lk.toArray(new SqlParameter[params_lk.size()]));
            delParams_lk.add(new SqlParameter(":FId", -5, (Object)FTId));
            delParams_lk.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            delParams_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            delParams_lk.add(new SqlParameter(":FSId", -5, (Object)FSBillId));
            deleteBatchParameters.add(delParams_lk.toArray(new SqlParameter[delParams_lk.size()]));
        }
        String sBuilder_tc = "INSERT INTO " + tc + " (FID, FTBillId, FTTableId,FTId,FSBillId,FSTableId,FSId) VALUES (?, ?,?,?, ?,?,?)";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sBuilder_tc, tcBatchParameters);
        String delete_lk = "delete from  " + lk + " where  FId= ? and FSTableId=? and FSBillId=? and FSId=?";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)delete_lk, deleteBatchParameters);
        String sBuilder_lk = "INSERT INTO " + lk + " (FId, FPKId, FSeq,FSTableId,FSBillId,FSId) VALUES (?, ?,?,?, ?,?)";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sBuilder_lk, lkBatchParameters);
    }

    public static Set<Long> getSrcBillByDestBill(Long destBillId, String destEntityKey, String srcEntityKey) {
        Map srcBills = BFTrackerServiceHelper.findSourceBills((String)destEntityKey, (Long[])new Long[]{destBillId});
        Set entrySet = srcBills.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            HashSet value = (HashSet)entry.getValue();
            if (!srcEntityKey.equals(key)) continue;
            return value;
        }
        return null;
    }

    public static Set<Long> getDestBillBySrcBill(Long srcBillId, String srcEntityKey, String destEntityKey) {
        Map destBills = BFTrackerServiceHelper.findTargetBills((String)srcEntityKey, (Long[])new Long[]{srcBillId});
        Set entrySet = destBills.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            HashSet value = (HashSet)entry.getValue();
            if (!destEntityKey.equals(key)) continue;
            return value;
        }
        return null;
    }

    public static Set<Long> getBotpRtansDetails(Long pkId, String entityId) {
        Set<Long> oldRecsrcBill = CasBotpHelper.getSrcBillByDestBill(pkId, entityId, "bei_intelrec");
        Set<Long> oldPaysrcBill = CasBotpHelper.getSrcBillByDestBill(pkId, entityId, "bei_intelpay");
        Set<Long> newsrcBill = CasBotpHelper.getSrcBillByDestBill(pkId, entityId, "bei_transdetail");
        Set<Long> handsrcBill = CasBotpHelper.getSrcBillByDestBill(pkId, entityId, "bei_transdetail_cas");
        Set<Long> idsSet = CasBotpHelper.mergerSet(oldPaysrcBill, oldRecsrcBill, newsrcBill);
        if (!EmptyUtil.isEmpty(handsrcBill)) {
            idsSet.addAll(handsrcBill);
        }
        return idsSet;
    }

    private static Set<Long> mergerSet(Set<Long> srcBillByDestBill, Set<Long> paysrcBillByDestBill, Set<Long> recsrcBillByDestBill) {
        HashSet<Long> set = new HashSet<Long>(10);
        if (!EmptyUtil.isEmpty(srcBillByDestBill)) {
            set.addAll(srcBillByDestBill);
        }
        if (!EmptyUtil.isEmpty(paysrcBillByDestBill)) {
            set.addAll(paysrcBillByDestBill);
        }
        if (!EmptyUtil.isEmpty(recsrcBillByDestBill)) {
            set.addAll(recsrcBillByDestBill);
        }
        return set;
    }
}

