/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.constants.BillTypeConstants;
import kd.tmc.bei.common.enums.FlowOperateTypeEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.common.enums.SourceBillTypeEnum;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class CasFlowConfirmLogHelper {
    private static final Log logger = LogFactory.getLog(CasFlowConfirmLogHelper.class);
    private static final String CAS_FLOWCONFIRMLOG = "cas_flowconfirmlog";

    public static void saveCancelLog(List<Long> detailIds, String way) {
        try {
            QFilter qFilter = new QFilter("entryentity.bizbillid", "in", detailIds);
            qFilter.and("entryentity.bizobject", "=", (Object)"bei_transdetail");
            DynamicObjectCollection existLogs = QueryServiceHelper.query((String)CAS_FLOWCONFIRMLOG, (String)"billno,optime,entryentity.bizbillid bizbillid,entryentity.bizobject bizobject", (QFilter[])qFilter.toArray());
            DynamicObjectCollection detailList = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,claimnoticebillno,company,currency,accountbank,bizdate,billno,creditamount,debitamount", (QFilter[])new QFilter("id", "in", detailIds).toArray());
            String genNum = String.valueOf(DB.genGlobalLongId());
            ArrayList<DynamicObject> confirmLogs = new ArrayList<DynamicObject>(detailList.size());
            for (DynamicObject transDetail : detailList) {
                DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)CAS_FLOWCONFIRMLOG);
                Optional<String> existBillNo = existLogs.stream().filter(e -> "bei_transdetail".equals(e.getString("bizobject")) && Long.valueOf(transDetail.getLong("id")).equals(e.getLong("bizbillid"))).sorted((bill1, bill2) -> {
                    Date optime1 = bill1.getDate("optime");
                    Date optime2 = bill2.getDate("optime");
                    return optime2.compareTo(optime1);
                }).map(e -> e.getString("billno")).findFirst();
                String number = existBillNo.orElse(genNum);
                confirmLog.set("billno", (Object)number);
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog);
                CasFlowConfirmLogHelper.fillAcctCurr(confirmLog, detailList);
                confirmLog.set("optype", (Object)way);
                DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
                DynamicObject detailEntry = entryEntity.addNew();
                CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, transDetail);
                confirmLogs.add(confirmLog);
            }
            SaveServiceHelper.save((DynamicObject[])confirmLogs.toArray(new DynamicObject[0]));
        }
        catch (Exception e2) {
            logger.error("generate flow confirm log error\uff1a", (Throwable)e2);
        }
    }

    public static void saveCancelMatchLog(DynamicObject[] transDeatilArr, List<AutoMatchInfoParam> tAutoMatchInfoList) {
        if (transDeatilArr.length == 0) {
            return;
        }
        try {
            Map<String, List<DynamicObject>> detailMap = Arrays.stream(transDeatilArr).collect(Collectors.groupingBy(detail -> detail.getString("receredway")));
            for (Map.Entry<String, List<DynamicObject>> entry : detailMap.entrySet()) {
                String receredWay = entry.getKey();
                List<DynamicObject> detailList = entry.getValue();
                Set detailIds = detailList.stream().map(detail -> detail.getLong("id")).collect(Collectors.toSet());
                List<AutoMatchInfoParam> autoMatchParamList = tAutoMatchInfoList.stream().filter(param -> detailIds.contains(param.getTransDetailId())).collect(Collectors.toList());
                if (ReceredWayEnum.AUTOMATCH.getValue().equals(receredWay) || ReceredWayEnum.BEIPAY.getValue().equals(receredWay)) {
                    CasFlowConfirmLogHelper.saveAutoMatchLog(detailList, autoMatchParamList, FlowOperateTypeEnum.CANCELMATCH.getValue());
                }
                if (!ReceredWayEnum.HANDMATCH.getValue().equals(receredWay) && !ReceredWayEnum.DIFFERMATCH.getValue().equals(receredWay) && !ReceredWayEnum.REVERSEMATCH.getValue().equals(receredWay) && !ReceredWayEnum.SINGLEMATCH.getValue().equals(receredWay)) continue;
                CasFlowConfirmLogHelper.saveHandMatchLog(detailList, autoMatchParamList);
            }
        }
        catch (Exception e) {
            logger.error("generate flow confirm log error\uff1a", (Throwable)e);
        }
    }

    public static void saveNoticeLog(List<Long> detailIds) {
        if (detailIds.isEmpty()) {
            return;
        }
        try {
            DynamicObjectCollection detailList = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,claimnoticebillno,company,currency,accountbank,bizdate,billno,creditamount,debitamount", (QFilter[])new QFilter("id", "in", detailIds).toArray());
            Set noticeBillNos = detailList.stream().map(detail -> detail.getString("claimnoticebillno")).collect(Collectors.toSet());
            DynamicObjectCollection noticeBills = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"billno,tradedetailno,id", (QFilter[])new QFilter("billno", "in", noticeBillNos).toArray());
            String number = String.valueOf(DB.genGlobalLongId());
            ArrayList<DynamicObject> confirmLogs = new ArrayList<DynamicObject>(detailList.size());
            for (DynamicObject transDetail : detailList) {
                DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)CAS_FLOWCONFIRMLOG);
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog);
                CasFlowConfirmLogHelper.fillAcctCurr(confirmLog, detailList);
                confirmLog.set("optype", (Object)FlowOperateTypeEnum.NOTICECLAIM.getValue());
                DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
                DynamicObject detailEntry = entryEntity.addNew();
                detailEntry.set("seq", (Object)1);
                confirmLog.set("billno", (Object)number);
                CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, transDetail);
                DynamicObject bizBillEntry = entryEntity.addNew();
                bizBillEntry.set("seq", (Object)2);
                bizBillEntry.set("bizbillno", (Object)transDetail.getString("claimnoticebillno"));
                bizBillEntry.set("bizobject", (Object)"cas_claimcenterbill");
                bizBillEntry.set("org", (Object)transDetail.getLong("company"));
                bizBillEntry.set("bizdate", (Object)transDetail.getDate("bizdate"));
                DynamicObject noticeBill = noticeBills.stream().filter(bill -> bill.getString("tradedetailno").equals(transDetail.getString("billno"))).findFirst().orElseGet(() -> (DynamicObject)noticeBills.get(0));
                bizBillEntry.set("bizbillid", (Object)noticeBill.getLong("id"));
                confirmLogs.add(confirmLog);
            }
            SaveServiceHelper.save((DynamicObject[])confirmLogs.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.error("generate flow confirm log error\uff1a", (Throwable)e);
        }
    }

    public static void saveMarkLog(List<DynamicObject> detailList, String opType) {
        try {
            String number = String.valueOf(DB.genGlobalLongId());
            ArrayList<DynamicObject> confirmLogs = new ArrayList<DynamicObject>(detailList.size());
            for (DynamicObject transDetail : detailList) {
                DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)CAS_FLOWCONFIRMLOG);
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog);
                confirmLog.set("currency", (Object)detailList.get(0).getDynamicObject("currency"));
                confirmLog.set("accountbank", (Object)detailList.get(0).getDynamicObject("accountbank"));
                confirmLog.set("optype", (Object)opType);
                confirmLog.set("billno", (Object)number);
                DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
                DynamicObject entry = entryEntity.addNew();
                CasFlowConfirmLogHelper.fillDetailInfo(entry, transDetail);
                confirmLogs.add(confirmLog);
            }
            SaveServiceHelper.save((DynamicObject[])confirmLogs.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.error("generate flow confirm log error\uff1a", (Throwable)e);
        }
    }

    private static void fillCommonInfo(DynamicObject confirmLog) {
        confirmLog.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        confirmLog.set("optime", (Object)DateUtils.getCurrentTime());
        confirmLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        confirmLog.set("traceid", (Object)RequestContext.get().getTraceId());
    }

    private static void fillCommonInfo(DynamicObject confirmLog, DynamicObject transDetail) {
        confirmLog.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        confirmLog.set("optime", (Object)DateUtils.getCurrentTime());
        confirmLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        confirmLog.set("traceid", (Object)RequestContext.get().getTraceId());
        if (transDetail != null) {
            confirmLog.set("accountbank", (Object)transDetail.getLong("accountbank"));
            confirmLog.set("currency", (Object)transDetail.getLong("currency"));
        }
    }

    private static void fillAcctCurr(DynamicObject confirmLog, DynamicObjectCollection detailList) {
        Optional<Long> accountBankId = detailList.stream().map(e -> e.getLong("accountbank")).findFirst();
        Optional currencyId = detailList.stream().map(e -> e.getLong("currency")).collect(Collectors.toList()).stream().findFirst();
        accountBankId.ifPresent(aLong -> confirmLog.set("accountbank", aLong));
        currencyId.ifPresent(aLong -> confirmLog.set("currency", aLong));
    }

    private static void fillDetailInfo(DynamicObject detailEntry, DynamicObject transDetail) {
        detailEntry.set("bizobject", (Object)"bei_transdetail");
        detailEntry.set("org", transDetail.get("company"));
        detailEntry.set("bizdate", (Object)transDetail.getDate("bizdate"));
        detailEntry.set("bizbillid", (Object)transDetail.getLong("id"));
        detailEntry.set("bizbillno", (Object)transDetail.getString("billno"));
        detailEntry.set("recamount", (Object)transDetail.getBigDecimal("creditamount"));
        detailEntry.set("payamount", (Object)transDetail.getBigDecimal("debitamount"));
    }

    public static void saveAutoMatchLog(List<DynamicObject> transDetails, List<AutoMatchInfoParam> autoMatchInfoParams, String opType) {
        try {
            DynamicObject detailEntry;
            DynamicObjectCollection transDetailList = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,currency,accountbank,bizdate,billno,creditamount,debitamount", (QFilter[])new QFilter("id", "in", transDetails.stream().map(detail -> detail.getLong("id")).collect(Collectors.toList())).toArray());
            ArrayList<DynamicObject> confirmLogs = new ArrayList<DynamicObject>(autoMatchInfoParams.size());
            Map<String, Long> billNuberCount = autoMatchInfoParams.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillNumber, Collectors.counting()));
            Map<Long, List<AutoMatchInfoParam>> manyToOneInfoMap = autoMatchInfoParams.stream().filter(param -> (Long)billNuberCount.get(param.getRecedBillNumber()) > 1L).collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillId));
            Map<Long, List<DynamicObject>> idToDetailMap = transDetailList.stream().collect(Collectors.groupingBy(c -> c.getLong("id")));
            for (Map.Entry<Long, List<AutoMatchInfoParam>> entry : manyToOneInfoMap.entrySet()) {
                List<AutoMatchInfoParam> matchInfoList = entry.getValue();
                DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)CAS_FLOWCONFIRMLOG);
                DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
                AutoMatchInfoParam firstParam = matchInfoList.get(0);
                DynamicObject firstDetail = transDetailList.stream().filter(detail -> detail.getLong("id") == firstParam.getTransDetailId().longValue()).findFirst().orElseGet(() -> (DynamicObject)transDetailList.get(0));
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog, firstDetail);
                confirmLog.set("billno", (Object)firstParam.getThisOpnumber());
                confirmLog.set("optype", (Object)opType);
                for (AutoMatchInfoParam matchParam : matchInfoList) {
                    detailEntry = entryEntity.addNew();
                    CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, transDetailList.stream().filter(detail -> detail.getLong("id") == matchParam.getTransDetailId().longValue()).findFirst().orElseGet(() -> (DynamicObject)transDetailList.get(0)));
                }
                DynamicObject bizBillEntry = entryEntity.addNew();
                CasFlowConfirmLogHelper.fillBizAutoMatchInfo(bizBillEntry, firstDetail, firstParam);
                BigDecimal totalAmt = matchInfoList.stream().map(AutoMatchInfoParam::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if ("rec".equals(firstParam.getDirection())) {
                    bizBillEntry.set("recamount", (Object)totalAmt);
                } else {
                    bizBillEntry.set("payamount", (Object)totalAmt);
                }
                confirmLogs.add(confirmLog);
            }
            Map<Long, List<AutoMatchInfoParam>> detailIdToInfoMap = autoMatchInfoParams.stream().filter(param -> (Long)billNuberCount.get(param.getRecedBillNumber()) == 1L).collect(Collectors.groupingBy(AutoMatchInfoParam::getTransDetailId));
            for (Map.Entry<Long, List<AutoMatchInfoParam>> entry : detailIdToInfoMap.entrySet()) {
                Long detailId = entry.getKey();
                List<AutoMatchInfoParam> matchInfoList = entry.getValue();
                DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)CAS_FLOWCONFIRMLOG);
                DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
                DynamicObject firstDetail = null;
                if (!transDetailList.isEmpty()) {
                    firstDetail = idToDetailMap.get(detailId).get(0);
                }
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog, firstDetail);
                AutoMatchInfoParam firstParam = matchInfoList.get(0);
                confirmLog.set("billno", (Object)firstParam.getThisOpnumber());
                confirmLog.set("optype", (Object)opType);
                detailEntry = entryEntity.addNew();
                CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, transDetails.stream().filter(detail -> detail.getLong("id") == detailId.longValue()).findFirst().orElseGet(() -> (DynamicObject)transDetails.get(0)));
                BigDecimal totalAmt = matchInfoList.stream().map(AutoMatchInfoParam::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if ("rec".equals(firstParam.getDirection())) {
                    detailEntry.set("recamount", (Object)totalAmt);
                } else {
                    detailEntry.set("payamount", (Object)totalAmt);
                }
                for (AutoMatchInfoParam matchParam : matchInfoList) {
                    DynamicObject bizBillEntry = entryEntity.addNew();
                    DynamicObject detail2 = idToDetailMap.get(detailId).get(0);
                    CasFlowConfirmLogHelper.fillBizAutoMatchInfo(bizBillEntry, detail2, matchParam);
                    if ("rec".equals(matchParam.getDirection())) {
                        bizBillEntry.set("recamount", (Object)matchParam.getAmount());
                        continue;
                    }
                    bizBillEntry.set("payamount", (Object)matchParam.getAmount());
                }
                confirmLogs.add(confirmLog);
            }
            SaveServiceHelper.save((DynamicObject[])confirmLogs.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.error("generate flow confirm log error\uff1a", (Throwable)e);
        }
    }

    private static void saveHandMatchLog(List<DynamicObject> detailList, List<AutoMatchInfoParam> autoMatchInfoParams) {
        try {
            Map<List, List<DynamicObject>> receredMap = detailList.stream().collect(Collectors.groupingBy(detail -> detail.getDynamicObjectCollection("recedbillentry").stream().map(billentry -> billentry.getString("e_recedbillnumber")).collect(Collectors.toList())));
            DynamicObjectCollection transDetailList = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,currency,accountbank,bizdate,billno,creditamount,debitamount", (QFilter[])new QFilter("id", "in", detailList.stream().map(detail -> detail.getLong("id")).collect(Collectors.toList())).toArray());
            ArrayList<DynamicObject> confirmLogs = new ArrayList<DynamicObject>(receredMap.size());
            for (Map.Entry<List, List<DynamicObject>> entry : receredMap.entrySet()) {
                List receredBillNos = entry.getKey();
                List<DynamicObject> receredDetails = entry.getValue();
                DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)CAS_FLOWCONFIRMLOG);
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog, (DynamicObject)transDetailList.get(0));
                confirmLog.set("billno", (Object)autoMatchInfoParams.stream().filter(param -> param.getRecedBillNumber().equals(receredBillNos.get(0))).map(AutoMatchInfoParam::getThisOpnumber).findFirst().orElse(""));
                confirmLog.set("optype", (Object)FlowOperateTypeEnum.CANCELMATCH.getValue());
                DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
                for (DynamicObject receredDetail : receredDetails) {
                    DynamicObject detailEntry = entryEntity.addNew();
                    CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, receredDetail);
                }
                for (String receredBillNo : receredBillNos) {
                    DynamicObject bizBill;
                    DynamicObject bizBillEntry = entryEntity.addNew();
                    AutoMatchInfoParam autoMatchInfoParam = autoMatchInfoParams.stream().filter(param -> param.getRecedBillNumber().equals(receredBillNo)).findFirst().orElseGet(() -> (AutoMatchInfoParam)autoMatchInfoParams.get(0));
                    CasFlowConfirmLogHelper.fillBizAutoMatchInfo(bizBillEntry, (DynamicObject)transDetailList.get(0), autoMatchInfoParam);
                    BigDecimal amount = autoMatchInfoParam.getAmount();
                    if ("rec".equals(autoMatchInfoParam.getDirection())) {
                        bizBillEntry.set("recamount", (Object)amount);
                    } else {
                        bizBillEntry.set("payamount", (Object)amount);
                    }
                    String recedBillType = autoMatchInfoParam.getRecedBillType();
                    if (amount.compareTo(BigDecimal.ZERO) != 0 || (bizBill = QueryServiceHelper.queryOne((String)recedBillType, (String)CasFlowConfirmLogHelper.getSelectFieldStr(autoMatchInfoParam), (QFilter[])new QFilter("id", "=", (Object)autoMatchInfoParam.getRecedBillId()).toArray())) == null) continue;
                    if ("cas_exchangebill".equals(recedBillType)) {
                        String traceType = autoMatchInfoParam.getTraceType();
                        BigDecimal buyAmount = bizBill.getBigDecimal("buyamount");
                        BigDecimal sellAmount = bizBill.getBigDecimal("sellamount");
                        if ("buy".equals(traceType)) {
                            bizBillEntry.set("recamount", (Object)buyAmount);
                            continue;
                        }
                        bizBillEntry.set("payamount", (Object)sellAmount);
                        continue;
                    }
                    if ("bei_transdetail".equals(recedBillType)) {
                        bizBillEntry.set("recamount", (Object)bizBill.getBigDecimal("creditamount"));
                        bizBillEntry.set("payamount", (Object)bizBill.getBigDecimal("debitamount"));
                        continue;
                    }
                    if (StringUtils.equalsAny((CharSequence)recedBillType, (CharSequence[])new CharSequence[]{"cas_paybill", "cas_agentpaybill", "fca_transdownbill", "ifm_transhandlebill"})) {
                        bizBillEntry.set("payamount", (Object)bizBill.getBigDecimal("amount"));
                        continue;
                    }
                    bizBillEntry.set("recamount", (Object)bizBill.getBigDecimal("amount"));
                }
                confirmLogs.add(confirmLog);
            }
            SaveServiceHelper.save((DynamicObject[])confirmLogs.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.error("generate flow confirm log error\uff1a", (Throwable)e);
        }
    }

    private static void fillBizBillInfo(DynamicObject bizBillEntry, DynamicObject transDetail) {
        bizBillEntry.set("bizobject", (Object)transDetail.getString("recedbilltype"));
        bizBillEntry.set("bizbillno", (Object)transDetail.getString("recedbillnumber"));
        bizBillEntry.set("bizbillid", (Object)transDetail.getLong("recedbillid"));
        bizBillEntry.set("org", transDetail.get("company"));
        bizBillEntry.set("bizdate", (Object)transDetail.getDate("bizdate"));
        bizBillEntry.set("recamount", (Object)transDetail.getBigDecimal("creditamount"));
        bizBillEntry.set("payamount", (Object)transDetail.getBigDecimal("debitamount"));
    }

    private static void fillBizAutoMatchInfo(DynamicObject bizBillEntry, DynamicObject transDetail, AutoMatchInfoParam autoMatchParam) {
        if (autoMatchParam.getRecedBillType().startsWith("cas_paybill")) {
            bizBillEntry.set("bizobject", (Object)SourceBillTypeEnum.PAYBILL.getValue());
            if ("cas_paybill".equals(autoMatchParam.getRecedBillType())) {
                DynamicObjectCollection payBill = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)autoMatchParam.getRecedBillId())});
                long billTypeId = ((DynamicObject)payBill.get(0)).getLong("billtype");
                String payBillType = CasFlowConfirmLogHelper.getPayBillType(billTypeId);
                bizBillEntry.set("billtype", (Object)payBillType);
            } else {
                bizBillEntry.set("billtype", (Object)autoMatchParam.getRecedBillType());
            }
        } else {
            bizBillEntry.set("bizobject", (Object)autoMatchParam.getRecedBillType());
            if ("cas_exchangebill".equals(autoMatchParam.getRecedBillType())) {
                String direction = autoMatchParam.getDirection();
                if (EmptyUtil.isEmpty((String)direction)) {
                    String traceType = autoMatchParam.getTraceType();
                    direction = "buy".equals(traceType) ? "rec" : "pay";
                }
                bizBillEntry.set("billtype", (Object)(autoMatchParam.getRecedBillType() + "_" + direction));
            }
        }
        bizBillEntry.set("bizbillno", (Object)autoMatchParam.getRecedBillNumber());
        bizBillEntry.set("bizbillid", (Object)autoMatchParam.getRecedBillId());
        bizBillEntry.set("detailid", (Object)autoMatchParam.getRecedBillEntryId());
        if (transDetail != null) {
            bizBillEntry.set("org", transDetail.get("company"));
            bizBillEntry.set("bizdate", (Object)transDetail.getDate("bizdate"));
        }
    }

    public static String getPayBillType(Long billTypeId) {
        if (BillTypeConstants.PAYBILL_SYN.equals(billTypeId)) {
            return SourceBillTypeEnum.PAYBILL_SYNONYM.getValue();
        }
        if (BillTypeConstants.PAYBILL_CASH.equals(billTypeId)) {
            return SourceBillTypeEnum.PAYBILL_CASH.getValue();
        }
        if (BillTypeConstants.PAYBILL_SPAN.equals(billTypeId)) {
            return "cas_paybill_spanmainpart";
        }
        if (BillTypeConstants.PAYBILL_DCEP.equals(billTypeId)) {
            return SourceBillTypeEnum.PAYBILL_DCEP.getValue();
        }
        if (BillTypeConstants.PAYBILL_PUR.equals(billTypeId)) {
            return "cas_paybill_pur";
        }
        return "cas_paybill_otr";
    }

    private static String getSelectFieldStr(AutoMatchInfoParam autoMatchInfoParam) {
        String recedBillType = autoMatchInfoParam.getRecedBillType();
        String selectFieldStr = "";
        switch (recedBillType) {
            case "cas_paybill": 
            case "ifm_transhandlebill": {
                selectFieldStr = "payeracctbank accountbank,currency,org,actpayamt amount";
                break;
            }
            case "cas_agentpaybill": {
                selectFieldStr = "payeracctbank accountbank,currency,org,payamount amount";
                break;
            }
            case "fca_transupbill": 
            case "fca_transdownbill": {
                selectFieldStr = "accountbank,currency,company org,amount";
                break;
            }
            case "cas_recbill": {
                selectFieldStr = "accountbank,currency,org,actrecamt amount";
                break;
            }
            case "cas_exchangebill": {
                selectFieldStr = "basecurrency currency,buyingaccount accountbank,org,buyamount,sellamount";
                break;
            }
        }
        return selectFieldStr;
    }
}

