/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.bean.AccountPredictDateResult;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.common.enums.DetailCorrectTypeEnum;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class ElecMatchCheckHelper {
    private static final Log logger = LogFactory.getLog(ElecMatchCheckHelper.class);
    private static final int ACCOUNT_BATCH = 200;

    /*
     * Exception decompiling
     */
    public static List<Map<String, Object>> getAllElecRecord(Date bizDate, QFilter accountFilter, QFilter filter, Map<Object, DynamicObject> acctMap, Map<Long, Date> acctBank_predictDate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 18 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void putRowEleMap(Row eleRow, Map<String, Row> eleRowMap) {
        String key = eleRow.get("elecaccountbank") + ":";
        if (!eleRowMap.containsKey(key)) {
            eleRowMap.put(key, eleRow);
        }
        if (Objects.nonNull(eleRow.get("eleccurrency"))) {
            key = key + eleRow.get("eleccurrency");
            eleRowMap.put(key, eleRow);
        }
    }

    private static Row getRowElePairRow(Row detailRow, Map<String, Row> eleRowMap) {
        String key = detailRow.get("detailaccountbank") + ":";
        Object currency = detailRow.get("detailcurrency");
        if (Objects.nonNull(currency) && Objects.nonNull(eleRowMap.get(key + currency))) {
            return eleRowMap.get(key + currency);
        }
        return eleRowMap.get(key);
    }

    private static Row getSelectRow(Row l, Row r) {
        if (Objects.isNull(l.getLong("detailaccountbank"))) {
            long lc = null != l.getLong("eleccount") ? l.getLong("eleccount") : 0L;
            long rc = null != r.getLong("detailcount") ? r.getLong("detailcount") : 0L;
            return lc > rc ? l : r;
        }
        return l;
    }

    private static Map<String, Object> dataToMap(Row row) {
        DetailCorrectTypeEnum checkEnum = ElecMatchCheckHelper.getElecCheckResult(row);
        HashMap<String, Object> checkMap = new HashMap<String, Object>(16);
        checkMap.put("company", ElecMatchCheckHelper.getRowNoNull(row, "eleccompany", "detailcompany"));
        checkMap.put("bank", ElecMatchCheckHelper.getRowNoNull(row, "elecbank", "detailbank"));
        checkMap.put("accountbank", ElecMatchCheckHelper.getRowNoNull(row, "elecaccountbank", "detailaccountbank"));
        checkMap.put("currency", ElecMatchCheckHelper.getRowNoNull(row, "eleccurrency", "detailcurrency"));
        checkMap.put("bizdate", ElecMatchCheckHelper.getRowNoNull(row, "elecbizdate", "detailbizdate"));
        checkMap.put("detailcount", row.get("detailcount"));
        checkMap.put("detailmatchcount", row.get("detailmatch"));
        checkMap.put("detaildebittotal", row.get("detaildebitamount"));
        checkMap.put("detailcredittotal", row.get("detailcreditamount"));
        checkMap.put("eleccount", row.get("eleccount"));
        checkMap.put("elecmatchcount", row.get("elecmatch"));
        checkMap.put("elecdebittotal", row.get("elecdebitamount"));
        checkMap.put("eleccredittotal", row.get("eleccreditamount"));
        checkMap.put("debitbalance", ElecMatchCheckHelper.getRowBalance(row, "detaildebitamount", "elecdebitamount"));
        checkMap.put("creditbalance", ElecMatchCheckHelper.getRowBalance(row, "detailcreditamount", "eleccreditamount"));
        checkMap.put("checkresult", checkEnum.getResult());
        checkMap.put("checkresultdesc", checkEnum.getName());
        checkMap.put("correcttype", checkEnum.getValue());
        checkMap.put("modifytime", new Date());
        return checkMap;
    }

    private static Object getRowNoNull(Row row, String p, String q) {
        return Objects.nonNull(row.get(p)) ? row.get(p) : row.get(q);
    }

    private static BigDecimal getRowBalance(Row row, String p, String q) {
        BigDecimal a = row.getBigDecimal(p);
        BigDecimal b = row.getBigDecimal(q);
        a = Objects.nonNull(a) ? a : BigDecimal.ZERO;
        b = Objects.nonNull(b) ? b : BigDecimal.ZERO;
        return a.subtract(b);
    }

    private static DetailCorrectTypeEnum getElecCheckResult(Row row) {
        boolean conditionB;
        BigDecimal debitBalance = ElecMatchCheckHelper.getRowBalance(row, "detaildebitamount", "elecdebitamount");
        BigDecimal creditBalance = ElecMatchCheckHelper.getRowBalance(row, "detailcreditamount", "eleccreditamount");
        boolean conditionA = Objects.equals(row.getLong("detailcount"), row.getLong("detailmatch"));
        boolean bl = conditionB = debitBalance.compareTo(BigDecimal.ZERO) == 0 && creditBalance.compareTo(BigDecimal.ZERO) == 0;
        if (conditionA) {
            return conditionB ? DetailCorrectTypeEnum.ELEC_COMPLETE : DetailCorrectTypeEnum.DETAIL_LOST;
        }
        return conditionB ? DetailCorrectTypeEnum.DETAIL_NOT_MATCH : DetailCorrectTypeEnum.ELEC_LOST;
    }

    private static List<Map<String, Object>> extendCurrency(List<Map<String, Object>> missRecords, Map<Object, DynamicObject> acctMap) {
        if (CollectionUtils.isEmpty(missRecords)) {
            return missRecords;
        }
        Map<Long, List<Map>> acctDataMap = missRecords.stream().collect(Collectors.groupingBy(t -> Long.valueOf(t.get("accountbank").toString())));
        ArrayList<Map<String, Object>> resRecords = new ArrayList<Map<String, Object>>(missRecords.size());
        for (Map.Entry<Object, DynamicObject> one : acctMap.entrySet()) {
            Object acctId = one.getKey();
            DynamicObject acct = one.getValue();
            Set currencyList = acct.getDynamicObjectCollection("currency").stream().map(t -> t.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(t -> t.getLong("id")).collect(Collectors.toSet());
            List<Map<String, Object>> records = acctDataMap.get(acctId);
            if (CollectionUtils.isEmpty(records)) continue;
            Map curMap = records.stream().collect(Collectors.toMap(t -> Objects.nonNull(t.get("currency")) ? Long.parseLong(t.get("currency").toString()) : 0L, Function.identity(), (p, q) -> p));
            for (Long curId : currencyList) {
                Map<String, Object> dataMap = (Map<String, Object>)curMap.get(curId);
                if (Objects.isNull(dataMap)) {
                    dataMap = ElecMatchCheckHelper.createMissingRecord(records);
                    dataMap.put("currency", curId);
                }
                resRecords.add(dataMap);
            }
        }
        return resRecords;
    }

    private static Map<String, Object> createMissingRecord(List<Map<String, Object>> records) {
        Optional<Map> find = records.stream().filter(t -> EmptyUtil.isEmpty(t.get("currency"))).findFirst();
        if (find.isPresent()) {
            return new HashMap<String, Object>(find.get());
        }
        DetailCorrectTypeEnum checkEnum = DetailCorrectTypeEnum.ELEC_COMPLETE;
        Map<String, Object> tempMap = records.get(0);
        HashMap<String, Object> checkMap = new HashMap<String, Object>(16);
        checkMap.put("company", tempMap.get("company"));
        checkMap.put("bank", tempMap.get("bank"));
        checkMap.put("accountbank", tempMap.get("accountbank"));
        checkMap.put("currency", null);
        checkMap.put("bizdate", tempMap.get("bizdate"));
        checkMap.put("detailcount", null);
        checkMap.put("detailmatchcount", null);
        checkMap.put("detaildebittotal", null);
        checkMap.put("detailcredittotal", null);
        checkMap.put("eleccount", null);
        checkMap.put("elecmatchcount", null);
        checkMap.put("elecdebittotal", null);
        checkMap.put("eleccredittotal", null);
        checkMap.put("debitbalance", null);
        checkMap.put("creditbalance", null);
        checkMap.put("checkresult", checkEnum.getResult());
        checkMap.put("checkresultdesc", checkEnum.getName());
        checkMap.put("correcttype", checkEnum.getValue());
        checkMap.put("modifytime", new Date());
        return checkMap;
    }

    public static Map<Long, String> processBankCheck(List<Long> idList, Date bizDate, String bankNumber, Long filterCurrency) {
        logger.info("processBankCheck id size {}, bizdate {}, bankNumber {}, filterCurrency {}", new Object[]{idList.size(), DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), bankNumber, filterCurrency});
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(16);
        List accountPart = Lists.partition(idList, (int)200);
        for (List part : accountPart) {
            Map<Long, String> tempMap = ElecMatchCheckHelper.doBankCheck(part, bizDate, bankNumber, filterCurrency);
            if (!EmptyUtil.isNoEmpty(tempMap)) continue;
            errorMsgMap.putAll(tempMap);
        }
        return errorMsgMap;
    }

    public static Map<Long, String> processBankCheck(List<Long> idList, Date bizDate, String bankNumber) {
        return ElecMatchCheckHelper.processBankCheck(idList, bizDate, bankNumber, null);
    }

    private static Map<Long, String> doBankCheck(List<Long> idList, Date bizDate, String bankNumber, Long filterCurrency) {
        QFilter accountFilter = new QFilter("id", "in", idList);
        Date enddate = DateUtils.getDataFormat((Date)bizDate, (boolean)false);
        QFilter filter = new QFilter("bizdate", ">=", (Object)bizDate).and("bizdate", "<=", (Object)enddate);
        if (StringUtils.isNotEmpty((CharSequence)bankNumber)) {
            String[] number = bankNumber.split(",");
            filter = filter.and("accountbank.bankaccountnumber", "in", (Object)number);
        }
        Map acctMap = TmcDataServiceHelper.loadFromCache((String)"am_accountbank", (String)"id,name,company,bankaccountnumber,currency", (QFilter[])new QFilter("id", "in", idList).toArray());
        Map<Long, Date> acctBank_predictDate = AccountBankHelper.getAcctBankWithPredictDate(acctMap.values(), BankFuncEnum.RECEIPT.getValue());
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(16);
        List<Map<String, Object>> allRecords = ElecMatchCheckHelper.getAllElecRecord(bizDate, accountFilter, filter, acctMap, acctBank_predictDate);
        if (EmptyUtil.isNoEmpty((Long)filterCurrency)) {
            allRecords = allRecords.stream().filter(t -> Objects.equals(filterCurrency, t.get("currency"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(allRecords)) {
            return errorMsgMap;
        }
        Map<Object, List<Map>> recordMaps = allRecords.stream().filter(t -> Objects.nonNull(t.get("accountbank"))).collect(Collectors.groupingBy(t -> t.get("accountbank")));
        Map<Object, List<DynamicObject>> missDbMap = ElecMatchCheckHelper.getAllMissingRecord(idList, bizDate);
        for (Long acctId : idList) {
            String errorMsg = ElecMatchCheckHelper.mergeMissingRecord(acctId, bizDate, recordMaps.get(acctId), missDbMap.get(acctId));
            if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
            errorMsgMap.put(acctId, errorMsg);
        }
        return errorMsgMap;
    }

    private static Map<Object, List<DynamicObject>> getAllMissingRecord(List<Long> idList, Date bizDate) {
        QFilter filter = new QFilter("accountbank", "in", idList).and("bizdate", "=", (Object)bizDate).and("checktype", "=", (Object)"E");
        String selectProp = "billno,company,accountbank,currency,bizdate,checktype,checkresult,checkresultdesc,trynum,detailcount,detailmatchcount,eleccount,elecmatchcount,detaildebittotal,detailcredittotal,elecdebittotal,eleccredittotal,debitbalance,creditbalance,correcttype,modifytime,entryentity,edetailcount,edetailmatchcount,eeleccount,eelecmatchcount,edetaildebittotal,edetailcredittotal,eelecdebittotal,eeleccredittotal,edebitbalance,ecreditbalance,lcheckresult,lcheckresultdesc,exectime";
        DynamicObject[] objects = TmcDataServiceHelper.load((String)"bei_missingreord", (String)selectProp, (QFilter[])filter.toArray());
        return Arrays.stream(objects).collect(Collectors.groupingBy(t -> t.getLong("accountbank.id")));
    }

    private static String mergeMissingRecord(Long acctId, Date bizDate, List<Map<String, Object>> recordList, List<DynamicObject> objectList) {
        if (CollectionUtils.isEmpty(recordList)) {
            logger.info("acctId [{}] bizDate [{}] not exist record", (Object)acctId, (Object)DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"));
            return "";
        }
        logger.info("acctId [{}] bizDate [{}] recordSize [{}]", new Object[]{acctId, DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), recordList.size()});
        Map objectMap = Optional.ofNullable(objectList).orElseGet(ArrayList::new).stream().collect(Collectors.toMap(t -> Objects.nonNull(t.getDynamicObject("currency")) ? t.getDynamicObject("currency").getPkValue() : Long.valueOf(0L), Function.identity(), (p, q) -> p));
        ArrayList<DynamicObject> addObjects = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> updateObjects = new ArrayList<DynamicObject>(16);
        for (Map<String, Object> rcMap : recordList) {
            Object curId;
            if (Objects.isNull(rcMap.get("bizdate"))) {
                rcMap.put("bizdate", bizDate);
            }
            if (Objects.isNull(curId = rcMap.get("currency"))) {
                logger.info("acctId [{}] bizDate [{}] not exist currency", (Object)acctId, (Object)DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"));
                curId = 0L;
            }
            String result = rcMap.get("checkresult").toString();
            DynamicObject object = (DynamicObject)objectMap.get(curId);
            if (Objects.nonNull(object)) {
                ElecMatchCheckHelper.mapToObject(rcMap, object);
                object.set("modifytime", rcMap.get("modifytime"));
                ElecMatchCheckHelper.addNewLog(object, rcMap);
                updateObjects.add(object);
                continue;
            }
            if (!DetailCorrectTypeEnum.LOST_LST_BALANCE.getResult().equals(result)) continue;
            DynamicObject obj = TmcDataServiceHelper.newDynamicObject((String)"bei_missingreord");
            ElecMatchCheckHelper.mapToObject(rcMap, obj);
            obj.set("checktype", (Object)"E");
            obj.set("trynum", (Object)0);
            ElecMatchCheckHelper.addNewLog(obj, rcMap);
            addObjects.add(obj);
        }
        if (CollectionUtils.isNotEmpty(addObjects)) {
            logger.info("acctId [{}] bizDate [{}] save object {}", new Object[]{acctId, DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), addObjects.size()});
            SaveServiceHelper.saveOperate((String)"bei_missingreord", (DynamicObject[])addObjects.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
        if (CollectionUtils.isNotEmpty(updateObjects)) {
            logger.info("acctId [{}] bizDate [{}] update object {}", new Object[]{acctId, DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), updateObjects.size()});
            SaveServiceHelper.save((DynamicObject[])updateObjects.toArray(new DynamicObject[0]));
        }
        return "";
    }

    private static void addNewLog(DynamicObject obj, Map<String, Object> map) {
        DynamicObjectCollection logList = obj.getDynamicObjectCollection("entryentity");
        DynamicObject row = logList.addNew();
        row.set("edetailcount", map.get("detailcount"));
        row.set("edetailmatchcount", map.get("detailmatchcount"));
        row.set("eeleccount", map.get("eleccount"));
        row.set("eelecmatchcount", map.get("elecmatchcount"));
        row.set("edetaildebittotal", map.get("detaildebittotal"));
        row.set("edetailcredittotal", map.get("detailcredittotal"));
        row.set("eelecdebittotal", map.get("elecdebittotal"));
        row.set("eeleccredittotal", map.get("eleccredittotal"));
        row.set("edebitbalance", map.get("debitbalance"));
        row.set("ecreditbalance", map.get("creditbalance"));
        row.set("lcheckresult", map.get("checkresult"));
        row.set("lcheckresultdesc", map.get("checkresultdesc"));
        row.set("exectime", map.get("modifytime"));
    }

    private static void mapToObject(Map<String, Object> map, DynamicObject obj) {
        ElecMatchCheckHelper.setProperties(obj, map, "company", "accountbank", "currency", "bizdate", "checkresult", "checkresultdesc", "detailcount", "detailmatchcount", "eleccount", "elecmatchcount", "detaildebittotal", "detailcredittotal", "elecdebittotal", "eleccredittotal", "debitbalance", "creditbalance", "correcttype");
    }

    private static void setProperties(DynamicObject obj, Map<String, Object> map, String ... keys) {
        for (String key : keys) {
            obj.set(key, map.get(key));
        }
    }

    public static Map<Long, String> processDataEntity(DynamicObject[] dataEntities) {
        Map dateEntityMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(d -> d.getDate("bizdate"), Collectors.toList()));
        HashMap<Long, String> resMap = new HashMap<Long, String>(16);
        for (Map.Entry one : dateEntityMap.entrySet()) {
            Date bizDate = one.getKey();
            Map<Long, List<DynamicObject>> currMap = one.getValue().stream().collect(Collectors.groupingBy(t -> t.getDynamicObject("currency").getLong("id")));
            for (List<DynamicObject> dataList : currMap.values()) {
                Long currency = dataList.get(0).getDynamicObject("currency").getLong("id");
                List<Long> idList = dataList.stream().map(d -> d.getDynamicObject("accountbank").getLong("id")).distinct().collect(Collectors.toList());
                logger.info("processDataEntity id size {}", (Object)idList.size());
                Map<Long, String> map = ElecMatchCheckHelper.processBankCheck(idList, bizDate, null, currency);
                for (Map.Entry<Long, String> cur : map.entrySet()) {
                    Long acct = cur.getKey();
                    String res = (String)resMap.get(acct);
                    res = StringUtils.isBlank((CharSequence)res) ? cur.getValue() : res + ";" + cur.getValue();
                    resMap.put(acct, res);
                }
            }
        }
        return resMap;
    }

    public static void setBizBillGetReceipt(String billFormId, Set<Long> billIds, Boolean isCancel) {
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject[] bills;
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)billFormId, (String)"id, isgetreceipt", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)})) {
                bill.set("isgetreceipt", (Object)(isCancel == false ? 1 : 0));
            }
            try {
                SaveServiceHelper.save((DynamicObject[])bills);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            logger.error("setBizBillGetReceipt fail. " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static boolean checkReceiptIsFile(DynamicObject receipt) {
        return receipt.getBoolean("fileflag") && receipt.getBigDecimal("creditamount").compareTo(BigDecimal.ZERO) == 0 && receipt.getBigDecimal("debitamount").compareTo(BigDecimal.ZERO) == 0;
    }

    private static /* synthetic */ void lambda$getAllElecRecord$2(Date bizDate, Map t) {
        t.put("bizdate", bizDate);
    }

    private static /* synthetic */ boolean lambda$getAllElecRecord$1(Set allowAccounts, Map t) {
        return allowAccounts.contains(Long.parseLong(t.get("accountbank").toString()));
    }

    private static /* synthetic */ boolean lambda$getAllElecRecord$0(AccountPredictDateResult t) {
        return !t.isPermit();
    }
}

