/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.common.enums.AutoMatchBillEnum;
import kd.tmc.bei.common.enums.AutoMatchFlagEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.common.enums.SourceBillTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;

public class MatchAmountDealHelper {
    public static final List<String> BUSINESS_TYPE = Arrays.asList("cas_paybill_spanmainpart", SourceBillTypeEnum.PAYBILL.getValue(), SourceBillTypeEnum.PAYBILL_SYNONYM.getValue(), "cas_paybill_cash", SourceBillTypeEnum.RECBILL.getValue(), "ifm_transhandlebill", SourceBillTypeEnum.PAYBILL_DCEP.getValue());
    public static final List<String> A_BUSINESS_TYPE = Arrays.asList(SourceBillTypeEnum.AGENTPAYBILL.getValue(), AutoMatchBillEnum.DOWN_BILL.getName(), AutoMatchBillEnum.UP_BILL.getName());
    private static final String MATCH_AMT = "matchamount";
    private static final String UN_MATCH_AMT = "unmatchamount";
    private static final String MATCH_FLAG = "matchflag";
    private static final String MATCH_FLAG_MSG = "matchflagmsg";
    private static final List<String> TRACE_TYPE = Arrays.asList("buy", "sell");

    public static void matchManyToOne(DynamicObject businessBill, String type, BigDecimal thisMatchAmount, String billType, String receredway) {
        Map<String, Object> tMatchResult;
        boolean isMatched;
        if (!BUSINESS_TYPE.contains(billType)) {
            return;
        }
        type = "pay".equals(type) ? "pay" : "rec";
        String matchAmt = MATCH_AMT + type;
        String unMatchAmt = UN_MATCH_AMT + type;
        BigDecimal matchAmount = businessBill.getBigDecimal(matchAmt);
        BigDecimal unMatchAmount = businessBill.getBigDecimal(unMatchAmt);
        boolean bl = isMatched = unMatchAmount.compareTo(BigDecimal.ZERO) == 0;
        if (isMatched) {
            return;
        }
        if (Arrays.asList(ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(receredway)) {
            matchAmount = BigDecimal.ZERO;
            unMatchAmount = thisMatchAmount;
        }
        boolean flag = Arrays.asList("cas_paybill_spanmainpart", SourceBillTypeEnum.PAYBILL.getValue(), SourceBillTypeEnum.PAYBILL_SYNONYM.getValue(), "cas_paybill_cash", SourceBillTypeEnum.RECBILL.getValue(), SourceBillTypeEnum.PAYBILL_DCEP.getValue()).contains(businessBill.getDataEntityType().getName());
        MatchAmountDealHelper.dealRelateOtherFlow(businessBill);
        if (flag) {
            String otype = "pay".equals(type) ? "rec" : "pay";
            BigDecimal oMatchAmount = businessBill.getBigDecimal(MATCH_AMT + otype);
            BigDecimal oUnMatchAmount = businessBill.getBigDecimal(UN_MATCH_AMT + otype);
            if (Arrays.asList(ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(receredway)) {
                oMatchAmount = BigDecimal.ZERO;
                oUnMatchAmount = thisMatchAmount;
            }
            tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount, businessBill.getBoolean("relateotherflow"), oMatchAmount, oUnMatchAmount);
        } else {
            tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount);
        }
        AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, matchAmt, unMatchAmt, MATCH_FLAG, MATCH_FLAG_MSG);
    }

    public static void matchManyToOne(DynamicObject businessBill, String type, BigDecimal thisMatchAmount, String billType) {
        MatchAmountDealHelper.matchManyToOne(businessBill, type, thisMatchAmount, billType, "");
    }

    private static void dealRelateOtherFlow(DynamicObject businessBill) {
        String billName = businessBill.getDataEntityType().getName();
        if (SourceBillTypeEnum.RECBILL.getValue().equals(billName)) {
            String payerType = businessBill.getString("payertype");
            Long payerId = businessBill.getLong("payer");
            Long payeeId = businessBill.getDynamicObject("org").getLong("id");
            if ("bos_org".equals(payerType) && payeeId.compareTo(payerId) == 0) {
                boolean cs1047 = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.CAS.getId(), (long)businessBill.getDynamicObject("org").getLong("id"), (String)"cs1047");
                businessBill.set("relateotherflow", (Object)cs1047);
            } else {
                businessBill.set("relateotherflow", (Object)false);
            }
        } else if (Arrays.asList(SourceBillTypeEnum.PAYBILL.getValue(), SourceBillTypeEnum.PAYBILL_SYNONYM.getValue()).contains(billName)) {
            String payeeType = businessBill.getString("payeetype");
            Long payerId = businessBill.getDynamicObject("org").getLong("id");
            Long payeeId = businessBill.getLong("payee");
            if ("bos_org".equals(payeeType) && payeeId.compareTo(payerId) == 0) {
                boolean cs1047 = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.CAS.getId(), (long)businessBill.getDynamicObject("org").getLong("id"), (String)"cs1047");
                businessBill.set("relateotherflow", (Object)cs1047);
            } else {
                businessBill.set("relateotherflow", (Object)Boolean.FALSE);
            }
        }
    }

    public static void matchOneToMany(DynamicObject businessBill, String billType, String type, BigDecimal thisMatchAmount) {
        Map<String, Object> tMatchResult;
        if (!BUSINESS_TYPE.contains(billType)) {
            return;
        }
        type = "pay".equals(type) ? "pay" : "rec";
        String matchAmt = MATCH_AMT + type;
        String unMatchAmt = UN_MATCH_AMT + type;
        BigDecimal matchAmount = businessBill.getBigDecimal(matchAmt);
        BigDecimal unMatchAmount = businessBill.getBigDecimal(unMatchAmt);
        boolean flag = Arrays.asList("cas_paybill_spanmainpart", SourceBillTypeEnum.PAYBILL.getValue(), SourceBillTypeEnum.PAYBILL_SYNONYM.getValue(), "cas_paybill_cash", SourceBillTypeEnum.RECBILL.getValue(), SourceBillTypeEnum.PAYBILL_DCEP.getValue()).contains(businessBill.getDataEntityType().getName());
        if (flag) {
            String otype = "pay".equals(type) ? "rec" : "pay";
            tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount, businessBill.getBoolean("relateotherflow"), businessBill.getBigDecimal(MATCH_AMT + otype), businessBill.getBigDecimal(UN_MATCH_AMT + otype));
        } else {
            tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount);
        }
        AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, matchAmt, unMatchAmt, MATCH_FLAG, MATCH_FLAG_MSG);
    }

    public static void matchManyToOne(DynamicObject busnessBill, String billtype, BigDecimal totalamount, Object billEntryId, String receredway) {
        if (!A_BUSINESS_TYPE.contains(billtype)) {
            return;
        }
        String entryName = "";
        if (AutoMatchBillEnum.UP_BILL.getName().equals(billtype) || AutoMatchBillEnum.DOWN_BILL.getName().equals(billtype)) {
            entryName = "entrys";
        } else if (SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billtype)) {
            entryName = "entry";
        }
        if (Long.parseLong(billEntryId.toString()) > 0L) {
            DynamicObjectCollection entry1 = busnessBill.getDynamicObjectCollection(entryName);
            DynamicObject first = entry1.stream().filter(y -> y.getPkValue().equals(billEntryId)).findFirst().get();
            MatchAmountDealHelper.dealWithMatchProperty(first, busnessBill, totalamount, "entry", receredway);
        } else {
            MatchAmountDealHelper.dealWithMatchProperty(busnessBill, busnessBill, totalamount, "", receredway);
        }
    }

    public static void matchManyToOne(DynamicObject busnessBill, String billtype, BigDecimal totalamount, Object billEntryId) {
        MatchAmountDealHelper.matchManyToOne(busnessBill, billtype, totalamount, billEntryId, "");
    }

    public static BigDecimal matchOneToMany(DynamicObject busnessBill, Long billEntryId, String billtype, BigDecimal totalAmount) {
        if (!A_BUSINESS_TYPE.contains(billtype)) {
            return BigDecimal.ZERO;
        }
        String entryName = "";
        if (AutoMatchBillEnum.UP_BILL.getName().equals(billtype) || AutoMatchBillEnum.DOWN_BILL.getName().equals(billtype)) {
            entryName = "entrys";
        } else if (SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billtype)) {
            entryName = "entry";
        }
        BigDecimal canMatchAmount = totalAmount;
        DynamicObjectCollection entrys = busnessBill.getDynamicObjectCollection(entryName);
        List selectedEntry = entrys.stream().filter(y -> billEntryId.equals(y.getLong("id"))).collect(Collectors.toList());
        canMatchAmount = selectedEntry != null && selectedEntry.size() > 0 ? MatchAmountDealHelper.dealWithMatchProperty((DynamicObject)selectedEntry.get(0), busnessBill, canMatchAmount, "entry") : MatchAmountDealHelper.dealWithMatchProperty(busnessBill, busnessBill, canMatchAmount, "");
        return canMatchAmount;
    }

    public static void matchExchangeBill(DynamicObject businessBill, String tracetype, BigDecimal thisMatchAmount, String receredway) {
        if (businessBill != null && SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(businessBill.getDataEntityType().getName()) && TRACE_TYPE.contains(tracetype)) {
            boolean isMatched;
            BigDecimal matchAmount = businessBill.getBigDecimal(tracetype + MATCH_AMT);
            BigDecimal unMatchAmount = businessBill.getBigDecimal(tracetype + UN_MATCH_AMT);
            boolean bl = isMatched = unMatchAmount.compareTo(BigDecimal.ZERO) == 0;
            if (isMatched) {
                return;
            }
            if (Arrays.asList(ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(receredway)) {
                matchAmount = BigDecimal.ZERO;
                unMatchAmount = thisMatchAmount;
            }
            Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount);
            AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, tracetype + MATCH_AMT, tracetype + UN_MATCH_AMT, tracetype + MATCH_FLAG, tracetype + MATCH_FLAG_MSG);
            MatchAmountDealHelper.updataExchangeBill(businessBill);
        }
    }

    public static void matchExchangeBill(DynamicObject businessBill, String tracetype, BigDecimal thisMatchAmount) {
        MatchAmountDealHelper.matchExchangeBill(businessBill, tracetype, thisMatchAmount, "");
    }

    public static void updataExchangeBill(DynamicObject businessBill) {
        ArrayList matchflagList = new ArrayList(TRACE_TYPE.size());
        TRACE_TYPE.stream().forEach(o -> matchflagList.add(businessBill.getString(o + MATCH_FLAG)));
        if (matchflagList.stream().allMatch(o -> AutoMatchFlagEnum.NONE.getValue().equals(o))) {
            businessBill.set(MATCH_FLAG, (Object)AutoMatchFlagEnum.NONE.getValue());
        } else if (matchflagList.stream().allMatch(o -> AutoMatchFlagEnum.ALL.getValue().equals(o))) {
            businessBill.set(MATCH_FLAG, (Object)AutoMatchFlagEnum.ALL.getValue());
        } else if (matchflagList.stream().anyMatch(o -> AutoMatchFlagEnum.ERROR.getValue().equals(o))) {
            businessBill.set(MATCH_FLAG, (Object)AutoMatchFlagEnum.ERROR.getValue());
        } else {
            businessBill.set(MATCH_FLAG, (Object)AutoMatchFlagEnum.SOME.getValue());
        }
    }

    public static BigDecimal dealWithMatchProperty(DynamicObject dy, DynamicObject billDy, BigDecimal totalamount, String type, String receredway) {
        boolean isMatched;
        Map<Object, Object> tMatchResult = new HashMap(4);
        BigDecimal canMatchAmount = BigDecimal.ZERO;
        BigDecimal matchAmount = dy.getBigDecimal(type + MATCH_AMT);
        BigDecimal unMatchAmount = dy.getBigDecimal(type + UN_MATCH_AMT);
        boolean bl = isMatched = unMatchAmount.compareTo(BigDecimal.ZERO) == 0;
        if (isMatched) {
            return BigDecimal.ZERO;
        }
        if (Arrays.asList(ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(receredway)) {
            matchAmount = BigDecimal.ZERO;
            unMatchAmount = totalamount;
        }
        if ((tMatchResult = AutoMatchHelper.getMatchAmount(totalamount, matchAmount, unMatchAmount)) != null) {
            dy.set(type + MATCH_AMT, tMatchResult.get("matchAmount"));
            dy.set(type + UN_MATCH_AMT, tMatchResult.get("unMatchAmount"));
            dy.set(type + MATCH_FLAG, tMatchResult.get("matchFlag"));
            if (tMatchResult.containsKey("matchFlagMsg")) {
                dy.set(type + "matcherrmsg", tMatchResult.get("matchFlagMsg"));
            }
        }
        if (!type.isEmpty()) {
            matchAmount = billDy.getBigDecimal(MATCH_AMT);
            unMatchAmount = billDy.getBigDecimal(UN_MATCH_AMT);
            if (Arrays.asList(ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(receredway)) {
                matchAmount = BigDecimal.ZERO;
                unMatchAmount = totalamount;
            }
            if ((tMatchResult = AutoMatchHelper.getMatchAmount(totalamount, matchAmount, unMatchAmount)) != null) {
                billDy.set(MATCH_AMT, tMatchResult.get("matchAmount"));
                billDy.set(UN_MATCH_AMT, tMatchResult.get("unMatchAmount"));
                billDy.set(MATCH_FLAG, tMatchResult.get("matchFlag"));
                if (tMatchResult.containsKey("matchFlagMsg")) {
                    billDy.set("matcherrmsg", tMatchResult.get("matchFlagMsg"));
                }
            }
        } else {
            dy.set("ismatchbyhead", (Object)"1");
        }
        return canMatchAmount;
    }

    public static BigDecimal dealWithMatchProperty(DynamicObject dy, DynamicObject billDy, BigDecimal totalamount, String type) {
        return MatchAmountDealHelper.dealWithMatchProperty(dy, billDy, totalamount, type, "");
    }

    public static void dealCancelMatchInfo(String type, BigDecimal amount, Long entryId, DynamicObject bizDto, String receredWay) {
        if (BUSINESS_TYPE.contains(bizDto.getDataEntityType().getName()) || A_BUSINESS_TYPE.contains(bizDto.getDataEntityType().getName())) {
            BigDecimal totalAmt = BigDecimal.ZERO;
            String matchAmt = MATCH_AMT + type;
            String unMatchAmt = UN_MATCH_AMT + type;
            if ("cas_recbill".equals(bizDto.getDataEntityType().getName())) {
                totalAmt = bizDto.getBigDecimal("actrecamt");
            } else if ("ifm_transhandlebill".equals(bizDto.getDataEntityType().getName())) {
                totalAmt = bizDto.getBigDecimal("actpayamt");
            } else if ("cas_agentpaybill".equals(bizDto.getDataEntityType().getName()) || "fca_transupbill".equals(bizDto.getDataEntityType().getName()) || "fca_transdownbill".equals(bizDto.getDataEntityType().getName())) {
                if (Long.compare(entryId, 0L) != 0) {
                    String entityName = "entrys";
                    String totalAmtKey = "transamt";
                    if ("cas_agentpaybill".equals(bizDto.getDataEntityType().getName())) {
                        entityName = "entry";
                        totalAmtKey = "e_amount";
                    }
                    MatchAmountDealHelper.dealCancelMatchEntryInfo(bizDto, entryId, amount, entityName, totalAmtKey, receredWay);
                }
                matchAmt = MATCH_AMT;
                unMatchAmt = UN_MATCH_AMT;
                totalAmt = "cas_agentpaybill".equals(bizDto.getDataEntityType().getName()) ? bizDto.getBigDecimal("payamount") : bizDto.getBigDecimal("amount");
            } else {
                totalAmt = bizDto.getBigDecimal("totalpayamt");
            }
            MatchAmountDealHelper.dealCancelMatchObj(bizDto, matchAmt, unMatchAmt, amount, totalAmt, MATCH_FLAG, Boolean.FALSE, bizDto, type, receredWay);
        }
    }

    private static void dealCancelMatchObj(DynamicObject bizDto, String matchAmt, String unMatchAmt, BigDecimal amount, BigDecimal totalAmt, String matchFlag, Boolean isEntry, DynamicObject billDy, String type, String receredWay) {
        Map<String, Object> tMatchResult = null;
        boolean hasRelateOtherFlow = bizDto.getDataEntityType().getProperties().stream().anyMatch(o -> "relateotherflow".equals(o.getName()));
        boolean flag = Arrays.asList(SourceBillTypeEnum.PAYBILL.getValue(), SourceBillTypeEnum.RECBILL.getValue()).contains(bizDto.getDataEntityType().getName());
        BigDecimal matchAmount = bizDto.getBigDecimal(matchAmt);
        BigDecimal unMatchAmount = bizDto.getBigDecimal(unMatchAmt);
        if (Arrays.asList(ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(receredWay)) {
            matchAmount = amount = totalAmt;
            unMatchAmount = BigDecimal.ZERO;
        }
        if (flag && hasRelateOtherFlow) {
            String otype = "pay".equals(type) ? "rec" : "pay";
            BigDecimal oMatchAmount = bizDto.getBigDecimal(MATCH_AMT + otype);
            BigDecimal oUnMatchAmount = bizDto.getBigDecimal(UN_MATCH_AMT + otype);
            if (Arrays.asList(ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(receredWay)) {
                oMatchAmount = BigDecimal.ZERO;
                oUnMatchAmount = amount;
            }
            tMatchResult = AutoMatchHelper.getMatchAmount(amount.negate(), matchAmount, unMatchAmount, bizDto.getBoolean("relateotherflow"), oMatchAmount, oUnMatchAmount);
        } else {
            tMatchResult = AutoMatchHelper.getMatchAmount(amount.negate(), matchAmount, unMatchAmount);
        }
        if (tMatchResult != null && tMatchResult.size() > 0) {
            bizDto.set(matchAmt, tMatchResult.get("matchAmount"));
            bizDto.set(unMatchAmt, tMatchResult.get("unMatchAmount"));
            bizDto.set(matchFlag, tMatchResult.get("matchFlag"));
            if (tMatchResult.containsKey("matchFlagMsg")) {
                if (A_BUSINESS_TYPE.contains(billDy.getDataEntityType().getName())) {
                    if (isEntry.booleanValue()) {
                        bizDto.set("entrymatcherrmsg", tMatchResult.get("matchFlagMsg"));
                    } else {
                        bizDto.set("matcherrmsg", tMatchResult.get("matchFlagMsg"));
                    }
                } else {
                    bizDto.set(MATCH_FLAG_MSG, tMatchResult.get("matchFlagMsg"));
                }
            }
        }
        if (A_BUSINESS_TYPE.contains(bizDto.getDataEntityType().getName()) && !isEntry.booleanValue() && bizDto.getBigDecimal(matchAmt).compareTo(BigDecimal.ZERO) == 0) {
            bizDto.set("ismatchbyhead", (Object)Boolean.FALSE);
        }
    }

    public static void dealCancelMatchEntryInfo(DynamicObject bizDto, Long entryId, BigDecimal amount, String entityName, String totalAmtKey, String receredWay) {
        DynamicObjectCollection entry = bizDto.getDynamicObjectCollection(entityName);
        DynamicObject row = entry.stream().filter(y -> y.getPkValue().equals(entryId)).findFirst().get();
        BigDecimal totalAmt = row.getBigDecimal(totalAmtKey);
        String matchAmtKey = "entrymatchamount";
        String unMatchAmtKey = "entryunmatchamount";
        String matchFlagKey = "entrymatchflag";
        MatchAmountDealHelper.dealCancelMatchObj(row, matchAmtKey, unMatchAmtKey, amount, totalAmt, matchFlagKey, Boolean.TRUE, bizDto, null, receredWay);
    }

    public static void matchExchangeBill(DynamicObject businessBill, DynamicObject detail) {
        if (businessBill != null && detail != null && SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(businessBill.getDataEntityType().getName())) {
            String oldReceredWay = detail.getString("receredway");
            detail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(o.getString("e_recedbilltype")) && Long.compare(businessBill.getLong("id"), o.getLong("e_recedbillid")) == 0).forEach(o -> {
                String tracetype = o.getString("e_amttype");
                BigDecimal amount = o.getBigDecimal("e_amount");
                BigDecimal matchAmount = businessBill.getBigDecimal(tracetype + MATCH_AMT);
                BigDecimal unMatchAmount = businessBill.getBigDecimal(tracetype + UN_MATCH_AMT);
                if (Arrays.asList(ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(oldReceredWay)) {
                    matchAmount = amount = businessBill.getBigDecimal(tracetype + MATCH_AMT);
                    unMatchAmount = BigDecimal.ZERO;
                }
                Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(amount.negate(), matchAmount, unMatchAmount);
                AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, tracetype + MATCH_AMT, tracetype + UN_MATCH_AMT, tracetype + MATCH_FLAG, tracetype + MATCH_FLAG_MSG);
            });
            MatchAmountDealHelper.updataExchangeBill(businessBill);
        }
    }
}

