/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.bei.common.enums.QueryRequestStatusEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class QueryRequestRecordHelper {
    public static void saveQueryTaskInfo(long taskId, String queryType, String executeWay) {
        DynamicObject taskRecord = BusinessDataServiceHelper.newDynamicObject((String)"bei_querytask");
        taskRecord.set("id", (Object)taskId);
        taskRecord.set("number", (Object)taskId);
        taskRecord.set("querytype", (Object)queryType);
        taskRecord.set("executeway", (Object)executeWay);
        taskRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
        taskRecord.set("createtime", (Object)new Date());
        taskRecord.set("traceid", (Object)RequestContext.get().getTraceId());
        taskRecord.set("enable", (Object)BaseEnableEnum.ENABLE.getValue());
        taskRecord.set("status", (Object)BillStatusEnum.SAVE.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskRecord});
    }

    public static DynamicObject buildQueryRequestRecord(List<DynamicObject> accountList, DynamicObject currency, Date beginDate, Date endDate, long taskId) {
        DynamicObject queryRequestRecord = BusinessDataServiceHelper.newDynamicObject((String)"bei_queryrequest");
        Date creatTime = new Date();
        long requestId = DB.genLongId((String)"t_bei_queryrequest");
        DynamicObjectCollection accounts = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)queryRequestRecord, (String)"accountbank", (DynamicObject[])accountList.toArray(new DynamicObject[0]));
        queryRequestRecord.set("accountbank", (Object)accounts);
        queryRequestRecord.set("begindate", (Object)beginDate);
        queryRequestRecord.set("enddate", (Object)endDate);
        queryRequestRecord.set("currency", (Object)currency);
        queryRequestRecord.set("id", (Object)requestId);
        queryRequestRecord.set("requestid", (Object)requestId);
        queryRequestRecord.set("task", (Object)taskId);
        queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.NOSTART.getValue());
        queryRequestRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
        queryRequestRecord.set("createtime", (Object)creatTime);
        queryRequestRecord.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        return queryRequestRecord;
    }

    public static List<DynamicObject> checkOldQueryRequestRecord(DynamicObject queryRequestRecord, List<DynamicObject> containsOldRequests) {
        ArrayList<DynamicObject> oldQueryRequestRecords = new ArrayList<DynamicObject>(10);
        for (DynamicObject oldRequest : containsOldRequests) {
            String status = oldRequest.getString("status");
            int diffMinute = DateUtils.getDiffMinute((Date)oldRequest.getDate("createtime"), (Date)queryRequestRecord.getDate("createtime"));
            int minute = TmcParameterHelper.getAppIntParameter((String)TmcAppEnum.BEI.getId(), (long)OrgUnitServiceHelper.getRootOrgId(), (String)"bei013");
            if (diffMinute > 30 && QueryRequestStatusEnum.NOSTART.getValue().equals(status) || diffMinute > minute && QueryRequestStatusEnum.QUERYING.getValue().equals(status)) {
                oldRequest.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                oldRequest.set("exception", (Object)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d85\u65f6\uff0c\u8d85\u65f6\u524d\u72b6\u6001\u4e3a\u3010%1$s\u3011,\u91cd\u8bd5\u8bf7\u6c42ID:%2$s\u3002", (String)"QueryRequestRecordHelper_0", (String)"tmc-bei-business", (Object[])new Object[0]), QueryRequestStatusEnum.getByValue((String)status).getName(), queryRequestRecord.getLong("requestid")));
                oldQueryRequestRecords.add(oldRequest);
                continue;
            }
            queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
            queryRequestRecord.set("exception", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728%1$s\u7684\u8bf7\u6c42ID:%2$s,\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"QueryRequestRecordHelper_1", (String)"tmc-bei-business", (Object[])new Object[0]), QueryRequestStatusEnum.getByValue((String)status).getName(), oldRequest.getLong("id")));
        }
        return oldQueryRequestRecords;
    }
}

