/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SmartRecPayHelper {
    public static void saveDetailReceredWayAndRuleNameApi(Object id, String receredWay, String ruleName) {
        DynamicObject transDetail = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas"));
        transDetail.set("receredway", (Object)receredWay);
        transDetail.set("rulename", (Object)ruleName);
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transDetail});
        }
    }

    public static void writeDetail(HashMap<Long, HashMap<String, Object>> recInfo) {
        List ids = recInfo.keySet().stream().collect(Collectors.toList());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas"));
        HashMap<Object, DynamicObject> dyMap = SmartRecPayHelper.getDyMap(dynamicObjects);
        if (dyMap == null || dyMap.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Object ruleName;
            AutoMatchHelper.deleteRecedBillEntry(dynamicObject);
            HashMap<String, Object> e = recInfo.get(dynamicObject.getPkValue());
            Object receredWay = e.get("ruleWay");
            dynamicObject.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
            if (EmptyUtil.isNoEmpty((Object)receredWay)) {
                dynamicObject.set("receredway", (Object)((String)receredWay));
            }
            if (EmptyUtil.isNoEmpty((Object)(ruleName = e.get("ruleName")))) {
                dynamicObject.set("rulename", (Object)((String)ruleName));
            }
            BigDecimal amt = BigDecimal.ZERO;
            String type = (String)e.get("way");
            String direction = "";
            if ("pay".equals(type)) {
                amt = dynamicObject.getBigDecimal("debitamount");
                direction = "pay";
            } else {
                amt = dynamicObject.getBigDecimal("creditamount");
                direction = "rec";
            }
            AutoMatchHelper.setRecedBillEntry(dynamicObject, (String)e.get("recedbilltype"), (String)e.get("recedbillnumber"), (Long)e.get("recedbillid"), (Long)e.get("recedbillentryid"), (String)e.get("amttype"), amt, (String)e.get("opnumber"), direction);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private static HashMap<Object, DynamicObject> getDyMap(DynamicObject[] dynamicObjects) {
        HashMap<Object, DynamicObject> dyMap = new HashMap<Object, DynamicObject>(4);
        for (DynamicObject dynamicObject : dynamicObjects) {
            dyMap.put(dynamicObject.getPkValue(), dynamicObject);
        }
        return dyMap;
    }

    public static Boolean saveDetailReceredWayAndRuleNameApiTest(Object id, String receredWay, String ruleName) {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject transDetail = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas"));
            transDetail.set("receredway", (Object)receredWay);
            transDetail.set("rulename", (Object)ruleName);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transDetail});
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static void setReceredWay(Object[] ids, String receredWay) {
        QFilter filter = new QFilter("id", "in", (Object)ids);
        Object[] transDetails = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id,receredway,rulename", (QFilter[])new QFilter[]{filter});
        if (!EmptyUtil.isEmpty((Object[])transDetails)) {
            for (Object transDetail : transDetails) {
                transDetail.set("receredway", (Object)receredWay);
                transDetail.set("rulename", null);
            }
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])transDetails);
            }
        }
    }

    public static void saveDetails(DynamicObject[] infos) {
        if (!EmptyUtil.isEmpty((Object[])infos) && infos.length > 0) {
            for (DynamicObject info : infos) {
                info.set("receredway", null);
            }
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])infos);
            }
        }
    }

    public static void saveDetail(DynamicObject info) {
        if (!EmptyUtil.isEmpty((DynamicObject)info)) {
            info.set("receredway", null);
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
            }
        }
    }

    public static void saveHandLinkDetail(DynamicObject[] infos, String billnos) {
        if (!EmptyUtil.isEmpty((Object[])infos) && infos.length > 0) {
            for (DynamicObject detail : infos) {
                detail.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
                detail.set("ishandlink", (Object)true);
                detail.set("receredway", (Object)ReceredWayEnum.HANDMATCH.getValue());
                detail.set("rulename", null);
            }
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])infos);
            }
        }
    }

    public static String dealBankcheckflag(String detailFlag, String bussFlag) {
        if (bussFlag != null) {
            if (bussFlag.equals(detailFlag)) {
                return null;
            }
            if (bussFlag.startsWith(detailFlag)) {
                return bussFlag.replace(detailFlag + ",", "");
            }
            if (bussFlag.contains(detailFlag)) {
                return bussFlag.replace("," + detailFlag, "");
            }
        }
        return bussFlag;
    }

    public static Map<String, HashSet<Long>> mergerMap(Map<String, HashSet<Long>> targetBills, Map<String, HashSet<Long>> newTargetBills) {
        HashMap<String, HashSet<Long>> returnMap = new HashMap<String, HashSet<Long>>();
        if (!EmptyUtil.isEmpty(newTargetBills) && newTargetBills.size() > 0) {
            for (Map.Entry<String, HashSet<Long>> setEntry : newTargetBills.entrySet()) {
                returnMap.put(setEntry.getKey(), setEntry.getValue());
            }
        }
        if (!EmptyUtil.isEmpty(targetBills) && targetBills.size() > 0) {
            for (Map.Entry<String, HashSet<Long>> setEntry : targetBills.entrySet()) {
                String key = setEntry.getKey();
                HashSet<Long> set = returnMap.get(key);
                if (EmptyUtil.isEmpty(set)) {
                    returnMap.put(key, setEntry.getValue());
                    continue;
                }
                set.addAll((Collection<Long>)setEntry.getValue());
                returnMap.put(key, set);
            }
        }
        return returnMap;
    }

    public static Set<Long> mergerSet(Set<Long> srcBillByDestBill, Set<Long> paysrcBillByDestBill, Set<Long> recsrcBillByDestBill) {
        HashSet<Long> set = new HashSet<Long>();
        if (!EmptyUtil.isEmpty(srcBillByDestBill)) {
            set.addAll(srcBillByDestBill);
        }
        if (!EmptyUtil.isEmpty(paysrcBillByDestBill)) {
            set.addAll(paysrcBillByDestBill);
        }
        if (!EmptyUtil.isEmpty(recsrcBillByDestBill)) {
            set.addAll(recsrcBillByDestBill);
        }
        return set;
    }
}

