/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.fbp.common.helper.BalanceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TransDetailHelper {
    private static final Log logger = LogFactory.getLog(TransDetailHelper.class);
    private static final String DETAILS_SELECT_PROPS = "id,creditamount,debitamount,bizdate,accountbank,currency,modifytime";
    private static final String BANKBANLANCE_SELECT_PROPS = "id,accountbank,currency,bizdate,amount,valibalance,lstbalance,datasource,modifytime";
    private static final String ACCOUNTBANK_SELECT_PROPS = "id,opendate,bankaccountnumber,currency,closedate,bank";
    private static final String CALCULATE_AMOUNT_FLAG = "0";
    private static final String CALCULATE_VALIBALANCE_FLAG = "1";
    private static final String CALCULATE_LSTBALANCE_FLA = "2";
    private static final int PERIOD = 90;

    public static boolean noneBusiness(DynamicObject object) {
        return !object.getBoolean("isdowntobankstate") && !object.getBoolean("isdownbankjournal") && CALCULATE_AMOUNT_FLAG.equals(object.getString("receredtype")) && !object.getBoolean("ismatchereceipt") && StringUtils.isBlank((CharSequence)object.getString("claimnoticebillno")) && !object.getBoolean("istransdown") && !object.getBoolean("istransup") && !object.getBoolean("isbankwithholding") && !object.getBoolean("isreced");
    }

    public static void detailGenerateBalance(Long companyId, List<Long> accountBankIds, String cycle, CountDownLatch countDownLatch, int i, Map<String, List<DynamicObject>> genBalanceLogGroupByAccCurr) {
        try {
            Date startDate = DateUtils.getCurrentDate();
            Date endDate = DateUtils.getCurrentDate();
            if (StringUtils.isNotEmpty((CharSequence)cycle)) {
                startDate = DateUtils.getLastDay((Date)startDate, (int)(Integer.parseInt(cycle) - 1));
            } else {
                cycle = CALCULATE_LSTBALANCE_FLA;
                startDate = DateUtils.getLastDay((Date)startDate, (int)(Integer.parseInt(cycle) - 1));
            }
            logger.info("TransDetailHelper\u7684\u5f00\u59cb\u65e5\u671f:{}", (Object)startDate);
            logger.info("TransDetailHelper\u7684\u7ed3\u675f\u65e5\u671f:{}", (Object)endDate);
            if (DateUtils.getDiffDays((Date)DateUtils.getDataFormat((Date)startDate, (boolean)true), (Date)DateUtils.getDataFormat((Date)endDate, (boolean)true)) > 90) {
                logger.info("TransDetailHelper\u7684\u5f00\u59cb\u65e5\u671fTime:{}", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime());
                logger.info("TransDetailHelper\u7684\u7ed3\u675f\u65e5\u671fTime:{}", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)true).getTime());
                throw new KDBizException(ResManager.loadKDString((String)"\u5386\u53f2\u8c03\u5ea6\u8ba1\u5212\u53ea\u80fd\u914d\u7f6e90\u5929\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"TransDetailHelper_01", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
            ArrayList<DynamicObject> addNewBanlanceList = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> updateOldBanlanceList = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> genBalanceLogList = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> addNewgenBalanceLogList = new ArrayList<DynamicObject>(16);
            Long threadStartTime = System.currentTimeMillis();
            logger.info("\u591a\u7ebf\u7a0b\u6279\u6b21=[{}]\uff0c\u5f00\u59cb\u6267\u884c\u3002\u3002\u3002", (Object)(i + 1));
            Date detailStartDay = DateUtils.getLastDay((Date)startDate, (int)(Integer.parseInt(cycle) - 1));
            QFilter transDetailQfilter = new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)detailStartDay, (boolean)true)).and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false))).and(new QFilter("accountbank", "in", accountBankIds));
            DynamicObject[] transDetails = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)DETAILS_SELECT_PROPS, (QFilter[])new QFilter[]{transDetailQfilter}, (String)"  bizdate asc ");
            LinkedHashMap transDetilsSortedGroupByAccCurrency = Arrays.stream(transDetails).sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.groupingBy(e -> e.getString("accountbank.bankaccountnumber") + "#" + e.getDynamicObject("currency").getString("number"), LinkedHashMap::new, Collectors.toList()));
            LinkedHashMap transDetilsSortedGroupByAccCurrDate = Arrays.stream(transDetails).sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.groupingBy(e -> DateUtils.getDataFormat((Date)e.getDate("bizdate"), (boolean)true).getTime() + "#" + e.getString("accountbank.bankaccountnumber") + "#" + e.getDynamicObject("currency").getString("number"), LinkedHashMap::new, Collectors.toList()));
            Date originalEndDate = endDate;
            QFilter accountBankQfilter = new QFilter("id", "in", accountBankIds);
            Map accountBanks = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)ACCOUNTBANK_SELECT_PROPS, (QFilter[])new QFilter[]{accountBankQfilter});
            block5: for (DynamicObject accountBank : accountBanks.values()) {
                String bankAccountNumber = accountBank.getString("bankaccountnumber");
                Long bankAccountId = accountBank.getLong("id");
                DynamicObjectCollection currencyCollection = accountBank.getDynamicObjectCollection("currency");
                Date bankAccountCloseDate = accountBank.getDate("closedate");
                if (bankAccountCloseDate != null && DateUtils.getDataFormat((Date)bankAccountCloseDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() >= 0L && DateUtils.getDataFormat((Date)bankAccountCloseDate, (boolean)false).getTime() - DateUtils.getDataFormat((Date)originalEndDate, (boolean)false).getTime() <= 0L) {
                    endDate = bankAccountCloseDate;
                }
                for (DynamicObject currencyData : currencyCollection) {
                    DynamicObject currency = currencyData.getDynamicObject("fbasedataid");
                    String currencyNumber = currency.getString("number");
                    String filterKey = bankAccountNumber + "#" + currencyNumber;
                    List<DynamicObject> genBalanceLogs = genBalanceLogGroupByAccCurr.get(filterKey);
                    if (genBalanceLogs != null && genBalanceLogs.size() > 0) {
                        Date balanceQueryStartTime = DateUtils.getLastDay((Date)startDate, (int)1);
                        QFilter inBankBanlanceQfilter = new QFilter("accountbank", "=", (Object)bankAccountId);
                        inBankBanlanceQfilter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)balanceQueryStartTime, (boolean)true)));
                        inBankBanlanceQfilter.and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
                        DynamicObject[] inPeriodBankBanlances = BusinessDataServiceHelper.load((String)"bei_bankbalance", (String)BANKBANLANCE_SELECT_PROPS, (QFilter[])new QFilter[]{inBankBanlanceQfilter}, (String)"  bizdate desc ");
                        TransDetailHelper.doWhenLogExist(accountBank, currency, startDate, endDate, companyId, genBalanceLogs, inPeriodBankBanlances, transDetails, transDetilsSortedGroupByAccCurrency, genBalanceLogGroupByAccCurr, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
                        continue;
                    }
                    Date bankBanlanceStartDate = DateUtils.getLastDay((Date)startDate, (int)Integer.parseInt(cycle));
                    QFilter ountBankBanlanceQfilter = new QFilter("accountbank", "=", (Object)bankAccountId);
                    ountBankBanlanceQfilter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)bankBanlanceStartDate, (boolean)true)));
                    ountBankBanlanceQfilter.and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
                    DynamicObject[] outPeriodBankBanlances = BusinessDataServiceHelper.load((String)"bei_bankbalance", (String)BANKBANLANCE_SELECT_PROPS, (QFilter[])new QFilter[]{ountBankBanlanceQfilter}, (String)"  bizdate desc ");
                    if (bankAccountCloseDate != null && DateUtils.getDataFormat((Date)bankAccountCloseDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L) continue block5;
                    TransDetailHelper.doWhenLogNotExist(accountBank, currency, startDate, endDate, companyId, outPeriodBankBanlances, transDetilsSortedGroupByAccCurrency, genBalanceLogGroupByAccCurr, transDetilsSortedGroupByAccCurrDate, updateOldBanlanceList, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
                }
            }
            logger.info("TransDetailHelper\u7684updateOldBanlanceList\uff1a{}", updateOldBanlanceList.toArray());
            logger.info("TransDetailHelper\u7684addNewBanlanceList\uff1a{}", addNewBanlanceList.toArray());
            logger.info("TransDetailHelper\u7684genBalanceLogList\uff1a{}", genBalanceLogList.toArray());
            logger.info("TransDetailHelper\u7684addNewgenBalanceLogList\uff1a{}", addNewgenBalanceLogList.toArray());
            if (updateOldBanlanceList.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])updateOldBanlanceList.toArray(new DynamicObject[0]));
            }
            if (addNewBanlanceList.size() > 0) {
                ArrayList updateEndBalances = new ArrayList(10);
                Map<String, List> groupedAndSorted = addNewBanlanceList.stream().collect(Collectors.groupingBy(balance -> balance.getLong("accountbank") + "#" + balance.getLong("currency"), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.toList()))));
                for (List balannces : groupedAndSorted.values()) {
                    List bizDates = balannces.stream().map(s -> s.getDate("bizdate")).collect(Collectors.toList());
                    for (int k = 0; k < balannces.size(); ++k) {
                        DynamicObject balannce = (DynamicObject)balannces.get(k);
                        long accountBankId = balannce.getLong("accountbank");
                        long currencyId = balannce.getLong("currency");
                        Date calEndDate = BalanceHelper.dealEndDate((int)k, bizDates, (Date)balannce.getDate("bizdate"), (Object)accountBankId, (Object)currencyId, updateEndBalances);
                        balannce.set("enddate", (Object)calEndDate);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])addNewBanlanceList.toArray(new DynamicObject[0]));
                if (updateEndBalances.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])updateEndBalances.toArray(new DynamicObject[0]));
                }
            }
            if (genBalanceLogList.size() > 0) {
                genBalanceLogList.forEach(e -> e.set("lastupdatetime", (Object)new Date()));
                genBalanceLogList.forEach(e -> e.set("deletetime", null));
                genBalanceLogList.forEach(e -> e.set("balancedeletetime", null));
                SaveServiceHelper.save((DynamicObject[])genBalanceLogList.toArray(new DynamicObject[0]));
            }
            if (addNewgenBalanceLogList.size() > 0) {
                Date finalStartDate = startDate;
                addNewgenBalanceLogList.forEach(e -> e.set("initdate", (Object)finalStartDate));
                addNewgenBalanceLogList.forEach(e -> e.set("lastupdatetime", (Object)new Date()));
                SaveServiceHelper.save((DynamicObject[])addNewgenBalanceLogList.toArray(new DynamicObject[0]));
            }
            logger.info("\u591a\u7ebf\u7a0b\u6279\u6b21=[{}]\uff0c\u6267\u884c\u7ed3\u675f\uff0c\u8017\u65f6=[{}]", (Object)(i + 1), (Object)(System.currentTimeMillis() - threadStartTime));
        }
        catch (Exception e2) {
            logger.info("\u7ec4\u7ec7ID\uff1a{}\uff0cdetailGenerateBalance\u6267\u884c\u5f02\u5e38:{}", (Object)companyId, (Object)e2);
            throw new KDBizException(e2.getMessage());
        }
        finally {
            countDownLatch.countDown();
        }
    }

    private static void doWhenLogExist(DynamicObject accountBank, DynamicObject currency, Date startDate, Date endDate, Long companyId, List<DynamicObject> genBalanceLogs, DynamicObject[] inPeriodBankBanlances, DynamicObject[] transDetails, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrency, Map<String, List<DynamicObject>> genBalanceLogGroupByAccCurr, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrDate, List<DynamicObject> addNewBanlanceList, List<DynamicObject> genBalanceLogList, List<DynamicObject> addNewgenBalanceLogList) {
        DynamicObject preBankBalance;
        Date calDate;
        Date compareDate;
        String bankAccountNumber = accountBank.getString("bankaccountnumber");
        Long bankAccountId = accountBank.getLong("id");
        String currencyNumber = currency.getString("number");
        Long currencyId = currency.getLong("id");
        String filterKey = bankAccountNumber + "#" + currencyNumber;
        DynamicObject genBalanceLog = genBalanceLogs.get(0);
        Date logLastUpdateTime = genBalanceLog.getDate("lastupdatetime");
        Date logInitDate = genBalanceLog.getDate("initdate");
        Date genBalanceLogDeletetime = genBalanceLog.getDate("deletetime");
        Date logBalanceDeleteTime = genBalanceLog.getDate("balancedeletetime");
        logger.info("\u5b58\u5728\u65e5\u5fd7\u8bb0\u5f55\u7684logLastUpdateTime:{}", (Object)logLastUpdateTime);
        LinkedHashMap bankBanlanceGroupAccountCurrDateSortedByDate = Arrays.stream(inPeriodBankBanlances).sorted(Comparator.comparing(t -> t.getDate("bizdate"), Comparator.reverseOrder())).collect(Collectors.groupingBy(e -> DateUtils.getDataFormat((Date)e.getDate("bizdate"), (boolean)true).getTime() + "#" + e.getString("accountbank.bankaccountnumber") + "#" + e.getDynamicObject("currency").getString("number"), LinkedHashMap::new, Collectors.toList()));
        List afterLogLastUpdateTimeDetails = Arrays.stream(transDetails).filter(e -> e.getString("accountbank.bankaccountnumber").equals(bankAccountNumber) && e.getDynamicObject("currency").getString("number").equals(currencyNumber) && e.getDate("modifytime").getTime() - logLastUpdateTime.getTime() > 0L && DateUtils.getDataFormat((Date)e.getDate("bizdate"), (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() >= 0L && DateUtils.getDataFormat((Date)e.getDate("bizdate"), (boolean)false).getTime() - DateUtils.getDataFormat((Date)endDate, (boolean)false).getTime() <= 0L).sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.toList());
        List afterLogLastUpdateTimeBalances = Arrays.stream(inPeriodBankBanlances).filter(e -> bankAccountNumber.equals(e.getString("accountbank.bankaccountnumber")) && e.getDynamicObject("currency").getString("number").equals(currencyNumber) && e.getDate("modifytime").getTime() - logLastUpdateTime.getTime() > 0L && DateUtils.getDataFormat((Date)e.getDate("bizdate"), (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() >= 0L && DateUtils.getDataFormat((Date)e.getDate("bizdate"), (boolean)false).getTime() - DateUtils.getDataFormat((Date)endDate, (boolean)false).getTime() <= 0L).sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.toList());
        Date minDetailsBizDate = compareDate = DateUtils.getNextDay((Date)new Date(), (int)1);
        Date minBalanceBizDate = compareDate;
        if (afterLogLastUpdateTimeDetails.size() > 0) {
            minDetailsBizDate = ((DynamicObject)afterLogLastUpdateTimeDetails.get(0)).getDate("bizdate");
        }
        if (afterLogLastUpdateTimeBalances.size() > 0) {
            minBalanceBizDate = ((DynamicObject)afterLogLastUpdateTimeBalances.get(0)).getDate("bizdate");
        }
        List<DynamicObject> accCurrencyTransDetails = transDetilsSortedGroupByAccCurrency.get(filterKey);
        LinkedHashMap detailsGroupByAccCurrSortedDate = new LinkedHashMap(16);
        if (accCurrencyTransDetails != null) {
            detailsGroupByAccCurrSortedDate = accCurrencyTransDetails.stream().sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.groupingBy(r -> DateUtils.getDataFormat((Date)r.getDate("bizdate"), (boolean)true).getTime(), LinkedHashMap::new, Collectors.toList()));
        }
        boolean detailDeleteFlag = genBalanceLogDeletetime != null && genBalanceLogDeletetime.getTime() - logLastUpdateTime.getTime() <= 0L;
        boolean balanceDeleteFlag = logBalanceDeleteTime != null && logBalanceDeleteTime.getTime() - logLastUpdateTime.getTime() <= 0L;
        Date finalMumDate = null;
        if (compareDate.compareTo(minDetailsBizDate) == 0 && compareDate.compareTo(minBalanceBizDate) == 0) {
            if (detailDeleteFlag || balanceDeleteFlag) {
                if (detailDeleteFlag && balanceDeleteFlag) {
                    Date minDate = genBalanceLogDeletetime.getTime() - logBalanceDeleteTime.getTime() <= 0L ? genBalanceLogDeletetime : logBalanceDeleteTime;
                    finalMumDate = DateUtils.getDataFormat((Date)minDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L ? DateUtils.getNextDay((Date)logLastUpdateTime, (int)1) : minDate;
                } else if (detailDeleteFlag) {
                    finalMumDate = DateUtils.getDataFormat((Date)genBalanceLogDeletetime, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L ? DateUtils.getNextDay((Date)logLastUpdateTime, (int)1) : genBalanceLogDeletetime;
                } else {
                    Date date = finalMumDate = DateUtils.getDataFormat((Date)logBalanceDeleteTime, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L ? DateUtils.getNextDay((Date)logLastUpdateTime, (int)1) : logBalanceDeleteTime;
                }
                if (DateUtils.getDataFormat((Date)finalMumDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)endDate, (boolean)true).getTime() > 0L) {
                    finalMumDate = endDate;
                }
                calDate = finalMumDate;
                preBankBalance = TransDetailHelper.getPreBankBalance(calDate, bankBanlanceGroupAccountCurrDateSortedByDate, bankAccountNumber, currencyNumber);
            } else {
                List bankBanlanceList;
                preBankBalance = bankBanlanceGroupAccountCurrDateSortedByDate == null || bankBanlanceGroupAccountCurrDateSortedByDate.size() == 0 ? TransDetailHelper.newBalanceWithZeroValue() : ((bankBanlanceList = (List)bankBanlanceGroupAccountCurrDateSortedByDate.get(DateUtils.getDataFormat((Date)logLastUpdateTime, (boolean)true).getTime() + "#" + bankAccountNumber + "#" + currencyNumber)) == null || bankBanlanceList.size() == 0 ? TransDetailHelper.newBalanceWithZeroValue() : (DynamicObject)bankBanlanceList.get(0));
                calDate = DateUtils.getNextDay((Date)logLastUpdateTime, (int)1);
            }
        } else if (DateUtils.getDataFormat((Date)minDetailsBizDate, (boolean)true).getTime() <= DateUtils.getDataFormat((Date)logLastUpdateTime, (boolean)true).getTime() || DateUtils.getDataFormat((Date)minBalanceBizDate, (boolean)true).getTime() < DateUtils.getDataFormat((Date)logLastUpdateTime, (boolean)true).getTime()) {
            if (detailDeleteFlag || balanceDeleteFlag) {
                if (detailDeleteFlag && balanceDeleteFlag) {
                    Date finalTempDate;
                    Date minDeleteDate = genBalanceLogDeletetime.getTime() - logBalanceDeleteTime.getTime() <= 0L ? genBalanceLogDeletetime : logBalanceDeleteTime;
                    Date minModifyDate = DateUtils.getDataFormat((Date)minDetailsBizDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)minBalanceBizDate, (boolean)true).getTime() <= 0L ? minDetailsBizDate : minBalanceBizDate;
                    Date tempDate = minDeleteDate.getTime() - minModifyDate.getTime() <= 0L ? minDeleteDate : minModifyDate;
                    Date date = finalTempDate = DateUtils.getDataFormat((Date)tempDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L ? DateUtils.getNextDay((Date)logLastUpdateTime, (int)1) : tempDate;
                    if (finalTempDate.getTime() - minDetailsBizDate.getTime() == 0L || finalTempDate.getTime() - genBalanceLogDeletetime.getTime() == 0L || finalTempDate.getTime() - logBalanceDeleteTime.getTime() == 0L) {
                        finalMumDate = finalTempDate;
                    } else if (finalTempDate.getTime() - minBalanceBizDate.getTime() == 0L) {
                        finalMumDate = DateUtils.getNextDay((Date)finalTempDate, (int)1);
                    }
                } else if (detailDeleteFlag) {
                    Date minModifyDate = DateUtils.getDataFormat((Date)minDetailsBizDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)minBalanceBizDate, (boolean)true).getTime() <= 0L ? minDetailsBizDate : minBalanceBizDate;
                    Date minTempDate = DateUtils.getDataFormat((Date)genBalanceLogDeletetime, (boolean)true).getTime() - DateUtils.getDataFormat((Date)minModifyDate, (boolean)true).getTime() <= 0L ? genBalanceLogDeletetime : minModifyDate;
                    finalMumDate = DateUtils.getDataFormat((Date)minTempDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L ? DateUtils.getNextDay((Date)logLastUpdateTime, (int)1) : minTempDate;
                } else {
                    Date minModifyDate = DateUtils.getDataFormat((Date)minDetailsBizDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)minBalanceBizDate, (boolean)true).getTime() <= 0L ? minDetailsBizDate : minBalanceBizDate;
                    Date minTempDate = DateUtils.getDataFormat((Date)logBalanceDeleteTime, (boolean)true).getTime() - DateUtils.getDataFormat((Date)minModifyDate, (boolean)true).getTime() <= 0L ? logBalanceDeleteTime : minModifyDate;
                    Date date = finalMumDate = DateUtils.getDataFormat((Date)minTempDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L ? DateUtils.getNextDay((Date)logLastUpdateTime, (int)1) : minTempDate;
                }
                if (DateUtils.getDataFormat((Date)finalMumDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)endDate, (boolean)true).getTime() > 0L) {
                    finalMumDate = endDate;
                }
                calDate = finalMumDate;
            } else {
                calDate = DateUtils.getDataFormat((Date)minDetailsBizDate, (boolean)true).getTime() <= DateUtils.getDataFormat((Date)minBalanceBizDate, (boolean)true).getTime() ? minDetailsBizDate : DateUtils.getNextDay((Date)minBalanceBizDate, (int)1);
            }
            preBankBalance = TransDetailHelper.getPreBankBalance(calDate, bankBanlanceGroupAccountCurrDateSortedByDate, bankAccountNumber, currencyNumber);
        } else if (detailDeleteFlag || balanceDeleteFlag) {
            if (detailDeleteFlag && balanceDeleteFlag) {
                Date minDate = genBalanceLogDeletetime.getTime() - logBalanceDeleteTime.getTime() <= 0L ? genBalanceLogDeletetime : logBalanceDeleteTime;
                finalMumDate = DateUtils.getDataFormat((Date)minDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L ? DateUtils.getNextDay((Date)logLastUpdateTime, (int)1) : minDate;
            } else if (detailDeleteFlag) {
                finalMumDate = DateUtils.getDataFormat((Date)genBalanceLogDeletetime, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L ? DateUtils.getNextDay((Date)logLastUpdateTime, (int)1) : genBalanceLogDeletetime;
            } else {
                Date date = finalMumDate = DateUtils.getDataFormat((Date)logBalanceDeleteTime, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L ? DateUtils.getNextDay((Date)logLastUpdateTime, (int)1) : logBalanceDeleteTime;
            }
            if (DateUtils.getDataFormat((Date)finalMumDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)endDate, (boolean)true).getTime() > 0L) {
                finalMumDate = endDate;
            }
            calDate = finalMumDate;
            preBankBalance = TransDetailHelper.getPreBankBalance(calDate, bankBanlanceGroupAccountCurrDateSortedByDate, bankAccountNumber, currencyNumber);
        } else {
            calDate = DateUtils.getNextDay((Date)logLastUpdateTime, (int)1);
            List bankBanlanceList = (List)bankBanlanceGroupAccountCurrDateSortedByDate.get(DateUtils.getDataFormat((Date)logLastUpdateTime, (boolean)true).getTime() + "#" + bankAccountNumber + "#" + currencyNumber);
            preBankBalance = (DynamicObject)bankBanlanceList.get(0);
        }
        if (logInitDate != null && DateUtils.getDataFormat((Date)logInitDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)calDate, (boolean)true).getTime() == 0L) {
            calDate = DateUtils.getNextDay((Date)calDate, (int)1);
            preBankBalance = bankBanlanceGroupAccountCurrDateSortedByDate == null || bankBanlanceGroupAccountCurrDateSortedByDate.size() == 0 ? TransDetailHelper.newBalanceWithZeroValue() : TransDetailHelper.getPreBankBalance(calDate, bankBanlanceGroupAccountCurrDateSortedByDate, bankAccountNumber, currencyNumber);
        }
        TransDetailHelper.deleteBalance(bankAccountId, currencyId, calDate, endDate, null);
        TransDetailHelper.calculateBalance(genBalanceLogGroupByAccCurr, detailsGroupByAccCurrSortedDate, calDate, endDate, accountBank, currency, companyId, preBankBalance, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
    }

    private static DynamicObject getPreBankBalance(Date finalMumDate, LinkedHashMap<String, List<DynamicObject>> bankBanlanceGroupAccountCurrDateSortedByDate, String bankAccountNumber, String currencyNumber) {
        Date beforeDate = DateUtils.getLastDay((Date)finalMumDate, (int)1);
        List<DynamicObject> banlanceLogDeleteBeforeBalanceList = bankBanlanceGroupAccountCurrDateSortedByDate.get(DateUtils.getDataFormat((Date)beforeDate, (boolean)true).getTime() + "#" + bankAccountNumber + "#" + currencyNumber);
        if (banlanceLogDeleteBeforeBalanceList == null || banlanceLogDeleteBeforeBalanceList.size() == 0) {
            return TransDetailHelper.newBalanceWithZeroValue();
        }
        return banlanceLogDeleteBeforeBalanceList.get(0);
    }

    private static void doWhenLogNotExist(DynamicObject accountBank, DynamicObject currency, Date startDate, Date endDate, Long companyId, DynamicObject[] outPeriodBankBanlances, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrency, Map<String, List<DynamicObject>> genBalanceLogGroupByAccCurr, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrDate, List<DynamicObject> updateOldBanlanceList, List<DynamicObject> addNewBanlanceList, List<DynamicObject> genBalanceLogList, List<DynamicObject> addNewgenBalanceLogList) {
        Date bankAccountOpenDate = accountBank.getDate("opendate");
        String bankAccountNumber = accountBank.getString("bankaccountnumber");
        Long bankAccountId = accountBank.getLong("id");
        DynamicObject bank = accountBank.getDynamicObject("bank");
        Long bankId = EmptyUtil.isEmpty((DynamicObject)bank) ? 0L : bank.getLong("id");
        String currencyNumber = currency.getString("number");
        Long currencyId = currency.getLong("id");
        String filterKey = bankAccountNumber + "#" + currencyNumber;
        Date finalStartDate1 = startDate;
        Set subBetweenBalance = Arrays.stream(outPeriodBankBanlances).filter(e -> e.getDate("bizdate").getTime() - DateUtils.getDataFormat((Date)finalStartDate1, (boolean)true).getTime() >= 0L && e.getDate("bizdate").getTime() - DateUtils.getDataFormat((Date)endDate, (boolean)false).getTime() <= 0L).collect(Collectors.toSet());
        LinkedHashMap subBetweenBalanceGroupAccountCurrencySortedByDate = subBetweenBalance.stream().sorted(Comparator.comparing(t -> t.getDate("bizdate"), Comparator.reverseOrder())).collect(Collectors.groupingBy(e -> e.getString("accountbank.bankaccountnumber") + "#" + e.getDynamicObject("currency").getString("number"), LinkedHashMap::new, Collectors.toList()));
        LinkedHashMap bankBanlanceGroupAccountCurrencySortedByDate = Arrays.stream(outPeriodBankBanlances).sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.groupingBy(e -> e.getString("accountbank.bankaccountnumber") + "#" + e.getDynamicObject("currency").getString("number"), LinkedHashMap::new, Collectors.toList()));
        if (DateUtils.getDataFormat((Date)bankAccountOpenDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() >= 0L) {
            Set subBetweenOpenEndBalances = Arrays.stream(outPeriodBankBanlances).filter(e -> DateUtils.getDataFormat((Date)e.getDate("bizdate"), (boolean)true).getTime() - DateUtils.getDataFormat((Date)bankAccountOpenDate, (boolean)true).getTime() >= 0L && DateUtils.getDataFormat((Date)e.getDate("bizdate"), (boolean)false).getTime() - DateUtils.getDataFormat((Date)endDate, (boolean)false).getTime() <= 0L).collect(Collectors.toSet());
            List subBetweenOpenEndBalanceList = subBetweenOpenEndBalances.stream().filter(e -> bankAccountNumber.equals(e.getString("accountbank.bankaccountnumber")) && e.getDynamicObject("currency").getString("number").equals(currencyNumber) && (e.getBigDecimal("amount") != null || e.getBigDecimal("valibalance") != null || e.getBigDecimal("lstbalance") != null)).sorted(Comparator.comparing(e -> e.getDate("bizdate"))).collect(Collectors.toList());
            List<DynamicObject> accCurrencyTransDetails = transDetilsSortedGroupByAccCurrency.get(filterKey);
            LinkedHashMap detailsGroupByAccCurrSortedDate = new LinkedHashMap(16);
            if (accCurrencyTransDetails != null) {
                detailsGroupByAccCurrSortedDate = accCurrencyTransDetails.stream().sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.groupingBy(r -> DateUtils.getDataFormat((Date)r.getDate("bizdate"), (boolean)true).getTime(), LinkedHashMap::new, Collectors.toList()));
            }
            if (subBetweenOpenEndBalanceList.size() > 0) {
                DynamicObject miniMumBalance = (DynamicObject)subBetweenOpenEndBalanceList.get(0);
                Date miniMumBizDate = miniMumBalance.getDate("bizdate");
                TransDetailHelper.completeEarlistBalance(bankAccountNumber, currencyNumber, miniMumBalance, transDetilsSortedGroupByAccCurrDate, updateOldBanlanceList);
                if (subBetweenOpenEndBalanceList.size() > 1) {
                    TransDetailHelper.deleteBalance(bankAccountId, currencyId, bankAccountOpenDate, endDate, miniMumBizDate);
                }
                Date lastDay = DateUtils.getLastDay((Date)miniMumBizDate, (int)1);
                TransDetailHelper.calculateBalanceReverseOrder(detailsGroupByAccCurrSortedDate, lastDay, bankAccountOpenDate, companyId, bankAccountId, currencyId, bankId, miniMumBalance, addNewBanlanceList);
                Date nextDay = DateUtils.getNextDay((Date)miniMumBizDate, (int)1);
                TransDetailHelper.calculateBalance(genBalanceLogGroupByAccCurr, detailsGroupByAccCurrSortedDate, nextDay, endDate, accountBank, currency, companyId, miniMumBalance, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
            } else {
                DynamicObject preBalance = BusinessDataServiceHelper.newDynamicObject((String)"bei_bankbalance");
                preBalance.set("amount", (Object)BigDecimal.ZERO);
                preBalance.set("valibalance", (Object)BigDecimal.ZERO);
                preBalance.set("lstbalance", (Object)BigDecimal.ZERO);
                TransDetailHelper.deleteBalance(bankAccountId, currencyId, bankAccountOpenDate, endDate, null);
                TransDetailHelper.calculateBalance(genBalanceLogGroupByAccCurr, detailsGroupByAccCurrSortedDate, bankAccountOpenDate, endDate, accountBank, currency, companyId, preBalance, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
            }
        } else {
            List subBetweenBalanceList = (List)subBetweenBalanceGroupAccountCurrencySortedByDate.get(filterKey);
            if (subBetweenBalanceList != null && subBetweenBalanceList.size() > 0) {
                List streamBalanceData = subBetweenBalanceList.stream().filter(e -> e.getBigDecimal("amount") == null && e.getBigDecimal("valibalance") == null && e.getBigDecimal("lstbalance") == null).collect(Collectors.toList());
                if (subBetweenBalanceList.size() == streamBalanceData.size()) {
                    TransDetailHelper.calDataWithoutBalances(genBalanceLogGroupByAccCurr, filterKey, bankBanlanceGroupAccountCurrencySortedByDate, transDetilsSortedGroupByAccCurrency, startDate, endDate, accountBank, currency, companyId, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
                } else {
                    List<DynamicObject> accCurrencyTransDetails = transDetilsSortedGroupByAccCurrency.get(filterKey);
                    LinkedHashMap detailsGroupByAccCurrSortedDate = new LinkedHashMap(16);
                    if (accCurrencyTransDetails != null) {
                        detailsGroupByAccCurrSortedDate = accCurrencyTransDetails.stream().sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.groupingBy(r -> DateUtils.getDataFormat((Date)r.getDate("bizdate"), (boolean)true).getTime(), LinkedHashMap::new, Collectors.toList()));
                    }
                    LinkedHashMap balanceOrderByDate = subBetweenBalanceList.stream().filter(e -> e.getBigDecimal("amount") != null || e.getBigDecimal("valibalance") != null || e.getBigDecimal("lstbalance") != null).sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.groupingBy(e -> e.getDate("bizdate"), LinkedHashMap::new, Collectors.toList()));
                    Optional balances = balanceOrderByDate.values().stream().findFirst();
                    DynamicObject earliestBalance = (DynamicObject)((List)balances.get()).get(0);
                    Date earliestBalanceBizdate = earliestBalance.getDate("bizdate");
                    TransDetailHelper.completeEarlistBalance(bankAccountNumber, currencyNumber, earliestBalance, transDetilsSortedGroupByAccCurrDate, updateOldBanlanceList);
                    if (balanceOrderByDate.size() > 0) {
                        TransDetailHelper.deleteBalance(bankAccountId, currencyId, startDate, endDate, earliestBalanceBizdate);
                    }
                    Date beforeBizdate = DateUtils.getLastDay((Date)earliestBalanceBizdate, (int)1);
                    TransDetailHelper.calculateBalanceReverseOrder(detailsGroupByAccCurrSortedDate, beforeBizdate, startDate, companyId, bankAccountId, currencyId, bankId, earliestBalance, addNewBanlanceList);
                    Date afterBizdate = DateUtils.getNextDay((Date)earliestBalanceBizdate, (int)1);
                    TransDetailHelper.calculateBalance(genBalanceLogGroupByAccCurr, detailsGroupByAccCurrSortedDate, afterBizdate, endDate, accountBank, currency, companyId, earliestBalance, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
                }
            } else {
                TransDetailHelper.calDataWithoutBalances(genBalanceLogGroupByAccCurr, filterKey, bankBanlanceGroupAccountCurrencySortedByDate, transDetilsSortedGroupByAccCurrency, startDate, endDate, accountBank, currency, companyId, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
            }
        }
    }

    private static DynamicObject newBalanceWithZeroValue() {
        DynamicObject preBankBalance = BusinessDataServiceHelper.newDynamicObject((String)"bei_bankbalance");
        preBankBalance.set("amount", (Object)BigDecimal.ZERO);
        preBankBalance.set("valibalance", (Object)BigDecimal.ZERO);
        preBankBalance.set("lstbalance", (Object)BigDecimal.ZERO);
        return preBankBalance;
    }

    private static void deleteBalance(Long bankAccountId, Long currencyId, Date startDate, Date endDate, Date noDeleteDate) {
        QFilter qFilter = new QFilter("accountbank", "=", (Object)bankAccountId);
        qFilter.and("currency", "=", (Object)currencyId);
        qFilter.and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true));
        qFilter.and("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false));
        if (EmptyUtil.isNoEmpty((Object)noDeleteDate)) {
            qFilter.and("bizdate", "!=", (Object)noDeleteDate);
        }
        DeleteServiceHelper.delete((String)"bei_bankbalance", (QFilter[])qFilter.toArray());
    }

    private static void completeEarlistBalance(String bankAccountNumber, String currencyNumber, DynamicObject earliestBalance, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrDate, List<DynamicObject> updateOldBanlanceList) {
        BigDecimal earlistAmount = earliestBalance.getBigDecimal("amount");
        BigDecimal earlistValibalance = earliestBalance.getBigDecimal("valibalance");
        BigDecimal earlistLstbalance = earliestBalance.getBigDecimal("lstbalance");
        Date earlistBizDate = earliestBalance.getDate("bizdate");
        String filterKey = DateUtils.getDataFormat((Date)earlistBizDate, (boolean)true).getTime() + "#" + bankAccountNumber + "#" + currencyNumber;
        BigDecimal totalCreditamount = BigDecimal.ZERO;
        BigDecimal totalDebitamount = BigDecimal.ZERO;
        List<DynamicObject> details = transDetilsSortedGroupByAccCurrDate.get(filterKey);
        if (details != null && details.size() > 0) {
            totalCreditamount = details.stream().map(e -> e.getBigDecimal("creditamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalDebitamount = details.stream().map(e -> e.getBigDecimal("debitamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (earlistAmount != null && earlistValibalance == null && earlistLstbalance == null) {
            earliestBalance.set("valibalance", (Object)earlistAmount);
            earliestBalance.set("lstbalance", (Object)earlistAmount.subtract(totalCreditamount).add(totalDebitamount));
        } else if (earlistAmount == null && earlistValibalance != null && earlistLstbalance == null) {
            earliestBalance.set("amount", (Object)earlistValibalance);
            earliestBalance.set("lstbalance", (Object)earlistValibalance.subtract(totalCreditamount).add(totalDebitamount));
        } else if (earlistAmount == null && earlistValibalance == null && earlistLstbalance != null) {
            earliestBalance.set("amount", (Object)earlistLstbalance.add(totalCreditamount).subtract(totalDebitamount));
            earliestBalance.set("valibalance", (Object)earlistLstbalance.add(totalCreditamount).subtract(totalDebitamount));
        } else if (earlistAmount != null && earlistValibalance != null && earlistLstbalance == null) {
            earliestBalance.set("lstbalance", (Object)earlistAmount.subtract(totalCreditamount).add(totalDebitamount));
        } else if (earlistAmount == null && earlistValibalance != null && earlistLstbalance != null) {
            earliestBalance.set("amount", (Object)earlistValibalance);
        } else if (earlistAmount != null && earlistValibalance == null && earlistLstbalance != null) {
            earliestBalance.set("valibalance", (Object)earlistAmount);
        }
        earliestBalance.set("bizdate", (Object)DateUtils.getDataFormat((Date)earlistBizDate, (boolean)true));
        updateOldBanlanceList.add(earliestBalance);
    }

    private static void calDataWithoutBalances(Map<String, List<DynamicObject>> genBalanceLogGroupByAccCurr, String filterKey, LinkedHashMap<String, List<DynamicObject>> bankBanlanceGroupAccountCurrencySortedByDate, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrency, Date startDate, Date endDate, DynamicObject accountBank, DynamicObject currency, Long companyId, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrDate, List<DynamicObject> addNewBanlanceList, List<DynamicObject> genBalanceLogList, List<DynamicObject> addNewgenBalanceLogList) {
        List<DynamicObject> preBankBalanceList = bankBanlanceGroupAccountCurrencySortedByDate.get(filterKey);
        List<DynamicObject> accCurrencyTransDetails = transDetilsSortedGroupByAccCurrency.get(filterKey);
        if (accCurrencyTransDetails != null && accCurrencyTransDetails.size() > 0) {
            TransDetailHelper.calBalance(genBalanceLogGroupByAccCurr, accCurrencyTransDetails, preBankBalanceList, startDate, endDate, accountBank, currency, companyId, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
        } else {
            ArrayList<DynamicObject> details = new ArrayList<DynamicObject>();
            TransDetailHelper.calBalance(genBalanceLogGroupByAccCurr, details, preBankBalanceList, startDate, endDate, accountBank, currency, companyId, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
        }
    }

    private static void calBalance(Map<String, List<DynamicObject>> genBalanceLogGroupByAccCurr, List<DynamicObject> accCurrencyTransDetails, List<DynamicObject> preBankBalanceList, Date startDate, Date endDate, DynamicObject accountBank, DynamicObject currency, Long companyId, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrDate, List<DynamicObject> addNewBanlanceList, List<DynamicObject> genBalanceLogList, List<DynamicObject> addNewgenBalanceLogList) {
        DynamicObject runBalance;
        LinkedHashMap details;
        DynamicObject preBalance = BusinessDataServiceHelper.newDynamicObject((String)"bei_bankbalance");
        preBalance.set("amount", (Object)BigDecimal.ZERO);
        preBalance.set("valibalance", (Object)BigDecimal.ZERO);
        preBalance.set("lstbalance", (Object)BigDecimal.ZERO);
        if (EmptyUtil.isEmpty(accCurrencyTransDetails)) {
            details = new LinkedHashMap();
            runBalance = EmptyUtil.isEmpty(preBankBalanceList) ? preBalance : preBankBalanceList.get(0);
        } else {
            details = accCurrencyTransDetails.stream().sorted(Comparator.comparing(t -> DateUtils.getDataFormat((Date)t.getDate("bizdate"), (boolean)true))).collect(Collectors.groupingBy(r -> DateUtils.getDataFormat((Date)r.getDate("bizdate"), (boolean)true).getTime(), LinkedHashMap::new, Collectors.toList()));
            runBalance = EmptyUtil.isEmpty(preBankBalanceList) ? preBalance : preBankBalanceList.get(0);
        }
        TransDetailHelper.calculateBalance(genBalanceLogGroupByAccCurr, details, startDate, endDate, accountBank, currency, companyId, runBalance, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
    }

    private static void calculateBalance(Map<String, List<DynamicObject>> genBalanceLogGroupByAccCurr, LinkedHashMap<Long, List<DynamicObject>> detailsGroupByAccCurrSortedDate, Date startDate, Date endDate, DynamicObject accountBank, DynamicObject currency, Long companyId, DynamicObject preBalance, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrDate, List<DynamicObject> addNewBanlanceList, List<DynamicObject> genBalanceLogList, List<DynamicObject> addNewgenBalanceLogList) {
        BigDecimal lstBalance;
        BigDecimal valiBalance;
        BigDecimal amount;
        String bankAccountNumber = accountBank.getString("bankaccountnumber");
        Long bankAccountId = accountBank.getLong("id");
        DynamicObject bank = accountBank.getDynamicObject("bank");
        Long bankId = EmptyUtil.isEmpty((DynamicObject)bank) ? 0L : bank.getLong("id");
        String currencyNumber = currency.getString("number");
        Long currencyId = currency.getLong("id");
        if (DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)endDate, (boolean)true).getTime() > 0L) {
            String filterKey = bankAccountNumber + "#" + currencyNumber;
            if (genBalanceLogGroupByAccCurr != null && genBalanceLogGroupByAccCurr.size() > 0) {
                List<DynamicObject> logList = genBalanceLogGroupByAccCurr.get(filterKey);
                if (logList == null || logList.size() == 0) {
                    DynamicObject newBalanceLog = BusinessDataServiceHelper.newDynamicObject((String)"bei_genbalance_log");
                    newBalanceLog.set("accountbank", (Object)bankAccountId);
                    newBalanceLog.set("currency", (Object)currencyId);
                    addNewgenBalanceLogList.add(newBalanceLog);
                } else {
                    genBalanceLogList.add(logList.get(0));
                }
            } else {
                DynamicObject newBalanceLog = BusinessDataServiceHelper.newDynamicObject((String)"bei_genbalance_log");
                newBalanceLog.set("accountbank", (Object)bankAccountId);
                newBalanceLog.set("currency", (Object)currencyId);
                addNewgenBalanceLogList.add(newBalanceLog);
            }
            return;
        }
        long currentDateMills = DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime();
        List<DynamicObject> currentDetails = detailsGroupByAccCurrSortedDate.get(currentDateMills);
        DynamicObject newBanlance = BusinessDataServiceHelper.newDynamicObject((String)"bei_bankbalance");
        newBanlance.set("company", (Object)companyId);
        newBanlance.set("accountbank", (Object)bankAccountId);
        newBanlance.set("bank", (Object)bankId);
        newBanlance.set("currency", (Object)currencyId);
        newBanlance.set("datasource", (Object)DataSourceEnum.FROMSCHEDULE.getValue());
        newBanlance.set("bizdate", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true));
        if (currentDetails != null && currentDetails.size() > 0) {
            BigDecimal totalCreditamount = currentDetails.stream().map(e -> e.getBigDecimal("creditamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalDebitamount = currentDetails.stream().map(e -> e.getBigDecimal("debitamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal other = totalCreditamount.subtract(totalDebitamount);
            amount = TransDetailHelper.calMoney(preBalance, bankAccountNumber, currencyNumber, other, CALCULATE_AMOUNT_FLAG, transDetilsSortedGroupByAccCurrDate);
            valiBalance = TransDetailHelper.calMoney(preBalance, bankAccountNumber, currencyNumber, other, CALCULATE_VALIBALANCE_FLAG, transDetilsSortedGroupByAccCurrDate);
            lstBalance = TransDetailHelper.calMoney(preBalance, bankAccountNumber, currencyNumber, other, CALCULATE_LSTBALANCE_FLA, transDetilsSortedGroupByAccCurrDate);
        } else {
            amount = TransDetailHelper.calMoney(preBalance, bankAccountNumber, currencyNumber, BigDecimal.ZERO, CALCULATE_AMOUNT_FLAG, transDetilsSortedGroupByAccCurrDate);
            valiBalance = TransDetailHelper.calMoney(preBalance, bankAccountNumber, currencyNumber, BigDecimal.ZERO, CALCULATE_VALIBALANCE_FLAG, transDetilsSortedGroupByAccCurrDate);
            lstBalance = TransDetailHelper.calMoney(preBalance, bankAccountNumber, currencyNumber, BigDecimal.ZERO, CALCULATE_LSTBALANCE_FLA, transDetilsSortedGroupByAccCurrDate);
        }
        newBanlance.set("amount", (Object)amount);
        newBanlance.set("valibalance", (Object)valiBalance);
        newBanlance.set("lstbalance", (Object)lstBalance);
        addNewBanlanceList.add(newBanlance);
        Date nextDate = DateUtils.getNextDay((Date)startDate, (int)1);
        TransDetailHelper.calculateBalance(genBalanceLogGroupByAccCurr, detailsGroupByAccCurrSortedDate, nextDate, endDate, accountBank, currency, companyId, newBanlance, transDetilsSortedGroupByAccCurrDate, addNewBanlanceList, genBalanceLogList, addNewgenBalanceLogList);
    }

    private static void calculateBalanceReverseOrder(LinkedHashMap<Long, List<DynamicObject>> detailsGroupByAccCurrSortedDate, Date beforeBizdate, Date startDate, Long companyId, Long bankAccountId, Long currencyId, Long bankId, DynamicObject preBalance, List<DynamicObject> addNewBanlanceList) {
        BigDecimal lstBalance;
        BigDecimal valiBalance;
        BigDecimal amount;
        if (DateUtils.getDataFormat((Date)beforeBizdate, (boolean)true).getTime() - DateUtils.getDataFormat((Date)startDate, (boolean)true).getTime() < 0L) {
            return;
        }
        Date calDate = DateUtils.getNextDay((Date)beforeBizdate, (int)1);
        long currentDateMills = DateUtils.getDataFormat((Date)calDate, (boolean)true).getTime();
        DynamicObject newBanlance = BusinessDataServiceHelper.newDynamicObject((String)"bei_bankbalance");
        newBanlance.set("company", (Object)companyId);
        newBanlance.set("accountbank", (Object)bankAccountId);
        newBanlance.set("bank", (Object)bankId);
        newBanlance.set("currency", (Object)currencyId);
        newBanlance.set("datasource", (Object)DataSourceEnum.FROMSCHEDULE.getValue());
        newBanlance.set("bizdate", (Object)DateUtils.getDataFormat((Date)beforeBizdate, (boolean)true));
        List<DynamicObject> currentDetails = detailsGroupByAccCurrSortedDate.get(currentDateMills);
        if (currentDetails != null && currentDetails.size() > 0) {
            BigDecimal totalCreditamount = currentDetails.stream().map(e -> e.getBigDecimal("creditamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalDebitamount = currentDetails.stream().map(e -> e.getBigDecimal("debitamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            amount = preBalance.getBigDecimal("amount").subtract(totalCreditamount).add(totalDebitamount);
            valiBalance = preBalance.getBigDecimal("valibalance").subtract(totalCreditamount).add(totalDebitamount);
            lstBalance = preBalance.getBigDecimal("lstbalance").subtract(totalCreditamount).add(totalDebitamount);
        } else {
            amount = preBalance.getBigDecimal("amount");
            valiBalance = preBalance.getBigDecimal("valibalance");
            lstBalance = preBalance.getBigDecimal("lstbalance");
        }
        newBanlance.set("amount", (Object)amount);
        newBanlance.set("valibalance", (Object)valiBalance);
        newBanlance.set("lstbalance", (Object)lstBalance);
        addNewBanlanceList.add(newBanlance);
        Date lastDate = DateUtils.getLastDay((Date)beforeBizdate, (int)1);
        TransDetailHelper.calculateBalanceReverseOrder(detailsGroupByAccCurrSortedDate, lastDate, startDate, companyId, bankAccountId, currencyId, bankId, newBanlance, addNewBanlanceList);
    }

    private static BigDecimal calMoney(DynamicObject preBalance, String bankAccountNumber, String currencyNumber, BigDecimal other, String flag, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrDate) {
        BigDecimal preLastAmount = preBalance.getBigDecimal("amount");
        BigDecimal preLastValiBalance = preBalance.getBigDecimal("valibalance");
        BigDecimal preLastLstbalance = preBalance.getBigDecimal("lstbalance");
        Date preLastDate = preBalance.getDate("bizdate");
        BigDecimal value = BigDecimal.ZERO;
        switch (flag) {
            case "0": {
                if (preLastAmount == null) {
                    if (preLastValiBalance == null) {
                        if (preLastDate == null) {
                            value = other;
                            break;
                        }
                        value = TransDetailHelper.getBalanceFromTransDetail(preLastDate, bankAccountNumber, currencyNumber, transDetilsSortedGroupByAccCurrDate, preLastLstbalance).add(other);
                        break;
                    }
                    value = preLastValiBalance.add(other);
                    break;
                }
                value = preLastAmount.add(other);
                break;
            }
            case "1": {
                if (preLastValiBalance == null) {
                    if (preLastAmount == null) {
                        if (preLastDate == null) {
                            value = other;
                            break;
                        }
                        value = TransDetailHelper.getBalanceFromTransDetail(preLastDate, bankAccountNumber, currencyNumber, transDetilsSortedGroupByAccCurrDate, preLastLstbalance).add(other);
                        break;
                    }
                    value = preLastAmount.add(other);
                    break;
                }
                value = preLastValiBalance.add(other);
                break;
            }
            case "2": {
                if (preLastAmount == null) {
                    if (preLastValiBalance == null) {
                        if (preLastDate == null) {
                            value = BigDecimal.ZERO;
                            break;
                        }
                        value = TransDetailHelper.getBalanceFromTransDetail(preLastDate, bankAccountNumber, currencyNumber, transDetilsSortedGroupByAccCurrDate, preLastLstbalance);
                        break;
                    }
                    value = preLastValiBalance;
                    break;
                }
                value = preLastAmount;
                break;
            }
        }
        return value;
    }

    private static BigDecimal getBalanceFromTransDetail(Date preLastDate, String bankAccountNumber, String currencyNumber, LinkedHashMap<String, List<DynamicObject>> transDetilsSortedGroupByAccCurrDate, BigDecimal preLastLstbalance) {
        String filterKey = DateUtils.getDataFormat((Date)preLastDate, (boolean)true).getTime() + "#" + bankAccountNumber + "#" + currencyNumber;
        List<DynamicObject> preBalanceDetails = transDetilsSortedGroupByAccCurrDate.get(filterKey);
        BigDecimal preTotalCreditamount = BigDecimal.ZERO;
        BigDecimal preTotalDebitamount = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty(preBalanceDetails)) {
            preTotalCreditamount = preBalanceDetails.stream().map(e -> e.getBigDecimal("creditamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            preTotalDebitamount = preBalanceDetails.stream().map(e -> e.getBigDecimal("debitamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return preLastLstbalance.add(preTotalCreditamount).subtract(preTotalDebitamount);
    }

    public static boolean updateSynonym(DynamicObject transDetail, long acctBankId, long companyId) {
        return TransDetailHelper.updateSynonym(transDetail, TmcDataServiceHelper.loadSingleFromCache((Object)acctBankId, (String)"bd_accountbanks"), TmcDataServiceHelper.loadSingleFromCache((Object)companyId, (String)"bos_org"));
    }

    public static boolean updateSynonym(DynamicObject transDetail, DynamicObject acctBank, DynamicObject company) {
        String companyName;
        String oppUnit = transDetail.getString("oppunit");
        String oppBankNumber = transDetail.getString("oppbanknumber");
        if (EmptyUtil.isNoEmpty((String)oppUnit)) {
            if (null != acctBank) {
                String openOrgName;
                String acctName = acctBank.getString("acctname");
                if (oppUnit.equals(acctName)) {
                    return true;
                }
                String string = openOrgName = EmptyUtil.isEmpty((DynamicObject)acctBank.getDynamicObject("openorg")) ? "" : acctBank.getDynamicObject("openorg").getString("name");
                if (oppUnit.equals(openOrgName)) {
                    return true;
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)company) && oppUnit.equals(companyName = company.getString("name"))) {
                return true;
            }
        }
        if (EmptyUtil.isNoEmpty((String)oppBankNumber) && EmptyUtil.isNoEmpty((DynamicObject)company)) {
            companyName = company.getString("name");
            DynamicObject oppAcctBank = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company.name", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)oppBankNumber)});
            if (EmptyUtil.isNoEmpty((DynamicObject)oppAcctBank)) {
                String applyComapny = oppAcctBank.getString("company.name");
                return companyName.equals(applyComapny);
            }
            QFilter filter = new QFilter("virtualentity.virtualaccount", "=", (Object)oppBankNumber);
            DynamicObject acctBankByVirtual = QueryServiceHelper.queryOne((String)"am_accountbank", (String)"company.name", (QFilter[])new QFilter[]{filter});
            if (EmptyUtil.isNoEmpty((DynamicObject)acctBankByVirtual)) {
                String applyComapny = acctBankByVirtual.getString("company.name");
                return companyName.equals(applyComapny);
            }
        }
        return false;
    }

    public static String getOppRelAcct(String oppBankNumber) {
        QFilter filter = new QFilter("virtualentity.virtualaccount", "=", (Object)oppBankNumber);
        filter.and(new QFilter("finorgtype", "=", (Object)"3"));
        filter.and(new QFilter("acctstatus", "!=", (Object)"closed"));
        DynamicObject acctBankByVirtual = QueryServiceHelper.queryOne((String)"am_accountbank", (String)"bankaccountnumber", (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isNoEmpty((DynamicObject)acctBankByVirtual)) {
            return acctBankByVirtual.getString("bankaccountnumber");
        }
        return " ";
    }
}

