/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.botp.helper.SystemStatusCtrolHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.helper.RecPayRuleHelper;
import kd.tmc.bei.business.helper.WorkBenchFillBill;
import kd.tmc.bei.common.helper.BeiBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class WorkBenchHelper {
    private static final Log LOGGER = LogFactory.getLog(WorkBenchHelper.class);

    public static Map<String, DynamicObject[]> getTargetBillByWay(Object[] selectedPks, String entity, String way, String target, boolean isThrowErr, OperationResult result) {
        Map<String, DynamicObject[]> targetBills = new HashMap<String, DynamicObject[]>(4);
        switch (way) {
            case "rule": {
                targetBills = WorkBenchHelper.createBusinessBillRule(selectedPks, entity, isThrowErr, result);
                break;
            }
            case "hand": {
                targetBills = WorkBenchHelper.createBusinessBillHand(selectedPks, entity, target);
            }
        }
        return targetBills;
    }

    private static List<DynamicObject> checkOrgIni(List<DynamicObject> srcBills, boolean isThrowErr, OperationResult result) {
        if (srcBills == null || srcBills.size() == 0) {
            return new ArrayList<DynamicObject>(16);
        }
        if (isThrowErr) {
            return srcBills;
        }
        HashSet<Long> orgIds = new HashSet<Long>(srcBills.size());
        HashSet<Long> orgIds_err = new HashSet<Long>(srcBills.size());
        ArrayList<DynamicObject> returns = new ArrayList<DynamicObject>(srcBills.size());
        for (DynamicObject srcBill : srcBills) {
            Long orgId = srcBill.getDynamicObject("company").getLong("id");
            if (orgIds.add(orgId)) {
                DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId);
                if (systemStatusCtrol == null || systemStatusCtrol.getDynamicObject("exratetable") == null) {
                    orgIds_err.add(orgId);
                    WorkBenchHelper.doException(srcBill, result);
                    continue;
                }
                returns.add(srcBill);
                continue;
            }
            if (orgIds_err.contains(orgId)) {
                WorkBenchHelper.doException(srcBill, result);
                continue;
            }
            returns.add(srcBill);
        }
        return returns;
    }

    public static Map<String, DynamicObject[]> createBusinessBillRule(Object[] selectedPks, String entity, boolean isThrowErr, OperationResult result) {
        LOGGER.info("createBusinessBillRule begin");
        DynamicObject[] transDetail = BusinessDataServiceHelper.load((Object[])Arrays.stream(selectedPks).map(p -> Long.valueOf(p.toString())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        String type = "rec";
        if ("bei_intelpay".equals(entity)) {
            type = "pay";
        }
        HashMap<Long, DynamicObject> detailMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject dynamicObject : transDetail) {
            detailMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        Map<Long, Pair<String, Map<String, Object>>> smp = RecPayRuleHelper.getBillNameByMatchRuleApiFill(selectedPks, type, isThrowErr, result);
        HashMap<Long, Map<String, Object>> fillMap = new HashMap<Long, Map<String, Object>>(4);
        HashMap listMap = new HashMap(4);
        for (Map.Entry entry : smp.entrySet()) {
            ArrayList dynamicObjects = (ArrayList)listMap.get(WorkBenchHelper.getEntityNameByString((String)((Pair)entry.getValue()).getLeft()));
            if (EmptyUtil.isEmpty((Collection)dynamicObjects)) {
                dynamicObjects = new ArrayList(8);
                dynamicObjects.add(detailMap.get(entry.getKey()));
            } else {
                dynamicObjects.add(detailMap.get(entry.getKey()));
            }
            fillMap.put((Long)entry.getKey(), (Map<String, Object>)((Pair)entry.getValue()).getRight());
            listMap.put(WorkBenchHelper.getEntityNameByString((String)((Pair)entry.getValue()).getLeft()), dynamicObjects);
        }
        HashMap<String, DynamicObject[]> targetBills = new HashMap<String, DynamicObject[]>(4);
        String string = "";
        LOGGER.info("[createBusinessBillRule]\u4e0b\u63a8\u5355\u636e\uff1a{}", listMap.keySet());
        if ("rec".equals(type)) {
            List<DynamicObject> bills_ok;
            if (EmptyUtil.isNoEmpty(listMap.get("cas_recbill")) && (bills_ok = WorkBenchHelper.checkOrgIni((List)listMap.get("cas_recbill"), isThrowErr, result)).size() > 0) {
                String string2 = WorkBenchHelper.getRuleIdByOP("bei_intelrec", "pushandsave");
                targetBills.put("cas_recbill", BeiBotpHelper.push((DynamicObject[])bills_ok.toArray(new DynamicObject[0]), (String)"cas_recbill", (String)string2));
            }
            if (EmptyUtil.isNoEmpty(listMap.get("fca_transupbill"))) {
                String string3 = WorkBenchHelper.getRuleIdByOP("bei_intelrec", "pushandsavefca");
                targetBills.put("fca_transupbill", BeiBotpHelper.push((DynamicObject[])((List)listMap.get("fca_transupbill")).toArray(new DynamicObject[0]), (String)"fca_transupbill", (String)string3));
            }
        } else {
            if (EmptyUtil.isNoEmpty(listMap.get("cas_paybill"))) {
                String string4 = WorkBenchHelper.getRuleIdByOP("bei_intelpay", "pushandsave");
                targetBills.put("cas_paybill", BeiBotpHelper.push((DynamicObject[])((List)listMap.get("cas_paybill")).toArray(new DynamicObject[0]), (String)"cas_paybill", (String)string4));
            }
            if (EmptyUtil.isNoEmpty(listMap.get("fca_transdownbill"))) {
                String string5 = WorkBenchHelper.getRuleIdByOP("bei_intelpay", "pushandsavefca");
                targetBills.put("fca_transdownbill", BeiBotpHelper.push((DynamicObject[])((List)listMap.get("fca_transdownbill")).toArray(new DynamicObject[0]), (String)"fca_transdownbill", (String)string5));
            }
        }
        return WorkBenchHelper.fillTargetBills(targetBills, fillMap);
    }

    private static String getRuleIdByOP(String entity, String opKey) {
        Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)entity, (String)opKey);
        Map opParameter = (Map)operateMetaMap.get("parameter");
        String ruleId = (String)opParameter.get("ruleid");
        if (StringUtils.equals((CharSequence)ruleId, (CharSequence)"@all")) {
            ruleId = "";
        }
        return ruleId;
    }

    private static Map<String, DynamicObject[]> fillTargetBills(Map<String, DynamicObject[]> targetBills, Map<Long, Map<String, Object>> fillMap) {
        HashMap<String, DynamicObject[]> stringHashMap = new HashMap<String, DynamicObject[]>(4);
        for (Map.Entry<String, DynamicObject[]> entry : targetBills.entrySet()) {
            DynamicObject[] dynamicObjects = entry.getValue();
            if (dynamicObjects == null || dynamicObjects.length == 0) continue;
            for (int i = 0; i < dynamicObjects.length; ++i) {
                Long sourceBillId = dynamicObjects[i].getLong("sourcebillid");
                Map<String, Object> fills = fillMap.get(sourceBillId);
                if (!EmptyUtil.isNoEmpty(fills)) continue;
                WorkBenchHelper.fillBillByRule(dynamicObjects[i], fills, entry.getKey());
            }
            stringHashMap.put(entry.getKey(), dynamicObjects);
        }
        return stringHashMap;
    }

    private static void fillBillByRule(DynamicObject dynamicObject, Map<String, Object> fills, String key) {
        if (fills == null || fills.isEmpty()) {
            return;
        }
        switch (key) {
            case "cas_recbill": {
                WorkBenchFillBill.setRecValueByRule(fills, dynamicObject);
                break;
            }
            case "cas_paybill": {
                WorkBenchFillBill.setPayValueByRule(fills, dynamicObject);
                break;
            }
            case "fca_transdownbill": 
            case "fca_transupbill": {
                WorkBenchFillBill.setTransBillValue(fills, dynamicObject);
            }
        }
        DynamicObjectCollection billConFieldConfigs = QueryServiceHelper.query((String)"cas_billconvertfieldcfg", (String)"billtype, datatype, tarfieldname", null);
        billConFieldConfigs.stream().filter(billConFieldConfig -> {
            String billtype = billConFieldConfig.getString("billtype");
            if ("recvbill".equals(billtype)) {
                billtype = billtype.replace("v", "");
            }
            return EmptyUtil.isNoEmpty((String)key) && key.contains(billtype);
        }).forEach(billConFieldConfig -> {
            String tarfieldname = billConFieldConfig.getString("tarfieldname");
            if (dynamicObject.containsProperty(tarfieldname)) {
                dynamicObject.set(tarfieldname, fills.get(tarfieldname));
            }
        });
    }

    public static Map<String, DynamicObject[]> createBusinessBillHand(Object[] selectedPks, String entity, String targetEntity) {
        targetEntity = WorkBenchHelper.getEntityNameByString(targetEntity);
        DynamicObject[] transDetail = BusinessDataServiceHelper.load((Object[])Arrays.stream(selectedPks).map(p -> Long.valueOf(p.toString())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        HashMap<String, DynamicObject[]> targetBills = new HashMap<String, DynamicObject[]>(4);
        String ruleId = "";
        String opKey = "";
        opKey = "cas_recbill".equals(targetEntity) || "cas_paybill".equals(targetEntity) ? "pushandsave" : "pushandsavefca";
        ruleId = "cas_paybill".equals(targetEntity) || "fca_transdownbill".equals(targetEntity) ? WorkBenchHelper.getRuleIdByOP("bei_intelpay", opKey) : WorkBenchHelper.getRuleIdByOP("bei_intelrec", opKey);
        targetBills.put(targetEntity, BeiBotpHelper.push((DynamicObject[])transDetail, (String)targetEntity, (String)ruleId));
        return targetBills;
    }

    private static String getEntityNameByString(String type) {
        switch (type) {
            case "rec": 
            case "recbill": {
                return "cas_recbill";
            }
            case "pay": 
            case "paybill": {
                return "cas_paybill";
            }
            case "downbill": {
                return "fca_transdownbill";
            }
            case "upbill": {
                return "fca_transupbill";
            }
        }
        return null;
    }

    private static void doException(DynamicObject detailDO, OperationResult result) {
        LOGGER.info("WorkBenchHelper.doException");
        String errorStr = String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011\u4e0a\u7684\u8d44\u91d1\u7ec4\u7ec7\u6ca1\u6709\u7ed3\u675f\u521d\u59cb\u5316", (String)"WorkBenchHelper_01", (String)"tmc-bei-business", (Object[])new Object[0]), detailDO.getString("billno"));
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(detailDO.getPkValue());
        operateErrorInfo.setMessage(errorStr);
        result.addErrorInfo(operateErrorInfo);
    }
}

