/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ocr.impl;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.ocr.api.ScanService;
import kd.tmc.bei.common.scan.ScanResponse;
import kd.tmc.bei.common.scan.ScanResponseData;
import kd.tmc.bei.common.scan.ScanTokenRequest;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.service.ebservice.errorcode.ErrorCodeUtils;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class ScanServiceImpl
implements ScanService {
    private static final Log logger = LogFactory.getLog(ScanServiceImpl.class);
    private static DistributeSessionlessCache cache = TmcCacheHelper.getSessionlessCacheInstance();
    private static final int TOKEN_TIMEOUT_MINUTES_HOUR = 2;

    @Override
    public String getScanSystem(String clientId, String clientSercet, String url, String phone) {
        return this.getPageUrl(clientId, clientSercet, url, phone);
    }

    private static String getTokenRequestBody(String clientId, String clientSercet, String phone) {
        StringBuilder sb = new StringBuilder();
        long currentTimeMillis = System.currentTimeMillis();
        String timestamp = String.valueOf(currentTimeMillis);
        sb.append(clientId);
        sb.append(clientSercet);
        sb.append(timestamp);
        String sign = DigestUtils.md5Hex((String)sb.toString());
        ScanTokenRequest request = new ScanTokenRequest();
        request.setClientId(clientId);
        request.setSign(sign);
        request.setTimestamp(Long.valueOf(currentTimeMillis));
        request.setFphoneNumber(phone);
        request.setLanguage("zh-CN");
        String jsonBody = JSON.toJSONString((Object)request);
        return jsonBody;
    }

    private String getPageUrl(String clientId, String clientSercet, String url, String phone) {
        String jsonBody = ScanServiceImpl.getTokenRequestBody(clientId, clientSercet, phone);
        logger.info("ScanServiceImpl.getPageUrl jsonBody=" + jsonBody);
        return this.doPost(url, jsonBody);
    }

    public static InputStream getImage(String clientId, String clientSercet, String url, String phone, String fileId) {
        String imgsysUrl = ScanServiceImpl.getImgsysUrl(clientId, clientSercet, url, phone, fileId);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(imgsysUrl);
        InputStream content = null;
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            content = response.getEntity().getContent();
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return content;
    }

    public static String getImgsysUrl(String clientId, String clientSercet, String url, String phone, String fileId) {
        String jsonBody = ScanServiceImpl.getTokenRequestBody(clientId, clientSercet, phone);
        String token = ScanServiceImpl.getToken(url, jsonBody);
        String returnUrl = url + "/imgsys/bill/erp/bankReceipt/view?access_token=" + token + "&fileId=" + fileId;
        return returnUrl;
    }

    private String doPost(String url, String body) {
        String responseDody;
        String pageUrl = "";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String token = ScanServiceImpl.getToken(url, body);
        HttpGet httpGet = new HttpGet(url + "imgsys/bill/erp/bankReceipt/bankReceiptPageUrl?access_token=" + token);
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            logger.info("ScanServiceImpl.doPost response=" + response);
            responseDody = EntityUtils.toString((HttpEntity)response.getEntity());
            logger.info("ScanServiceImpl.doPost responseDody=" + responseDody);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new EBBizNCException(ErrorCodeUtils.create((String)"TOKEN", (String)ResManager.loadKDString((String)"\u8df3\u8f6c\u626b\u63cf\u7cfb\u7edf\u5931\u8d25\uff1a%s\u3002", (String)"ScanServiceImpl_0", (String)"tmc-bei-business", (Object[])new Object[]{e.getMessage()})));
        }
        ScanResponse osResponse = (ScanResponse)JSON.parseObject((String)responseDody, ScanResponse.class);
        if (!"0000".equals(osResponse.getErrcode())) {
            throw new EBBizNCException(ErrorCodeUtils.create((String)"TOKEN", (String)ResManager.loadKDString((String)"\u8df3\u8f6c\u626b\u63cf\u7cfb\u7edf\u5931\u8d25\uff1a%s\u3002", (String)"ScanServiceImpl_0", (String)"tmc-bei-business", (Object[])new Object[]{osResponse.getDescription()})));
        }
        pageUrl = osResponse.getData().getBankReceiptPageUrl();
        return pageUrl;
    }

    private static String getToken(String url, String body) {
        String responseDody;
        String token = (String)cache.get("imisys_token");
        if (token != null && !ScanServiceImpl.isTokenExpired()) {
            return token;
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String tokenUrl = url + "archivebase/scan/login/token";
        logger.info("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u83b7\u53d6token\u7684url:" + tokenUrl);
        HttpPost httpPost = new HttpPost(tokenUrl);
        httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
        StringEntity se = new StringEntity(body, "UTF-8");
        se.setContentType("text/json");
        se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json; charset=UTF-8"));
        httpPost.setEntity((HttpEntity)se);
        try {
            logger.info("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u83b7\u53d6token\u7684body:" + body);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            responseDody = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new EBBizNCException(ErrorCodeUtils.create((String)"TOKEN", (String)ResManager.loadKDString((String)"\u83b7\u53d6TOKEN\u5931\u8d25\u3002", (String)"ScanServiceImpl_1", (String)"tmc-bei-business", (Object[])new Object[0])));
        }
        ScanResponse result = (ScanResponse)JSON.parseObject((String)responseDody, ScanResponse.class);
        if (!"0000".equals(result.getErrcode())) {
            throw new EBBizNCException(ErrorCodeUtils.create((String)"TOKEN", (String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6TOKEN\u5931\u8d25\uff1a%s\u3002", (String)"ScanServiceImpl_3", (String)"tmc-bei-business", (Object[])new Object[0]), result.getDescription())));
        }
        ScanResponseData data = result.getData();
        String accessToken = data.getAccessToken();
        String timeStr = System.currentTimeMillis() + "";
        cache.put("imisys_timeout", (Object)timeStr);
        cache.put("imisys_token", (Object)accessToken);
        return accessToken;
    }

    private static boolean isTokenExpired() {
        String timeStr = (String)cache.get("imisys_timeout");
        if (timeStr != null) {
            try {
                long currTime = System.currentTimeMillis();
                long prevTime = Long.parseLong(timeStr);
                long minuteDiff = (currTime - prevTime) / 1000L / 60L / 60L;
                return minuteDiff >= 2L;
            }
            catch (Exception ignored) {
                return true;
            }
        }
        return true;
    }
}

