/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.balance;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.tmc.bei.business.helper.BalanceCheckErrorHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class BalanceMissgingRepairService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BalanceMissgingRepairService.class);
    private static final int ACCOUNT_BATCH = 200;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("issetbankinterface");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        try {
            List idList = Arrays.stream(dataEntities).filter(t -> t.getBoolean("issetbankinterface")).map(d -> (Long)d.getPkValue()).collect(Collectors.toList());
            int tryNum = this.getTryNum();
            logger.info("process repair error tryNum [{}], entity size {}", (Object)tryNum, (Object)idList.size());
            if (CollectionUtils.isEmpty(idList)) {
                this.operationResult.setSuccess(true);
                return;
            }
            List accountPart = Lists.partition(idList, (int)200);
            for (int i = 0; i < accountPart.size(); ++i) {
                QFilter filter = new QFilter("accountbank", "in", accountPart.get(i));
                filter.and("trynum", "<", (Object)tryNum);
                String selectProp = StringUtils.join(Arrays.asList("id", "billno", "accountbank", "bizdate", "currency", "correcttype", "trynum", "checkresult", "checktype"), (String)",");
                Object[] recordList = TmcDataServiceHelper.load((String)"bei_missingreord", (String)selectProp, (QFilter[])filter.toArray());
                if (EmptyUtil.isNoEmpty((Object[])recordList)) {
                    List<OperateErrorInfo> operateErrorInfos = BalanceCheckErrorHelper.repairMissingRecord((DynamicObject[])recordList);
                    if (!CollectionUtils.isEmpty(operateErrorInfos)) {
                        this.operationResult.setSuccess(false);
                        this.operationResult.setAllErrorInfo(operateErrorInfos);
                        this.operationResult.setShowMessage(false);
                        continue;
                    }
                    this.operationResult.setSuccess(true);
                    continue;
                }
                logger.info("not find missing record");
            }
        }
        catch (Exception e) {
            ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.FatalError);
                operateErrorInfo.setMessage(e.getMessage());
                operateErrorInfo.setPkValue(dataEntity.getPkValue());
                errorInfos.add(operateErrorInfo);
            }
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(errorInfos);
            this.operationResult.setShowMessage(false);
        }
    }

    private int getTryNum() {
        String num = (String)this.operationVariable.get("try_num");
        return StringUtils.isNotEmpty((CharSequence)num) ? Integer.parseInt(num) : 3;
    }
}

