/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.bankpay;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;

public abstract class AbstractCommitBeOpService
extends AbstractTmcBizOppService {
    protected List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        String isBizPayParam = (String)this.getOperationVariable().get("isBizPay");
        boolean isBankPay = !Boolean.parseBoolean(isBizPayParam);
        Map bankBillIdMap = Arrays.stream(dataEntities).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        List<SyncStatusInfo> resultList = EBServiceFacadeFactory.getBankService().pay(Arrays.asList(dataEntities), isBankPay);
        List errList = resultList.stream().filter(o -> o.getStatusCode() == EBResultStatusCode.ERROR || o.getStatusCode() == EBResultStatusCode.ROLLBACK).collect(Collectors.toList());
        for (SyncStatusInfo errorInfo : errList) {
            DynamicObject bankPayBill = (DynamicObject)bankBillIdMap.get(errorInfo.getBankBillId());
            if (bankPayBill == null) {
                if (errorInfo.getErrMsg() == null) continue;
                throw new KDBizException(errorInfo.getErrMsg());
            }
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, bankPayBill.getPkValue(), (Object)bankPayBill.getDynamicObjectType().getName());
            operateErrorInfo.setErrorCode(errorInfo.getStatusCode().name());
            String errMsg = errorInfo.getErrMsg();
            String preError = String.format(ResManager.loadKDString((String)"\u5904\u7406\u524d\u5931\u8d25%s", (String)"EBBizErrorCode_5", (String)"tmc-fbp-mservice", (Object[])new Object[0]), ":");
            StringBuilder builder = new StringBuilder();
            if (errMsg.contains(preError)) {
                try {
                    String jsonStr = errMsg.split(preError)[1];
                    Map map = (Map)JSON.parseObject((String)jsonStr, Map.class);
                    for (Map.Entry message : map.entrySet()) {
                        if (!this.getMatchId(bankPayBill).contains(message.getKey())) continue;
                        String showMessage = isBankPay ? bankPayBill.getString("billno") : this.getSrcBillNo(bankPayBill);
                        builder.append(showMessage);
                        builder.append(":");
                        builder.append((String)message.getValue());
                    }
                    operateErrorInfo.setMessage(builder.toString());
                }
                catch (Exception e) {
                    operateErrorInfo.setMessage(bankPayBill.get("billno") + ":" + errorInfo.getErrMsg());
                }
            } else if (errorInfo.isBankPay()) {
                operateErrorInfo.setMessage(bankPayBill.get("billno") + ":" + errorInfo.getErrMsg());
            } else {
                operateErrorInfo.setMessage(this.getSrcBillNo(bankPayBill) + ":" + errorInfo.getErrMsg());
            }
            this.errorInfoList.add(operateErrorInfo);
        }
    }

    protected abstract List<String> getMatchId(DynamicObject var1);

    protected abstract String getSrcBillNo(DynamicObject var1);

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.addErrorInfo(operateErrorInfo);
        }
    }
}

