/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.bankpay;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.utils.JsonUtil;

public abstract class AbstractUpdateOpService
extends AbstractTmcBizOppService {
    protected List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        Map bankBillIdMap = Arrays.stream(dataEntities).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        String statusJson = (String)this.operationVariable.get("entryaimstatus");
        Map statusMap = (Map)JsonUtil.json2Obj((String)statusJson, Map.class);
        String directUpdateIdListStr = (String)this.operationVariable.get("directUpdateIdList");
        List directUpdateIdList = JSON.parseArray((String)directUpdateIdListStr, Long.class);
        try {
            List<EBResult> resultList = EBServiceFacadeFactory.getBankService().updateStatus(dataEntities, directUpdateIdList, statusMap);
            for (EBResult result : resultList) {
                DynamicObject bankBill;
                if (result.getStatusCode() == EBResultStatusCode.SUCCESS || (bankBill = (DynamicObject)bankBillIdMap.get(result.getBankBillId())) == null) continue;
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, bankBill.getPkValue(), (Object)bankBill.getDynamicObjectType().getName());
                operateErrorInfo.setErrorCode(result.getStatusCode().name());
                operateErrorInfo.setMessage(bankBill.get("billno") + ":" + result.getErrMsg());
                this.errorInfoList.add(operateErrorInfo);
            }
        }
        finally {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("isupdatingstatus", (Object)0);
            }
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.addErrorInfo(operateErrorInfo);
        }
    }
}

