/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.bankpay;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.constants.DBRouteConst;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class BankPayingBitBackService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List lst = super.getSelector();
        lst.add("isbitback");
        lst.add("bitbackopinion");
        lst.add("billstatus");
        lst.add("sourcebillid");
        lst.add("payunique");
        lst.add("srcbilltype");
        lst.add("isupdatestate");
        lst.add("billno");
        lst.add("billstatus");
        lst.add("srcbillno");
        lst.add("company");
        lst.add("payeeacct");
        lst.add("isrefund");
        lst.add("submittime");
        lst.add("accountbank");
        lst.add("serialnumber");
        lst.add("bankreturnmsg");
        lst.add("batchseqid");
        lst.add("sourcebillid");
        lst.add("statementrefno");
        lst.add("currency");
        lst.add("paytime");
        lst.add("returntime");
        lst.add("incomeradds");
        lst.add("incomeswiftcode");
        lst.add("incomebankcode");
        lst.add("istranspay");
        lst.add("usecn");
        lst.add("excontract");
        lst.add("payerfeeaccno");
        lst.add("paymentmethod");
        lst.add("servicelevel");
        lst.add("transremarks");
        lst.add("proxyaccno");
        lst.add("proxyaccname");
        lst.add("proxybankcountry");
        lst.add("proxybankarea");
        lst.add("proxyswiftcode");
        lst.add("proxybankname");
        lst.add("proxybankadds");
        lst.add("deliverymethod");
        lst.add("chequetype");
        lst.add("chequeusage");
        lst.add("payerfeetype");
        lst.add("payerfeecurrency");
        lst.add("tolexchangerate");
        lst.add("srcbilltype");
        lst.add("netbankacct");
        lst.add("islinkpay");
        lst.add("parentacctbank");
        lst.add("childacctbank");
        return lst;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String tableName = dataEntities[0].getDynamicObjectType().getAlias();
        List idList = Arrays.stream(dataEntities).map(o -> (Long)o.getPkValue()).collect(Collectors.toList());
        String sql = "update " + tableName + " set fbillstatus = ? where fid in (" + TmcBusinessBaseHelper.idListToString(idList) + ") and ((fbillstatus = ? and fbankpaystate = ?) or (fbillstatus = ? and fbankpaystate = ?))";
        int[] result = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, Collections.singletonList(new Object[]{BillStatusEnum.BIT_BACK.getValue(), BillStatusEnum.AUDIT.getValue(), BeBillStatusEnum.TF.getValue(), BillStatusEnum.SAVE.getValue(), BeBillStatusEnum.OP.getValue()}));
        if (result.length < 1 || result[0] != idList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u6216\u8005\u4ea4\u6613\u5931\u8d25\u7684\u94f6\u884c\u4ed8\u6b3e\u5355\u624d\u53ef\u4ee5\u6253\u56de\u3002", (String)"BankPayingBitBackValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        String bitBackOpinion = (String)this.getOperationVariable().get("bitbackopinion");
        for (DynamicObject info : dataEntities) {
            this.execSrcBillBitBack(info, bitBackOpinion);
            info.set("isbitback", (Object)"1");
            info.set("bitbackopinion", (Object)bitBackOpinion);
            info.set("payunique", info.getPkValue());
            info.set("billstatus", (Object)BillStatusEnum.BIT_BACK.getValue());
            String userID = RequestContext.get().getUserId();
            info.set("bitbacker", (Object)Long.valueOf(userID));
            info.set("bitbacktime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void execSrcBillBitBack(DynamicObject info, String bitBackOpinion) {
        String transBillName = "cas_paybill";
        if ("ifm_transhandlebill".equals(info.getString("srcbilltype"))) {
            transBillName = "ifm_transhandlebill";
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isbitback", "1");
        operateOption.setVariableValue("bitbackopinion", bitBackOpinion);
        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"bitback", (String)transBillName, (Object[])new Long[]{info.getLong("sourcebillid")}, (OperateOption)operateOption, (boolean)true);
        if (!operationResult.isSuccess()) {
            String message = operationResult.getMessage();
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u4e0a\u6e38\u6253\u56de\u64cd\u4f5c\u5f02\u5e38\uff1a%s", (String)"BankPayingBitBackValidator_3", (String)"tmc-bei-business", (Object[])new Object[]{message}));
        }
    }
}

