/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.banktrans;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.constants.DBRouteConst;
import kd.tmc.bei.common.helper.BankTransBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class BankTransBitBackService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("isbitback");
        selectors.add("sourcebillid");
        selectors.add("billstatus");
        selectors.add("payunique");
        selectors.add("isupdatestate");
        selectors.add("billstatus");
        selectors.add("billno");
        selectors.add("company");
        selectors.add("bizdate");
        selectors.add("isbitback");
        selectors.add("bitbackopinion");
        selectors.add("accountbank");
        selectors.add("currency");
        selectors.add("actcount");
        selectors.add("actamount");
        selectors.add("paystate");
        selectors.add("sourcebillid");
        selectors.add("serialnumber");
        selectors.add("bankcheckflag");
        selectors.add("submittime");
        selectors.add("entrys");
        selectors.add("status");
        selectors.add("transamt");
        selectors.add("subacct");
        selectors.add("sourceentryid");
        selectors.add("bankreturnmsg");
        selectors.add("bankcheckflag");
        selectors.add("amount");
        return selectors;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String tableName = dataEntities[0].getDynamicObjectType().getAlias();
        List idList = Arrays.stream(dataEntities).map(o -> (Long)o.getPkValue()).collect(Collectors.toList());
        String sql = "update " + tableName + " set fbillstatus = ? where fid in (" + TmcBusinessBaseHelper.idListToString(idList) + ") and ((fbillstatus = ? and (fpaystate = ? or fpaystate = ?)) or (fbillstatus = ? and fpaystate = ?))";
        int[] result = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, Collections.singletonList(new Object[]{BillStatusEnum.BIT_BACK.getValue(), BillStatusEnum.AUDIT.getValue(), BeBillStatusEnum.TF.getValue(), BeBillStatusEnum.PS.getValue(), BillStatusEnum.SAVE.getValue(), BeBillStatusEnum.OP.getValue()}));
        if (result.length < 1 || result[0] != idList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u6682\u5b58\u201d\u3001\u201c\u4ea4\u6613\u5931\u8d25\u201d\u6216\u201c\u90e8\u5206\u5931\u8d25\u201d\u7684\u5355\u636e\u624d\u80fd\u6253\u56de\u3002", (String)"BankTransBitBackValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        String bitBackOpinion = (String)this.getOperationVariable().get("bitbackopinion");
        this.execSrcBillBitBack(dataEntities, bitBackOpinion);
        for (DynamicObject info : dataEntities) {
            info.set("payunique", info.getPkValue());
            info.set("isbitback", (Object)"1");
            info.set("bitbackopinion", (Object)bitBackOpinion);
            info.set("billstatus", (Object)BillStatusEnum.BIT_BACK.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void execSrcBillBitBack(DynamicObject[] dataEntities, String bitBackOpinion) {
        String transBillName = BankTransBillHelper.getTransBillEntity((DynamicObject)dataEntities[0]);
        Object[] sourceBillIds = Arrays.stream(dataEntities).map(o -> o.getLong("sourcebillid")).toArray();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isbitback", "1");
        operateOption.setVariableValue("bitbackopinion", bitBackOpinion);
        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"beibitback", (String)transBillName, (Object[])sourceBillIds, (OperateOption)operateOption, (boolean)true);
        if (!operationResult.isSuccess()) {
            String message = operationResult.getMessage();
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u4e0a\u6e38\u6253\u56de\u64cd\u4f5c\u5f02\u5e38\uff1a%s", (String)"BankPayingBitBackValidator_3", (String)"tmc-bei-business", (Object[])new Object[]{message}));
        }
    }
}

