/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.banktrans;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.SucessFailStateEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class UpdateStateAuditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(UpdateStateAuditService.class);
    private List<Long> directUpdateIdList = new ArrayList<Long>();
    private Map<Long, Map<Long, String>> updateStatusMap = new HashMap<Long, Map<Long, String>>();
    private Map<Long, String> syncErrorInfoMap = new HashMap<Long, String>();
    private final Set<Long> modifyErrorBillIds = new HashSet<Long>(16);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcetype");
        selector.add("sourcebillid");
        selector.add("entrys");
        selector.add("statusnew");
        selector.add("paystatus");
        selector.add("opstatus");
        selector.add("sourceentryid");
        selector.add("errmsg");
        selector.add("e_sourcebillid");
        selector.add("e_sourcebillno");
        return selector;
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        super.beforeProcess(dataEntities);
        EBBizErrorCode ebBizErrorCode = new EBBizErrorCode();
        Map<String, List<DynamicObject>> groupedList = dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.groupingBy(o -> o.getString("sourcetype")));
        for (Map.Entry<String, List<DynamicObject>> grpEntry : groupedList.entrySet()) {
            List<DynamicObject> grpUpdateList = grpEntry.getValue();
            String sourceType = grpEntry.getKey();
            ArrayList srcbBillIds = new ArrayList(10);
            grpUpdateList.forEach(s -> {
                List collect = s.getDynamicObjectCollection("entrys").stream().map(e -> e.getLong("e_sourcebillid")).collect(Collectors.toList());
                srcbBillIds.addAll(collect);
            });
            if ("bei_bankpaybill".equals(sourceType)) {
                ArrayList needInspectBillIds = new ArrayList(10);
                grpUpdateList.forEach(s -> {
                    List collect = s.getDynamicObjectCollection("entrys").stream().filter(e -> BeBillStatusEnum.TF.getValue().equals(e.getString("statusnew"))).map(e -> e.getLong("e_sourcebillid")).collect(Collectors.toList());
                    needInspectBillIds.addAll(collect);
                });
                DynamicObjectCollection bankPayBills = QueryServiceHelper.query((String)"bei_bankpaybill", (String)"id,accountbank.id,currency.id", (QFilter[])new QFilter[]{new QFilter("id", "in", needInspectBillIds)});
                this.inspectRepeatCtrl(bankPayBills);
            }
            DynamicObject[] srcDataList = TmcDataServiceHelper.load((Object[])srcbBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)sourceType));
            List<EBResult> resultList = EBServiceFacadeFactory.getBankService().queryPay(Arrays.asList(srcDataList), true);
            for (EBResult result : resultList) {
                if (result.getStatusCode() == EBResultStatusCode.SUCCESS) continue;
                if (ebBizErrorCode.UNKNOWN_BATCH().equals((Object)result.getErrCode())) {
                    this.directUpdateIdList.add(result.getBankBillId());
                    continue;
                }
                if ("bei_banktransupbill".equals(sourceType)) {
                    this.syncErrorInfoMap.put(result.getBankBillEntryId(), result.getErrMsg());
                    continue;
                }
                this.syncErrorInfoMap.put(result.getBankBillId(), result.getErrMsg());
            }
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        Map<String, List<DynamicObject>> groupedList = Arrays.stream(dataEntities).collect(Collectors.groupingBy(o -> o.getString("sourcetype")));
        for (Map.Entry<String, List<DynamicObject>> grpEntry : groupedList.entrySet()) {
            String sourceType = grpEntry.getKey();
            this.updateStatus(grpEntry.getValue(), sourceType);
        }
        for (DynamicObject dataEntity : dataEntities) {
            if (!this.modifyErrorBillIds.contains(dataEntity.getLong("id"))) continue;
            dataEntity.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    private void updateStatus(List<DynamicObject> updateStatusDataList, String sourceType) {
        ArrayList srcbBillIds = new ArrayList(10);
        updateStatusDataList.forEach(s -> {
            List collect = s.getDynamicObjectCollection("entrys").stream().map(e -> e.getLong("e_sourcebillid")).collect(Collectors.toList());
            srcbBillIds.addAll(collect);
        });
        DynamicObject[] srcDataList = TmcDataServiceHelper.load((Object[])srcbBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)sourceType));
        Map srcDataMap = Arrays.stream(srcDataList).collect(Collectors.toMap(DataEntityBase::getPkValue, Functions.identity()));
        ArrayList<DynamicObject> notUpdateSrcDataList = new ArrayList<DynamicObject>(updateStatusDataList.size());
        ArrayList<Long> needUpdateSrcIdList = new ArrayList<Long>(updateStatusDataList.size());
        HashMap<Long, Long> idRecord = new HashMap<Long, Long>(16);
        for (DynamicObject updateStatusData : updateStatusDataList) {
            DynamicObjectCollection entrys = updateStatusData.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entrys) {
                Long sourceId = entry.getLong("e_sourcebillid");
                DynamicObject srcData = (DynamicObject)srcDataMap.get(sourceId);
                Map<Long, String> updateMap = this.getUpdateMap(updateStatusData, srcData);
                if (updateMap.size() > 0) {
                    this.updateStatusMap.put(sourceId, updateMap);
                    needUpdateSrcIdList.add(srcData.getLong("id"));
                    idRecord.put(sourceId, updateStatusData.getLong("id"));
                    continue;
                }
                srcData.set("isupdatingstatus", (Object)0);
                notUpdateSrcDataList.add(srcData);
            }
        }
        if (needUpdateSrcIdList.size() > 0) {
            String appId;
            OperateOption option = OperateOption.create();
            Map operationVariable = this.getOperationVariable();
            if (null != operationVariable && operationVariable.size() > 0 && EmptyUtil.isNotEmpty((CharSequence)(appId = (String)operationVariable.get("appnumber")))) {
                option.setVariableValue("currbizappid", appId);
            }
            option.setVariableValue("entryaimstatus", JSON.toJSONString(this.updateStatusMap));
            option.setVariableValue("directUpdateIdList", JSON.toJSONString(this.directUpdateIdList));
            logger.info("--------\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\uff0c\u94f6\u884c\u4ed8\u6b3e\u5355\uff0centryaimstatus" + JSON.toJSONString(this.updateStatusMap));
            OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"updatestatus", (String)sourceType, (Object[])needUpdateSrcIdList.toArray(), (OperateOption)option);
            List opErrInfoList = result.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : opErrInfoList) {
                Long pkVal = (Long)errorInfo.getPkValue();
                if (errorInfo.getMessage().contains(this.getErrorInfoStr())) {
                    this.modifyErrorBillIds.add((Long)idRecord.get(pkVal));
                }
                Map<Long, String> statusMap = this.updateStatusMap.get(pkVal);
                Map updateStatusEntryMap = updateStatusDataList.stream().map(o -> o.getDynamicObjectCollection("entrys")).flatMap(Collection::stream).collect(Collectors.toMap(o -> o.getLong("sourceentryid"), Function.identity(), (a, b) -> a));
                for (Long srcEntryId : statusMap.keySet()) {
                    DynamicObject entry = (DynamicObject)updateStatusEntryMap.get(srcEntryId);
                    if (entry == null) continue;
                    entry.set("opstatus", (Object)SucessFailStateEnum.FAILED.getValue());
                    entry.set("errmsg", (Object)errorInfo.getMessage());
                }
            }
        }
        if (notUpdateSrcDataList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])notUpdateSrcDataList.toArray(new DynamicObject[0]));
        }
    }

    private Map<Long, String> getUpdateMap(DynamicObject updateStatusData, DynamicObject srcData) {
        Map<Long, String> updateMap;
        String sourceType = srcData.getDataEntityType().getName();
        long srcBillId = srcData.getLong("id");
        if (StringUtils.equals((CharSequence)sourceType, (CharSequence)"bei_banktransupbill") || StringUtils.equals((CharSequence)sourceType, (CharSequence)"bei_banktransdownbill") || StringUtils.equals((CharSequence)sourceType, (CharSequence)"bei_bankagentpay")) {
            DynamicObjectCollection targetEntries = srcData.getDynamicObjectCollection("entrys");
            DynamicObjectCollection currEntries = updateStatusData.getDynamicObjectCollection("entrys");
            updateMap = currEntries.stream().filter(o -> !Objects.equals(o.get("statusnew"), o.get("paystatus"))).flatMap(c -> targetEntries.stream().filter(t -> c.getString("sourceentryid").equals(t.getString("id"))).map(t -> Pair.of((Object)c, (Object)t))).map(o -> {
                DynamicObject currEntry = (DynamicObject)o.getLeft();
                DynamicObject targetEntry = (DynamicObject)o.getRight();
                boolean syncErr = this.syncErrorInfoMap.containsKey(srcBillId);
                String errMsg = this.syncErrorInfoMap.get(srcBillId);
                if (StringUtils.equals((CharSequence)sourceType, (CharSequence)"bei_banktransupbill")) {
                    syncErr = this.syncErrorInfoMap.containsKey(targetEntry.getLong("id"));
                    errMsg = this.syncErrorInfoMap.get(targetEntry.getLong("id"));
                }
                if (!syncErr) {
                    Object targetEntryState;
                    Object oldState = currEntry.get("paystatus");
                    boolean statusNotChange = oldState.equals(targetEntryState = targetEntry.get("status"));
                    if (statusNotChange) {
                        return currEntry;
                    }
                    currEntry.set("opstatus", (Object)SucessFailStateEnum.FAILED.getValue());
                    currEntry.set("errmsg", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ed8\u6b3e\u72b6\u6001\u5df2\u53d8\u5316\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"UpdateStateAuditService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
                    return null;
                }
                currEntry.set("opstatus", (Object)SucessFailStateEnum.FAILED.getValue());
                currEntry.set("errmsg", (Object)errMsg);
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toMap(o -> o.getLong("sourceentryid"), o -> o.getString("statusnew")));
        } else if (StringUtils.equals((CharSequence)sourceType, (CharSequence)"bei_bankpaybill")) {
            boolean syncErr = this.syncErrorInfoMap.containsKey(srcBillId);
            String errMsg = this.syncErrorInfoMap.get(srcBillId);
            String paystate = srcData.getString("bankpaystate");
            DynamicObjectCollection currEntries = updateStatusData.getDynamicObjectCollection("entrys");
            updateMap = new HashMap<Long, String>(16);
            DynamicObject currEntriesObject = currEntries.stream().filter(s -> String.valueOf(s.getLong("e_sourcebillid")).equals(String.valueOf(srcBillId))).findFirst().orElse(null);
            if (currEntriesObject != null) {
                if (!syncErr) {
                    if (StringUtils.equals((CharSequence)paystate, (CharSequence)currEntriesObject.getString("paystatus"))) {
                        Long sourceentryid = currEntriesObject.getLong("e_sourcebillid");
                        String statusnew = currEntriesObject.getString("statusnew");
                        updateMap.put(sourceentryid, statusnew);
                    } else {
                        currEntriesObject.set("opstatus", (Object)SucessFailStateEnum.FAILED.getValue());
                        currEntriesObject.set("errmsg", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ed8\u6b3e\u72b6\u6001\u5df2\u53d8\u5316\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"UpdateStateAuditService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
                    }
                } else {
                    currEntriesObject.set("opstatus", (Object)SucessFailStateEnum.FAILED.getValue());
                    currEntriesObject.set("errmsg", (Object)errMsg);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        return updateMap;
    }

    private String getErrorInfoStr() {
        return ResManager.loadKDString((String)"\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"UpdateStateErrorInfoStr_0", (String)"tmc-bei-business", (Object[])new Object[0]);
    }

    private void inspectRepeatCtrl(DynamicObjectCollection bankBills) {
        logger.info("------InspectRepeatCtrl--UpdateStateAudit------");
        Map<String, List<DynamicObject>> bankBillMap = bankBills.stream().collect(Collectors.groupingBy(v -> v.get("accountbank.id") + "-" + v.get("currency.id")));
        bankBillMap.forEach((bankAcctId, bankBillList) -> {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("InspectType", "bankQuery");
            paramMap.put("bankAcct", Long.valueOf(bankAcctId.split("-")[0]));
            paramMap.put("currency", Long.valueOf(bankAcctId.split("-")[1]));
            paramMap.put("targetEntity", "bei_bankpaybill");
            Set setIds = bankBillList.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            logger.info("setIds=============size" + setIds.size());
            paramMap.put("billIds", new ArrayList(setIds));
            paramMap.put("bizDate", DateUtils.getCurrentDate());
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("tmc", "fcs.inspect");){
                logger.info("------MQ Message Send------");
                pub.publish(paramMap);
            }
        });
    }
}

